// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package dataplex provides access to the Cloud Dataplex API.
//
// For product documentation, see: https://cloud.google.com/dataplex/docs
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/dataplex/v1"
//	...
//	ctx := context.Background()
//	dataplexService, err := dataplex.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	dataplexService, err := dataplex.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	dataplexService, err := dataplex.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package dataplex // import "google.golang.org/api/dataplex/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "dataplex:v1"
const apiName = "dataplex"
const apiVersion = "v1"
const basePath = "https://dataplex.googleapis.com/"
const basePathTemplate = "https://dataplex.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://dataplex.mtls.googleapis.com/"
const defaultUniverseDomain = "googleapis.com"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.WithDefaultUniverseDomain(defaultUniverseDomain))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.AspectTypes = NewProjectsLocationsAspectTypesService(s)
	rs.DataAttributeBindings = NewProjectsLocationsDataAttributeBindingsService(s)
	rs.DataScans = NewProjectsLocationsDataScansService(s)
	rs.DataTaxonomies = NewProjectsLocationsDataTaxonomiesService(s)
	rs.EntryGroups = NewProjectsLocationsEntryGroupsService(s)
	rs.EntryTypes = NewProjectsLocationsEntryTypesService(s)
	rs.GovernanceRules = NewProjectsLocationsGovernanceRulesService(s)
	rs.Lakes = NewProjectsLocationsLakesService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	AspectTypes *ProjectsLocationsAspectTypesService

	DataAttributeBindings *ProjectsLocationsDataAttributeBindingsService

	DataScans *ProjectsLocationsDataScansService

	DataTaxonomies *ProjectsLocationsDataTaxonomiesService

	EntryGroups *ProjectsLocationsEntryGroupsService

	EntryTypes *ProjectsLocationsEntryTypesService

	GovernanceRules *ProjectsLocationsGovernanceRulesService

	Lakes *ProjectsLocationsLakesService

	Operations *ProjectsLocationsOperationsService
}

func NewProjectsLocationsAspectTypesService(s *Service) *ProjectsLocationsAspectTypesService {
	rs := &ProjectsLocationsAspectTypesService{s: s}
	return rs
}

type ProjectsLocationsAspectTypesService struct {
	s *Service
}

func NewProjectsLocationsDataAttributeBindingsService(s *Service) *ProjectsLocationsDataAttributeBindingsService {
	rs := &ProjectsLocationsDataAttributeBindingsService{s: s}
	return rs
}

type ProjectsLocationsDataAttributeBindingsService struct {
	s *Service
}

func NewProjectsLocationsDataScansService(s *Service) *ProjectsLocationsDataScansService {
	rs := &ProjectsLocationsDataScansService{s: s}
	rs.Jobs = NewProjectsLocationsDataScansJobsService(s)
	return rs
}

type ProjectsLocationsDataScansService struct {
	s *Service

	Jobs *ProjectsLocationsDataScansJobsService
}

func NewProjectsLocationsDataScansJobsService(s *Service) *ProjectsLocationsDataScansJobsService {
	rs := &ProjectsLocationsDataScansJobsService{s: s}
	return rs
}

type ProjectsLocationsDataScansJobsService struct {
	s *Service
}

func NewProjectsLocationsDataTaxonomiesService(s *Service) *ProjectsLocationsDataTaxonomiesService {
	rs := &ProjectsLocationsDataTaxonomiesService{s: s}
	rs.Attributes = NewProjectsLocationsDataTaxonomiesAttributesService(s)
	return rs
}

type ProjectsLocationsDataTaxonomiesService struct {
	s *Service

	Attributes *ProjectsLocationsDataTaxonomiesAttributesService
}

func NewProjectsLocationsDataTaxonomiesAttributesService(s *Service) *ProjectsLocationsDataTaxonomiesAttributesService {
	rs := &ProjectsLocationsDataTaxonomiesAttributesService{s: s}
	return rs
}

type ProjectsLocationsDataTaxonomiesAttributesService struct {
	s *Service
}

func NewProjectsLocationsEntryGroupsService(s *Service) *ProjectsLocationsEntryGroupsService {
	rs := &ProjectsLocationsEntryGroupsService{s: s}
	rs.Entries = NewProjectsLocationsEntryGroupsEntriesService(s)
	return rs
}

type ProjectsLocationsEntryGroupsService struct {
	s *Service

	Entries *ProjectsLocationsEntryGroupsEntriesService
}

func NewProjectsLocationsEntryGroupsEntriesService(s *Service) *ProjectsLocationsEntryGroupsEntriesService {
	rs := &ProjectsLocationsEntryGroupsEntriesService{s: s}
	return rs
}

type ProjectsLocationsEntryGroupsEntriesService struct {
	s *Service
}

func NewProjectsLocationsEntryTypesService(s *Service) *ProjectsLocationsEntryTypesService {
	rs := &ProjectsLocationsEntryTypesService{s: s}
	return rs
}

type ProjectsLocationsEntryTypesService struct {
	s *Service
}

func NewProjectsLocationsGovernanceRulesService(s *Service) *ProjectsLocationsGovernanceRulesService {
	rs := &ProjectsLocationsGovernanceRulesService{s: s}
	return rs
}

type ProjectsLocationsGovernanceRulesService struct {
	s *Service
}

func NewProjectsLocationsLakesService(s *Service) *ProjectsLocationsLakesService {
	rs := &ProjectsLocationsLakesService{s: s}
	rs.Actions = NewProjectsLocationsLakesActionsService(s)
	rs.Content = NewProjectsLocationsLakesContentService(s)
	rs.Contentitems = NewProjectsLocationsLakesContentitemsService(s)
	rs.Environments = NewProjectsLocationsLakesEnvironmentsService(s)
	rs.Tasks = NewProjectsLocationsLakesTasksService(s)
	rs.Zones = NewProjectsLocationsLakesZonesService(s)
	return rs
}

type ProjectsLocationsLakesService struct {
	s *Service

	Actions *ProjectsLocationsLakesActionsService

	Content *ProjectsLocationsLakesContentService

	Contentitems *ProjectsLocationsLakesContentitemsService

	Environments *ProjectsLocationsLakesEnvironmentsService

	Tasks *ProjectsLocationsLakesTasksService

	Zones *ProjectsLocationsLakesZonesService
}

func NewProjectsLocationsLakesActionsService(s *Service) *ProjectsLocationsLakesActionsService {
	rs := &ProjectsLocationsLakesActionsService{s: s}
	return rs
}

type ProjectsLocationsLakesActionsService struct {
	s *Service
}

func NewProjectsLocationsLakesContentService(s *Service) *ProjectsLocationsLakesContentService {
	rs := &ProjectsLocationsLakesContentService{s: s}
	return rs
}

type ProjectsLocationsLakesContentService struct {
	s *Service
}

func NewProjectsLocationsLakesContentitemsService(s *Service) *ProjectsLocationsLakesContentitemsService {
	rs := &ProjectsLocationsLakesContentitemsService{s: s}
	return rs
}

type ProjectsLocationsLakesContentitemsService struct {
	s *Service
}

func NewProjectsLocationsLakesEnvironmentsService(s *Service) *ProjectsLocationsLakesEnvironmentsService {
	rs := &ProjectsLocationsLakesEnvironmentsService{s: s}
	rs.Sessions = NewProjectsLocationsLakesEnvironmentsSessionsService(s)
	return rs
}

type ProjectsLocationsLakesEnvironmentsService struct {
	s *Service

	Sessions *ProjectsLocationsLakesEnvironmentsSessionsService
}

func NewProjectsLocationsLakesEnvironmentsSessionsService(s *Service) *ProjectsLocationsLakesEnvironmentsSessionsService {
	rs := &ProjectsLocationsLakesEnvironmentsSessionsService{s: s}
	return rs
}

type ProjectsLocationsLakesEnvironmentsSessionsService struct {
	s *Service
}

func NewProjectsLocationsLakesTasksService(s *Service) *ProjectsLocationsLakesTasksService {
	rs := &ProjectsLocationsLakesTasksService{s: s}
	rs.Jobs = NewProjectsLocationsLakesTasksJobsService(s)
	return rs
}

type ProjectsLocationsLakesTasksService struct {
	s *Service

	Jobs *ProjectsLocationsLakesTasksJobsService
}

func NewProjectsLocationsLakesTasksJobsService(s *Service) *ProjectsLocationsLakesTasksJobsService {
	rs := &ProjectsLocationsLakesTasksJobsService{s: s}
	return rs
}

type ProjectsLocationsLakesTasksJobsService struct {
	s *Service
}

func NewProjectsLocationsLakesZonesService(s *Service) *ProjectsLocationsLakesZonesService {
	rs := &ProjectsLocationsLakesZonesService{s: s}
	rs.Actions = NewProjectsLocationsLakesZonesActionsService(s)
	rs.Assets = NewProjectsLocationsLakesZonesAssetsService(s)
	rs.Entities = NewProjectsLocationsLakesZonesEntitiesService(s)
	return rs
}

type ProjectsLocationsLakesZonesService struct {
	s *Service

	Actions *ProjectsLocationsLakesZonesActionsService

	Assets *ProjectsLocationsLakesZonesAssetsService

	Entities *ProjectsLocationsLakesZonesEntitiesService
}

func NewProjectsLocationsLakesZonesActionsService(s *Service) *ProjectsLocationsLakesZonesActionsService {
	rs := &ProjectsLocationsLakesZonesActionsService{s: s}
	return rs
}

type ProjectsLocationsLakesZonesActionsService struct {
	s *Service
}

func NewProjectsLocationsLakesZonesAssetsService(s *Service) *ProjectsLocationsLakesZonesAssetsService {
	rs := &ProjectsLocationsLakesZonesAssetsService{s: s}
	rs.Actions = NewProjectsLocationsLakesZonesAssetsActionsService(s)
	return rs
}

type ProjectsLocationsLakesZonesAssetsService struct {
	s *Service

	Actions *ProjectsLocationsLakesZonesAssetsActionsService
}

func NewProjectsLocationsLakesZonesAssetsActionsService(s *Service) *ProjectsLocationsLakesZonesAssetsActionsService {
	rs := &ProjectsLocationsLakesZonesAssetsActionsService{s: s}
	return rs
}

type ProjectsLocationsLakesZonesAssetsActionsService struct {
	s *Service
}

func NewProjectsLocationsLakesZonesEntitiesService(s *Service) *ProjectsLocationsLakesZonesEntitiesService {
	rs := &ProjectsLocationsLakesZonesEntitiesService{s: s}
	rs.Partitions = NewProjectsLocationsLakesZonesEntitiesPartitionsService(s)
	return rs
}

type ProjectsLocationsLakesZonesEntitiesService struct {
	s *Service

	Partitions *ProjectsLocationsLakesZonesEntitiesPartitionsService
}

func NewProjectsLocationsLakesZonesEntitiesPartitionsService(s *Service) *ProjectsLocationsLakesZonesEntitiesPartitionsService {
	rs := &ProjectsLocationsLakesZonesEntitiesPartitionsService{s: s}
	return rs
}

type ProjectsLocationsLakesZonesEntitiesPartitionsService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For
// instance: service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleCloudDataplexV1Action: Action represents an issue requiring
// administrator action for resolution.
type GoogleCloudDataplexV1Action struct {
	// Asset: Output only. The relative resource name of the asset, of the
	// form:
	// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zone
	// s/{zone_id}/assets/{asset_id}.
	Asset string `json:"asset,omitempty"`

	// Category: The category of issue associated with the action.
	//
	// Possible values:
	//   "CATEGORY_UNSPECIFIED" - Unspecified category.
	//   "RESOURCE_MANAGEMENT" - Resource management related issues.
	//   "SECURITY_POLICY" - Security policy related issues.
	//   "DATA_DISCOVERY" - Data and discovery related issues.
	Category string `json:"category,omitempty"`

	// DataLocations: The list of data locations associated with this
	// action. Cloud Storage locations are represented as URI paths(E.g.
	// gs://bucket/table1/year=2020/month=Jan/). BigQuery locations refer to
	// resource names(E.g.
	// bigquery.googleapis.com/projects/project-id/datasets/dataset-id).
	DataLocations []string `json:"dataLocations,omitempty"`

	// DetectTime: The time that the issue was detected.
	DetectTime string `json:"detectTime,omitempty"`

	// FailedSecurityPolicyApply: Details for issues related to applying
	// security policy.
	FailedSecurityPolicyApply *GoogleCloudDataplexV1ActionFailedSecurityPolicyApply `json:"failedSecurityPolicyApply,omitempty"`

	// IncompatibleDataSchema: Details for issues related to incompatible
	// schemas detected within data.
	IncompatibleDataSchema *GoogleCloudDataplexV1ActionIncompatibleDataSchema `json:"incompatibleDataSchema,omitempty"`

	// InvalidDataFormat: Details for issues related to invalid or
	// unsupported data formats.
	InvalidDataFormat *GoogleCloudDataplexV1ActionInvalidDataFormat `json:"invalidDataFormat,omitempty"`

	// InvalidDataOrganization: Details for issues related to invalid data
	// arrangement.
	InvalidDataOrganization *GoogleCloudDataplexV1ActionInvalidDataOrganization `json:"invalidDataOrganization,omitempty"`

	// InvalidDataPartition: Details for issues related to invalid or
	// unsupported data partition structure.
	InvalidDataPartition *GoogleCloudDataplexV1ActionInvalidDataPartition `json:"invalidDataPartition,omitempty"`

	// Issue: Detailed description of the issue requiring action.
	Issue string `json:"issue,omitempty"`

	// Lake: Output only. The relative resource name of the lake, of the
	// form:
	// projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
	Lake string `json:"lake,omitempty"`

	// MissingData: Details for issues related to absence of data within
	// managed resources.
	MissingData *GoogleCloudDataplexV1ActionMissingData `json:"missingData,omitempty"`

	// MissingResource: Details for issues related to absence of a managed
	// resource.
	MissingResource *GoogleCloudDataplexV1ActionMissingResource `json:"missingResource,omitempty"`

	// Name: Output only. The relative resource name of the action, of the
	// form:
	// projects/{project}/locations/{location}/lakes/{lake}/actions/{action}
	// projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/acti
	// ons/{action}
	// projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/asse
	// ts/{asset}/actions/{action}.
	Name string `json:"name,omitempty"`

	// UnauthorizedResource: Details for issues related to lack of
	// permissions to access data resources.
	UnauthorizedResource *GoogleCloudDataplexV1ActionUnauthorizedResource `json:"unauthorizedResource,omitempty"`

	// Zone: Output only. The relative resource name of the zone, of the
	// form:
	// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zone
	// s/{zone_id}.
	Zone string `json:"zone,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Asset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Asset") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1Action) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1Action
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ActionFailedSecurityPolicyApply: Failed to apply
// security policy to the managed resource(s) under a lake, zone or an
// asset. For a lake or zone resource, one or more underlying assets has
// a failure applying security policy to the associated managed
// resource.
type GoogleCloudDataplexV1ActionFailedSecurityPolicyApply struct {
	// Asset: Resource name of one of the assets with failing security
	// policy application. Populated for a lake or zone resource only.
	Asset string `json:"asset,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Asset") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Asset") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ActionFailedSecurityPolicyApply) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ActionFailedSecurityPolicyApply
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ActionIncompatibleDataSchema: Action details for
// incompatible schemas detected by discovery.
type GoogleCloudDataplexV1ActionIncompatibleDataSchema struct {
	// ExistingSchema: The existing and expected schema of the table. The
	// schema is provided as a JSON formatted structure listing columns and
	// data types.
	ExistingSchema string `json:"existingSchema,omitempty"`

	// NewSchema: The new and incompatible schema within the table. The
	// schema is provided as a JSON formatted structured listing columns and
	// data types.
	NewSchema string `json:"newSchema,omitempty"`

	// SampledDataLocations: The list of data locations sampled and used for
	// format/schema inference.
	SampledDataLocations []string `json:"sampledDataLocations,omitempty"`

	// SchemaChange: Whether the action relates to a schema that is
	// incompatible or modified.
	//
	// Possible values:
	//   "SCHEMA_CHANGE_UNSPECIFIED" - Schema change unspecified.
	//   "INCOMPATIBLE" - Newly discovered schema is incompatible with
	// existing schema.
	//   "MODIFIED" - Newly discovered schema has changed from existing
	// schema for data in a curated zone.
	SchemaChange string `json:"schemaChange,omitempty"`

	// Table: The name of the table containing invalid data.
	Table string `json:"table,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExistingSchema") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExistingSchema") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ActionIncompatibleDataSchema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ActionIncompatibleDataSchema
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ActionInvalidDataFormat: Action details for
// invalid or unsupported data files detected by discovery.
type GoogleCloudDataplexV1ActionInvalidDataFormat struct {
	// ExpectedFormat: The expected data format of the entity.
	ExpectedFormat string `json:"expectedFormat,omitempty"`

	// NewFormat: The new unexpected data format within the entity.
	NewFormat string `json:"newFormat,omitempty"`

	// SampledDataLocations: The list of data locations sampled and used for
	// format/schema inference.
	SampledDataLocations []string `json:"sampledDataLocations,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExpectedFormat") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExpectedFormat") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ActionInvalidDataFormat) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ActionInvalidDataFormat
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ActionInvalidDataOrganization: Action details
// for invalid data arrangement.
type GoogleCloudDataplexV1ActionInvalidDataOrganization struct {
}

// GoogleCloudDataplexV1ActionInvalidDataPartition: Action details for
// invalid or unsupported partitions detected by discovery.
type GoogleCloudDataplexV1ActionInvalidDataPartition struct {
	// ExpectedStructure: The issue type of InvalidDataPartition.
	//
	// Possible values:
	//   "PARTITION_STRUCTURE_UNSPECIFIED" - PartitionStructure unspecified.
	//   "CONSISTENT_KEYS" - Consistent hive-style partition definition
	// (both raw and curated zone).
	//   "HIVE_STYLE_KEYS" - Hive style partition definition (curated zone
	// only).
	ExpectedStructure string `json:"expectedStructure,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExpectedStructure")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExpectedStructure") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ActionInvalidDataPartition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ActionInvalidDataPartition
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ActionMissingData: Action details for absence of
// data detected by discovery.
type GoogleCloudDataplexV1ActionMissingData struct {
}

// GoogleCloudDataplexV1ActionMissingResource: Action details for
// resource references in assets that cannot be located.
type GoogleCloudDataplexV1ActionMissingResource struct {
}

// GoogleCloudDataplexV1ActionUnauthorizedResource: Action details for
// unauthorized resource issues raised to indicate that the service
// account associated with the lake instance is not authorized to access
// or manage the resource associated with an asset.
type GoogleCloudDataplexV1ActionUnauthorizedResource struct {
}

// GoogleCloudDataplexV1Aspect: An aspect is a single piece of metadata
// describing an entry.
type GoogleCloudDataplexV1Aspect struct {
	AspectSource *GoogleCloudDataplexV1AspectSource `json:"aspectSource,omitempty"`

	// AspectType: Output only. The resource name of the type used to create
	// this Aspect.
	AspectType string `json:"aspectType,omitempty"`

	// CreateTime: Output only. The time when the Aspect was created.
	CreateTime string `json:"createTime,omitempty"`

	// Data: Required. The content of the aspect, according to its aspect
	// type schema. This will replace content. The maximum size of the field
	// is 120KB (encoded as UTF-8).
	Data googleapi.RawMessage `json:"data,omitempty"`

	// Path: Output only. The path in the entry under which the aspect is
	// attached.
	Path string `json:"path,omitempty"`

	// UpdateTime: Output only. The time when the Aspect was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AspectSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AspectSource") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1Aspect) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1Aspect
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1AspectSource: AspectSource contains source
// system related information for the aspect.
type GoogleCloudDataplexV1AspectSource struct {
	// CreateTime: The create time of the aspect in the source system.
	CreateTime string `json:"createTime,omitempty"`

	// UpdateTime: The update time of the aspect in the source system.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1AspectSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1AspectSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1AspectType: Aspect Type is a template for
// creating Aspects, and represents the JSON-schema for a given Entry,
// e.g., BigQuery Table Schema.
type GoogleCloudDataplexV1AspectType struct {
	// Authorization: Immutable. Authorization defined for this type.
	Authorization *GoogleCloudDataplexV1AspectTypeAuthorization `json:"authorization,omitempty"`

	// CreateTime: Output only. The time when the AspectType was created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Optional. Description of the AspectType.
	Description string `json:"description,omitempty"`

	// DisplayName: Optional. User friendly display name.
	DisplayName string `json:"displayName,omitempty"`

	// Etag: This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure
	// the client has an up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`

	// Labels: Optional. User-defined labels for the AspectType.
	Labels map[string]string `json:"labels,omitempty"`

	// MetadataTemplate: Required. MetadataTemplate of the aspect.
	MetadataTemplate *GoogleCloudDataplexV1AspectTypeMetadataTemplate `json:"metadataTemplate,omitempty"`

	// Name: Output only. The relative resource name of the AspectType, of
	// the form:
	// projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_
	// type_id}.
	Name string `json:"name,omitempty"`

	// TransferStatus: Output only. Denotes the transfer status of the
	// Aspect Type. It is unspecified for Aspect Types created from Dataplex
	// API.
	//
	// Possible values:
	//   "TRANSFER_STATUS_UNSPECIFIED" - The default value. It is set for
	// resources that were not subject for migration from Data Catalog
	// service.
	//   "TRANSFER_STATUS_MIGRATED" - Indicates that a resource was migrated
	// from Data Catalog service but it hasn't been transferred yet. In
	// particular the resource cannot be updated from Dataplex API.
	//   "TRANSFER_STATUS_TRANSFERRED" - Indicates that a resource was
	// transferred from Data Catalog service. The resource can only be
	// updated from Dataplex API.
	TransferStatus string `json:"transferStatus,omitempty"`

	// Uid: Output only. System generated globally unique ID for the
	// AspectType. This ID will be different if the AspectType is deleted
	// and re-created with the same name.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time when the AspectType was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Authorization") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Authorization") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1AspectType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1AspectType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1AspectTypeAuthorization: Autorization for an
// Aspect Type.
type GoogleCloudDataplexV1AspectTypeAuthorization struct {
	// AlternateUsePermission: Immutable. The IAM permission grantable on
	// the Entry Group to allow access to instantiate Aspects of Dataplex
	// owned Aspect Types, only settable for Dataplex owned Types.
	AlternateUsePermission string `json:"alternateUsePermission,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AlternateUsePermission") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AlternateUsePermission")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1AspectTypeAuthorization) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1AspectTypeAuthorization
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1AspectTypeMetadataTemplate: MetadataTemplate
// definition for AspectType
type GoogleCloudDataplexV1AspectTypeMetadataTemplate struct {
	// Annotations: Optional. Specifies annotations on this field.
	Annotations *GoogleCloudDataplexV1AspectTypeMetadataTemplateAnnotations `json:"annotations,omitempty"`

	// ArrayItems: Optional. array_items needs to be set if the type is
	// array. array_items can refer to a primitive field or a complex
	// (record only) field. To specify a primitive field, just name and type
	// needs to be set in the nested MetadataTemplate. The recommended value
	// for the name field is item, as this is not used in the actual
	// payload.
	ArrayItems *GoogleCloudDataplexV1AspectTypeMetadataTemplate `json:"arrayItems,omitempty"`

	// Constraints: Optional. Specifies the constraints on this field.
	Constraints *GoogleCloudDataplexV1AspectTypeMetadataTemplateConstraints `json:"constraints,omitempty"`

	// EnumValues: Optional. The list of values for an enum type. Needs to
	// be defined if the type is enum.
	EnumValues []*GoogleCloudDataplexV1AspectTypeMetadataTemplateEnumValue `json:"enumValues,omitempty"`

	// Index: Optional. Index is used to encode Template messages. The value
	// of index can range between 1 and 2,147,483,647. Index must be unique
	// within all fields in a Template. (Nested Templates can reuse
	// indexes). Once a Template is defined, the index cannot be changed,
	// because it identifies the field in the actual storage format. Index
	// is a mandatory field, but it is optional for top level fields, and
	// map/array "values" definitions.
	Index int64 `json:"index,omitempty"`

	// MapItems: Optional. map_items needs to be set if the type is map.
	// map_items can refer to a primitive field or a complex (record only)
	// field. To specify a primitive field, just name and type needs to be
	// set in the nested MetadataTemplate. The recommended value for the
	// name field is item, as this is not used in the actual payload.
	MapItems *GoogleCloudDataplexV1AspectTypeMetadataTemplate `json:"mapItems,omitempty"`

	// Name: Required. The name of the field.
	Name string `json:"name,omitempty"`

	// RecordFields: Optional. Field definition, needs to be specified if
	// the type is record. Defines the nested fields.
	RecordFields []*GoogleCloudDataplexV1AspectTypeMetadataTemplate `json:"recordFields,omitempty"`

	// Type: Required. The datatype of this field. The following values are
	// supported: Primitive types (string, integer, boolean, double,
	// datetime); datetime must be of the format RFC3339 UTC "Zulu"
	// (Examples: "2014-10-02T15:01:23Z" and
	// "2014-10-02T15:01:23.045123456Z"). Complex types (enum, array, map,
	// record).
	Type string `json:"type,omitempty"`

	// TypeId: Optional. Id can be used if this definition of the field
	// needs to be reused later. Id needs to be unique across the entire
	// template. Id can only be specified if the field type is record.
	TypeId string `json:"typeId,omitempty"`

	// TypeRef: Optional. A reference to another field definition (instead
	// of an inline definition). The value must be equal to the value of an
	// id field defined elsewhere in the MetadataTemplate. Only fields with
	// type as record can refer to other fields.
	TypeRef string `json:"typeRef,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Annotations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1AspectTypeMetadataTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1AspectTypeMetadataTemplate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1AspectTypeMetadataTemplateAnnotations:
// Definition of the annotations of a field
type GoogleCloudDataplexV1AspectTypeMetadataTemplateAnnotations struct {
	// Deprecated -- Optional. Marks a field as deprecated, a deprecation
	// message can be included.
	Deprecated string `json:"deprecated,omitempty"`

	// Description: Optional. Specify a description for a field
	Description string `json:"description,omitempty"`

	// DisplayName: Optional. Specify a displayname for a field.
	DisplayName string `json:"displayName,omitempty"`

	// DisplayOrder: Optional. Specify a display order for a field. Display
	// order can be used to reorder where a field is rendered
	DisplayOrder int64 `json:"displayOrder,omitempty"`

	// StringType: Optional. String Type annotations can be used to specify
	// special meaning to string fields. The following values are supported:
	// richText: The field must be interpreted as a rich text field. url: A
	// fully qualified url link. resource: A service qualified resource
	// reference.
	StringType string `json:"stringType,omitempty"`

	// StringValues: Optional. Suggested hints for string fields. These can
	// be used to suggest values to users, through an UI for example.
	StringValues []string `json:"stringValues,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Deprecated") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Deprecated") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1AspectTypeMetadataTemplateAnnotations) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1AspectTypeMetadataTemplateAnnotations
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1AspectTypeMetadataTemplateConstraints:
// Definition of the constraints of a field
type GoogleCloudDataplexV1AspectTypeMetadataTemplateConstraints struct {
	// Required: Optional. Marks this as an optional/required field.
	Required bool `json:"required,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Required") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Required") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1AspectTypeMetadataTemplateConstraints) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1AspectTypeMetadataTemplateConstraints
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1AspectTypeMetadataTemplateEnumValue: Definition
// of Enumvalue (to be used by enum fields)
type GoogleCloudDataplexV1AspectTypeMetadataTemplateEnumValue struct {
	// Deprecated -- Optional. Optional deprecation message to be set if an
	// enum value needs to be deprecated.
	Deprecated string `json:"deprecated,omitempty"`

	// Index: Required. Index for the enum. Cannot be modified.
	Index int64 `json:"index,omitempty"`

	// Name: Required. Name of the enumvalue. This is the actual value that
	// the aspect will contain.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Deprecated") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Deprecated") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1AspectTypeMetadataTemplateEnumValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1AspectTypeMetadataTemplateEnumValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1Asset: An asset represents a cloud resource that
// is being managed within a lake as a member of a zone.
type GoogleCloudDataplexV1Asset struct {
	// CreateTime: Output only. The time when the asset was created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Optional. Description of the asset.
	Description string `json:"description,omitempty"`

	// DiscoverySpec: Optional. Specification of the discovery feature
	// applied to data referenced by this asset. When this spec is left
	// unset, the asset will use the spec set on the parent zone.
	DiscoverySpec *GoogleCloudDataplexV1AssetDiscoverySpec `json:"discoverySpec,omitempty"`

	// DiscoveryStatus: Output only. Status of the discovery feature applied
	// to data referenced by this asset.
	DiscoveryStatus *GoogleCloudDataplexV1AssetDiscoveryStatus `json:"discoveryStatus,omitempty"`

	// DisplayName: Optional. User friendly display name.
	DisplayName string `json:"displayName,omitempty"`

	// Labels: Optional. User defined labels for the asset.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. The relative resource name of the asset, of the
	// form:
	// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zone
	// s/{zone_id}/assets/{asset_id}.
	Name string `json:"name,omitempty"`

	// ResourceSpec: Required. Specification of the resource that is
	// referenced by this asset.
	ResourceSpec *GoogleCloudDataplexV1AssetResourceSpec `json:"resourceSpec,omitempty"`

	// ResourceStatus: Output only. Status of the resource referenced by
	// this asset.
	ResourceStatus *GoogleCloudDataplexV1AssetResourceStatus `json:"resourceStatus,omitempty"`

	// SecurityStatus: Output only. Status of the security policy applied to
	// resource referenced by this asset.
	SecurityStatus *GoogleCloudDataplexV1AssetSecurityStatus `json:"securityStatus,omitempty"`

	// State: Output only. Current state of the asset.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is not specified.
	//   "ACTIVE" - Resource is active, i.e., ready to use.
	//   "CREATING" - Resource is under creation.
	//   "DELETING" - Resource is under deletion.
	//   "ACTION_REQUIRED" - Resource is active but has unresolved actions.
	State string `json:"state,omitempty"`

	// Uid: Output only. System generated globally unique ID for the asset.
	// This ID will be different if the asset is deleted and re-created with
	// the same name.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time when the asset was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1Asset) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1Asset
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1AssetDiscoverySpec: Settings to manage the
// metadata discovery and publishing for an asset.
type GoogleCloudDataplexV1AssetDiscoverySpec struct {
	// CsvOptions: Optional. Configuration for CSV data.
	CsvOptions *GoogleCloudDataplexV1AssetDiscoverySpecCsvOptions `json:"csvOptions,omitempty"`

	// Enabled: Optional. Whether discovery is enabled.
	Enabled bool `json:"enabled,omitempty"`

	// ExcludePatterns: Optional. The list of patterns to apply for
	// selecting data to exclude during discovery. For Cloud Storage bucket
	// assets, these are interpreted as glob patterns used to match object
	// names. For BigQuery dataset assets, these are interpreted as patterns
	// to match table names.
	ExcludePatterns []string `json:"excludePatterns,omitempty"`

	// IncludePatterns: Optional. The list of patterns to apply for
	// selecting data to include during discovery if only a subset of the
	// data should considered. For Cloud Storage bucket assets, these are
	// interpreted as glob patterns used to match object names. For BigQuery
	// dataset assets, these are interpreted as patterns to match table
	// names.
	IncludePatterns []string `json:"includePatterns,omitempty"`

	// JsonOptions: Optional. Configuration for Json data.
	JsonOptions *GoogleCloudDataplexV1AssetDiscoverySpecJsonOptions `json:"jsonOptions,omitempty"`

	// Schedule: Optional. Cron schedule
	// (https://en.wikipedia.org/wiki/Cron) for running discovery
	// periodically. Successive discovery runs must be scheduled at least 60
	// minutes apart. The default value is to run discovery every 60
	// minutes. To explicitly set a timezone to the cron tab, apply a prefix
	// in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or
	// TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid
	// string from IANA time zone database. For example,
	// CRON_TZ=America/New_York 1 * * * *, or TZ=America/New_York 1 * * * *.
	Schedule string `json:"schedule,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CsvOptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CsvOptions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1AssetDiscoverySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1AssetDiscoverySpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1AssetDiscoverySpecCsvOptions: Describe CSV and
// similar semi-structured data formats.
type GoogleCloudDataplexV1AssetDiscoverySpecCsvOptions struct {
	// Delimiter: Optional. The delimiter being used to separate values.
	// This defaults to ','.
	Delimiter string `json:"delimiter,omitempty"`

	// DisableTypeInference: Optional. Whether to disable the inference of
	// data type for CSV data. If true, all columns will be registered as
	// strings.
	DisableTypeInference bool `json:"disableTypeInference,omitempty"`

	// Encoding: Optional. The character encoding of the data. The default
	// is UTF-8.
	Encoding string `json:"encoding,omitempty"`

	// HeaderRows: Optional. The number of rows to interpret as header rows
	// that should be skipped when reading data rows.
	HeaderRows int64 `json:"headerRows,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Delimiter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Delimiter") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1AssetDiscoverySpecCsvOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1AssetDiscoverySpecCsvOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1AssetDiscoverySpecJsonOptions: Describe JSON
// data format.
type GoogleCloudDataplexV1AssetDiscoverySpecJsonOptions struct {
	// DisableTypeInference: Optional. Whether to disable the inference of
	// data type for Json data. If true, all columns will be registered as
	// their primitive types (strings, number or boolean).
	DisableTypeInference bool `json:"disableTypeInference,omitempty"`

	// Encoding: Optional. The character encoding of the data. The default
	// is UTF-8.
	Encoding string `json:"encoding,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DisableTypeInference") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisableTypeInference") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1AssetDiscoverySpecJsonOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1AssetDiscoverySpecJsonOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1AssetDiscoveryStatus: Status of discovery for an
// asset.
type GoogleCloudDataplexV1AssetDiscoveryStatus struct {
	// LastRunDuration: The duration of the last discovery run.
	LastRunDuration string `json:"lastRunDuration,omitempty"`

	// LastRunTime: The start time of the last discovery run.
	LastRunTime string `json:"lastRunTime,omitempty"`

	// Message: Additional information about the current state.
	Message string `json:"message,omitempty"`

	// State: The current status of the discovery feature.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is unspecified.
	//   "SCHEDULED" - Discovery for the asset is scheduled.
	//   "IN_PROGRESS" - Discovery for the asset is running.
	//   "PAUSED" - Discovery for the asset is currently paused (e.g. due to
	// a lack of available resources). It will be automatically resumed.
	//   "DISABLED" - Discovery for the asset is disabled.
	State string `json:"state,omitempty"`

	// Stats: Data Stats of the asset reported by discovery.
	Stats *GoogleCloudDataplexV1AssetDiscoveryStatusStats `json:"stats,omitempty"`

	// UpdateTime: Last update time of the status.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LastRunDuration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LastRunDuration") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1AssetDiscoveryStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1AssetDiscoveryStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1AssetDiscoveryStatusStats: The aggregated data
// statistics for the asset reported by discovery.
type GoogleCloudDataplexV1AssetDiscoveryStatusStats struct {
	// DataItems: The count of data items within the referenced resource.
	DataItems int64 `json:"dataItems,omitempty,string"`

	// DataSize: The number of stored data bytes within the referenced
	// resource.
	DataSize int64 `json:"dataSize,omitempty,string"`

	// Filesets: The count of fileset entities within the referenced
	// resource.
	Filesets int64 `json:"filesets,omitempty,string"`

	// Tables: The count of table entities within the referenced resource.
	Tables int64 `json:"tables,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "DataItems") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataItems") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1AssetDiscoveryStatusStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1AssetDiscoveryStatusStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1AssetResourceSpec: Identifies the cloud resource
// that is referenced by this asset.
type GoogleCloudDataplexV1AssetResourceSpec struct {
	// Name: Immutable. Relative name of the cloud resource that contains
	// the data that is being managed within a lake. For example:
	// projects/{project_number}/buckets/{bucket_id}
	// projects/{project_number}/datasets/{dataset_id}
	Name string `json:"name,omitempty"`

	// ReadAccessMode: Optional. Determines how read permissions are handled
	// for each asset and their associated tables. Only available to storage
	// buckets assets.
	//
	// Possible values:
	//   "ACCESS_MODE_UNSPECIFIED" - Access mode unspecified.
	//   "DIRECT" - Default. Data is accessed directly using storage APIs.
	//   "MANAGED" - Data is accessed through a managed interface using
	// BigQuery APIs.
	ReadAccessMode string `json:"readAccessMode,omitempty"`

	// Type: Required. Immutable. Type of resource.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Type not specified.
	//   "STORAGE_BUCKET" - Cloud Storage bucket.
	//   "BIGQUERY_DATASET" - BigQuery dataset.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1AssetResourceSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1AssetResourceSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1AssetResourceStatus: Status of the resource
// referenced by an asset.
type GoogleCloudDataplexV1AssetResourceStatus struct {
	// ManagedAccessIdentity: Output only. Service account associated with
	// the BigQuery Connection.
	ManagedAccessIdentity string `json:"managedAccessIdentity,omitempty"`

	// Message: Additional information about the current state.
	Message string `json:"message,omitempty"`

	// State: The current state of the managed resource.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "READY" - Resource does not have any errors.
	//   "ERROR" - Resource has errors.
	State string `json:"state,omitempty"`

	// UpdateTime: Last update time of the status.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ManagedAccessIdentity") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ManagedAccessIdentity") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1AssetResourceStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1AssetResourceStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1AssetSecurityStatus: Security policy status of
// the asset. Data security policy, i.e., readers, writers & owners,
// should be specified in the lake/zone/asset IAM policy.
type GoogleCloudDataplexV1AssetSecurityStatus struct {
	// Message: Additional information about the current state.
	Message string `json:"message,omitempty"`

	// State: The current state of the security policy applied to the
	// attached resource.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State unspecified.
	//   "READY" - Security policy has been successfully applied to the
	// attached resource.
	//   "APPLYING" - Security policy is in the process of being applied to
	// the attached resource.
	//   "ERROR" - Security policy could not be applied to the attached
	// resource due to errors.
	State string `json:"state,omitempty"`

	// UpdateTime: Last update time of the status.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Message") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Message") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1AssetSecurityStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1AssetSecurityStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1AssetStatus: Aggregated status of the underlying
// assets of a lake or zone.
type GoogleCloudDataplexV1AssetStatus struct {
	// ActiveAssets: Number of active assets.
	ActiveAssets int64 `json:"activeAssets,omitempty"`

	// SecurityPolicyApplyingAssets: Number of assets that are in process of
	// updating the security policy on attached resources.
	SecurityPolicyApplyingAssets int64 `json:"securityPolicyApplyingAssets,omitempty"`

	// UpdateTime: Last update time of the status.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActiveAssets") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActiveAssets") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1AssetStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1AssetStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1CancelJobRequest: Cancel task jobs.
type GoogleCloudDataplexV1CancelJobRequest struct {
}

// GoogleCloudDataplexV1Content: Content represents a user-visible
// notebook or a sql script
type GoogleCloudDataplexV1Content struct {
	// CreateTime: Output only. Content creation time.
	CreateTime string `json:"createTime,omitempty"`

	// DataText: Required. Content data in string format.
	DataText string `json:"dataText,omitempty"`

	// Description: Optional. Description of the content.
	Description string `json:"description,omitempty"`

	// Labels: Optional. User defined labels for the content.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. The relative resource name of the content, of the
	// form:
	// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/content/
	// {content_id}
	Name string `json:"name,omitempty"`

	// Notebook: Notebook related configurations.
	Notebook *GoogleCloudDataplexV1ContentNotebook `json:"notebook,omitempty"`

	// Path: Required. The path for the Content file, represented as
	// directory structure. Unique within a lake. Limited to alphanumerics,
	// hyphens, underscores, dots and slashes.
	Path string `json:"path,omitempty"`

	// SqlScript: Sql Script related configurations.
	SqlScript *GoogleCloudDataplexV1ContentSqlScript `json:"sqlScript,omitempty"`

	// Uid: Output only. System generated globally unique ID for the
	// content. This ID will be different if the content is deleted and
	// re-created with the same name.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time when the content was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1Content) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1Content
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ContentNotebook: Configuration for Notebook
// content.
type GoogleCloudDataplexV1ContentNotebook struct {
	// KernelType: Required. Kernel Type of the notebook.
	//
	// Possible values:
	//   "KERNEL_TYPE_UNSPECIFIED" - Kernel Type unspecified.
	//   "PYTHON3" - Python 3 Kernel.
	KernelType string `json:"kernelType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "KernelType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "KernelType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ContentNotebook) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ContentNotebook
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ContentSqlScript: Configuration for the Sql
// Script content.
type GoogleCloudDataplexV1ContentSqlScript struct {
	// Engine: Required. Query Engine to be used for the Sql Query.
	//
	// Possible values:
	//   "QUERY_ENGINE_UNSPECIFIED" - Value was unspecified.
	//   "SPARK" - Spark SQL Query.
	Engine string `json:"engine,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Engine") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Engine") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ContentSqlScript) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ContentSqlScript
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataAccessSpec: DataAccessSpec holds the access
// control configuration to be enforced on data stored within resources
// (eg: rows, columns in BigQuery Tables). When associated with data,
// the data is only accessible to principals explicitly granted access
// through the DataAccessSpec. Principals with access to the containing
// resource are not implicitly granted access.
type GoogleCloudDataplexV1DataAccessSpec struct {
	// Readers: Optional. The format of strings follows the pattern followed
	// by IAM in the bindings. user:{email}, serviceAccount:{email}
	// group:{email}. The set of principals to be granted reader role on
	// data stored within resources.
	Readers []string `json:"readers,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Readers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Readers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataAccessSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataAccessSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataAttribute: Denotes one dataAttribute in a
// dataTaxonomy, for example, PII. DataAttribute resources can be
// defined in a hierarchy. A single dataAttribute resource can contain
// specs of multiple types PII - ResourceAccessSpec : - readers
// :foo@bar.com - DataAccessSpec : - readers :bar@foo.com
type GoogleCloudDataplexV1DataAttribute struct {
	// AttributeCount: Output only. The number of child attributes present
	// for this attribute.
	AttributeCount int64 `json:"attributeCount,omitempty"`

	// CreateTime: Output only. The time when the DataAttribute was created.
	CreateTime string `json:"createTime,omitempty"`

	// DataAccessSpec: Optional. Specified when applied to data stored on
	// the resource (eg: rows, columns in BigQuery Tables).
	DataAccessSpec *GoogleCloudDataplexV1DataAccessSpec `json:"dataAccessSpec,omitempty"`

	// Description: Optional. Description of the DataAttribute.
	Description string `json:"description,omitempty"`

	// DisplayName: Optional. User friendly display name.
	DisplayName string `json:"displayName,omitempty"`

	// Etag: This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure
	// the client has an up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`

	// Labels: Optional. User-defined labels for the DataAttribute.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. The relative resource name of the dataAttribute,
	// of the form:
	// projects/{project_number}/locations/{location_id}/dataTaxonomies/{data
	// Taxonomy}/attributes/{data_attribute_id}.
	Name string `json:"name,omitempty"`

	// ParentId: Optional. The ID of the parent DataAttribute resource,
	// should belong to the same data taxonomy. Circular dependency in
	// parent chain is not valid. Maximum depth of the hierarchy allowed is
	// 4. a -> b -> c -> d -> e, depth = 4
	ParentId string `json:"parentId,omitempty"`

	// ResourceAccessSpec: Optional. Specified when applied to a resource
	// (eg: Cloud Storage bucket, BigQuery dataset, BigQuery table).
	ResourceAccessSpec *GoogleCloudDataplexV1ResourceAccessSpec `json:"resourceAccessSpec,omitempty"`

	// Uid: Output only. System generated globally unique ID for the
	// DataAttribute. This ID will be different if the DataAttribute is
	// deleted and re-created with the same name.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time when the DataAttribute was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AttributeCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributeCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataAttribute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataAttribute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataAttributeBinding: DataAttributeBinding
// represents binding of attributes to resources. Eg: Bind
// 'CustomerInfo' entity with 'PII' attribute.
type GoogleCloudDataplexV1DataAttributeBinding struct {
	// Attributes: Optional. List of attributes to be associated with the
	// resource, provided in the form:
	// projects/{project}/locations/{location}/dataTaxonomies/{dataTaxonomy}/
	// attributes/{data_attribute_id}
	Attributes []string `json:"attributes,omitempty"`

	// CreateTime: Output only. The time when the DataAttributeBinding was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Optional. Description of the DataAttributeBinding.
	Description string `json:"description,omitempty"`

	// DisplayName: Optional. User friendly display name.
	DisplayName string `json:"displayName,omitempty"`

	// Etag: This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure
	// the client has an up-to-date value before proceeding. Etags must be
	// used when calling the DeleteDataAttributeBinding and the
	// UpdateDataAttributeBinding method.
	Etag string `json:"etag,omitempty"`

	// Labels: Optional. User-defined labels for the DataAttributeBinding.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. The relative resource name of the Data Attribute
	// Binding, of the form:
	// projects/{project_number}/locations/{location}/dataAttributeBindings/{
	// data_attribute_binding_id}
	Name string `json:"name,omitempty"`

	// Paths: Optional. The list of paths for items within the associated
	// resource (eg. columns and partitions within a table) along with
	// attribute bindings.
	Paths []*GoogleCloudDataplexV1DataAttributeBindingPath `json:"paths,omitempty"`

	// Resource: Optional. Immutable. The resource name of the resource that
	// is associated to attributes. Presently, only entity resource is
	// supported in the form:
	// projects/{project}/locations/{location}/lakes/{lake}/zones/{zone}/enti
	// ties/{entity_id} Must belong in the same project and region as the
	// attribute binding, and there can only exist one active binding for a
	// resource.
	Resource string `json:"resource,omitempty"`

	// Uid: Output only. System generated globally unique ID for the
	// DataAttributeBinding. This ID will be different if the
	// DataAttributeBinding is deleted and re-created with the same name.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time when the DataAttributeBinding was
	// last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attributes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataAttributeBinding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataAttributeBinding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataAttributeBindingPath: Represents a
// subresource of the given resource, and associated bindings with it.
// Currently supported subresources are column and partition schema
// fields within a table.
type GoogleCloudDataplexV1DataAttributeBindingPath struct {
	// Attributes: Optional. List of attributes to be associated with the
	// path of the resource, provided in the form:
	// projects/{project}/locations/{location}/dataTaxonomies/{dataTaxonomy}/
	// attributes/{data_attribute_id}
	Attributes []string `json:"attributes,omitempty"`

	// Name: Required. The name identifier of the path. Nested columns
	// should be of the form: 'address.city'.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attributes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataAttributeBindingPath) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataAttributeBindingPath
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataProfileResult: DataProfileResult defines the
// output of DataProfileScan. Each field of the table will have field
// type specific profile result.
type GoogleCloudDataplexV1DataProfileResult struct {
	// PostScanActionsResult: Output only. The result of post scan actions.
	PostScanActionsResult *GoogleCloudDataplexV1DataProfileResultPostScanActionsResult `json:"postScanActionsResult,omitempty"`

	// Profile: The profile information per field.
	Profile *GoogleCloudDataplexV1DataProfileResultProfile `json:"profile,omitempty"`

	// RowCount: The count of rows scanned.
	RowCount int64 `json:"rowCount,omitempty,string"`

	// ScannedData: The data scanned for this result.
	ScannedData *GoogleCloudDataplexV1ScannedData `json:"scannedData,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "PostScanActionsResult") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PostScanActionsResult") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataProfileResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataProfileResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataProfileResultPostScanActionsResult: The
// result of post scan actions of DataProfileScan job.
type GoogleCloudDataplexV1DataProfileResultPostScanActionsResult struct {
	// BigqueryExportResult: Output only. The result of BigQuery export post
	// scan action.
	BigqueryExportResult *GoogleCloudDataplexV1DataProfileResultPostScanActionsResultBigQueryExportResult `json:"bigqueryExportResult,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BigqueryExportResult") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigqueryExportResult") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataProfileResultPostScanActionsResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataProfileResultPostScanActionsResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataProfileResultPostScanActionsResultBigQueryExp
// ortResult: The result of BigQuery export post scan action.
type GoogleCloudDataplexV1DataProfileResultPostScanActionsResultBigQueryExportResult struct {
	// Message: Output only. Additional information about the BigQuery
	// exporting.
	Message string `json:"message,omitempty"`

	// State: Output only. Execution state for the BigQuery exporting.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The exporting state is unspecified.
	//   "SUCCEEDED" - The exporting completed successfully.
	//   "FAILED" - The exporting is no longer running due to an error.
	//   "SKIPPED" - The exporting is skipped due to no valid scan result to
	// export (usually caused by scan failed).
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Message") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Message") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataProfileResultPostScanActionsResultBigQueryExportResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataProfileResultPostScanActionsResultBigQueryExportResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataProfileResultProfile: Contains name, type,
// mode and field type specific profile information.
type GoogleCloudDataplexV1DataProfileResultProfile struct {
	// Fields: List of fields with structural and profile information for
	// each field.
	Fields []*GoogleCloudDataplexV1DataProfileResultProfileField `json:"fields,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Fields") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataProfileResultProfile) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataProfileResultProfile
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataProfileResultProfileField: A field within a
// table.
type GoogleCloudDataplexV1DataProfileResultProfileField struct {
	// Mode: The mode of the field. Possible values include: REQUIRED, if it
	// is a required field. NULLABLE, if it is an optional field. REPEATED,
	// if it is a repeated field.
	Mode string `json:"mode,omitempty"`

	// Name: The name of the field.
	Name string `json:"name,omitempty"`

	// Profile: Profile information for the corresponding field.
	Profile *GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfo `json:"profile,omitempty"`

	// Type: The data type retrieved from the schema of the data source. For
	// instance, for a BigQuery native table, it is the BigQuery Table
	// Schema
	// (https://cloud.google.com/bigquery/docs/reference/rest/v2/tables#tablefieldschema).
	// For a Dataplex Entity, it is the Entity Schema
	// (https://cloud.google.com/dataplex/docs/reference/rpc/google.cloud.dataplex.v1#type_3).
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Mode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Mode") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataProfileResultProfileField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataProfileResultProfileField
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfo: The
// profile information for each field type.
type GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfo struct {
	// DistinctRatio: Ratio of rows with distinct values against total
	// scanned rows. Not available for complex non-groupable field type
	// RECORD and fields with REPEATABLE mode.
	DistinctRatio float64 `json:"distinctRatio,omitempty"`

	// DoubleProfile: Double type field information.
	DoubleProfile *GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoDoubleFieldInfo `json:"doubleProfile,omitempty"`

	// IntegerProfile: Integer type field information.
	IntegerProfile *GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoIntegerFieldInfo `json:"integerProfile,omitempty"`

	// NullRatio: Ratio of rows with null value against total scanned rows.
	NullRatio float64 `json:"nullRatio,omitempty"`

	// StringProfile: String type field information.
	StringProfile *GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoStringFieldInfo `json:"stringProfile,omitempty"`

	// TopNValues: The list of top N non-null values, frequency and ratio
	// with which they occur in the scanned data. N is 10 or equal to the
	// number of distinct values in the field, whichever is smaller. Not
	// available for complex non-groupable field type RECORD and fields with
	// REPEATABLE mode.
	TopNValues []*GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoTopNValue `json:"topNValues,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DistinctRatio") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DistinctRatio") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfo
	var s1 struct {
		DistinctRatio gensupport.JSONFloat64 `json:"distinctRatio"`
		NullRatio     gensupport.JSONFloat64 `json:"nullRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.DistinctRatio = float64(s1.DistinctRatio)
	s.NullRatio = float64(s1.NullRatio)
	return nil
}

// GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoDoubleFie
// ldInfo: The profile information for a double type field.
type GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoDoubleFieldInfo struct {
	// Average: Average of non-null values in the scanned data. NaN, if the
	// field has a NaN.
	Average float64 `json:"average,omitempty"`

	// Max: Maximum of non-null values in the scanned data. NaN, if the
	// field has a NaN.
	Max float64 `json:"max,omitempty"`

	// Min: Minimum of non-null values in the scanned data. NaN, if the
	// field has a NaN.
	Min float64 `json:"min,omitempty"`

	// Quartiles: A quartile divides the number of data points into four
	// parts, or quarters, of more-or-less equal size. Three main quartiles
	// used are: The first quartile (Q1) splits off the lowest 25% of data
	// from the highest 75%. It is also known as the lower or 25th empirical
	// quartile, as 25% of the data is below this point. The second quartile
	// (Q2) is the median of a data set. So, 50% of the data lies below this
	// point. The third quartile (Q3) splits off the highest 25% of data
	// from the lowest 75%. It is known as the upper or 75th empirical
	// quartile, as 75% of the data lies below this point. Here, the
	// quartiles is provided as an ordered list of quartile values for the
	// scanned data, occurring in order Q1, median, Q3.
	Quartiles []float64 `json:"quartiles,omitempty"`

	// StandardDeviation: Standard deviation of non-null values in the
	// scanned data. NaN, if the field has a NaN.
	StandardDeviation float64 `json:"standardDeviation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Average") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Average") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoDoubleFieldInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoDoubleFieldInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoDoubleFieldInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoDoubleFieldInfo
	var s1 struct {
		Average           gensupport.JSONFloat64   `json:"average"`
		Max               gensupport.JSONFloat64   `json:"max"`
		Min               gensupport.JSONFloat64   `json:"min"`
		Quartiles         []gensupport.JSONFloat64 `json:"quartiles"`
		StandardDeviation gensupport.JSONFloat64   `json:"standardDeviation"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Average = float64(s1.Average)
	s.Max = float64(s1.Max)
	s.Min = float64(s1.Min)
	s.Quartiles = make([]float64, len(s1.Quartiles))
	for i := range s1.Quartiles {
		s.Quartiles[i] = float64(s1.Quartiles[i])
	}
	s.StandardDeviation = float64(s1.StandardDeviation)
	return nil
}

// GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoIntegerFi
// eldInfo: The profile information for an integer type field.
type GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoIntegerFieldInfo struct {
	// Average: Average of non-null values in the scanned data. NaN, if the
	// field has a NaN.
	Average float64 `json:"average,omitempty"`

	// Max: Maximum of non-null values in the scanned data. NaN, if the
	// field has a NaN.
	Max int64 `json:"max,omitempty,string"`

	// Min: Minimum of non-null values in the scanned data. NaN, if the
	// field has a NaN.
	Min int64 `json:"min,omitempty,string"`

	// Quartiles: A quartile divides the number of data points into four
	// parts, or quarters, of more-or-less equal size. Three main quartiles
	// used are: The first quartile (Q1) splits off the lowest 25% of data
	// from the highest 75%. It is also known as the lower or 25th empirical
	// quartile, as 25% of the data is below this point. The second quartile
	// (Q2) is the median of a data set. So, 50% of the data lies below this
	// point. The third quartile (Q3) splits off the highest 25% of data
	// from the lowest 75%. It is known as the upper or 75th empirical
	// quartile, as 75% of the data lies below this point. Here, the
	// quartiles is provided as an ordered list of approximate quartile
	// values for the scanned data, occurring in order Q1, median, Q3.
	Quartiles googleapi.Int64s `json:"quartiles,omitempty"`

	// StandardDeviation: Standard deviation of non-null values in the
	// scanned data. NaN, if the field has a NaN.
	StandardDeviation float64 `json:"standardDeviation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Average") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Average") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoIntegerFieldInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoIntegerFieldInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoIntegerFieldInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoIntegerFieldInfo
	var s1 struct {
		Average           gensupport.JSONFloat64 `json:"average"`
		StandardDeviation gensupport.JSONFloat64 `json:"standardDeviation"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Average = float64(s1.Average)
	s.StandardDeviation = float64(s1.StandardDeviation)
	return nil
}

// GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoStringFie
// ldInfo: The profile information for a string type field.
type GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoStringFieldInfo struct {
	// AverageLength: Average length of non-null values in the scanned data.
	AverageLength float64 `json:"averageLength,omitempty"`

	// MaxLength: Maximum length of non-null values in the scanned data.
	MaxLength int64 `json:"maxLength,omitempty,string"`

	// MinLength: Minimum length of non-null values in the scanned data.
	MinLength int64 `json:"minLength,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "AverageLength") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AverageLength") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoStringFieldInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoStringFieldInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoStringFieldInfo) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoStringFieldInfo
	var s1 struct {
		AverageLength gensupport.JSONFloat64 `json:"averageLength"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.AverageLength = float64(s1.AverageLength)
	return nil
}

// GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoTopNValue
// : Top N non-null values in the scanned data.
type GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoTopNValue struct {
	// Count: Count of the corresponding value in the scanned data.
	Count int64 `json:"count,omitempty,string"`

	// Ratio: Ratio of the corresponding value in the field against the
	// total number of rows in the scanned data.
	Ratio float64 `json:"ratio,omitempty"`

	// Value: String value of a top N non-null value.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Count") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoTopNValue) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoTopNValue
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoTopNValue) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataProfileResultProfileFieldProfileInfoTopNValue
	var s1 struct {
		Ratio gensupport.JSONFloat64 `json:"ratio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Ratio = float64(s1.Ratio)
	return nil
}

// GoogleCloudDataplexV1DataProfileSpec: DataProfileScan related
// setting.
type GoogleCloudDataplexV1DataProfileSpec struct {
	// ExcludeFields: Optional. The fields to exclude from data profile.If
	// specified, the fields will be excluded from data profile, regardless
	// of include_fields value.
	ExcludeFields *GoogleCloudDataplexV1DataProfileSpecSelectedFields `json:"excludeFields,omitempty"`

	// IncludeFields: Optional. The fields to include in data profile.If not
	// specified, all fields at the time of profile scan job execution are
	// included, except for ones listed in exclude_fields.
	IncludeFields *GoogleCloudDataplexV1DataProfileSpecSelectedFields `json:"includeFields,omitempty"`

	// PostScanActions: Optional. Actions to take upon job completion..
	PostScanActions *GoogleCloudDataplexV1DataProfileSpecPostScanActions `json:"postScanActions,omitempty"`

	// RowFilter: Optional. A filter applied to all rows in a single
	// DataScan job. The filter needs to be a valid SQL expression for a
	// WHERE clause in BigQuery standard SQL syntax. Example: col1 >= 0 AND
	// col2 < 10
	RowFilter string `json:"rowFilter,omitempty"`

	// SamplingPercent: Optional. The percentage of the records to be
	// selected from the dataset for DataScan. Value can range between 0.0
	// and 100.0 with up to 3 significant decimal digits. Sampling is not
	// applied if sampling_percent is not specified, 0 or 100.
	SamplingPercent float64 `json:"samplingPercent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExcludeFields") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExcludeFields") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataProfileSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataProfileSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataProfileSpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataProfileSpec
	var s1 struct {
		SamplingPercent gensupport.JSONFloat64 `json:"samplingPercent"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SamplingPercent = float64(s1.SamplingPercent)
	return nil
}

// GoogleCloudDataplexV1DataProfileSpecPostScanActions: The
// configuration of post scan actions of DataProfileScan job.
type GoogleCloudDataplexV1DataProfileSpecPostScanActions struct {
	// BigqueryExport: Optional. If set, results will be exported to the
	// provided BigQuery table.
	BigqueryExport *GoogleCloudDataplexV1DataProfileSpecPostScanActionsBigQueryExport `json:"bigqueryExport,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigqueryExport") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigqueryExport") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataProfileSpecPostScanActions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataProfileSpecPostScanActions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataProfileSpecPostScanActionsBigQueryExport:
// The configuration of BigQuery export post scan action.
type GoogleCloudDataplexV1DataProfileSpecPostScanActionsBigQueryExport struct {
	// ResultsTable: Optional. The BigQuery table to export DataProfileScan
	// results to. Format:
	// //bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tabl
	// es/TABLE_ID
	ResultsTable string `json:"resultsTable,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResultsTable") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResultsTable") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataProfileSpecPostScanActionsBigQueryExport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataProfileSpecPostScanActionsBigQueryExport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataProfileSpecSelectedFields: The specification
// for fields to include or exclude in data profile scan.
type GoogleCloudDataplexV1DataProfileSpecSelectedFields struct {
	// FieldNames: Optional. Expected input is a list of fully qualified
	// names of fields as in the schema.Only top-level field names for
	// nested fields are supported. For instance, if 'x' is of nested field
	// type, listing 'x' is supported but 'x.y.z' is not supported. Here 'y'
	// and 'y.z' are nested fields of 'x'.
	FieldNames []string `json:"fieldNames,omitempty"`

	// ForceSendFields is a list of field names (e.g. "FieldNames") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FieldNames") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataProfileSpecSelectedFields) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataProfileSpecSelectedFields
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataQualityColumnResult: DataQualityColumnResult
// provides a more detailed, per-column view of the results.
type GoogleCloudDataplexV1DataQualityColumnResult struct {
	// Column: Output only. The column specified in the DataQualityRule.
	Column string `json:"column,omitempty"`

	// Score: Output only. The column-level data quality score for this data
	// scan job if and only if the 'column' field is set.The score ranges
	// between between 0, 100 (up to two decimal points).
	Score float64 `json:"score,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Column") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Column") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualityColumnResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualityColumnResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataQualityColumnResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataQualityColumnResult
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDataplexV1DataQualityDimension: A dimension captures data
// quality intent about a defined subset of the rules specified.
type GoogleCloudDataplexV1DataQualityDimension struct {
	// Name: The dimension name a rule belongs to. Supported dimensions are
	// "COMPLETENESS", "ACCURACY", "CONSISTENCY", "VALIDITY", "UNIQUENESS",
	// "INTEGRITY"
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualityDimension) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualityDimension
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataQualityDimensionResult:
// DataQualityDimensionResult provides a more detailed, per-dimension
// view of the results.
type GoogleCloudDataplexV1DataQualityDimensionResult struct {
	// Dimension: Output only. The dimension config specified in the
	// DataQualitySpec, as is.
	Dimension *GoogleCloudDataplexV1DataQualityDimension `json:"dimension,omitempty"`

	// Passed: Whether the dimension passed or failed.
	Passed bool `json:"passed,omitempty"`

	// Score: Output only. The dimension-level data quality score for this
	// data scan job if and only if the 'dimension' field is set.The score
	// ranges between 0, 100 (up to two decimal points).
	Score float64 `json:"score,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimension") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimension") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualityDimensionResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualityDimensionResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataQualityDimensionResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataQualityDimensionResult
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDataplexV1DataQualityResult: The output of a
// DataQualityScan.
type GoogleCloudDataplexV1DataQualityResult struct {
	// Columns: Output only. A list of results at the column level.A column
	// will have a corresponding DataQualityColumnResult if and only if
	// there is at least one rule with the 'column' field set to it.
	Columns []*GoogleCloudDataplexV1DataQualityColumnResult `json:"columns,omitempty"`

	// Dimensions: A list of results at the dimension level.A dimension will
	// have a corresponding DataQualityDimensionResult if and only if there
	// is at least one rule with the 'dimension' field set to it.
	Dimensions []*GoogleCloudDataplexV1DataQualityDimensionResult `json:"dimensions,omitempty"`

	// Passed: Overall data quality result -- true if all rules passed.
	Passed bool `json:"passed,omitempty"`

	// PostScanActionsResult: Output only. The result of post scan actions.
	PostScanActionsResult *GoogleCloudDataplexV1DataQualityResultPostScanActionsResult `json:"postScanActionsResult,omitempty"`

	// RowCount: The count of rows processed.
	RowCount int64 `json:"rowCount,omitempty,string"`

	// Rules: A list of all the rules in a job, and their results.
	Rules []*GoogleCloudDataplexV1DataQualityRuleResult `json:"rules,omitempty"`

	// ScannedData: The data scanned for this result.
	ScannedData *GoogleCloudDataplexV1ScannedData `json:"scannedData,omitempty"`

	// Score: Output only. The overall data quality score.The score ranges
	// between 0, 100 (up to two decimal points).
	Score float64 `json:"score,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Columns") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Columns") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualityResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualityResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataQualityResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataQualityResult
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDataplexV1DataQualityResultPostScanActionsResult: The
// result of post scan actions of DataQualityScan job.
type GoogleCloudDataplexV1DataQualityResultPostScanActionsResult struct {
	// BigqueryExportResult: Output only. The result of BigQuery export post
	// scan action.
	BigqueryExportResult *GoogleCloudDataplexV1DataQualityResultPostScanActionsResultBigQueryExportResult `json:"bigqueryExportResult,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BigqueryExportResult") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigqueryExportResult") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualityResultPostScanActionsResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualityResultPostScanActionsResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataQualityResultPostScanActionsResultBigQueryExp
// ortResult: The result of BigQuery export post scan action.
type GoogleCloudDataplexV1DataQualityResultPostScanActionsResultBigQueryExportResult struct {
	// Message: Output only. Additional information about the BigQuery
	// exporting.
	Message string `json:"message,omitempty"`

	// State: Output only. Execution state for the BigQuery exporting.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The exporting state is unspecified.
	//   "SUCCEEDED" - The exporting completed successfully.
	//   "FAILED" - The exporting is no longer running due to an error.
	//   "SKIPPED" - The exporting is skipped due to no valid scan result to
	// export (usually caused by scan failed).
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Message") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Message") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualityResultPostScanActionsResultBigQueryExportResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualityResultPostScanActionsResultBigQueryExportResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataQualityRule: A rule captures data quality
// intent about a data source.
type GoogleCloudDataplexV1DataQualityRule struct {
	// Column: Optional. The unnested column which this rule is evaluated
	// against.
	Column string `json:"column,omitempty"`

	// Description: Optional. Description of the rule. The maximum length is
	// 1,024 characters.
	Description string `json:"description,omitempty"`

	// Dimension: Required. The dimension a rule belongs to. Results are
	// also aggregated at the dimension level. Supported dimensions are
	// "COMPLETENESS", "ACCURACY", "CONSISTENCY", "VALIDITY", "UNIQUENESS",
	// "INTEGRITY"
	Dimension string `json:"dimension,omitempty"`

	// IgnoreNull: Optional. Rows with null values will automatically fail a
	// rule, unless ignore_null is true. In that case, such null rows are
	// trivially considered passing.This field is only valid for the
	// following type of rules: RangeExpectation RegexExpectation
	// SetExpectation UniquenessExpectation
	IgnoreNull bool `json:"ignoreNull,omitempty"`

	// Name: Optional. A mutable name for the rule. The name must contain
	// only letters (a-z, A-Z), numbers (0-9), or hyphens (-). The maximum
	// length is 63 characters. Must start with a letter. Must end with a
	// number or a letter.
	Name string `json:"name,omitempty"`

	// NonNullExpectation: Row-level rule which evaluates whether each
	// column value is null.
	NonNullExpectation *GoogleCloudDataplexV1DataQualityRuleNonNullExpectation `json:"nonNullExpectation,omitempty"`

	// RangeExpectation: Row-level rule which evaluates whether each column
	// value lies between a specified range.
	RangeExpectation *GoogleCloudDataplexV1DataQualityRuleRangeExpectation `json:"rangeExpectation,omitempty"`

	// RegexExpectation: Row-level rule which evaluates whether each column
	// value matches a specified regex.
	RegexExpectation *GoogleCloudDataplexV1DataQualityRuleRegexExpectation `json:"regexExpectation,omitempty"`

	// RowConditionExpectation: Row-level rule which evaluates whether each
	// row in a table passes the specified condition.
	RowConditionExpectation *GoogleCloudDataplexV1DataQualityRuleRowConditionExpectation `json:"rowConditionExpectation,omitempty"`

	// SetExpectation: Row-level rule which evaluates whether each column
	// value is contained by a specified set.
	SetExpectation *GoogleCloudDataplexV1DataQualityRuleSetExpectation `json:"setExpectation,omitempty"`

	// StatisticRangeExpectation: Aggregate rule which evaluates whether the
	// column aggregate statistic lies between a specified range.
	StatisticRangeExpectation *GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectation `json:"statisticRangeExpectation,omitempty"`

	// TableConditionExpectation: Aggregate rule which evaluates whether the
	// provided expression is true for a table.
	TableConditionExpectation *GoogleCloudDataplexV1DataQualityRuleTableConditionExpectation `json:"tableConditionExpectation,omitempty"`

	// Threshold: Optional. The minimum ratio of passing_rows / total_rows
	// required to pass this rule, with a range of 0.0, 1.0.0 indicates
	// default value (i.e. 1.0).This field is only valid for row-level type
	// rules.
	Threshold float64 `json:"threshold,omitempty"`

	// UniquenessExpectation: Row-level rule which evaluates whether each
	// column value is unique.
	UniquenessExpectation *GoogleCloudDataplexV1DataQualityRuleUniquenessExpectation `json:"uniquenessExpectation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Column") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Column") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualityRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualityRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataQualityRule) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataQualityRule
	var s1 struct {
		Threshold gensupport.JSONFloat64 `json:"threshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Threshold = float64(s1.Threshold)
	return nil
}

// GoogleCloudDataplexV1DataQualityRuleNonNullExpectation: Evaluates
// whether each column value is null.
type GoogleCloudDataplexV1DataQualityRuleNonNullExpectation struct {
}

// GoogleCloudDataplexV1DataQualityRuleRangeExpectation: Evaluates
// whether each column value lies between a specified range.
type GoogleCloudDataplexV1DataQualityRuleRangeExpectation struct {
	// MaxValue: Optional. The maximum column value allowed for a row to
	// pass this validation. At least one of min_value and max_value need to
	// be provided.
	MaxValue string `json:"maxValue,omitempty"`

	// MinValue: Optional. The minimum column value allowed for a row to
	// pass this validation. At least one of min_value and max_value need to
	// be provided.
	MinValue string `json:"minValue,omitempty"`

	// StrictMaxEnabled: Optional. Whether each value needs to be strictly
	// lesser than ('<') the maximum, or if equality is allowed.Only
	// relevant if a max_value has been defined. Default = false.
	StrictMaxEnabled bool `json:"strictMaxEnabled,omitempty"`

	// StrictMinEnabled: Optional. Whether each value needs to be strictly
	// greater than ('>') the minimum, or if equality is allowed.Only
	// relevant if a min_value has been defined. Default = false.
	StrictMinEnabled bool `json:"strictMinEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MaxValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxValue") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualityRuleRangeExpectation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualityRuleRangeExpectation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataQualityRuleRegexExpectation: Evaluates
// whether each column value matches a specified regex.
type GoogleCloudDataplexV1DataQualityRuleRegexExpectation struct {
	// Regex: Optional. A regular expression the column value is expected to
	// match.
	Regex string `json:"regex,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Regex") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Regex") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualityRuleRegexExpectation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualityRuleRegexExpectation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataQualityRuleResult: DataQualityRuleResult
// provides a more detailed, per-rule view of the results.
type GoogleCloudDataplexV1DataQualityRuleResult struct {
	// EvaluatedCount: The number of rows a rule was evaluated against.This
	// field is only valid for row-level type rules.Evaluated count can be
	// configured to either include all rows (default) - with null rows
	// automatically failing rule evaluation, or exclude null rows from the
	// evaluated_count, by setting ignore_nulls = true.
	EvaluatedCount int64 `json:"evaluatedCount,omitempty,string"`

	// FailingRowsQuery: The query to find rows that did not pass this
	// rule.This field is only valid for row-level type rules.
	FailingRowsQuery string `json:"failingRowsQuery,omitempty"`

	// NullCount: The number of rows with null values in the specified
	// column.
	NullCount int64 `json:"nullCount,omitempty,string"`

	// PassRatio: The ratio of passed_count / evaluated_count.This field is
	// only valid for row-level type rules.
	PassRatio float64 `json:"passRatio,omitempty"`

	// Passed: Whether the rule passed or failed.
	Passed bool `json:"passed,omitempty"`

	// PassedCount: The number of rows which passed a rule evaluation.This
	// field is only valid for row-level type rules.
	PassedCount int64 `json:"passedCount,omitempty,string"`

	// Rule: The rule specified in the DataQualitySpec, as is.
	Rule *GoogleCloudDataplexV1DataQualityRule `json:"rule,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EvaluatedCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EvaluatedCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualityRuleResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualityRuleResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataQualityRuleResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataQualityRuleResult
	var s1 struct {
		PassRatio gensupport.JSONFloat64 `json:"passRatio"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.PassRatio = float64(s1.PassRatio)
	return nil
}

// GoogleCloudDataplexV1DataQualityRuleRowConditionExpectation:
// Evaluates whether each row passes the specified condition.The SQL
// expression needs to use BigQuery standard SQL syntax and should
// produce a boolean value per row as the result.Example: col1 >= 0 AND
// col2 < 10
type GoogleCloudDataplexV1DataQualityRuleRowConditionExpectation struct {
	// SqlExpression: Optional. The SQL expression.
	SqlExpression string `json:"sqlExpression,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SqlExpression") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SqlExpression") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualityRuleRowConditionExpectation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualityRuleRowConditionExpectation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataQualityRuleSetExpectation: Evaluates whether
// each column value is contained by a specified set.
type GoogleCloudDataplexV1DataQualityRuleSetExpectation struct {
	// Values: Optional. Expected values for the column value.
	Values []string `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Values") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualityRuleSetExpectation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualityRuleSetExpectation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectation:
// Evaluates whether the column aggregate statistic lies between a
// specified range.
type GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectation struct {
	// MaxValue: Optional. The maximum column statistic value allowed for a
	// row to pass this validation.At least one of min_value and max_value
	// need to be provided.
	MaxValue string `json:"maxValue,omitempty"`

	// MinValue: Optional. The minimum column statistic value allowed for a
	// row to pass this validation.At least one of min_value and max_value
	// need to be provided.
	MinValue string `json:"minValue,omitempty"`

	// Statistic: Optional. The aggregate metric to evaluate.
	//
	// Possible values:
	//   "STATISTIC_UNDEFINED" - Unspecified statistic type
	//   "MEAN" - Evaluate the column mean
	//   "MIN" - Evaluate the column min
	//   "MAX" - Evaluate the column max
	Statistic string `json:"statistic,omitempty"`

	// StrictMaxEnabled: Optional. Whether column statistic needs to be
	// strictly lesser than ('<') the maximum, or if equality is
	// allowed.Only relevant if a max_value has been defined. Default =
	// false.
	StrictMaxEnabled bool `json:"strictMaxEnabled,omitempty"`

	// StrictMinEnabled: Optional. Whether column statistic needs to be
	// strictly greater than ('>') the minimum, or if equality is
	// allowed.Only relevant if a min_value has been defined. Default =
	// false.
	StrictMinEnabled bool `json:"strictMinEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MaxValue") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MaxValue") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualityRuleStatisticRangeExpectation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataQualityRuleTableConditionExpectation:
// Evaluates whether the provided expression is true.The SQL expression
// needs to use BigQuery standard SQL syntax and should produce a scalar
// boolean result.Example: MIN(col1) >= 0
type GoogleCloudDataplexV1DataQualityRuleTableConditionExpectation struct {
	// SqlExpression: Optional. The SQL expression.
	SqlExpression string `json:"sqlExpression,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SqlExpression") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SqlExpression") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualityRuleTableConditionExpectation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualityRuleTableConditionExpectation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataQualityRuleUniquenessExpectation: Evaluates
// whether the column has duplicates.
type GoogleCloudDataplexV1DataQualityRuleUniquenessExpectation struct {
}

// GoogleCloudDataplexV1DataQualityScanRuleResult: Information about the
// result of a data quality rule for data quality scan. The monitored
// resource is 'DataScan'.
type GoogleCloudDataplexV1DataQualityScanRuleResult struct {
	// Column: The column which this rule is evaluated against.
	Column string `json:"column,omitempty"`

	// DataSource: The data source of the data scan (e.g. BigQuery table
	// name).
	DataSource string `json:"dataSource,omitempty"`

	// EvaluatedRowCount: The number of rows evaluated against the data
	// quality rule. This field is only valid for rules of PER_ROW
	// evaluation type.
	EvaluatedRowCount int64 `json:"evaluatedRowCount,omitempty,string"`

	// EvalutionType: The evaluation type of the data quality rule.
	//
	// Possible values:
	//   "EVALUATION_TYPE_UNSPECIFIED" - An unspecified evaluation type.
	//   "PER_ROW" - The rule evaluation is done at per row level.
	//   "AGGREGATE" - The rule evaluation is done for an aggregate of rows.
	EvalutionType string `json:"evalutionType,omitempty"`

	// JobId: Identifier of the specific data scan job this log entry is
	// for.
	JobId string `json:"jobId,omitempty"`

	// NullRowCount: The number of rows with null values in the specified
	// column.
	NullRowCount int64 `json:"nullRowCount,omitempty,string"`

	// PassedRowCount: The number of rows which passed a rule evaluation.
	// This field is only valid for rules of PER_ROW evaluation type.
	PassedRowCount int64 `json:"passedRowCount,omitempty,string"`

	// Result: The result of the data quality rule.
	//
	// Possible values:
	//   "RESULT_UNSPECIFIED" - An unspecified result.
	//   "PASSED" - The data quality rule passed.
	//   "FAILED" - The data quality rule failed.
	Result string `json:"result,omitempty"`

	// RuleDimension: The dimension of the data quality rule.
	RuleDimension string `json:"ruleDimension,omitempty"`

	// RuleName: The name of the data quality rule.
	RuleName string `json:"ruleName,omitempty"`

	// RuleType: The type of the data quality rule.
	//
	// Possible values:
	//   "RULE_TYPE_UNSPECIFIED" - An unspecified rule type.
	//   "NON_NULL_EXPECTATION" - Please see
	// https://cloud.google.com/dataplex/docs/reference/rest/v1/DataQualityRule#nonnullexpectation.
	//   "RANGE_EXPECTATION" - Please see
	// https://cloud.google.com/dataplex/docs/reference/rest/v1/DataQualityRule#rangeexpectation.
	//   "REGEX_EXPECTATION" - Please see
	// https://cloud.google.com/dataplex/docs/reference/rest/v1/DataQualityRule#regexexpectation.
	//   "ROW_CONDITION_EXPECTATION" - Please see
	// https://cloud.google.com/dataplex/docs/reference/rest/v1/DataQualityRule#rowconditionexpectation.
	//   "SET_EXPECTATION" - Please see
	// https://cloud.google.com/dataplex/docs/reference/rest/v1/DataQualityRule#setexpectation.
	//   "STATISTIC_RANGE_EXPECTATION" - Please see
	// https://cloud.google.com/dataplex/docs/reference/rest/v1/DataQualityRule#statisticrangeexpectation.
	//   "TABLE_CONDITION_EXPECTATION" - Please see
	// https://cloud.google.com/dataplex/docs/reference/rest/v1/DataQualityRule#tableconditionexpectation.
	//   "UNIQUENESS_EXPECTATION" - Please see
	// https://cloud.google.com/dataplex/docs/reference/rest/v1/DataQualityRule#uniquenessexpectation.
	RuleType string `json:"ruleType,omitempty"`

	// ThresholdPercent: The passing threshold (0.0, 100.0) of the data
	// quality rule.
	ThresholdPercent float64 `json:"thresholdPercent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Column") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Column") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualityScanRuleResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualityScanRuleResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataQualityScanRuleResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataQualityScanRuleResult
	var s1 struct {
		ThresholdPercent gensupport.JSONFloat64 `json:"thresholdPercent"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ThresholdPercent = float64(s1.ThresholdPercent)
	return nil
}

// GoogleCloudDataplexV1DataQualitySpec: DataQualityScan related
// setting.
type GoogleCloudDataplexV1DataQualitySpec struct {
	// PostScanActions: Optional. Actions to take upon job completion.
	PostScanActions *GoogleCloudDataplexV1DataQualitySpecPostScanActions `json:"postScanActions,omitempty"`

	// RowFilter: Optional. A filter applied to all rows in a single
	// DataScan job. The filter needs to be a valid SQL expression for a
	// WHERE clause in BigQuery standard SQL syntax. Example: col1 >= 0 AND
	// col2 < 10
	RowFilter string `json:"rowFilter,omitempty"`

	// Rules: Required. The list of rules to evaluate against a data source.
	// At least one rule is required.
	Rules []*GoogleCloudDataplexV1DataQualityRule `json:"rules,omitempty"`

	// SamplingPercent: Optional. The percentage of the records to be
	// selected from the dataset for DataScan. Value can range between 0.0
	// and 100.0 with up to 3 significant decimal digits. Sampling is not
	// applied if sampling_percent is not specified, 0 or 100.
	SamplingPercent float64 `json:"samplingPercent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "PostScanActions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "PostScanActions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualitySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualitySpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataQualitySpec) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataQualitySpec
	var s1 struct {
		SamplingPercent gensupport.JSONFloat64 `json:"samplingPercent"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SamplingPercent = float64(s1.SamplingPercent)
	return nil
}

// GoogleCloudDataplexV1DataQualitySpecPostScanActions: The
// configuration of post scan actions of DataQualityScan.
type GoogleCloudDataplexV1DataQualitySpecPostScanActions struct {
	// BigqueryExport: Optional. If set, results will be exported to the
	// provided BigQuery table.
	BigqueryExport *GoogleCloudDataplexV1DataQualitySpecPostScanActionsBigQueryExport `json:"bigqueryExport,omitempty"`

	// NotificationReport: Optional. If set, results will be sent to the
	// provided notification receipts upon triggers.
	NotificationReport *GoogleCloudDataplexV1DataQualitySpecPostScanActionsNotificationReport `json:"notificationReport,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BigqueryExport") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigqueryExport") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualitySpecPostScanActions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualitySpecPostScanActions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataQualitySpecPostScanActionsBigQueryExport:
// The configuration of BigQuery export post scan action.
type GoogleCloudDataplexV1DataQualitySpecPostScanActionsBigQueryExport struct {
	// ResultsTable: Optional. The BigQuery table to export DataQualityScan
	// results to. Format:
	// //bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tabl
	// es/TABLE_ID
	ResultsTable string `json:"resultsTable,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResultsTable") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResultsTable") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualitySpecPostScanActionsBigQueryExport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualitySpecPostScanActionsBigQueryExport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataQualitySpecPostScanActionsJobEndTrigger:
// This trigger is triggered whenever a scan job run ends, regardless of
// the result.
type GoogleCloudDataplexV1DataQualitySpecPostScanActionsJobEndTrigger struct {
}

// GoogleCloudDataplexV1DataQualitySpecPostScanActionsJobFailureTrigger:
// This trigger is triggered when the scan job itself fails, regardless
// of the result.
type GoogleCloudDataplexV1DataQualitySpecPostScanActionsJobFailureTrigger struct {
}

// GoogleCloudDataplexV1DataQualitySpecPostScanActionsNotificationReport:
//
//	The configuration of notification report post scan action.
type GoogleCloudDataplexV1DataQualitySpecPostScanActionsNotificationReport struct {
	// JobEndTrigger: Optional. If set, report will be sent when a scan job
	// ends.
	JobEndTrigger *GoogleCloudDataplexV1DataQualitySpecPostScanActionsJobEndTrigger `json:"jobEndTrigger,omitempty"`

	// JobFailureTrigger: Optional. If set, report will be sent when a scan
	// job fails.
	JobFailureTrigger *GoogleCloudDataplexV1DataQualitySpecPostScanActionsJobFailureTrigger `json:"jobFailureTrigger,omitempty"`

	// Recipients: Required. The recipients who will receive the
	// notification report.
	Recipients *GoogleCloudDataplexV1DataQualitySpecPostScanActionsRecipients `json:"recipients,omitempty"`

	// ScoreThresholdTrigger: Optional. If set, report will be sent when
	// score threshold is met.
	ScoreThresholdTrigger *GoogleCloudDataplexV1DataQualitySpecPostScanActionsScoreThresholdTrigger `json:"scoreThresholdTrigger,omitempty"`

	// ForceSendFields is a list of field names (e.g. "JobEndTrigger") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "JobEndTrigger") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualitySpecPostScanActionsNotificationReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualitySpecPostScanActionsNotificationReport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataQualitySpecPostScanActionsRecipients: The
// individuals or groups who are designated to receive notifications
// upon triggers.
type GoogleCloudDataplexV1DataQualitySpecPostScanActionsRecipients struct {
	// Emails: Optional. The email recipients who will receive the
	// DataQualityScan results report.
	Emails []string `json:"emails,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Emails") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Emails") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualitySpecPostScanActionsRecipients) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualitySpecPostScanActionsRecipients
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataQualitySpecPostScanActionsScoreThresholdTrigg
// er: This trigger is triggered when the DQ score in the job result is
// less than a specified input score.
type GoogleCloudDataplexV1DataQualitySpecPostScanActionsScoreThresholdTrigger struct {
	// ScoreThreshold: Optional. The score range is in 0,100.
	ScoreThreshold float64 `json:"scoreThreshold,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ScoreThreshold") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ScoreThreshold") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataQualitySpecPostScanActionsScoreThresholdTrigger) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataQualitySpecPostScanActionsScoreThresholdTrigger
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataQualitySpecPostScanActionsScoreThresholdTrigger) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataQualitySpecPostScanActionsScoreThresholdTrigger
	var s1 struct {
		ScoreThreshold gensupport.JSONFloat64 `json:"scoreThreshold"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.ScoreThreshold = float64(s1.ScoreThreshold)
	return nil
}

// GoogleCloudDataplexV1DataScan: Represents a user-visible job which
// provides the insights for the related data source.For example: Data
// Quality: generates queries based on the rules and runs against the
// data to get data quality check results. Data Profile: analyzes the
// data in table(s) and generates insights about the structure, content
// and relationships (such as null percent, cardinality, min/max/mean,
// etc).
type GoogleCloudDataplexV1DataScan struct {
	// CreateTime: Output only. The time when the scan was created.
	CreateTime string `json:"createTime,omitempty"`

	// Data: Required. The data source for DataScan.
	Data *GoogleCloudDataplexV1DataSource `json:"data,omitempty"`

	// DataProfileResult: Output only. The result of the data profile scan.
	DataProfileResult *GoogleCloudDataplexV1DataProfileResult `json:"dataProfileResult,omitempty"`

	// DataProfileSpec: DataProfileScan related setting.
	DataProfileSpec *GoogleCloudDataplexV1DataProfileSpec `json:"dataProfileSpec,omitempty"`

	// DataQualityResult: Output only. The result of the data quality scan.
	DataQualityResult *GoogleCloudDataplexV1DataQualityResult `json:"dataQualityResult,omitempty"`

	// DataQualitySpec: DataQualityScan related setting.
	DataQualitySpec *GoogleCloudDataplexV1DataQualitySpec `json:"dataQualitySpec,omitempty"`

	// Description: Optional. Description of the scan. Must be between
	// 1-1024 characters.
	Description string `json:"description,omitempty"`

	// DisplayName: Optional. User friendly display name. Must be between
	// 1-256 characters.
	DisplayName string `json:"displayName,omitempty"`

	// ExecutionSpec: Optional. DataScan execution settings.If not
	// specified, the fields in it will use their default values.
	ExecutionSpec *GoogleCloudDataplexV1DataScanExecutionSpec `json:"executionSpec,omitempty"`

	// ExecutionStatus: Output only. Status of the data scan execution.
	ExecutionStatus *GoogleCloudDataplexV1DataScanExecutionStatus `json:"executionStatus,omitempty"`

	// Labels: Optional. User-defined labels for the scan.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. The relative resource name of the scan, of the
	// form:
	// projects/{project}/locations/{location_id}/dataScans/{datascan_id},
	// where project refers to a project_id or project_number and
	// location_id refers to a GCP region.
	Name string `json:"name,omitempty"`

	// State: Output only. Current state of the DataScan.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is not specified.
	//   "ACTIVE" - Resource is active, i.e., ready to use.
	//   "CREATING" - Resource is under creation.
	//   "DELETING" - Resource is under deletion.
	//   "ACTION_REQUIRED" - Resource is active but has unresolved actions.
	State string `json:"state,omitempty"`

	// Type: Output only. The type of DataScan.
	//
	// Possible values:
	//   "DATA_SCAN_TYPE_UNSPECIFIED" - The DataScan type is unspecified.
	//   "DATA_QUALITY" - Data Quality scan.
	//   "DATA_PROFILE" - Data Profile scan.
	Type string `json:"type,omitempty"`

	// Uid: Output only. System generated globally unique ID for the scan.
	// This ID will be different if the scan is deleted and re-created with
	// the same name.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time when the scan was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataScan) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataScan
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataScanEvent: These messages contain
// information about the execution of a datascan. The monitored resource
// is 'DataScan' Next ID: 13
type GoogleCloudDataplexV1DataScanEvent struct {
	// CreateTime: The time when the data scan job was created.
	CreateTime string `json:"createTime,omitempty"`

	// DataProfile: Data profile result for data profile type data scan.
	DataProfile *GoogleCloudDataplexV1DataScanEventDataProfileResult `json:"dataProfile,omitempty"`

	// DataProfileConfigs: Applied configs for data profile type data scan.
	DataProfileConfigs *GoogleCloudDataplexV1DataScanEventDataProfileAppliedConfigs `json:"dataProfileConfigs,omitempty"`

	// DataQuality: Data quality result for data quality type data scan.
	DataQuality *GoogleCloudDataplexV1DataScanEventDataQualityResult `json:"dataQuality,omitempty"`

	// DataQualityConfigs: Applied configs for data quality type data scan.
	DataQualityConfigs *GoogleCloudDataplexV1DataScanEventDataQualityAppliedConfigs `json:"dataQualityConfigs,omitempty"`

	// DataSource: The data source of the data scan
	DataSource string `json:"dataSource,omitempty"`

	// EndTime: The time when the data scan job finished.
	EndTime string `json:"endTime,omitempty"`

	// JobId: The identifier of the specific data scan job this log entry is
	// for.
	JobId string `json:"jobId,omitempty"`

	// Message: The message describing the data scan job event.
	Message string `json:"message,omitempty"`

	// PostScanActionsResult: The result of post scan actions.
	PostScanActionsResult *GoogleCloudDataplexV1DataScanEventPostScanActionsResult `json:"postScanActionsResult,omitempty"`

	// Scope: The scope of the data scan (e.g. full, incremental).
	//
	// Possible values:
	//   "SCOPE_UNSPECIFIED" - An unspecified scope type.
	//   "FULL" - Data scan runs on all of the data.
	//   "INCREMENTAL" - Data scan runs on incremental data.
	Scope string `json:"scope,omitempty"`

	// SpecVersion: A version identifier of the spec which was used to
	// execute this job.
	SpecVersion string `json:"specVersion,omitempty"`

	// StartTime: The time when the data scan job started to run.
	StartTime string `json:"startTime,omitempty"`

	// State: The status of the data scan job.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified job state.
	//   "STARTED" - Data scan job started.
	//   "SUCCEEDED" - Data scan job successfully completed.
	//   "FAILED" - Data scan job was unsuccessful.
	//   "CANCELLED" - Data scan job was cancelled.
	//   "CREATED" - Data scan job was createed.
	State string `json:"state,omitempty"`

	// Trigger: The trigger type of the data scan job.
	//
	// Possible values:
	//   "TRIGGER_UNSPECIFIED" - An unspecified trigger type.
	//   "ON_DEMAND" - Data scan triggers on demand.
	//   "SCHEDULE" - Data scan triggers as per schedule.
	Trigger string `json:"trigger,omitempty"`

	// Type: The type of the data scan.
	//
	// Possible values:
	//   "SCAN_TYPE_UNSPECIFIED" - An unspecified data scan type.
	//   "DATA_PROFILE" - Data scan for data profile.
	//   "DATA_QUALITY" - Data scan for data quality.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataScanEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataScanEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataScanEventDataProfileAppliedConfigs: Applied
// configs for data profile type data scan job.
type GoogleCloudDataplexV1DataScanEventDataProfileAppliedConfigs struct {
	// ColumnFilterApplied: Boolean indicating whether a column filter was
	// applied in the DataScan job.
	ColumnFilterApplied bool `json:"columnFilterApplied,omitempty"`

	// RowFilterApplied: Boolean indicating whether a row filter was applied
	// in the DataScan job.
	RowFilterApplied bool `json:"rowFilterApplied,omitempty"`

	// SamplingPercent: The percentage of the records selected from the
	// dataset for DataScan. Value ranges between 0.0 and 100.0. Value 0.0
	// or 100.0 imply that sampling was not applied.
	SamplingPercent float64 `json:"samplingPercent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ColumnFilterApplied")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ColumnFilterApplied") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataScanEventDataProfileAppliedConfigs) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataScanEventDataProfileAppliedConfigs
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataScanEventDataProfileAppliedConfigs) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataScanEventDataProfileAppliedConfigs
	var s1 struct {
		SamplingPercent gensupport.JSONFloat64 `json:"samplingPercent"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SamplingPercent = float64(s1.SamplingPercent)
	return nil
}

// GoogleCloudDataplexV1DataScanEventDataProfileResult: Data profile
// result for data scan job.
type GoogleCloudDataplexV1DataScanEventDataProfileResult struct {
	// RowCount: The count of rows processed in the data scan job.
	RowCount int64 `json:"rowCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "RowCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RowCount") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataScanEventDataProfileResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataScanEventDataProfileResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataScanEventDataQualityAppliedConfigs: Applied
// configs for data quality type data scan job.
type GoogleCloudDataplexV1DataScanEventDataQualityAppliedConfigs struct {
	// RowFilterApplied: Boolean indicating whether a row filter was applied
	// in the DataScan job.
	RowFilterApplied bool `json:"rowFilterApplied,omitempty"`

	// SamplingPercent: The percentage of the records selected from the
	// dataset for DataScan. Value ranges between 0.0 and 100.0. Value 0.0
	// or 100.0 imply that sampling was not applied.
	SamplingPercent float64 `json:"samplingPercent,omitempty"`

	// ForceSendFields is a list of field names (e.g. "RowFilterApplied") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RowFilterApplied") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataScanEventDataQualityAppliedConfigs) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataScanEventDataQualityAppliedConfigs
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataScanEventDataQualityAppliedConfigs) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataScanEventDataQualityAppliedConfigs
	var s1 struct {
		SamplingPercent gensupport.JSONFloat64 `json:"samplingPercent"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SamplingPercent = float64(s1.SamplingPercent)
	return nil
}

// GoogleCloudDataplexV1DataScanEventDataQualityResult: Data quality
// result for data scan job.
type GoogleCloudDataplexV1DataScanEventDataQualityResult struct {
	// ColumnScore: The score of each column scanned in the data scan job.
	// The key of the map is the name of the column. The value is the data
	// quality score for the column.The score ranges between 0, 100 (up to
	// two decimal points).
	ColumnScore map[string]float64 `json:"columnScore,omitempty"`

	// DimensionPassed: The result of each dimension for data quality
	// result. The key of the map is the name of the dimension. The value is
	// the bool value depicting whether the dimension result was pass or
	// not.
	DimensionPassed map[string]bool `json:"dimensionPassed,omitempty"`

	// DimensionScore: The score of each dimension for data quality result.
	// The key of the map is the name of the dimension. The value is the
	// data quality score for the dimension.The score ranges between 0, 100
	// (up to two decimal points).
	DimensionScore map[string]float64 `json:"dimensionScore,omitempty"`

	// Passed: Whether the data quality result was pass or not.
	Passed bool `json:"passed,omitempty"`

	// RowCount: The count of rows processed in the data scan job.
	RowCount int64 `json:"rowCount,omitempty,string"`

	// Score: The table-level data quality score for the data scan job.The
	// data quality score ranges between 0, 100 (up to two decimal points).
	Score float64 `json:"score,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ColumnScore") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ColumnScore") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataScanEventDataQualityResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataScanEventDataQualityResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudDataplexV1DataScanEventDataQualityResult) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudDataplexV1DataScanEventDataQualityResult
	var s1 struct {
		Score gensupport.JSONFloat64 `json:"score"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Score = float64(s1.Score)
	return nil
}

// GoogleCloudDataplexV1DataScanEventPostScanActionsResult: Post scan
// actions result for data scan job.
type GoogleCloudDataplexV1DataScanEventPostScanActionsResult struct {
	// BigqueryExportResult: The result of BigQuery export post scan action.
	BigqueryExportResult *GoogleCloudDataplexV1DataScanEventPostScanActionsResultBigQueryExportResult `json:"bigqueryExportResult,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BigqueryExportResult") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BigqueryExportResult") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataScanEventPostScanActionsResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataScanEventPostScanActionsResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataScanEventPostScanActionsResultBigQueryExportR
// esult: The result of BigQuery export post scan action.
type GoogleCloudDataplexV1DataScanEventPostScanActionsResultBigQueryExportResult struct {
	// Message: Additional information about the BigQuery exporting.
	Message string `json:"message,omitempty"`

	// State: Execution state for the BigQuery exporting.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The exporting state is unspecified.
	//   "SUCCEEDED" - The exporting completed successfully.
	//   "FAILED" - The exporting is no longer running due to an error.
	//   "SKIPPED" - The exporting is skipped due to no valid scan result to
	// export (usually caused by scan failed).
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Message") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Message") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataScanEventPostScanActionsResultBigQueryExportResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataScanEventPostScanActionsResultBigQueryExportResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataScanExecutionSpec: DataScan execution
// settings.
type GoogleCloudDataplexV1DataScanExecutionSpec struct {
	// Field: Immutable. The unnested field (of type Date or Timestamp) that
	// contains values which monotonically increase over time.If not
	// specified, a data scan will run for all data in the table.
	Field string `json:"field,omitempty"`

	// Trigger: Optional. Spec related to how often and when a scan should
	// be triggered.If not specified, the default is OnDemand, which means
	// the scan will not run until the user calls RunDataScan API.
	Trigger *GoogleCloudDataplexV1Trigger `json:"trigger,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Field") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataScanExecutionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataScanExecutionSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataScanExecutionStatus: Status of the data scan
// execution.
type GoogleCloudDataplexV1DataScanExecutionStatus struct {
	// LatestJobEndTime: The time when the latest DataScanJob ended.
	LatestJobEndTime string `json:"latestJobEndTime,omitempty"`

	// LatestJobStartTime: The time when the latest DataScanJob started.
	LatestJobStartTime string `json:"latestJobStartTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LatestJobEndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LatestJobEndTime") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataScanExecutionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataScanExecutionStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataScanJob: A DataScanJob represents an
// instance of DataScan execution.
type GoogleCloudDataplexV1DataScanJob struct {
	// DataProfileResult: Output only. The result of the data profile scan.
	DataProfileResult *GoogleCloudDataplexV1DataProfileResult `json:"dataProfileResult,omitempty"`

	// DataProfileSpec: Output only. DataProfileScan related setting.
	DataProfileSpec *GoogleCloudDataplexV1DataProfileSpec `json:"dataProfileSpec,omitempty"`

	// DataQualityResult: Output only. The result of the data quality scan.
	DataQualityResult *GoogleCloudDataplexV1DataQualityResult `json:"dataQualityResult,omitempty"`

	// DataQualitySpec: Output only. DataQualityScan related setting.
	DataQualitySpec *GoogleCloudDataplexV1DataQualitySpec `json:"dataQualitySpec,omitempty"`

	// EndTime: Output only. The time when the DataScanJob ended.
	EndTime string `json:"endTime,omitempty"`

	// Message: Output only. Additional information about the current state.
	Message string `json:"message,omitempty"`

	// Name: Output only. The relative resource name of the DataScanJob, of
	// the form:
	// projects/{project}/locations/{location_id}/dataScans/{datascan_id}/job
	// s/{job_id}, where project refers to a project_id or project_number
	// and location_id refers to a GCP region.
	Name string `json:"name,omitempty"`

	// StartTime: Output only. The time when the DataScanJob was started.
	StartTime string `json:"startTime,omitempty"`

	// State: Output only. Execution state for the DataScanJob.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The DataScanJob state is unspecified.
	//   "RUNNING" - The DataScanJob is running.
	//   "CANCELING" - The DataScanJob is canceling.
	//   "CANCELLED" - The DataScanJob cancellation was successful.
	//   "SUCCEEDED" - The DataScanJob completed successfully.
	//   "FAILED" - The DataScanJob is no longer running due to an error.
	//   "PENDING" - The DataScanJob has been created but not started to run
	// yet.
	State string `json:"state,omitempty"`

	// Type: Output only. The type of the parent DataScan.
	//
	// Possible values:
	//   "DATA_SCAN_TYPE_UNSPECIFIED" - The DataScan type is unspecified.
	//   "DATA_QUALITY" - Data Quality scan.
	//   "DATA_PROFILE" - Data Profile scan.
	Type string `json:"type,omitempty"`

	// Uid: Output only. System generated globally unique ID for the
	// DataScanJob.
	Uid string `json:"uid,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DataProfileResult")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataProfileResult") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataScanJob) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataScanJob
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataSource: The data source for DataScan.
type GoogleCloudDataplexV1DataSource struct {
	// Entity: Immutable. The Dataplex entity that represents the data
	// source (e.g. BigQuery table) for DataScan, of the form:
	// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zone
	// s/{zone_id}/entities/{entity_id}.
	Entity string `json:"entity,omitempty"`

	// Resource: Immutable. The service-qualified full resource name of the
	// cloud resource for a DataScan job to scan against. The field could
	// be: BigQuery table of type "TABLE" for
	// DataProfileScan/DataQualityScan Format:
	// //bigquery.googleapis.com/projects/PROJECT_ID/datasets/DATASET_ID/tabl
	// es/TABLE_ID
	Resource string `json:"resource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entity") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entity") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataSource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DataTaxonomy: DataTaxonomy represents a set of
// hierarchical DataAttributes resources, grouped with a common theme
// Eg: 'SensitiveDataTaxonomy' can have attributes to manage PII data.
// It is defined at project level.
type GoogleCloudDataplexV1DataTaxonomy struct {
	// AttributeCount: Output only. The number of attributes in the
	// DataTaxonomy.
	AttributeCount int64 `json:"attributeCount,omitempty"`

	// ClassCount: Output only. The number of classes in the DataTaxonomy.
	ClassCount int64 `json:"classCount,omitempty"`

	// CreateTime: Output only. The time when the DataTaxonomy was created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Optional. Description of the DataTaxonomy.
	Description string `json:"description,omitempty"`

	// DisplayName: Optional. User friendly display name.
	DisplayName string `json:"displayName,omitempty"`

	// Etag: This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure
	// the client has an up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`

	// Labels: Optional. User-defined labels for the DataTaxonomy.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. The relative resource name of the DataTaxonomy, of
	// the form:
	// projects/{project_number}/locations/{location_id}/dataTaxonomies/{data
	// _taxonomy_id}.
	Name string `json:"name,omitempty"`

	// Uid: Output only. System generated globally unique ID for the
	// dataTaxonomy. This ID will be different if the DataTaxonomy is
	// deleted and re-created with the same name.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time when the DataTaxonomy was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AttributeCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttributeCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DataTaxonomy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DataTaxonomy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DiscoveryEvent: The payload associated with
// Discovery data processing.
type GoogleCloudDataplexV1DiscoveryEvent struct {
	// Action: Details about the action associated with the event.
	Action *GoogleCloudDataplexV1DiscoveryEventActionDetails `json:"action,omitempty"`

	// AssetId: The id of the associated asset.
	AssetId string `json:"assetId,omitempty"`

	// Config: Details about discovery configuration in effect.
	Config *GoogleCloudDataplexV1DiscoveryEventConfigDetails `json:"config,omitempty"`

	// DataLocation: The data location associated with the event.
	DataLocation string `json:"dataLocation,omitempty"`

	// Entity: Details about the entity associated with the event.
	Entity *GoogleCloudDataplexV1DiscoveryEventEntityDetails `json:"entity,omitempty"`

	// LakeId: The id of the associated lake.
	LakeId string `json:"lakeId,omitempty"`

	// Message: The log message.
	Message string `json:"message,omitempty"`

	// Partition: Details about the partition associated with the event.
	Partition *GoogleCloudDataplexV1DiscoveryEventPartitionDetails `json:"partition,omitempty"`

	// Type: The type of the event being logged.
	//
	// Possible values:
	//   "EVENT_TYPE_UNSPECIFIED" - An unspecified event type.
	//   "CONFIG" - An event representing discovery configuration in effect.
	//   "ENTITY_CREATED" - An event representing a metadata entity being
	// created.
	//   "ENTITY_UPDATED" - An event representing a metadata entity being
	// updated.
	//   "ENTITY_DELETED" - An event representing a metadata entity being
	// deleted.
	//   "PARTITION_CREATED" - An event representing a partition being
	// created.
	//   "PARTITION_UPDATED" - An event representing a partition being
	// updated.
	//   "PARTITION_DELETED" - An event representing a partition being
	// deleted.
	Type string `json:"type,omitempty"`

	// ZoneId: The id of the associated zone.
	ZoneId string `json:"zoneId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DiscoveryEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DiscoveryEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DiscoveryEventActionDetails: Details about the
// action.
type GoogleCloudDataplexV1DiscoveryEventActionDetails struct {
	// Type: The type of action. Eg. IncompatibleDataSchema,
	// InvalidDataFormat
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DiscoveryEventActionDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DiscoveryEventActionDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DiscoveryEventConfigDetails: Details about
// configuration events.
type GoogleCloudDataplexV1DiscoveryEventConfigDetails struct {
	// Parameters: A list of discovery configuration parameters in effect.
	// The keys are the field paths within DiscoverySpec. Eg.
	// includePatterns, excludePatterns, csvOptions.disableTypeInference,
	// etc.
	Parameters map[string]string `json:"parameters,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Parameters") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Parameters") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DiscoveryEventConfigDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DiscoveryEventConfigDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DiscoveryEventEntityDetails: Details about the
// entity.
type GoogleCloudDataplexV1DiscoveryEventEntityDetails struct {
	// Entity: The name of the entity resource. The name is the
	// fully-qualified resource name.
	Entity string `json:"entity,omitempty"`

	// Type: The type of the entity resource.
	//
	// Possible values:
	//   "ENTITY_TYPE_UNSPECIFIED" - An unspecified event type.
	//   "TABLE" - Entities representing structured data.
	//   "FILESET" - Entities representing unstructured data.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entity") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entity") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DiscoveryEventEntityDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DiscoveryEventEntityDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1DiscoveryEventPartitionDetails: Details about
// the partition.
type GoogleCloudDataplexV1DiscoveryEventPartitionDetails struct {
	// Entity: The name to the containing entity resource. The name is the
	// fully-qualified resource name.
	Entity string `json:"entity,omitempty"`

	// Partition: The name to the partition resource. The name is the
	// fully-qualified resource name.
	Partition string `json:"partition,omitempty"`

	// SampledDataLocations: The locations of the data items (e.g., a Cloud
	// Storage objects) sampled for metadata inference.
	SampledDataLocations []string `json:"sampledDataLocations,omitempty"`

	// Type: The type of the containing entity resource.
	//
	// Possible values:
	//   "ENTITY_TYPE_UNSPECIFIED" - An unspecified event type.
	//   "TABLE" - Entities representing structured data.
	//   "FILESET" - Entities representing unstructured data.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entity") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entity") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1DiscoveryEventPartitionDetails) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1DiscoveryEventPartitionDetails
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1Entity: Represents tables and fileset metadata
// contained within a zone.
type GoogleCloudDataplexV1Entity struct {
	// Access: Output only. Identifies the access mechanism to the entity.
	// Not user settable.
	Access *GoogleCloudDataplexV1StorageAccess `json:"access,omitempty"`

	// Asset: Required. Immutable. The ID of the asset associated with the
	// storage location containing the entity data. The entity must be with
	// in the same zone with the asset.
	Asset string `json:"asset,omitempty"`

	// CatalogEntry: Output only. The name of the associated Data Catalog
	// entry.
	CatalogEntry string `json:"catalogEntry,omitempty"`

	// Compatibility: Output only. Metadata stores that the entity is
	// compatible with.
	Compatibility *GoogleCloudDataplexV1EntityCompatibilityStatus `json:"compatibility,omitempty"`

	// CreateTime: Output only. The time when the entity was created.
	CreateTime string `json:"createTime,omitempty"`

	// DataPath: Required. Immutable. The storage path of the entity data.
	// For Cloud Storage data, this is the fully-qualified path to the
	// entity, such as gs://bucket/path/to/data. For BigQuery data, this is
	// the name of the table resource, such as
	// projects/project_id/datasets/dataset_id/tables/table_id.
	DataPath string `json:"dataPath,omitempty"`

	// DataPathPattern: Optional. The set of items within the data path
	// constituting the data in the entity, represented as a glob path.
	// Example: gs://bucket/path/to/data/**/*.csv.
	DataPathPattern string `json:"dataPathPattern,omitempty"`

	// Description: Optional. User friendly longer description text. Must be
	// shorter than or equal to 1024 characters.
	Description string `json:"description,omitempty"`

	// DisplayName: Optional. Display name must be shorter than or equal to
	// 256 characters.
	DisplayName string `json:"displayName,omitempty"`

	// Etag: Optional. The etag associated with the entity, which can be
	// retrieved with a GetEntity request. Required for update and delete
	// requests.
	Etag string `json:"etag,omitempty"`

	// Format: Required. Identifies the storage format of the entity data.
	// It does not apply to entities with data stored in BigQuery.
	Format *GoogleCloudDataplexV1StorageFormat `json:"format,omitempty"`

	// Id: Required. A user-provided entity ID. It is mutable, and will be
	// used as the published table name. Specifying a new ID in an update
	// entity request will override the existing value. The ID must contain
	// only letters (a-z, A-Z), numbers (0-9), and underscores, and consist
	// of 256 or fewer characters.
	Id string `json:"id,omitempty"`

	// Name: Output only. The resource name of the entity, of the form:
	// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zone
	// s/{zone_id}/entities/{id}.
	Name string `json:"name,omitempty"`

	// Schema: Required. The description of the data structure and layout.
	// The schema is not included in list responses. It is only included in
	// SCHEMA and FULL entity views of a GetEntity response.
	Schema *GoogleCloudDataplexV1Schema `json:"schema,omitempty"`

	// System: Required. Immutable. Identifies the storage system of the
	// entity data.
	//
	// Possible values:
	//   "STORAGE_SYSTEM_UNSPECIFIED" - Storage system unspecified.
	//   "CLOUD_STORAGE" - The entity data is contained within a Cloud
	// Storage bucket.
	//   "BIGQUERY" - The entity data is contained within a BigQuery
	// dataset.
	System string `json:"system,omitempty"`

	// Type: Required. Immutable. The type of entity.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Type unspecified.
	//   "TABLE" - Structured and semi-structured data.
	//   "FILESET" - Unstructured data.
	Type string `json:"type,omitempty"`

	// Uid: Output only. System generated unique ID for the Entity. This ID
	// will be different if the Entity is deleted and re-created with the
	// same name.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time when the entity was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Access") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Access") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1Entity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1Entity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1EntityCompatibilityStatus: Provides
// compatibility information for various metadata stores.
type GoogleCloudDataplexV1EntityCompatibilityStatus struct {
	// Bigquery: Output only. Whether this entity is compatible with
	// BigQuery.
	Bigquery *GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility `json:"bigquery,omitempty"`

	// HiveMetastore: Output only. Whether this entity is compatible with
	// Hive Metastore.
	HiveMetastore *GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility `json:"hiveMetastore,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Bigquery") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Bigquery") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1EntityCompatibilityStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1EntityCompatibilityStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility: Provides
// compatibility information for a specific metadata store.
type GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility struct {
	// Compatible: Output only. Whether the entity is compatible and can be
	// represented in the metadata store.
	Compatible bool `json:"compatible,omitempty"`

	// Reason: Output only. Provides additional detail if the entity is
	// incompatible with the metadata store.
	Reason string `json:"reason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Compatible") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Compatible") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1EntityCompatibilityStatusCompatibility
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1Entry: An entry is a representation of a data
// asset which can be described by various metadata.
type GoogleCloudDataplexV1Entry struct {
	// Aspects: Optional. The Aspects attached to the Entry. The key is
	// either the resource name of the aspect type (if the aspect is
	// attached directly to the entry) or "aspectType@path" if the aspect is
	// attached to an entry's path.
	Aspects map[string]GoogleCloudDataplexV1Aspect `json:"aspects,omitempty"`

	// CreateTime: Output only. The time when the Entry was created.
	CreateTime string `json:"createTime,omitempty"`

	// EntrySource: Optional. Source system related information for an
	// entry.
	EntrySource *GoogleCloudDataplexV1EntrySource `json:"entrySource,omitempty"`

	// EntryType: Required. Immutable. The resource name of the EntryType
	// used to create this Entry.
	EntryType string `json:"entryType,omitempty"`

	// FullyQualifiedName: Optional. A name for the entry that can reference
	// it in an external system. The maximum size of the field is 4000
	// characters.
	FullyQualifiedName string `json:"fullyQualifiedName,omitempty"`

	// Name: Identifier. The relative resource name of the Entry, of the
	// form:
	// projects/{project}/locations/{location}/entryGroups/{entry_group}/entr
	// ies/{entry}.
	Name string `json:"name,omitempty"`

	// ParentEntry: Optional. Immutable. The resource name of the parent
	// entry.
	ParentEntry string `json:"parentEntry,omitempty"`

	// UpdateTime: Output only. The time when the Entry was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Aspects") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Aspects") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1Entry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1Entry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1EntryGroup: An Entry Group represents a logical
// grouping of one or more Entries.
type GoogleCloudDataplexV1EntryGroup struct {
	// CreateTime: Output only. The time when the EntryGroup was created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Optional. Description of the EntryGroup.
	Description string `json:"description,omitempty"`

	// DisplayName: Optional. User friendly display name.
	DisplayName string `json:"displayName,omitempty"`

	// Etag: This checksum is computed by the server based on the value of
	// other fields, and may be sent on update and delete requests to ensure
	// the client has an up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`

	// Labels: Optional. User-defined labels for the EntryGroup.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. The relative resource name of the EntryGroup, of
	// the form:
	// projects/{project_number}/locations/{location_id}/entryGroups/{entry_g
	// roup_id}.
	Name string `json:"name,omitempty"`

	// TransferStatus: Output only. Denotes the transfer status of the Entry
	// Group. It is unspecified for Entry Group created from Dataplex API.
	//
	// Possible values:
	//   "TRANSFER_STATUS_UNSPECIFIED" - The default value. It is set for
	// resources that were not subject for migration from Data Catalog
	// service.
	//   "TRANSFER_STATUS_MIGRATED" - Indicates that a resource was migrated
	// from Data Catalog service but it hasn't been transferred yet. In
	// particular the resource cannot be updated from Dataplex API.
	//   "TRANSFER_STATUS_TRANSFERRED" - Indicates that a resource was
	// transferred from Data Catalog service. The resource can only be
	// updated from Dataplex API.
	TransferStatus string `json:"transferStatus,omitempty"`

	// Uid: Output only. System generated globally unique ID for the
	// EntryGroup. This ID will be different if the EntryGroup is deleted
	// and re-created with the same name.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time when the EntryGroup was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1EntryGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1EntryGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1EntrySource: EntrySource contains source system
// related information for the entry.
type GoogleCloudDataplexV1EntrySource struct {
	// Ancestors: Immutable. The ancestors of the Entry in the source
	// system.
	Ancestors []*GoogleCloudDataplexV1EntrySourceAncestor `json:"ancestors,omitempty"`

	// CreateTime: The create time of the resource in the source system.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Description of the Entry. The maximum size of the field
	// is 2000 characters.
	Description string `json:"description,omitempty"`

	// DisplayName: User friendly display name. The maximum size of the
	// field is 500 characters.
	DisplayName string `json:"displayName,omitempty"`

	// Labels: User-defined labels. The maximum size of keys and values is
	// 128 characters each.
	Labels map[string]string `json:"labels,omitempty"`

	// Platform: The platform containing the source system. The maximum size
	// of the field is 64 characters.
	Platform string `json:"platform,omitempty"`

	// Resource: The name of the resource in the source system. The maximum
	// size of the field is 4000 characters.
	Resource string `json:"resource,omitempty"`

	// System: The name of the source system. The maximum size of the field
	// is 64 characters.
	System string `json:"system,omitempty"`

	// UpdateTime: The update time of the resource in the source system.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Ancestors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Ancestors") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1EntrySource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1EntrySource
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1EntrySourceAncestor: Ancestor contains
// information about individual items in the hierarchy of an Entry.
type GoogleCloudDataplexV1EntrySourceAncestor struct {
	// Name: Optional. The name of the ancestor resource.
	Name string `json:"name,omitempty"`

	// Type: Optional. The type of the ancestor resource.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1EntrySourceAncestor) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1EntrySourceAncestor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1EntryType: Entry Type is a template for creating
// Entries.
type GoogleCloudDataplexV1EntryType struct {
	// Authorization: Immutable. Authorization defined for this type.
	Authorization *GoogleCloudDataplexV1EntryTypeAuthorization `json:"authorization,omitempty"`

	// CreateTime: Output only. The time when the EntryType was created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Optional. Description of the EntryType.
	Description string `json:"description,omitempty"`

	// DisplayName: Optional. User friendly display name.
	DisplayName string `json:"displayName,omitempty"`

	// Etag: Optional. This checksum is computed by the server based on the
	// value of other fields, and may be sent on update and delete requests
	// to ensure the client has an up-to-date value before proceeding.
	Etag string `json:"etag,omitempty"`

	// Labels: Optional. User-defined labels for the EntryType.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. The relative resource name of the EntryType, of
	// the form:
	// projects/{project_number}/locations/{location_id}/entryTypes/{entry_ty
	// pe_id}.
	Name string `json:"name,omitempty"`

	// Platform: Optional. The platform that Entries of this type belongs
	// to.
	Platform string `json:"platform,omitempty"`

	// RequiredAspects: AspectInfo for the entry type.
	RequiredAspects []*GoogleCloudDataplexV1EntryTypeAspectInfo `json:"requiredAspects,omitempty"`

	// System: Optional. The system that Entries of this type belongs to.
	// Examples include CloudSQL, MariaDB etc
	System string `json:"system,omitempty"`

	// TypeAliases: Optional. Indicates the class this Entry Type belongs
	// to, for example, TABLE, DATABASE, MODEL.
	TypeAliases []string `json:"typeAliases,omitempty"`

	// Uid: Output only. System generated globally unique ID for the
	// EntryType. This ID will be different if the EntryType is deleted and
	// re-created with the same name.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time when the EntryType was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Authorization") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Authorization") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1EntryType) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1EntryType
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudDataplexV1EntryTypeAspectInfo struct {
	// Type: Required aspect type for the entry type.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Type") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Type") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1EntryTypeAspectInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1EntryTypeAspectInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1EntryTypeAuthorization: Authorization for an
// Entry Type.
type GoogleCloudDataplexV1EntryTypeAuthorization struct {
	// AlternateUsePermission: Immutable. The IAM permission grantable on
	// the Entry Group to allow access to instantiate Entries of Dataplex
	// owned Entry Types, only settable for Dataplex owned Types.
	AlternateUsePermission string `json:"alternateUsePermission,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AlternateUsePermission") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AlternateUsePermission")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1EntryTypeAuthorization) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1EntryTypeAuthorization
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1Environment: Environment represents a
// user-visible compute infrastructure for analytics within a lake.
type GoogleCloudDataplexV1Environment struct {
	// CreateTime: Output only. Environment creation time.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Optional. Description of the environment.
	Description string `json:"description,omitempty"`

	// DisplayName: Optional. User friendly display name.
	DisplayName string `json:"displayName,omitempty"`

	// Endpoints: Output only. URI Endpoints to access sessions associated
	// with the Environment.
	Endpoints *GoogleCloudDataplexV1EnvironmentEndpoints `json:"endpoints,omitempty"`

	// InfrastructureSpec: Required. Infrastructure specification for the
	// Environment.
	InfrastructureSpec *GoogleCloudDataplexV1EnvironmentInfrastructureSpec `json:"infrastructureSpec,omitempty"`

	// Labels: Optional. User defined labels for the environment.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. The relative resource name of the environment, of
	// the form:
	// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/environm
	// ent/{environment_id}
	Name string `json:"name,omitempty"`

	// SessionSpec: Optional. Configuration for sessions created for this
	// environment.
	SessionSpec *GoogleCloudDataplexV1EnvironmentSessionSpec `json:"sessionSpec,omitempty"`

	// SessionStatus: Output only. Status of sessions created for this
	// environment.
	SessionStatus *GoogleCloudDataplexV1EnvironmentSessionStatus `json:"sessionStatus,omitempty"`

	// State: Output only. Current state of the environment.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is not specified.
	//   "ACTIVE" - Resource is active, i.e., ready to use.
	//   "CREATING" - Resource is under creation.
	//   "DELETING" - Resource is under deletion.
	//   "ACTION_REQUIRED" - Resource is active but has unresolved actions.
	State string `json:"state,omitempty"`

	// Uid: Output only. System generated globally unique ID for the
	// environment. This ID will be different if the environment is deleted
	// and re-created with the same name.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time when the environment was last
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1Environment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1Environment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1EnvironmentEndpoints: URI Endpoints to access
// sessions associated with the Environment.
type GoogleCloudDataplexV1EnvironmentEndpoints struct {
	// Notebooks: Output only. URI to serve notebook APIs
	Notebooks string `json:"notebooks,omitempty"`

	// Sql: Output only. URI to serve SQL APIs
	Sql string `json:"sql,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Notebooks") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Notebooks") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1EnvironmentEndpoints) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1EnvironmentEndpoints
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1EnvironmentInfrastructureSpec: Configuration for
// the underlying infrastructure used to run workloads.
type GoogleCloudDataplexV1EnvironmentInfrastructureSpec struct {
	// Compute: Optional. Compute resources needed for analyze interactive
	// workloads.
	Compute *GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources `json:"compute,omitempty"`

	// OsImage: Required. Software Runtime Configuration for analyze
	// interactive workloads.
	OsImage *GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime `json:"osImage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Compute") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Compute") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1EnvironmentInfrastructureSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1EnvironmentInfrastructureSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources:
// Compute resources associated with the analyze interactive workloads.
type GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources struct {
	// DiskSizeGb: Optional. Size in GB of the disk. Default is 100 GB.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty"`

	// MaxNodeCount: Optional. Max configurable nodes. If max_node_count >
	// node_count, then auto-scaling is enabled.
	MaxNodeCount int64 `json:"maxNodeCount,omitempty"`

	// NodeCount: Optional. Total number of nodes in the sessions created
	// for this environment.
	NodeCount int64 `json:"nodeCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DiskSizeGb") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DiskSizeGb") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1EnvironmentInfrastructureSpecComputeResources
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime:
// Software Runtime Configuration to run Analyze.
type GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime struct {
	// ImageVersion: Required. Dataplex Image version.
	ImageVersion string `json:"imageVersion,omitempty"`

	// JavaLibraries: Optional. List of Java jars to be included in the
	// runtime environment. Valid input includes Cloud Storage URIs to Jar
	// binaries. For example, gs://bucket-name/my/path/to/file.jar
	JavaLibraries []string `json:"javaLibraries,omitempty"`

	// Properties: Optional. Spark properties to provide configuration for
	// use in sessions created for this environment. The properties to set
	// on daemon config files. Property keys are specified in
	// prefix:property format. The prefix must be "spark".
	Properties map[string]string `json:"properties,omitempty"`

	// PythonPackages: Optional. A list of python packages to be installed.
	// Valid formats include Cloud Storage URI to a PIP installable library.
	// For example, gs://bucket-name/my/path/to/lib.tar.gz
	PythonPackages []string `json:"pythonPackages,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ImageVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ImageVersion") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1EnvironmentInfrastructureSpecOsImageRuntime
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1EnvironmentSessionSpec: Configuration for
// sessions created for this environment.
type GoogleCloudDataplexV1EnvironmentSessionSpec struct {
	// EnableFastStartup: Optional. If True, this causes sessions to be
	// pre-created and available for faster startup to enable interactive
	// exploration use-cases. This defaults to False to avoid additional
	// billed charges. These can only be set to True for the environment
	// with name set to "default", and with default configuration.
	EnableFastStartup bool `json:"enableFastStartup,omitempty"`

	// MaxIdleDuration: Optional. The idle time configuration of the
	// session. The session will be auto-terminated at the end of this
	// period.
	MaxIdleDuration string `json:"maxIdleDuration,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EnableFastStartup")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnableFastStartup") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1EnvironmentSessionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1EnvironmentSessionSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1EnvironmentSessionStatus: Status of sessions
// created for this environment.
type GoogleCloudDataplexV1EnvironmentSessionStatus struct {
	// Active: Output only. Queries over sessions to mark whether the
	// environment is currently active or not
	Active bool `json:"active,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Active") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Active") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1EnvironmentSessionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1EnvironmentSessionStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1GenerateDataQualityRulesRequest: Generate
// recommended DataQualityRules request.
type GoogleCloudDataplexV1GenerateDataQualityRulesRequest struct {
}

// GoogleCloudDataplexV1GenerateDataQualityRulesResponse: Generate
// recommended DataQualityRules response.
type GoogleCloudDataplexV1GenerateDataQualityRulesResponse struct {
	// Rule: Generated recommended {@link DataQualityRule}s.
	Rule []*GoogleCloudDataplexV1DataQualityRule `json:"rule,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Rule") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Rule") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1GenerateDataQualityRulesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1GenerateDataQualityRulesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1GovernanceEvent: Payload associated with
// Governance related log events.
type GoogleCloudDataplexV1GovernanceEvent struct {
	// Entity: Entity resource information if the log event is associated
	// with a specific entity.
	Entity *GoogleCloudDataplexV1GovernanceEventEntity `json:"entity,omitempty"`

	// EventType: The type of the event.
	//
	// Possible values:
	//   "EVENT_TYPE_UNSPECIFIED" - An unspecified event type.
	//   "RESOURCE_IAM_POLICY_UPDATE" - Resource IAM policy update event.
	//   "BIGQUERY_TABLE_CREATE" - BigQuery table create event.
	//   "BIGQUERY_TABLE_UPDATE" - BigQuery table update event.
	//   "BIGQUERY_TABLE_DELETE" - BigQuery table delete event.
	//   "BIGQUERY_CONNECTION_CREATE" - BigQuery connection create event.
	//   "BIGQUERY_CONNECTION_UPDATE" - BigQuery connection update event.
	//   "BIGQUERY_CONNECTION_DELETE" - BigQuery connection delete event.
	//   "BIGQUERY_TAXONOMY_CREATE" - BigQuery taxonomy created.
	//   "BIGQUERY_POLICY_TAG_CREATE" - BigQuery policy tag created.
	//   "BIGQUERY_POLICY_TAG_DELETE" - BigQuery policy tag deleted.
	//   "BIGQUERY_POLICY_TAG_SET_IAM_POLICY" - BigQuery set iam policy for
	// policy tag.
	//   "ACCESS_POLICY_UPDATE" - Access policy update event.
	//   "GOVERNANCE_RULE_MATCHED_RESOURCES" - Number of resources matched
	// with particular Query.
	//   "GOVERNANCE_RULE_SEARCH_LIMIT_EXCEEDS" - Rule processing exceeds
	// the allowed limit.
	//   "GOVERNANCE_RULE_ERRORS" - Rule processing errors.
	//   "GOVERNANCE_RULE_PROCESSING" - Governance rule processing Event.
	EventType string `json:"eventType,omitempty"`

	// Message: The log message.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entity") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entity") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1GovernanceEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1GovernanceEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1GovernanceEventEntity: Information about Entity
// resource that the log event is associated with.
type GoogleCloudDataplexV1GovernanceEventEntity struct {
	// Entity: The Entity resource the log event is associated with. Format:
	// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zone
	// s/{zone_id}/entities/{entity_id}
	Entity string `json:"entity,omitempty"`

	// EntityType: Type of entity.
	//
	// Possible values:
	//   "ENTITY_TYPE_UNSPECIFIED" - An unspecified Entity type.
	//   "TABLE" - Table entity type.
	//   "FILESET" - Fileset entity type.
	EntityType string `json:"entityType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Entity") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entity") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1GovernanceEventEntity) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1GovernanceEventEntity
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1Job: A job represents an instance of a task.
type GoogleCloudDataplexV1Job struct {
	// EndTime: Output only. The time when the job ended.
	EndTime string `json:"endTime,omitempty"`

	// ExecutionSpec: Output only. Spec related to how a task is executed.
	ExecutionSpec *GoogleCloudDataplexV1TaskExecutionSpec `json:"executionSpec,omitempty"`

	// Labels: Output only. User-defined labels for the task.
	Labels map[string]string `json:"labels,omitempty"`

	// Message: Output only. Additional information about the current state.
	Message string `json:"message,omitempty"`

	// Name: Output only. The relative resource name of the job, of the
	// form:
	// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/task
	// s/{task_id}/jobs/{job_id}.
	Name string `json:"name,omitempty"`

	// RetryCount: Output only. The number of times the job has been retried
	// (excluding the initial attempt).
	RetryCount int64 `json:"retryCount,omitempty"`

	// Service: Output only. The underlying service running a job.
	//
	// Possible values:
	//   "SERVICE_UNSPECIFIED" - Service used to run the job is unspecified.
	//   "DATAPROC" - Dataproc service is used to run this job.
	Service string `json:"service,omitempty"`

	// ServiceJob: Output only. The full resource name for the job run under
	// a particular service.
	ServiceJob string `json:"serviceJob,omitempty"`

	// StartTime: Output only. The time when the job was started.
	StartTime string `json:"startTime,omitempty"`

	// State: Output only. Execution state for the job.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The job state is unknown.
	//   "RUNNING" - The job is running.
	//   "CANCELLING" - The job is cancelling.
	//   "CANCELLED" - The job cancellation was successful.
	//   "SUCCEEDED" - The job completed successfully.
	//   "FAILED" - The job is no longer running due to an error.
	//   "ABORTED" - The job was cancelled outside of Dataplex.
	State string `json:"state,omitempty"`

	// Trigger: Output only. Job execution trigger.
	//
	// Possible values:
	//   "TRIGGER_UNSPECIFIED" - The trigger is unspecified.
	//   "TASK_CONFIG" - The job was triggered by Dataplex based on trigger
	// spec from task definition.
	//   "RUN_REQUEST" - The job was triggered by the explicit call of Task
	// API.
	Trigger string `json:"trigger,omitempty"`

	// Uid: Output only. System generated globally unique ID for the job.
	Uid string `json:"uid,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1Job) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1Job
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1JobEvent: The payload associated with Job logs
// that contains events describing jobs that have run within a Lake.
type GoogleCloudDataplexV1JobEvent struct {
	// EndTime: The time when the job ended running.
	EndTime string `json:"endTime,omitempty"`

	// ExecutionTrigger: Job execution trigger.
	//
	// Possible values:
	//   "EXECUTION_TRIGGER_UNSPECIFIED" - The job execution trigger is
	// unspecified.
	//   "TASK_CONFIG" - The job was triggered by Dataplex based on trigger
	// spec from task definition.
	//   "RUN_REQUEST" - The job was triggered by the explicit call of Task
	// API.
	ExecutionTrigger string `json:"executionTrigger,omitempty"`

	// JobId: The unique id identifying the job.
	JobId string `json:"jobId,omitempty"`

	// Message: The log message.
	Message string `json:"message,omitempty"`

	// Retries: The number of retries.
	Retries int64 `json:"retries,omitempty"`

	// Service: The service used to execute the job.
	//
	// Possible values:
	//   "SERVICE_UNSPECIFIED" - Unspecified service.
	//   "DATAPROC" - Cloud Dataproc.
	Service string `json:"service,omitempty"`

	// ServiceJob: The reference to the job within the service.
	ServiceJob string `json:"serviceJob,omitempty"`

	// StartTime: The time when the job started running.
	StartTime string `json:"startTime,omitempty"`

	// State: The job state on completion.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified job state.
	//   "SUCCEEDED" - Job successfully completed.
	//   "FAILED" - Job was unsuccessful.
	//   "CANCELLED" - Job was cancelled by the user.
	//   "ABORTED" - Job was cancelled or aborted via the service executing
	// the job.
	State string `json:"state,omitempty"`

	// Type: The type of the job.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified job type.
	//   "SPARK" - Spark jobs.
	//   "NOTEBOOK" - Notebook jobs.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1JobEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1JobEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1Lake: A lake is a centralized repository for
// managing enterprise data across the organization distributed across
// many cloud projects, and stored in a variety of storage services such
// as Google Cloud Storage and BigQuery. The resources attached to a
// lake are referred to as managed resources. Data within these managed
// resources can be structured or unstructured. A lake provides data
// admins with tools to organize, secure and manage their data at scale,
// and provides data scientists and data engineers an integrated
// experience to easily search, discover, analyze and transform data and
// associated metadata.
type GoogleCloudDataplexV1Lake struct {
	// AssetStatus: Output only. Aggregated status of the underlying assets
	// of the lake.
	AssetStatus *GoogleCloudDataplexV1AssetStatus `json:"assetStatus,omitempty"`

	// CreateTime: Output only. The time when the lake was created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Optional. Description of the lake.
	Description string `json:"description,omitempty"`

	// DisplayName: Optional. User friendly display name.
	DisplayName string `json:"displayName,omitempty"`

	// Labels: Optional. User-defined labels for the lake.
	Labels map[string]string `json:"labels,omitempty"`

	// Metastore: Optional. Settings to manage lake and Dataproc Metastore
	// service instance association.
	Metastore *GoogleCloudDataplexV1LakeMetastore `json:"metastore,omitempty"`

	// MetastoreStatus: Output only. Metastore status of the lake.
	MetastoreStatus *GoogleCloudDataplexV1LakeMetastoreStatus `json:"metastoreStatus,omitempty"`

	// Name: Output only. The relative resource name of the lake, of the
	// form:
	// projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
	Name string `json:"name,omitempty"`

	// ServiceAccount: Output only. Service account associated with this
	// lake. This service account must be authorized to access or operate on
	// resources managed by the lake.
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// State: Output only. Current state of the lake.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is not specified.
	//   "ACTIVE" - Resource is active, i.e., ready to use.
	//   "CREATING" - Resource is under creation.
	//   "DELETING" - Resource is under deletion.
	//   "ACTION_REQUIRED" - Resource is active but has unresolved actions.
	State string `json:"state,omitempty"`

	// Uid: Output only. System generated globally unique ID for the lake.
	// This ID will be different if the lake is deleted and re-created with
	// the same name.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time when the lake was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AssetStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssetStatus") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1Lake) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1Lake
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1LakeMetastore: Settings to manage association of
// Dataproc Metastore with a lake.
type GoogleCloudDataplexV1LakeMetastore struct {
	// Service: Optional. A relative reference to the Dataproc Metastore
	// (https://cloud.google.com/dataproc-metastore/docs) service associated
	// with the lake:
	// projects/{project_id}/locations/{location_id}/services/{service_id}
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Service") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Service") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1LakeMetastore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1LakeMetastore
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1LakeMetastoreStatus: Status of Lake and Dataproc
// Metastore service instance association.
type GoogleCloudDataplexV1LakeMetastoreStatus struct {
	// Endpoint: The URI of the endpoint used to access the Metastore
	// service.
	Endpoint string `json:"endpoint,omitempty"`

	// Message: Additional information about the current status.
	Message string `json:"message,omitempty"`

	// State: Current state of association.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Unspecified.
	//   "NONE" - A Metastore service instance is not associated with the
	// lake.
	//   "READY" - A Metastore service instance is attached to the lake.
	//   "UPDATING" - Attach/detach is in progress.
	//   "ERROR" - Attach/detach could not be done due to errors.
	State string `json:"state,omitempty"`

	// UpdateTime: Last update time of the metastore status of the lake.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Endpoint") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Endpoint") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1LakeMetastoreStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1LakeMetastoreStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListActionsResponse: List actions response.
type GoogleCloudDataplexV1ListActionsResponse struct {
	// Actions: Actions under the given parent lake/zone/asset.
	Actions []*GoogleCloudDataplexV1Action `json:"actions,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Actions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Actions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListActionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListActionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListAspectTypesResponse: List AspectTypes
// response
type GoogleCloudDataplexV1ListAspectTypesResponse struct {
	// AspectTypes: ListAspectTypes under the given parent location.
	AspectTypes []*GoogleCloudDataplexV1AspectType `json:"aspectTypes,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// UnreachableLocations: Locations that could not be reached.
	UnreachableLocations []string `json:"unreachableLocations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AspectTypes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AspectTypes") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListAspectTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListAspectTypesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListAssetsResponse: List assets response.
type GoogleCloudDataplexV1ListAssetsResponse struct {
	// Assets: Asset under the given parent zone.
	Assets []*GoogleCloudDataplexV1Asset `json:"assets,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Assets") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Assets") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListAssetsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListAssetsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListContentResponse: List content response.
type GoogleCloudDataplexV1ListContentResponse struct {
	// Content: Content under the given parent lake.
	Content []*GoogleCloudDataplexV1Content `json:"content,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Content") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Content") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListContentResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListContentResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListDataAttributeBindingsResponse: List
// DataAttributeBindings response.
type GoogleCloudDataplexV1ListDataAttributeBindingsResponse struct {
	// DataAttributeBindings: DataAttributeBindings under the given parent
	// Location.
	DataAttributeBindings []*GoogleCloudDataplexV1DataAttributeBinding `json:"dataAttributeBindings,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// UnreachableLocations: Locations that could not be reached.
	UnreachableLocations []string `json:"unreachableLocations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "DataAttributeBindings") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataAttributeBindings") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListDataAttributeBindingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListDataAttributeBindingsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListDataAttributesResponse: List DataAttributes
// response.
type GoogleCloudDataplexV1ListDataAttributesResponse struct {
	// DataAttributes: DataAttributes under the given parent DataTaxonomy.
	DataAttributes []*GoogleCloudDataplexV1DataAttribute `json:"dataAttributes,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// UnreachableLocations: Locations that could not be reached.
	UnreachableLocations []string `json:"unreachableLocations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DataAttributes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataAttributes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListDataAttributesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListDataAttributesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListDataScanJobsResponse: List DataScanJobs
// response.
type GoogleCloudDataplexV1ListDataScanJobsResponse struct {
	// DataScanJobs: DataScanJobs (BASIC view only) under a given dataScan.
	DataScanJobs []*GoogleCloudDataplexV1DataScanJob `json:"dataScanJobs,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DataScanJobs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataScanJobs") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListDataScanJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListDataScanJobsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListDataScansResponse: List dataScans response.
type GoogleCloudDataplexV1ListDataScansResponse struct {
	// DataScans: DataScans (BASIC view only) under the given parent
	// location.
	DataScans []*GoogleCloudDataplexV1DataScan `json:"dataScans,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DataScans") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataScans") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListDataScansResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListDataScansResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListDataTaxonomiesResponse: List DataTaxonomies
// response.
type GoogleCloudDataplexV1ListDataTaxonomiesResponse struct {
	// DataTaxonomies: DataTaxonomies under the given parent location.
	DataTaxonomies []*GoogleCloudDataplexV1DataTaxonomy `json:"dataTaxonomies,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// UnreachableLocations: Locations that could not be reached.
	UnreachableLocations []string `json:"unreachableLocations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DataTaxonomies") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataTaxonomies") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListDataTaxonomiesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListDataTaxonomiesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListEntitiesResponse: List metadata entities
// response.
type GoogleCloudDataplexV1ListEntitiesResponse struct {
	// Entities: Entities in the specified parent zone.
	Entities []*GoogleCloudDataplexV1Entity `json:"entities,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no remaining results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entities") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entities") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListEntitiesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListEntitiesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudDataplexV1ListEntriesResponse struct {
	// Entries: The list of entries.
	Entries []*GoogleCloudDataplexV1Entry `json:"entries,omitempty"`

	// NextPageToken: Pagination token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Entries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Entries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListEntriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListEntryGroupsResponse: List ListEntryGroups
// response.
type GoogleCloudDataplexV1ListEntryGroupsResponse struct {
	// EntryGroups: ListEntryGroups under the given parent location.
	EntryGroups []*GoogleCloudDataplexV1EntryGroup `json:"entryGroups,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// UnreachableLocations: Locations that could not be reached.
	UnreachableLocations []string `json:"unreachableLocations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "EntryGroups") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EntryGroups") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListEntryGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListEntryGroupsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListEntryTypesResponse: List EntryTypes response
type GoogleCloudDataplexV1ListEntryTypesResponse struct {
	// EntryTypes: ListEntryTypes under the given parent location.
	EntryTypes []*GoogleCloudDataplexV1EntryType `json:"entryTypes,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// UnreachableLocations: Locations that could not be reached.
	UnreachableLocations []string `json:"unreachableLocations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "EntryTypes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EntryTypes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListEntryTypesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListEntryTypesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListEnvironmentsResponse: List environments
// response.
type GoogleCloudDataplexV1ListEnvironmentsResponse struct {
	// Environments: Environments under the given parent lake.
	Environments []*GoogleCloudDataplexV1Environment `json:"environments,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Environments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Environments") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListEnvironmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListEnvironmentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListJobsResponse: List jobs response.
type GoogleCloudDataplexV1ListJobsResponse struct {
	// Jobs: Jobs under a given task.
	Jobs []*GoogleCloudDataplexV1Job `json:"jobs,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Jobs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Jobs") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListJobsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListLakesResponse: List lakes response.
type GoogleCloudDataplexV1ListLakesResponse struct {
	// Lakes: Lakes under the given parent location.
	Lakes []*GoogleCloudDataplexV1Lake `json:"lakes,omitempty"`

	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// UnreachableLocations: Locations that could not be reached.
	UnreachableLocations []string `json:"unreachableLocations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Lakes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Lakes") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListLakesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListLakesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListPartitionsResponse: List metadata partitions
// response.
type GoogleCloudDataplexV1ListPartitionsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no remaining results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Partitions: Partitions under the specified parent entity.
	Partitions []*GoogleCloudDataplexV1Partition `json:"partitions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListPartitionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListPartitionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListSessionsResponse: List sessions response.
type GoogleCloudDataplexV1ListSessionsResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Sessions: Sessions under a given environment.
	Sessions []*GoogleCloudDataplexV1Session `json:"sessions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListSessionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListSessionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListTasksResponse: List tasks response.
type GoogleCloudDataplexV1ListTasksResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Tasks: Tasks under the given parent lake.
	Tasks []*GoogleCloudDataplexV1Task `json:"tasks,omitempty"`

	// UnreachableLocations: Locations that could not be reached.
	UnreachableLocations []string `json:"unreachableLocations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListTasksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListTasksResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ListZonesResponse: List zones response.
type GoogleCloudDataplexV1ListZonesResponse struct {
	// NextPageToken: Token to retrieve the next page of results, or empty
	// if there are no more results in the list.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Zones: Zones under the given parent lake.
	Zones []*GoogleCloudDataplexV1Zone `json:"zones,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ListZonesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ListZonesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1OperationMetadata: Represents the metadata of a
// long-running operation.
type GoogleCloudDataplexV1OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`

	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`

	// RequestedCancellation: Output only. Identifies whether the user has
	// requested cancellation of the operation. Operations that have
	// successfully been cancelled have Operation.error value with a
	// google.rpc.Status.code of 1, corresponding to Code.CANCELLED.
	RequestedCancellation bool `json:"requestedCancellation,omitempty"`

	// StatusMessage: Output only. Human-readable status of the operation,
	// if any.
	StatusMessage string `json:"statusMessage,omitempty"`

	// Target: Output only. Server-defined resource path for the target of
	// the operation.
	Target string `json:"target,omitempty"`

	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiVersion") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1OperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1Partition: Represents partition metadata
// contained within entity instances.
type GoogleCloudDataplexV1Partition struct {
	// Etag: Optional. The etag for this partition.
	Etag string `json:"etag,omitempty"`

	// Location: Required. Immutable. The location of the entity data within
	// the partition, for example,
	// gs://bucket/path/to/entity/key1=value1/key2=value2. Or
	// projects//datasets//tables/
	Location string `json:"location,omitempty"`

	// Name: Output only. Partition values used in the HTTP URL must be
	// double encoded. For example, url_encode(url_encode(value)) can be
	// used to encode "US:CA/CA#Sunnyvale so that the request URL ends with
	// "/partitions/US%253ACA/CA%2523Sunnyvale". The name field in the
	// response retains the encoded format.
	Name string `json:"name,omitempty"`

	// Values: Required. Immutable. The set of values representing the
	// partition, which correspond to the partition schema defined in the
	// parent entity.
	Values []string `json:"values,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Etag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Etag") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1Partition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1Partition
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ResourceAccessSpec: ResourceAccessSpec holds the
// access control configuration to be enforced on the resources, for
// example, Cloud Storage bucket, BigQuery dataset, BigQuery table.
type GoogleCloudDataplexV1ResourceAccessSpec struct {
	// Owners: Optional. The set of principals to be granted owner role on
	// the resource.
	Owners []string `json:"owners,omitempty"`

	// Readers: Optional. The format of strings follows the pattern followed
	// by IAM in the bindings. user:{email}, serviceAccount:{email}
	// group:{email}. The set of principals to be granted reader role on the
	// resource.
	Readers []string `json:"readers,omitempty"`

	// Writers: Optional. The set of principals to be granted writer role on
	// the resource.
	Writers []string `json:"writers,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Owners") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Owners") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ResourceAccessSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ResourceAccessSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1RunDataScanRequest: Run DataScan Request
type GoogleCloudDataplexV1RunDataScanRequest struct {
}

// GoogleCloudDataplexV1RunDataScanResponse: Run DataScan Response.
type GoogleCloudDataplexV1RunDataScanResponse struct {
	// Job: DataScanJob created by RunDataScan request.
	Job *GoogleCloudDataplexV1DataScanJob `json:"job,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Job") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Job") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1RunDataScanResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1RunDataScanResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudDataplexV1RunTaskRequest struct {
	// Args: Optional. Execution spec arguments. If the map is left empty,
	// the task will run with existing execution spec args from task
	// definition. If the map contains an entry with a new key, the same
	// will be added to existing set of args. If the map contains an entry
	// with an existing arg key in task definition, the task will run with
	// new arg value for that entry. Clearing an existing arg will require
	// arg value to be explicitly set to a hyphen "-". The arg value cannot
	// be empty.
	Args map[string]string `json:"args,omitempty"`

	// Labels: Optional. User-defined labels for the task. If the map is
	// left empty, the task will run with existing labels from task
	// definition. If the map contains an entry with a new key, the same
	// will be added to existing set of labels. If the map contains an entry
	// with an existing label key in task definition, the task will run with
	// new label value for that entry. Clearing an existing label will
	// require label value to be explicitly set to a hyphen "-". The label
	// value cannot be empty.
	Labels map[string]string `json:"labels,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Args") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Args") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1RunTaskRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1RunTaskRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudDataplexV1RunTaskResponse struct {
	// Job: Jobs created by RunTask API.
	Job *GoogleCloudDataplexV1Job `json:"job,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Job") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Job") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1RunTaskResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1RunTaskResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ScannedData: The data scanned during processing
// (e.g. in incremental DataScan)
type GoogleCloudDataplexV1ScannedData struct {
	// IncrementalField: The range denoted by values of an incremental field
	IncrementalField *GoogleCloudDataplexV1ScannedDataIncrementalField `json:"incrementalField,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IncrementalField") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IncrementalField") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ScannedData) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ScannedData
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ScannedDataIncrementalField: A data range
// denoted by a pair of start/end values of a field.
type GoogleCloudDataplexV1ScannedDataIncrementalField struct {
	// End: Value that marks the end of the range.
	End string `json:"end,omitempty"`

	// Field: The field that contains values which monotonically increases
	// over time (e.g. a timestamp column).
	Field string `json:"field,omitempty"`

	// Start: Value that marks the start of the range.
	Start string `json:"start,omitempty"`

	// ForceSendFields is a list of field names (e.g. "End") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "End") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ScannedDataIncrementalField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ScannedDataIncrementalField
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1Schema: Schema information describing the
// structure and layout of the data.
type GoogleCloudDataplexV1Schema struct {
	// Fields: Optional. The sequence of fields describing data in table
	// entities. Note: BigQuery SchemaFields are immutable.
	Fields []*GoogleCloudDataplexV1SchemaSchemaField `json:"fields,omitempty"`

	// PartitionFields: Optional. The sequence of fields describing the
	// partition structure in entities. If this field is empty, there are no
	// partitions within the data.
	PartitionFields []*GoogleCloudDataplexV1SchemaPartitionField `json:"partitionFields,omitempty"`

	// PartitionStyle: Optional. The structure of paths containing partition
	// data within the entity.
	//
	// Possible values:
	//   "PARTITION_STYLE_UNSPECIFIED" - PartitionStyle unspecified
	//   "HIVE_COMPATIBLE" - Partitions are hive-compatible. Examples:
	// gs://bucket/path/to/table/dt=2019-10-31/lang=en,
	// gs://bucket/path/to/table/dt=2019-10-31/lang=en/late.
	PartitionStyle string `json:"partitionStyle,omitempty"`

	// UserManaged: Required. Set to true if user-managed or false if
	// managed by Dataplex. The default is false (managed by Dataplex). Set
	// to falseto enable Dataplex discovery to update the schema. including
	// new data discovery, schema inference, and schema evolution. Users
	// retain the ability to input and edit the schema. Dataplex treats
	// schema input by the user as though produced by a previous Dataplex
	// discovery operation, and it will evolve the schema and take action
	// based on that treatment. Set to true to fully manage the entity
	// schema. This setting guarantees that Dataplex will not change schema
	// fields.
	UserManaged bool `json:"userManaged,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Fields") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Fields") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1Schema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1Schema
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1SchemaPartitionField: Represents a key field
// within the entity's partition structure. You could have up to 20
// partition fields, but only the first 10 partitions have the filtering
// ability due to performance consideration. Note: Partition fields are
// immutable.
type GoogleCloudDataplexV1SchemaPartitionField struct {
	// Name: Required. Partition field name must consist of letters,
	// numbers, and underscores only, with a maximum of length of 256
	// characters, and must begin with a letter or underscore..
	Name string `json:"name,omitempty"`

	// Type: Required. Immutable. The type of field.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - SchemaType unspecified.
	//   "BOOLEAN" - Boolean field.
	//   "BYTE" - Single byte numeric field.
	//   "INT16" - 16-bit numeric field.
	//   "INT32" - 32-bit numeric field.
	//   "INT64" - 64-bit numeric field.
	//   "FLOAT" - Floating point numeric field.
	//   "DOUBLE" - Double precision numeric field.
	//   "DECIMAL" - Real value numeric field.
	//   "STRING" - Sequence of characters field.
	//   "BINARY" - Sequence of bytes field.
	//   "TIMESTAMP" - Date and time field.
	//   "DATE" - Date field.
	//   "TIME" - Time field.
	//   "RECORD" - Structured field. Nested fields that define the
	// structure of the map. If all nested fields are nullable, this field
	// represents a union.
	//   "NULL" - Null field that does not have values.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1SchemaPartitionField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1SchemaPartitionField
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1SchemaSchemaField: Represents a column field
// within a table schema.
type GoogleCloudDataplexV1SchemaSchemaField struct {
	// Description: Optional. User friendly field description. Must be less
	// than or equal to 1024 characters.
	Description string `json:"description,omitempty"`

	// Fields: Optional. Any nested field for complex types.
	Fields []*GoogleCloudDataplexV1SchemaSchemaField `json:"fields,omitempty"`

	// Mode: Required. Additional field semantics.
	//
	// Possible values:
	//   "MODE_UNSPECIFIED" - Mode unspecified.
	//   "REQUIRED" - The field has required semantics.
	//   "NULLABLE" - The field has optional semantics, and may be null.
	//   "REPEATED" - The field has repeated (0 or more) semantics, and is a
	// list of values.
	Mode string `json:"mode,omitempty"`

	// Name: Required. The name of the field. Must contain only letters,
	// numbers and underscores, with a maximum length of 767 characters, and
	// must begin with a letter or underscore.
	Name string `json:"name,omitempty"`

	// Type: Required. The type of field.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - SchemaType unspecified.
	//   "BOOLEAN" - Boolean field.
	//   "BYTE" - Single byte numeric field.
	//   "INT16" - 16-bit numeric field.
	//   "INT32" - 32-bit numeric field.
	//   "INT64" - 64-bit numeric field.
	//   "FLOAT" - Floating point numeric field.
	//   "DOUBLE" - Double precision numeric field.
	//   "DECIMAL" - Real value numeric field.
	//   "STRING" - Sequence of characters field.
	//   "BINARY" - Sequence of bytes field.
	//   "TIMESTAMP" - Date and time field.
	//   "DATE" - Date field.
	//   "TIME" - Time field.
	//   "RECORD" - Structured field. Nested fields that define the
	// structure of the map. If all nested fields are nullable, this field
	// represents a union.
	//   "NULL" - Null field that does not have values.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1SchemaSchemaField) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1SchemaSchemaField
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudDataplexV1SearchEntriesResponse struct {
	// NextPageToken: Pagination token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Results: The results matching the search query.
	Results []*GoogleCloudDataplexV1SearchEntriesResult `json:"results,omitempty"`

	// TotalSize: The estimated total number of matching entries. Not
	// guaranteed to be accurate.
	TotalSize int64 `json:"totalSize,omitempty"`

	// Unreachable: Unreachable locations. Search results don't include data
	// from those locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1SearchEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1SearchEntriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1SearchEntriesResult: A single result of a
// SearchEntries request.
type GoogleCloudDataplexV1SearchEntriesResult struct {
	// DataplexEntry: Entry format of the result.
	DataplexEntry *GoogleCloudDataplexV1Entry `json:"dataplexEntry,omitempty"`

	// Description: Entry description.
	Description string `json:"description,omitempty"`

	// DisplayName: Display name.
	DisplayName string `json:"displayName,omitempty"`

	// Entry: Resource name of the entry.
	Entry string `json:"entry,omitempty"`

	// EntryType: The entry type.
	EntryType string `json:"entryType,omitempty"`

	// FullyQualifiedName: Fully qualified name.
	FullyQualifiedName string `json:"fullyQualifiedName,omitempty"`

	// LinkedResource: Linked resource name.
	LinkedResource string `json:"linkedResource,omitempty"`

	// ModifyTime: The last modification timestamp.
	ModifyTime string `json:"modifyTime,omitempty"`

	// RelativeResource: Relative resource name.
	RelativeResource string `json:"relativeResource,omitempty"`

	// Snippets: Snippets.
	Snippets *GoogleCloudDataplexV1SearchEntriesResultSnippets `json:"snippets,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataplexEntry") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataplexEntry") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1SearchEntriesResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1SearchEntriesResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1SearchEntriesResultSnippets: Snippets for the
// entry, contains HTML-style highlighting for matched tokens, will be
// used in UI.
type GoogleCloudDataplexV1SearchEntriesResultSnippets struct {
	// DataplexEntry: Entry
	DataplexEntry *GoogleCloudDataplexV1Entry `json:"dataplexEntry,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DataplexEntry") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataplexEntry") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1SearchEntriesResultSnippets) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1SearchEntriesResultSnippets
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1Session: Represents an active analyze session
// running for a user.
type GoogleCloudDataplexV1Session struct {
	// CreateTime: Output only. Session start time.
	CreateTime string `json:"createTime,omitempty"`

	// Name: Output only. The relative resource name of the content, of the
	// form:
	// projects/{project_id}/locations/{location_id}/lakes/{lake_id}/environm
	// ent/{environment_id}/sessions/{session_id}
	Name string `json:"name,omitempty"`

	// State: Output only. State of Session
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is not specified.
	//   "ACTIVE" - Resource is active, i.e., ready to use.
	//   "CREATING" - Resource is under creation.
	//   "DELETING" - Resource is under deletion.
	//   "ACTION_REQUIRED" - Resource is active but has unresolved actions.
	State string `json:"state,omitempty"`

	// UserId: Output only. Email of user running the session.
	UserId string `json:"userId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1Session) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1Session
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1SessionEvent: These messages contain information
// about sessions within an environment. The monitored resource is
// 'Environment'.
type GoogleCloudDataplexV1SessionEvent struct {
	// EventSucceeded: The status of the event.
	EventSucceeded bool `json:"eventSucceeded,omitempty"`

	// FastStartupEnabled: If the session is associated with an environment
	// with fast startup enabled, and was created before being assigned to a
	// user.
	FastStartupEnabled bool `json:"fastStartupEnabled,omitempty"`

	// Message: The log message.
	Message string `json:"message,omitempty"`

	// Query: The execution details of the query.
	Query *GoogleCloudDataplexV1SessionEventQueryDetail `json:"query,omitempty"`

	// SessionId: Unique identifier for the session.
	SessionId string `json:"sessionId,omitempty"`

	// Type: The type of the event.
	//
	// Possible values:
	//   "EVENT_TYPE_UNSPECIFIED" - An unspecified event type.
	//   "START" - Event when the session is assigned to a user.
	//   "STOP" - Event for stop of a session.
	//   "QUERY" - Query events in the session.
	//   "CREATE" - Event for creation of a cluster. It is not yet assigned
	// to a user. This comes before START in the sequence
	Type string `json:"type,omitempty"`

	// UnassignedDuration: The idle duration of a warm pooled session before
	// it is assigned to user.
	UnassignedDuration string `json:"unassignedDuration,omitempty"`

	// UserId: The information about the user that created the session. It
	// will be the email address of the user.
	UserId string `json:"userId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EventSucceeded") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EventSucceeded") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1SessionEvent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1SessionEvent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1SessionEventQueryDetail: Execution details of
// the query.
type GoogleCloudDataplexV1SessionEventQueryDetail struct {
	// DataProcessedBytes: The data processed by the query.
	DataProcessedBytes int64 `json:"dataProcessedBytes,omitempty,string"`

	// Duration: Time taken for execution of the query.
	Duration string `json:"duration,omitempty"`

	// Engine: Query Execution engine.
	//
	// Possible values:
	//   "ENGINE_UNSPECIFIED" - An unspecified Engine type.
	//   "SPARK_SQL" - Spark-sql engine is specified in Query.
	//   "BIGQUERY" - BigQuery engine is specified in Query.
	Engine string `json:"engine,omitempty"`

	// QueryId: The unique Query id identifying the query.
	QueryId string `json:"queryId,omitempty"`

	// QueryText: The query text executed.
	QueryText string `json:"queryText,omitempty"`

	// ResultSizeBytes: The size of results the query produced.
	ResultSizeBytes int64 `json:"resultSizeBytes,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "DataProcessedBytes")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataProcessedBytes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1SessionEventQueryDetail) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1SessionEventQueryDetail
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1StorageAccess: Describes the access mechanism of
// the data within its storage location.
type GoogleCloudDataplexV1StorageAccess struct {
	// Read: Output only. Describes the read access mechanism of the data.
	// Not user settable.
	//
	// Possible values:
	//   "ACCESS_MODE_UNSPECIFIED" - Access mode unspecified.
	//   "DIRECT" - Default. Data is accessed directly using storage APIs.
	//   "MANAGED" - Data is accessed through a managed interface using
	// BigQuery APIs.
	Read string `json:"read,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Read") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Read") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1StorageAccess) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1StorageAccess
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1StorageFormat: Describes the format of the data
// within its storage location.
type GoogleCloudDataplexV1StorageFormat struct {
	// CompressionFormat: Optional. The compression type associated with the
	// stored data. If unspecified, the data is uncompressed.
	//
	// Possible values:
	//   "COMPRESSION_FORMAT_UNSPECIFIED" - CompressionFormat unspecified.
	// Implies uncompressed data.
	//   "GZIP" - GZip compressed set of files.
	//   "BZIP2" - BZip2 compressed set of files.
	CompressionFormat string `json:"compressionFormat,omitempty"`

	// Csv: Optional. Additional information about CSV formatted data.
	Csv *GoogleCloudDataplexV1StorageFormatCsvOptions `json:"csv,omitempty"`

	// Format: Output only. The data format associated with the stored data,
	// which represents content type values. The value is inferred from mime
	// type.
	//
	// Possible values:
	//   "FORMAT_UNSPECIFIED" - Format unspecified.
	//   "PARQUET" - Parquet-formatted structured data.
	//   "AVRO" - Avro-formatted structured data.
	//   "ORC" - Orc-formatted structured data.
	//   "CSV" - Csv-formatted semi-structured data.
	//   "JSON" - Json-formatted semi-structured data.
	//   "IMAGE" - Image data formats (such as jpg and png).
	//   "AUDIO" - Audio data formats (such as mp3, and wav).
	//   "VIDEO" - Video data formats (such as mp4 and mpg).
	//   "TEXT" - Textual data formats (such as txt and xml).
	//   "TFRECORD" - TensorFlow record format.
	//   "OTHER" - Data that doesn't match a specific format.
	//   "UNKNOWN" - Data of an unknown format.
	Format string `json:"format,omitempty"`

	// Iceberg: Optional. Additional information about iceberg tables.
	Iceberg *GoogleCloudDataplexV1StorageFormatIcebergOptions `json:"iceberg,omitempty"`

	// Json: Optional. Additional information about CSV formatted data.
	Json *GoogleCloudDataplexV1StorageFormatJsonOptions `json:"json,omitempty"`

	// MimeType: Required. The mime type descriptor for the data. Must match
	// the pattern {type}/{subtype}. Supported values: application/x-parquet
	// application/x-avro application/x-orc application/x-tfrecord
	// application/x-parquet+iceberg application/x-avro+iceberg
	// application/x-orc+iceberg application/json application/{subtypes}
	// text/csv text/ image/{image subtype} video/{video subtype}
	// audio/{audio subtype}
	MimeType string `json:"mimeType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CompressionFormat")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CompressionFormat") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1StorageFormat) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1StorageFormat
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1StorageFormatCsvOptions: Describes CSV and
// similar semi-structured data formats.
type GoogleCloudDataplexV1StorageFormatCsvOptions struct {
	// Delimiter: Optional. The delimiter used to separate values. Defaults
	// to ','.
	Delimiter string `json:"delimiter,omitempty"`

	// Encoding: Optional. The character encoding of the data. Accepts
	// "US-ASCII", "UTF-8", and "ISO-8859-1". Defaults to UTF-8 if
	// unspecified.
	Encoding string `json:"encoding,omitempty"`

	// HeaderRows: Optional. The number of rows to interpret as header rows
	// that should be skipped when reading data rows. Defaults to 0.
	HeaderRows int64 `json:"headerRows,omitempty"`

	// Quote: Optional. The character used to quote column values. Accepts
	// '"' (double quotation mark) or ''' (single quotation mark). Defaults
	// to '"' (double quotation mark) if unspecified.
	Quote string `json:"quote,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Delimiter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Delimiter") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1StorageFormatCsvOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1StorageFormatCsvOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1StorageFormatIcebergOptions: Describes Iceberg
// data format.
type GoogleCloudDataplexV1StorageFormatIcebergOptions struct {
	// MetadataLocation: Optional. The location of where the iceberg
	// metadata is present, must be within the table path
	MetadataLocation string `json:"metadataLocation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MetadataLocation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MetadataLocation") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1StorageFormatIcebergOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1StorageFormatIcebergOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1StorageFormatJsonOptions: Describes JSON data
// format.
type GoogleCloudDataplexV1StorageFormatJsonOptions struct {
	// Encoding: Optional. The character encoding of the data. Accepts
	// "US-ASCII", "UTF-8" and "ISO-8859-1". Defaults to UTF-8 if not
	// specified.
	Encoding string `json:"encoding,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Encoding") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Encoding") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1StorageFormatJsonOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1StorageFormatJsonOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1Task: A task represents a user-visible job.
type GoogleCloudDataplexV1Task struct {
	// CreateTime: Output only. The time when the task was created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Optional. Description of the task.
	Description string `json:"description,omitempty"`

	// DisplayName: Optional. User friendly display name.
	DisplayName string `json:"displayName,omitempty"`

	// ExecutionSpec: Required. Spec related to how a task is executed.
	ExecutionSpec *GoogleCloudDataplexV1TaskExecutionSpec `json:"executionSpec,omitempty"`

	// ExecutionStatus: Output only. Status of the latest task executions.
	ExecutionStatus *GoogleCloudDataplexV1TaskExecutionStatus `json:"executionStatus,omitempty"`

	// Labels: Optional. User-defined labels for the task.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. The relative resource name of the task, of the
	// form:
	// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/
	// tasks/{task_id}.
	Name string `json:"name,omitempty"`

	// Notebook: Config related to running scheduled Notebooks.
	Notebook *GoogleCloudDataplexV1TaskNotebookTaskConfig `json:"notebook,omitempty"`

	// Spark: Config related to running custom Spark tasks.
	Spark *GoogleCloudDataplexV1TaskSparkTaskConfig `json:"spark,omitempty"`

	// State: Output only. Current state of the task.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is not specified.
	//   "ACTIVE" - Resource is active, i.e., ready to use.
	//   "CREATING" - Resource is under creation.
	//   "DELETING" - Resource is under deletion.
	//   "ACTION_REQUIRED" - Resource is active but has unresolved actions.
	State string `json:"state,omitempty"`

	// TriggerSpec: Required. Spec related to how often and when a task
	// should be triggered.
	TriggerSpec *GoogleCloudDataplexV1TaskTriggerSpec `json:"triggerSpec,omitempty"`

	// Uid: Output only. System generated globally unique ID for the task.
	// This ID will be different if the task is deleted and re-created with
	// the same name.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time when the task was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1Task) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1Task
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1TaskExecutionSpec: Execution related settings,
// like retry and service_account.
type GoogleCloudDataplexV1TaskExecutionSpec struct {
	// Args: Optional. The arguments to pass to the task. The args can use
	// placeholders of the format ${placeholder} as part of key/value
	// string. These will be interpolated before passing the args to the
	// driver. Currently supported placeholders: - ${task_id} - ${job_time}
	// To pass positional args, set the key as TASK_ARGS. The value should
	// be a comma-separated string of all the positional arguments. To use a
	// delimiter other than comma, refer to
	// https://cloud.google.com/sdk/gcloud/reference/topic/escaping. In case
	// of other keys being present in the args, then TASK_ARGS will be
	// passed as the last argument.
	Args map[string]string `json:"args,omitempty"`

	// KmsKey: Optional. The Cloud KMS key to use for encryption, of the
	// form:
	// projects/{project_number}/locations/{location_id}/keyRings/{key-ring-n
	// ame}/cryptoKeys/{key-name}.
	KmsKey string `json:"kmsKey,omitempty"`

	// MaxJobExecutionLifetime: Optional. The maximum duration after which
	// the job execution is expired.
	MaxJobExecutionLifetime string `json:"maxJobExecutionLifetime,omitempty"`

	// Project: Optional. The project in which jobs are run. By default, the
	// project containing the Lake is used. If a project is provided, the
	// ExecutionSpec.service_account must belong to this project.
	Project string `json:"project,omitempty"`

	// ServiceAccount: Required. Service account to use to execute a task.
	// If not provided, the default Compute service account for the project
	// is used.
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Args") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Args") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1TaskExecutionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1TaskExecutionSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1TaskExecutionStatus: Status of the task
// execution (e.g. Jobs).
type GoogleCloudDataplexV1TaskExecutionStatus struct {
	// LatestJob: Output only. latest job execution
	LatestJob *GoogleCloudDataplexV1Job `json:"latestJob,omitempty"`

	// UpdateTime: Output only. Last update time of the status.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LatestJob") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LatestJob") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1TaskExecutionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1TaskExecutionStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1TaskInfrastructureSpec: Configuration for the
// underlying infrastructure used to run workloads.
type GoogleCloudDataplexV1TaskInfrastructureSpec struct {
	// Batch: Compute resources needed for a Task when using Dataproc
	// Serverless.
	Batch *GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResources `json:"batch,omitempty"`

	// ContainerImage: Container Image Runtime Configuration.
	ContainerImage *GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntime `json:"containerImage,omitempty"`

	// VpcNetwork: Vpc network.
	VpcNetwork *GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetwork `json:"vpcNetwork,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Batch") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Batch") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1TaskInfrastructureSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1TaskInfrastructureSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResources:
// Batch compute resources associated with the task.
type GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResources struct {
	// ExecutorsCount: Optional. Total number of job executors. Executor
	// Count should be between 2 and 100. Default=2
	ExecutorsCount int64 `json:"executorsCount,omitempty"`

	// MaxExecutorsCount: Optional. Max configurable executors. If
	// max_executors_count > executors_count, then auto-scaling is enabled.
	// Max Executor Count should be between 2 and 1000. Default=1000
	MaxExecutorsCount int64 `json:"maxExecutorsCount,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExecutorsCount") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExecutorsCount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResources) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1TaskInfrastructureSpecBatchComputeResources
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntime:
// Container Image Runtime Configuration used with Batch execution.
type GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntime struct {
	// Image: Optional. Container image to use.
	Image string `json:"image,omitempty"`

	// JavaJars: Optional. A list of Java JARS to add to the classpath.
	// Valid input includes Cloud Storage URIs to Jar binaries. For example,
	// gs://bucket-name/my/path/to/file.jar
	JavaJars []string `json:"javaJars,omitempty"`

	// Properties: Optional. Override to common configuration of open source
	// components installed on the Dataproc cluster. The properties to set
	// on daemon config files. Property keys are specified in
	// prefix:property format, for example core:hadoop.tmp.dir. For more
	// information, see Cluster properties
	// (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
	Properties map[string]string `json:"properties,omitempty"`

	// PythonPackages: Optional. A list of python packages to be installed.
	// Valid formats include Cloud Storage URI to a PIP installable library.
	// For example, gs://bucket-name/my/path/to/lib.tar.gz
	PythonPackages []string `json:"pythonPackages,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Image") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Image") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntime) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1TaskInfrastructureSpecContainerImageRuntime
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetwork: Cloud VPC
// Network used to run the infrastructure.
type GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetwork struct {
	// Network: Optional. The Cloud VPC network in which the job is run. By
	// default, the Cloud VPC network named Default within the project is
	// used.
	Network string `json:"network,omitempty"`

	// NetworkTags: Optional. List of network tags to apply to the job.
	NetworkTags []string `json:"networkTags,omitempty"`

	// SubNetwork: Optional. The Cloud VPC sub-network in which the job is
	// run.
	SubNetwork string `json:"subNetwork,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Network") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Network") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetwork) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1TaskInfrastructureSpecVpcNetwork
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1TaskNotebookTaskConfig: Config for running
// scheduled notebooks.
type GoogleCloudDataplexV1TaskNotebookTaskConfig struct {
	// ArchiveUris: Optional. Cloud Storage URIs of archives to be extracted
	// into the working directory of each executor. Supported file types:
	// .jar, .tar, .tar.gz, .tgz, and .zip.
	ArchiveUris []string `json:"archiveUris,omitempty"`

	// FileUris: Optional. Cloud Storage URIs of files to be placed in the
	// working directory of each executor.
	FileUris []string `json:"fileUris,omitempty"`

	// InfrastructureSpec: Optional. Infrastructure specification for the
	// execution.
	InfrastructureSpec *GoogleCloudDataplexV1TaskInfrastructureSpec `json:"infrastructureSpec,omitempty"`

	// Notebook: Required. Path to input notebook. This can be the Cloud
	// Storage URI of the notebook file or the path to a Notebook Content.
	// The execution args are accessible as environment variables
	// (TASK_key=value).
	Notebook string `json:"notebook,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ArchiveUris") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ArchiveUris") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1TaskNotebookTaskConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1TaskNotebookTaskConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1TaskSparkTaskConfig: User-specified config for
// running a Spark task.
type GoogleCloudDataplexV1TaskSparkTaskConfig struct {
	// ArchiveUris: Optional. Cloud Storage URIs of archives to be extracted
	// into the working directory of each executor. Supported file types:
	// .jar, .tar, .tar.gz, .tgz, and .zip.
	ArchiveUris []string `json:"archiveUris,omitempty"`

	// FileUris: Optional. Cloud Storage URIs of files to be placed in the
	// working directory of each executor.
	FileUris []string `json:"fileUris,omitempty"`

	// InfrastructureSpec: Optional. Infrastructure specification for the
	// execution.
	InfrastructureSpec *GoogleCloudDataplexV1TaskInfrastructureSpec `json:"infrastructureSpec,omitempty"`

	// MainClass: The name of the driver's main class. The jar file that
	// contains the class must be in the default CLASSPATH or specified in
	// jar_file_uris. The execution args are passed in as a sequence of
	// named process arguments (--key=value).
	MainClass string `json:"mainClass,omitempty"`

	// MainJarFileUri: The Cloud Storage URI of the jar file that contains
	// the main class. The execution args are passed in as a sequence of
	// named process arguments (--key=value).
	MainJarFileUri string `json:"mainJarFileUri,omitempty"`

	// PythonScriptFile: The Gcloud Storage URI of the main Python file to
	// use as the driver. Must be a .py file. The execution args are passed
	// in as a sequence of named process arguments (--key=value).
	PythonScriptFile string `json:"pythonScriptFile,omitempty"`

	// SqlScript: The query text. The execution args are used to declare a
	// set of script variables (set key="value";).
	SqlScript string `json:"sqlScript,omitempty"`

	// SqlScriptFile: A reference to a query file. This can be the Cloud
	// Storage URI of the query file or it can the path to a SqlScript
	// Content. The execution args are used to declare a set of script
	// variables (set key="value";).
	SqlScriptFile string `json:"sqlScriptFile,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ArchiveUris") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ArchiveUris") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1TaskSparkTaskConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1TaskSparkTaskConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1TaskTriggerSpec: Task scheduling and trigger
// settings.
type GoogleCloudDataplexV1TaskTriggerSpec struct {
	// Disabled: Optional. Prevent the task from executing. This does not
	// cancel already running tasks. It is intended to temporarily disable
	// RECURRING tasks.
	Disabled bool `json:"disabled,omitempty"`

	// MaxRetries: Optional. Number of retry attempts before aborting. Set
	// to zero to never attempt to retry a failed task.
	MaxRetries int64 `json:"maxRetries,omitempty"`

	// Schedule: Optional. Cron schedule
	// (https://en.wikipedia.org/wiki/Cron) for running tasks periodically.
	// To explicitly set a timezone to the cron tab, apply a prefix in the
	// cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}". The
	// ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
	// database. For example, CRON_TZ=America/New_York 1 * * * *, or
	// TZ=America/New_York 1 * * * *. This field is required for RECURRING
	// tasks.
	Schedule string `json:"schedule,omitempty"`

	// StartTime: Optional. The first run of the task will be after this
	// time. If not specified, the task will run shortly after being
	// submitted if ON_DEMAND and based on the schedule if RECURRING.
	StartTime string `json:"startTime,omitempty"`

	// Type: Required. Immutable. Trigger type of the user-specified Task.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Unspecified trigger type.
	//   "ON_DEMAND" - The task runs one-time shortly after Task Creation.
	//   "RECURRING" - The task is scheduled to run periodically.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Disabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1TaskTriggerSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1TaskTriggerSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1Trigger: DataScan scheduling and trigger
// settings.
type GoogleCloudDataplexV1Trigger struct {
	// OnDemand: The scan runs once via RunDataScan API.
	OnDemand *GoogleCloudDataplexV1TriggerOnDemand `json:"onDemand,omitempty"`

	// Schedule: The scan is scheduled to run periodically.
	Schedule *GoogleCloudDataplexV1TriggerSchedule `json:"schedule,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OnDemand") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OnDemand") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1Trigger) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1Trigger
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1TriggerOnDemand: The scan runs once via
// RunDataScan API.
type GoogleCloudDataplexV1TriggerOnDemand struct {
}

// GoogleCloudDataplexV1TriggerSchedule: The scan is scheduled to run
// periodically.
type GoogleCloudDataplexV1TriggerSchedule struct {
	// Cron: Required. Cron (https://en.wikipedia.org/wiki/Cron) schedule
	// for running scans periodically.To explicitly set a timezone in the
	// cron tab, apply a prefix in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}"
	// or "TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid
	// string from IANA time zone database (wikipedia
	// (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones#List)).
	// For example, CRON_TZ=America/New_York 1 * * * *, or
	// TZ=America/New_York 1 * * * *.This field is required for Schedule
	// scans.
	Cron string `json:"cron,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Cron") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cron") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1TriggerSchedule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1TriggerSchedule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1Zone: A zone represents a logical group of
// related assets within a lake. A zone can be used to map to
// organizational structure or represent stages of data readiness from
// raw to curated. It provides managing behavior that is shared or
// inherited by all contained assets.
type GoogleCloudDataplexV1Zone struct {
	// AssetStatus: Output only. Aggregated status of the underlying assets
	// of the zone.
	AssetStatus *GoogleCloudDataplexV1AssetStatus `json:"assetStatus,omitempty"`

	// CreateTime: Output only. The time when the zone was created.
	CreateTime string `json:"createTime,omitempty"`

	// Description: Optional. Description of the zone.
	Description string `json:"description,omitempty"`

	// DiscoverySpec: Optional. Specification of the discovery feature
	// applied to data in this zone.
	DiscoverySpec *GoogleCloudDataplexV1ZoneDiscoverySpec `json:"discoverySpec,omitempty"`

	// DisplayName: Optional. User friendly display name.
	DisplayName string `json:"displayName,omitempty"`

	// Labels: Optional. User defined labels for the zone.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Output only. The relative resource name of the zone, of the
	// form:
	// projects/{project_number}/locations/{location_id}/lakes/{lake_id}/zone
	// s/{zone_id}.
	Name string `json:"name,omitempty"`

	// ResourceSpec: Required. Specification of the resources that are
	// referenced by the assets within this zone.
	ResourceSpec *GoogleCloudDataplexV1ZoneResourceSpec `json:"resourceSpec,omitempty"`

	// State: Output only. Current state of the zone.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State is not specified.
	//   "ACTIVE" - Resource is active, i.e., ready to use.
	//   "CREATING" - Resource is under creation.
	//   "DELETING" - Resource is under deletion.
	//   "ACTION_REQUIRED" - Resource is active but has unresolved actions.
	State string `json:"state,omitempty"`

	// Type: Required. Immutable. The type of the zone.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Zone type not specified.
	//   "RAW" - A zone that contains data that needs further processing
	// before it is considered generally ready for consumption and analytics
	// workloads.
	//   "CURATED" - A zone that contains data that is considered to be
	// ready for broader consumption and analytics workloads. Curated
	// structured data stored in Cloud Storage must conform to certain file
	// formats (parquet, avro and orc) and organized in a hive-compatible
	// directory layout.
	Type string `json:"type,omitempty"`

	// Uid: Output only. System generated globally unique ID for the zone.
	// This ID will be different if the zone is deleted and re-created with
	// the same name.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Output only. The time when the zone was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AssetStatus") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AssetStatus") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1Zone) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1Zone
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ZoneDiscoverySpec: Settings to manage the
// metadata discovery and publishing in a zone.
type GoogleCloudDataplexV1ZoneDiscoverySpec struct {
	// CsvOptions: Optional. Configuration for CSV data.
	CsvOptions *GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptions `json:"csvOptions,omitempty"`

	// Enabled: Required. Whether discovery is enabled.
	Enabled bool `json:"enabled,omitempty"`

	// ExcludePatterns: Optional. The list of patterns to apply for
	// selecting data to exclude during discovery. For Cloud Storage bucket
	// assets, these are interpreted as glob patterns used to match object
	// names. For BigQuery dataset assets, these are interpreted as patterns
	// to match table names.
	ExcludePatterns []string `json:"excludePatterns,omitempty"`

	// IncludePatterns: Optional. The list of patterns to apply for
	// selecting data to include during discovery if only a subset of the
	// data should considered. For Cloud Storage bucket assets, these are
	// interpreted as glob patterns used to match object names. For BigQuery
	// dataset assets, these are interpreted as patterns to match table
	// names.
	IncludePatterns []string `json:"includePatterns,omitempty"`

	// JsonOptions: Optional. Configuration for Json data.
	JsonOptions *GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptions `json:"jsonOptions,omitempty"`

	// Schedule: Optional. Cron schedule
	// (https://en.wikipedia.org/wiki/Cron) for running discovery
	// periodically. Successive discovery runs must be scheduled at least 60
	// minutes apart. The default value is to run discovery every 60
	// minutes. To explicitly set a timezone to the cron tab, apply a prefix
	// in the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or
	// TZ=${IANA_TIME_ZONE}". The ${IANA_TIME_ZONE} may only be a valid
	// string from IANA time zone database. For example,
	// CRON_TZ=America/New_York 1 * * * *, or TZ=America/New_York 1 * * * *.
	Schedule string `json:"schedule,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CsvOptions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CsvOptions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ZoneDiscoverySpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ZoneDiscoverySpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptions: Describe CSV and
// similar semi-structured data formats.
type GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptions struct {
	// Delimiter: Optional. The delimiter being used to separate values.
	// This defaults to ','.
	Delimiter string `json:"delimiter,omitempty"`

	// DisableTypeInference: Optional. Whether to disable the inference of
	// data type for CSV data. If true, all columns will be registered as
	// strings.
	DisableTypeInference bool `json:"disableTypeInference,omitempty"`

	// Encoding: Optional. The character encoding of the data. The default
	// is UTF-8.
	Encoding string `json:"encoding,omitempty"`

	// HeaderRows: Optional. The number of rows to interpret as header rows
	// that should be skipped when reading data rows.
	HeaderRows int64 `json:"headerRows,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Delimiter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Delimiter") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ZoneDiscoverySpecCsvOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptions: Describe JSON data
// format.
type GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptions struct {
	// DisableTypeInference: Optional. Whether to disable the inference of
	// data type for Json data. If true, all columns will be registered as
	// their primitive types (strings, number or boolean).
	DisableTypeInference bool `json:"disableTypeInference,omitempty"`

	// Encoding: Optional. The character encoding of the data. The default
	// is UTF-8.
	Encoding string `json:"encoding,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "DisableTypeInference") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisableTypeInference") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ZoneDiscoverySpecJsonOptions
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudDataplexV1ZoneResourceSpec: Settings for resources
// attached as assets within a zone.
type GoogleCloudDataplexV1ZoneResourceSpec struct {
	// LocationType: Required. Immutable. The location type of the resources
	// that are allowed to be attached to the assets within this zone.
	//
	// Possible values:
	//   "LOCATION_TYPE_UNSPECIFIED" - Unspecified location type.
	//   "SINGLE_REGION" - Resources that are associated with a single
	// region.
	//   "MULTI_REGION" - Resources that are associated with a multi-region
	// location.
	LocationType string `json:"locationType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "LocationType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LocationType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudDataplexV1ZoneResourceSpec) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudDataplexV1ZoneResourceSpec
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudLocationListLocationsResponse: The response message for
// Locations.ListLocations.
type GoogleCloudLocationListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in
	// the request.
	Locations []*GoogleCloudLocationLocation `json:"locations,omitempty"`

	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Locations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudLocationListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudLocationListLocationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudLocationLocation: A resource that represents a Google
// Cloud location.
type GoogleCloudLocationLocation struct {
	// DisplayName: The friendly name for this location, typically a nearby
	// city name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`

	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`

	// LocationId: The canonical id for this location. For example:
	// "us-east1".
	LocationId string `json:"locationId,omitempty"`

	// Metadata: Service-specific metadata. For example the available
	// capacity at the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudLocationLocation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudLocationLocation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditConfig: Specifies the audit configuration for a
// service. The configuration determines which permission types are
// logged, and what identities, if any, are exempted from logging. An
// AuditConfig must have one or more AuditLogConfigs.If there are
// AuditConfigs for both allServices and a specific service, the union
// of the two AuditConfigs is used for that service: the log_types
// specified in each AuditConfig are enabled, and the exempted_members
// in each AuditLogConfig are exempted.Example Policy with multiple
// AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members":
// [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, {
// "log_type": "ADMIN_READ" } ] }, { "service":
// "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type":
// "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [
// "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy
// enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts
// jose@example.com from DATA_READ logging, and aliya@example.com from
// DATA_WRITE logging.
type GoogleIamV1AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of
	// permission.
	AuditLogConfigs []*GoogleIamV1AuditLogConfig `json:"auditLogConfigs,omitempty"`

	// Service: Specifies a service that will be enabled for audit logging.
	// For example, storage.googleapis.com, cloudsql.googleapis.com.
	// allServices is a special value that covers all services.
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditLogConfigs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditLogConfig: Provides the configuration for logging a
// type of permissions. Example: { "audit_log_configs": [ { "log_type":
// "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, {
// "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and
// 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ
// logging.
type GoogleIamV1AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging
	// for this type of permission. Follows the same format of
	// Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`

	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExemptedMembers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditLogConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Binding: Associates members, or principals, with a role.
type GoogleIamV1Binding struct {
	// Condition: The condition that is associated with this binding.If the
	// condition evaluates to true, then this binding applies to the current
	// request.If the condition evaluates to false, then this binding does
	// not apply to the current request. However, a different role binding
	// might grant the same role to one or more of the principals in this
	// binding.To learn which resources support conditions in their IAM
	// policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *GoogleTypeExpr `json:"condition,omitempty"`

	// Members: Specifies the principals requesting access for a Google
	// Cloud resource. members can have the following values: allUsers: A
	// special identifier that represents anyone who is on the internet;
	// with or without a Google account. allAuthenticatedUsers: A special
	// identifier that represents anyone who is authenticated with a Google
	// account or a service account. Does not include identities that come
	// from external identity providers (IdPs) through identity federation.
	// user:{emailid}: An email address that represents a specific Google
	// account. For example, alice@example.com . serviceAccount:{emailid}:
	// An email address that represents a Google service account. For
	// example, my-other-app@appspot.gserviceaccount.com.
	// serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]:
	// An identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, my-project.svc.id.goog[my-namespace/my-kubernetes-sa].
	// group:{emailid}: An email address that represents a Google group. For
	// example, admins@example.com. domain:{domain}: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// google.com or example.com.
	// principal://iam.googleapis.com/locations/global/workforcePools/{pool_i
	// d}/subject/{subject_attribute_value}: A single identity in a
	// workforce identity pool.
	// principalSet://iam.googleapis.com/locations/global/workforcePools/{poo
	// l_id}/group/{group_id}: All workforce identities in a group.
	// principalSet://iam.googleapis.com/locations/global/workforcePools/{poo
	// l_id}/attribute.{attribute_name}/{attribute_value}: All workforce
	// identities with a specific attribute value.
	// principalSet://iam.googleapis.com/locations/global/workforcePools/{poo
	// l_id}/*: All identities in a workforce identity pool.
	// principal://iam.googleapis.com/projects/{project_number}/locations/glo
	// bal/workloadIdentityPools/{pool_id}/subject/{subject_attribute_value}:
	//  A single identity in a workload identity pool.
	// principalSet://iam.googleapis.com/projects/{project_number}/locations/
	// global/workloadIdentityPools/{pool_id}/group/{group_id}: A workload
	// identity pool group.
	// principalSet://iam.googleapis.com/projects/{project_number}/locations/
	// global/workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{att
	// ribute_value}: All identities in a workload identity pool with a
	// certain attribute.
	// principalSet://iam.googleapis.com/projects/{project_number}/locations/
	// global/workloadIdentityPools/{pool_id}/*: All identities in a
	// workload identity pool. deleted:user:{emailid}?uid={uniqueid}: An
	// email address (plus unique identifier) representing a user that has
	// been recently deleted. For example,
	// alice@example.com?uid=123456789012345678901. If the user is
	// recovered, this value reverts to user:{emailid} and the recovered
	// user retains the role in the binding.
	// deleted:serviceAccount:{emailid}?uid={uniqueid}: An email address
	// (plus unique identifier) representing a service account that has been
	// recently deleted. For example,
	// my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901.
	// If the service account is undeleted, this value reverts to
	// serviceAccount:{emailid} and the undeleted service account retains
	// the role in the binding. deleted:group:{emailid}?uid={uniqueid}: An
	// email address (plus unique identifier) representing a Google group
	// that has been recently deleted. For example,
	// admins@example.com?uid=123456789012345678901. If the group is
	// recovered, this value reverts to group:{emailid} and the recovered
	// group retains the role in the binding.
	// deleted:principal://iam.googleapis.com/locations/global/workforcePools
	// /{pool_id}/subject/{subject_attribute_value}: Deleted single identity
	// in a workforce identity pool. For example,
	// deleted:principal://iam.googleapis.com/locations/global/workforcePools
	// /my-pool-id/subject/my-subject-attribute-value.
	Members []string `json:"members,omitempty"`

	// Role: Role that is assigned to the list of members, or principals.
	// For example, roles/viewer, roles/editor, or roles/owner.For an
	// overview of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Condition") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1Binding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Binding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Policy: An Identity and Access Management (IAM) policy,
// which specifies access controls for Google Cloud resources.A Policy
// is a collection of bindings. A binding binds one or more members, or
// principals, to a single role. Principals can be user accounts,
// service accounts, Google groups, and domains (such as G Suite). A
// role is a named list of permissions; each role can be an IAM
// predefined role or a user-created custom role.For some types of
// Google Cloud resources, a binding can also specify a condition, which
// is a logical expression that allows access to a resource only if the
// expression evaluates to true. A condition can add constraints based
// on attributes of the request, the resource, or both. To learn which
// resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).JSON
// example: { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com",
// "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, {
// "role": "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ],
// "etag": "BwWWja0YfJA=", "version": 3 } YAML example: bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com -
// serviceAccount:my-project-id@appspot.gserviceaccount.com role:
// roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access
// after Sep 2020 expression: request.time <
// timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA= version: 3
// For a description of IAM and its features, see the IAM documentation
// (https://cloud.google.com/iam/docs/).
type GoogleIamV1Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this
	// policy.
	AuditConfigs []*GoogleIamV1AuditConfig `json:"auditConfigs,omitempty"`

	// Bindings: Associates a list of members, or principals, with a role.
	// Optionally, may specify a condition that determines how and when the
	// bindings are applied. Each of the bindings must contain at least one
	// principal.The bindings in a Policy can refer to up to 1,500
	// principals; up to 250 of these principals can be Google groups. Each
	// occurrence of a principal counts towards these limits. For example,
	// if the bindings grant 50 different roles to user:alice@example.com,
	// and not to any other principal, then you can add another 1,450
	// principals to the bindings in the Policy.
	Bindings []*GoogleIamV1Binding `json:"bindings,omitempty"`

	// Etag: etag is used for optimistic concurrency control as a way to
	// help prevent simultaneous updates of a policy from overwriting each
	// other. It is strongly suggested that systems make use of the etag in
	// the read-modify-write cycle to perform policy updates in order to
	// avoid race conditions: An etag is returned in the response to
	// getIamPolicy, and systems are expected to put that etag in the
	// request to setIamPolicy to ensure that their change will be applied
	// to the same version of the policy.Important: If you use IAM
	// Conditions, you must include the etag field whenever you call
	// setIamPolicy. If you omit this field, then IAM allows you to
	// overwrite a version 3 policy with a version 1 policy, and all of the
	// conditions in the version 3 policy are lost.
	Etag string `json:"etag,omitempty"`

	// Version: Specifies the format of the policy.Valid values are 0, 1,
	// and 3. Requests that specify an invalid value are rejected.Any
	// operation that affects conditional role bindings must specify version
	// 3. This requirement applies to the following operations: Getting a
	// policy that includes a conditional role binding Adding a conditional
	// role binding to a policy Changing a conditional role binding in a
	// policy Removing any role binding, with or without a condition, from a
	// policy that includes conditionsImportant: If you use IAM Conditions,
	// you must include the etag field whenever you call setIamPolicy. If
	// you omit this field, then IAM allows you to overwrite a version 3
	// policy with a version 1 policy, and all of the conditions in the
	// version 3 policy are lost.If a policy does not include any
	// conditions, operations on that policy may specify any valid version
	// or leave the field unset.To learn which resources support conditions
	// in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditConfigs") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1Policy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Policy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1SetIamPolicyRequest: Request message for SetIamPolicy
// method.
type GoogleIamV1SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the resource.
	// The size of the policy is limited to a few 10s of KB. An empty policy
	// is a valid policy but certain Google Cloud services (such as
	// Projects) might reject them.
	Policy *GoogleIamV1Policy `json:"policy,omitempty"`

	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the
	// policy to modify. Only the fields in the mask will be modified. If no
	// mask is provided, the following default mask is used:paths:
	// "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Policy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1SetIamPolicyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1TestIamPermissionsRequest: Request message for
// TestIamPermissions method.
type GoogleIamV1TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the resource.
	// Permissions with wildcards (such as * or storage.*) are not allowed.
	// For more information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Permissions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1TestIamPermissionsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1TestIamPermissionsResponse: Response message for
// TestIamPermissions method.
type GoogleIamV1TestIamPermissionsResponse struct {
	// Permissions: A subset of TestPermissionsRequest.permissions that the
	// caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Permissions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1TestIamPermissionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningCancelOperationRequest: The request message for
// Operations.CancelOperation.
type GoogleLongrunningCancelOperationRequest struct {
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Operations: A list of operations that matches the specified filter in
	// the request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is false, it means the operation is still in
	// progress. If true, the operation is completed, and either error or
	// response is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the name should be a resource name ending with
	// operations/{unique_id}.
	Name string `json:"name,omitempty"`

	// Response: The normal, successful response of the operation. If the
	// original method returns no data on success, such as Delete, the
	// response is google.protobuf.Empty. If the original method is standard
	// Get/Create/Update, the response should be the resource. For other
	// methods, the response should have the type XxxResponse, where Xxx is
	// the original method name. For example, if the original method name is
	// TakeSnapshot(), the inferred response type is TakeSnapshotResponse.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleRpcStatus: The Status type defines a logical error model that
// is suitable for different programming environments, including REST
// APIs and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// Status message contains three pieces of data: error code, error
// message, and error details.You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeExpr: Represents a textual expression in the Common
// Expression Language (CEL) syntax. CEL is a C-like expression
// language. The syntax and semantics of CEL are documented at
// https://github.com/google/cel-spec.Example (Comparison): title:
// "Summary size limit" description: "Determines if a summary is less
// than 100 chars" expression: "document.summary.size() < 100" Example
// (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly
// visible" expression: "document.type != 'private' && document.type !=
// 'internal'" Example (Data Manipulation): title: "Notification string"
// description: "Create a notification string with a timestamp."
// expression: "'New message received at ' +
// string(document.create_time)" The exact variables and functions that
// may be referenced within an expression are determined by the service
// that evaluates it. See the service documentation for additional
// information.
type GoogleTypeExpr struct {
	// Description: Optional. Description of the expression. This is a
	// longer text which describes the expression, e.g. when hovered over it
	// in a UI.
	Description string `json:"description,omitempty"`

	// Expression: Textual representation of an expression in Common
	// Expression Language syntax.
	Expression string `json:"expression,omitempty"`

	// Location: Optional. String indicating the location of the expression
	// for error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`

	// Title: Optional. Title for the expression, i.e. a short string
	// describing its purpose. This can be used e.g. in UIs which allow to
	// enter the expression.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeExpr) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeExpr
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "dataplex.projects.locations.get":

type ProjectsLocationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a location.
//
// - name: Resource name for the location.
func (r *ProjectsLocationsService) Get(name string) *ProjectsLocationsGetCall {
	c := &ProjectsLocationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGetCall) Context(ctx context.Context) *ProjectsLocationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.get" call.
// Exactly one of *GoogleCloudLocationLocation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudLocationLocation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudLocationLocation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudLocationLocation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets information about a location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Resource name for the location.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudLocationLocation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.list":

type ProjectsLocationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this
// service.
//
//   - name: The resource that owns the locations collection, if
//     applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down
// results to a preferred subset. The filtering language accepts strings
// like "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token
// received from the next_page_token field in the response. Send that
// page token to receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.list" call.
// Exactly one of *GoogleCloudLocationListLocationsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudLocationListLocationsResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudLocationListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudLocationListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists information about the supported locations for this service.",
	//   "flatPath": "v1/projects/{projectsId}/locations",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "A filter to narrow down results to a preferred subset. The filtering language accepts strings like \"displayName=tokyo\", and is documented in more detail in AIP-160 (https://google.aip.dev/160).",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "The resource that owns the locations collection, if applicable.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of results to return. If not set, the service selects a default.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A page token received from the next_page_token field in the response. Send that page token to receive the subsequent page.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}/locations",
	//   "response": {
	//     "$ref": "GoogleCloudLocationListLocationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*GoogleCloudLocationListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dataplex.projects.locations.lookupEntry":

type ProjectsLocationsLookupEntryCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// LookupEntry: Looks up a single entry.
//
//   - name: The project to which the request should be attributed in the
//     following form: projects/{project}/locations/{location}.
func (r *ProjectsLocationsService) LookupEntry(name string) *ProjectsLocationsLookupEntryCall {
	c := &ProjectsLocationsLookupEntryCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// AspectTypes sets the optional parameter "aspectTypes": Limits the
// aspects returned to the provided aspect types. Only works if the
// CUSTOM view is selected.
func (c *ProjectsLocationsLookupEntryCall) AspectTypes(aspectTypes ...string) *ProjectsLocationsLookupEntryCall {
	c.urlParams_.SetMulti("aspectTypes", append([]string{}, aspectTypes...))
	return c
}

// Entry sets the optional parameter "entry": Required. The resource
// name of the Entry:
// projects/{project}/locations/{location}/entryGroups/{entry_group}/entr
// ies/{entry}.
func (c *ProjectsLocationsLookupEntryCall) Entry(entry string) *ProjectsLocationsLookupEntryCall {
	c.urlParams_.Set("entry", entry)
	return c
}

// Paths sets the optional parameter "paths": Limits the aspects
// returned to those associated with the provided paths within the
// Entry. Only works if the CUSTOM view is selected.
func (c *ProjectsLocationsLookupEntryCall) Paths(paths ...string) *ProjectsLocationsLookupEntryCall {
	c.urlParams_.SetMulti("paths", append([]string{}, paths...))
	return c
}

// View sets the optional parameter "view": View for controlling which
// parts of an entry are to be returned.
//
// Possible values:
//
//	"ENTRY_VIEW_UNSPECIFIED" - Unspecified EntryView. Defaults to FULL.
//	"BASIC" - Returns entry only, without aspects.
//	"FULL" - Returns all required aspects as well as the keys of all
//
// non-required aspects.
//
//	"CUSTOM" - Returns aspects matching custom fields in
//
// GetEntryRequest. If the number of aspects would exceed 100, the first
// 100 will be returned.
//
//	"ALL" - Returns all aspects. If the number of aspects would exceed
//
// 100, the first 100 will be returned.
func (c *ProjectsLocationsLookupEntryCall) View(view string) *ProjectsLocationsLookupEntryCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsLookupEntryCall) Fields(s ...googleapi.Field) *ProjectsLocationsLookupEntryCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsLookupEntryCall) IfNoneMatch(entityTag string) *ProjectsLocationsLookupEntryCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsLookupEntryCall) Context(ctx context.Context) *ProjectsLocationsLookupEntryCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsLookupEntryCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLookupEntryCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:lookupEntry")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.lookupEntry" call.
// Exactly one of *GoogleCloudDataplexV1Entry or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDataplexV1Entry.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsLookupEntryCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1Entry, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1Entry{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Looks up a single entry.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}:lookupEntry",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.lookupEntry",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "aspectTypes": {
	//       "description": "Optional. Limits the aspects returned to the provided aspect types. Only works if the CUSTOM view is selected.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "entry": {
	//       "description": "Required. The resource name of the Entry: projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. The project to which the request should be attributed in the following form: projects/{project}/locations/{location}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "paths": {
	//       "description": "Optional. Limits the aspects returned to those associated with the provided paths within the Entry. Only works if the CUSTOM view is selected.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Optional. View for controlling which parts of an entry are to be returned.",
	//       "enum": [
	//         "ENTRY_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL",
	//         "CUSTOM",
	//         "ALL"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified EntryView. Defaults to FULL.",
	//         "Returns entry only, without aspects.",
	//         "Returns all required aspects as well as the keys of all non-required aspects.",
	//         "Returns aspects matching custom fields in GetEntryRequest. If the number of aspects would exceed 100, the first 100 will be returned.",
	//         "Returns all aspects. If the number of aspects would exceed 100, the first 100 will be returned."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:lookupEntry",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1Entry"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.searchEntries":

type ProjectsLocationsSearchEntriesCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// SearchEntries: Searches for entries matching given query and scope.
//
//   - name: The project to which the request should be attributed in the
//     following form: projects/{project}/locations/{location}.
func (r *ProjectsLocationsService) SearchEntries(name string) *ProjectsLocationsSearchEntriesCall {
	c := &ProjectsLocationsSearchEntriesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// OrderBy sets the optional parameter "orderBy": Ordering of the
// results. Supported options to be added later.
func (c *ProjectsLocationsSearchEntriesCall) OrderBy(orderBy string) *ProjectsLocationsSearchEntriesCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Pagination.
func (c *ProjectsLocationsSearchEntriesCall) PageSize(pageSize int64) *ProjectsLocationsSearchEntriesCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken":
func (c *ProjectsLocationsSearchEntriesCall) PageToken(pageToken string) *ProjectsLocationsSearchEntriesCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Query sets the optional parameter "query": Required. The query
// against which entries in scope should be matched.
func (c *ProjectsLocationsSearchEntriesCall) Query(query string) *ProjectsLocationsSearchEntriesCall {
	c.urlParams_.Set("query", query)
	return c
}

// Scope sets the optional parameter "scope": The scope under which the
// search should be operating. Should either be organizations/ or
// projects/. If left unspecified, it will default to the organization
// where the project provided in name is located.
func (c *ProjectsLocationsSearchEntriesCall) Scope(scope string) *ProjectsLocationsSearchEntriesCall {
	c.urlParams_.Set("scope", scope)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsSearchEntriesCall) Fields(s ...googleapi.Field) *ProjectsLocationsSearchEntriesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsSearchEntriesCall) Context(ctx context.Context) *ProjectsLocationsSearchEntriesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsSearchEntriesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsSearchEntriesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:searchEntries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.searchEntries" call.
// Exactly one of *GoogleCloudDataplexV1SearchEntriesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDataplexV1SearchEntriesResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsSearchEntriesCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1SearchEntriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1SearchEntriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Searches for entries matching given query and scope.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}:searchEntries",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.searchEntries",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The project to which the request should be attributed in the following form: projects/{project}/locations/{location}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Optional. Ordering of the results. Supported options to be added later.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. Pagination.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "query": {
	//       "description": "Required. The query against which entries in scope should be matched.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "scope": {
	//       "description": "Optional. The scope under which the search should be operating. Should either be organizations/ or projects/. If left unspecified, it will default to the organization where the project provided in name is located.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:searchEntries",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1SearchEntriesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsSearchEntriesCall) Pages(ctx context.Context, f func(*GoogleCloudDataplexV1SearchEntriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dataplex.projects.locations.aspectTypes.create":

type ProjectsLocationsAspectTypesCreateCall struct {
	s                               *Service
	parent                          string
	googleclouddataplexv1aspecttype *GoogleCloudDataplexV1AspectType
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Create: Creates an AspectType
//
//   - parent: The resource name of the AspectType, of the form:
//     projects/{project_number}/locations/{location_id} where location_id
//     refers to a GCP region.
func (r *ProjectsLocationsAspectTypesService) Create(parent string, googleclouddataplexv1aspecttype *GoogleCloudDataplexV1AspectType) *ProjectsLocationsAspectTypesCreateCall {
	c := &ProjectsLocationsAspectTypesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddataplexv1aspecttype = googleclouddataplexv1aspecttype
	return c
}

// AspectTypeId sets the optional parameter "aspectTypeId": Required.
// AspectType identifier.
func (c *ProjectsLocationsAspectTypesCreateCall) AspectTypeId(aspectTypeId string) *ProjectsLocationsAspectTypesCreateCall {
	c.urlParams_.Set("aspectTypeId", aspectTypeId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsAspectTypesCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsAspectTypesCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAspectTypesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsAspectTypesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAspectTypesCreateCall) Context(ctx context.Context) *ProjectsLocationsAspectTypesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAspectTypesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAspectTypesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1aspecttype)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/aspectTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.aspectTypes.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsAspectTypesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an AspectType",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/aspectTypes",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.aspectTypes.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "aspectTypeId": {
	//       "description": "Required. AspectType identifier.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the AspectType, of the form: projects/{project_number}/locations/{location_id} where location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+parent}/aspectTypes",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1AspectType"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.aspectTypes.delete":

type ProjectsLocationsAspectTypesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a AspectType resource.
//
//   - name: The resource name of the AspectType:
//     projects/{project_number}/locations/{location_id}/aspectTypes/{aspec
//     t_type_id}.
func (r *ProjectsLocationsAspectTypesService) Delete(name string) *ProjectsLocationsAspectTypesDeleteCall {
	c := &ProjectsLocationsAspectTypesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": If the client provided etag
// value does not match the current etag value, the
// DeleteAspectTypeRequest method returns an ABORTED error response
func (c *ProjectsLocationsAspectTypesDeleteCall) Etag(etag string) *ProjectsLocationsAspectTypesDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAspectTypesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsAspectTypesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAspectTypesDeleteCall) Context(ctx context.Context) *ProjectsLocationsAspectTypesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAspectTypesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAspectTypesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.aspectTypes.delete" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsAspectTypesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a AspectType resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/aspectTypes/{aspectTypesId}",
	//   "httpMethod": "DELETE",
	//   "id": "dataplex.projects.locations.aspectTypes.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "etag": {
	//       "description": "Optional. If the client provided etag value does not match the current etag value, the DeleteAspectTypeRequest method returns an ABORTED error response",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. The resource name of the AspectType: projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/aspectTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.aspectTypes.get":

type ProjectsLocationsAspectTypesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a AspectType resource.
//
//   - name: The resource name of the AspectType:
//     projects/{project_number}/locations/{location_id}/aspectTypes/{aspec
//     t_type_id}.
func (r *ProjectsLocationsAspectTypesService) Get(name string) *ProjectsLocationsAspectTypesGetCall {
	c := &ProjectsLocationsAspectTypesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAspectTypesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsAspectTypesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsAspectTypesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsAspectTypesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAspectTypesGetCall) Context(ctx context.Context) *ProjectsLocationsAspectTypesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAspectTypesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAspectTypesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.aspectTypes.get" call.
// Exactly one of *GoogleCloudDataplexV1AspectType or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudDataplexV1AspectType.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsAspectTypesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1AspectType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1AspectType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a AspectType resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/aspectTypes/{aspectTypesId}",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.aspectTypes.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the AspectType: projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/aspectTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1AspectType"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.aspectTypes.getIamPolicy":

type ProjectsLocationsAspectTypesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsAspectTypesService) GetIamPolicy(resource string) *ProjectsLocationsAspectTypesGetIamPolicyCall {
	c := &ProjectsLocationsAspectTypesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy.Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected.Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset.The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1.To learn which
// resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsAspectTypesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsAspectTypesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAspectTypesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsAspectTypesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsAspectTypesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsAspectTypesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAspectTypesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsAspectTypesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAspectTypesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAspectTypesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.aspectTypes.getIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsAspectTypesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/aspectTypes/{aspectTypesId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.aspectTypes.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy.Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset.The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/aspectTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.aspectTypes.list":

type ProjectsLocationsAspectTypesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists AspectType resources in a project and location.
//
//   - parent: The resource name of the AspectType location, of the form:
//     projects/{project_number}/locations/{location_id} where location_id
//     refers to a GCP region.
func (r *ProjectsLocationsAspectTypesService) List(parent string) *ProjectsLocationsAspectTypesListCall {
	c := &ProjectsLocationsAspectTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter request. Filters
// are case-sensitive. The following formats are supported:labels.key1 =
// "value1" labels:key1 name = "value" These restrictions can be
// coinjoined with AND, OR and NOT conjunctions.
func (c *ProjectsLocationsAspectTypesListCall) Filter(filter string) *ProjectsLocationsAspectTypesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order by fields (name
// or create_time) for the result. If not specified, the ordering is
// undefined.
func (c *ProjectsLocationsAspectTypesListCall) OrderBy(orderBy string) *ProjectsLocationsAspectTypesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// AspectTypes to return. The service may return fewer than this value.
// If unspecified, at most 10 AspectTypes will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsAspectTypesListCall) PageSize(pageSize int64) *ProjectsLocationsAspectTypesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token
// received from a previous ListAspectTypes call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to ListAspectTypes must match the call that provided the
// page token.
func (c *ProjectsLocationsAspectTypesListCall) PageToken(pageToken string) *ProjectsLocationsAspectTypesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAspectTypesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAspectTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsAspectTypesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAspectTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAspectTypesListCall) Context(ctx context.Context) *ProjectsLocationsAspectTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAspectTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAspectTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/aspectTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.aspectTypes.list" call.
// Exactly one of *GoogleCloudDataplexV1ListAspectTypesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDataplexV1ListAspectTypesResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsAspectTypesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1ListAspectTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1ListAspectTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists AspectType resources in a project and location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/aspectTypes",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.aspectTypes.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Filter request. Filters are case-sensitive. The following formats are supported:labels.key1 = \"value1\" labels:key1 name = \"value\" These restrictions can be coinjoined with AND, OR and NOT conjunctions.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Optional. Order by fields (name or create_time) for the result. If not specified, the ordering is undefined.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. Maximum number of AspectTypes to return. The service may return fewer than this value. If unspecified, at most 10 AspectTypes will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. Page token received from a previous ListAspectTypes call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to ListAspectTypes must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the AspectType location, of the form: projects/{project_number}/locations/{location_id} where location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/aspectTypes",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1ListAspectTypesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAspectTypesListCall) Pages(ctx context.Context, f func(*GoogleCloudDataplexV1ListAspectTypesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dataplex.projects.locations.aspectTypes.patch":

type ProjectsLocationsAspectTypesPatchCall struct {
	s                               *Service
	name                            string
	googleclouddataplexv1aspecttype *GoogleCloudDataplexV1AspectType
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Patch: Updates a AspectType resource.
//
//   - name: Output only. The relative resource name of the AspectType, of
//     the form:
//     projects/{project_number}/locations/{location_id}/aspectTypes/{aspec
//     t_type_id}.
func (r *ProjectsLocationsAspectTypesService) Patch(name string, googleclouddataplexv1aspecttype *GoogleCloudDataplexV1AspectType) *ProjectsLocationsAspectTypesPatchCall {
	c := &ProjectsLocationsAspectTypesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddataplexv1aspecttype = googleclouddataplexv1aspecttype
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask
// of fields to update.
func (c *ProjectsLocationsAspectTypesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsAspectTypesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsAspectTypesPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsAspectTypesPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAspectTypesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsAspectTypesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAspectTypesPatchCall) Context(ctx context.Context) *ProjectsLocationsAspectTypesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAspectTypesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAspectTypesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1aspecttype)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.aspectTypes.patch" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsAspectTypesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a AspectType resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/aspectTypes/{aspectTypesId}",
	//   "httpMethod": "PATCH",
	//   "id": "dataplex.projects.locations.aspectTypes.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The relative resource name of the AspectType, of the form: projects/{project_number}/locations/{location_id}/aspectTypes/{aspect_type_id}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/aspectTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Mask of fields to update.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1AspectType"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.aspectTypes.setIamPolicy":

type ProjectsLocationsAspectTypesSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy.Can return NOT_FOUND,
// INVALID_ARGUMENT, and PERMISSION_DENIED errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsAspectTypesService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsAspectTypesSetIamPolicyCall {
	c := &ProjectsLocationsAspectTypesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAspectTypesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsAspectTypesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAspectTypesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsAspectTypesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAspectTypesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAspectTypesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.aspectTypes.setIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsAspectTypesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/aspectTypes/{aspectTypesId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.aspectTypes.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/aspectTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "GoogleIamV1SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.aspectTypes.testIamPermissions":

type ProjectsLocationsAspectTypesTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a NOT_FOUND error.Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsAspectTypesService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsAspectTypesTestIamPermissionsCall {
	c := &ProjectsLocationsAspectTypesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsAspectTypesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsAspectTypesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsAspectTypesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsAspectTypesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsAspectTypesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAspectTypesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.aspectTypes.testIamPermissions" call.
// Exactly one of *GoogleIamV1TestIamPermissionsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsAspectTypesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a NOT_FOUND error.Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/aspectTypes/{aspectTypesId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.aspectTypes.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/aspectTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "GoogleIamV1TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataAttributeBindings.create":

type ProjectsLocationsDataAttributeBindingsCreateCall struct {
	s                                         *Service
	parent                                    string
	googleclouddataplexv1dataattributebinding *GoogleCloudDataplexV1DataAttributeBinding
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Create: Create a DataAttributeBinding resource.
//
//   - parent: The resource name of the parent data taxonomy
//     projects/{project_number}/locations/{location_id}.
func (r *ProjectsLocationsDataAttributeBindingsService) Create(parent string, googleclouddataplexv1dataattributebinding *GoogleCloudDataplexV1DataAttributeBinding) *ProjectsLocationsDataAttributeBindingsCreateCall {
	c := &ProjectsLocationsDataAttributeBindingsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddataplexv1dataattributebinding = googleclouddataplexv1dataattributebinding
	return c
}

// DataAttributeBindingId sets the optional parameter
// "dataAttributeBindingId": Required. DataAttributeBinding identifier.
// * Must contain only lowercase letters, numbers and hyphens. * Must
// start with a letter. * Must be between 1-63 characters. * Must end
// with a number or a letter. * Must be unique within the Location.
func (c *ProjectsLocationsDataAttributeBindingsCreateCall) DataAttributeBindingId(dataAttributeBindingId string) *ProjectsLocationsDataAttributeBindingsCreateCall {
	c.urlParams_.Set("dataAttributeBindingId", dataAttributeBindingId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsDataAttributeBindingsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsDataAttributeBindingsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataAttributeBindingsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataAttributeBindingsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataAttributeBindingsCreateCall) Context(ctx context.Context) *ProjectsLocationsDataAttributeBindingsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataAttributeBindingsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataAttributeBindingsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1dataattributebinding)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dataAttributeBindings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataAttributeBindings.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataAttributeBindingsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Create a DataAttributeBinding resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataAttributeBindings",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.dataAttributeBindings.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "dataAttributeBindingId": {
	//       "description": "Required. DataAttributeBinding identifier. * Must contain only lowercase letters, numbers and hyphens. * Must start with a letter. * Must be between 1-63 characters. * Must end with a number or a letter. * Must be unique within the Location.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the parent data taxonomy projects/{project_number}/locations/{location_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+parent}/dataAttributeBindings",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1DataAttributeBinding"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataAttributeBindings.delete":

type ProjectsLocationsDataAttributeBindingsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a DataAttributeBinding resource. All attributes
// within the DataAttributeBinding must be deleted before the
// DataAttributeBinding can be deleted.
//
//   - name: The resource name of the DataAttributeBinding:
//     projects/{project_number}/locations/{location_id}/dataAttributeBindi
//     ngs/{data_attribute_binding_id}.
func (r *ProjectsLocationsDataAttributeBindingsService) Delete(name string) *ProjectsLocationsDataAttributeBindingsDeleteCall {
	c := &ProjectsLocationsDataAttributeBindingsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": Required. If the client
// provided etag value does not match the current etag value, the
// DeleteDataAttributeBindingRequest method returns an ABORTED error
// response. Etags must be used when calling the
// DeleteDataAttributeBinding.
func (c *ProjectsLocationsDataAttributeBindingsDeleteCall) Etag(etag string) *ProjectsLocationsDataAttributeBindingsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataAttributeBindingsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataAttributeBindingsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataAttributeBindingsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDataAttributeBindingsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataAttributeBindingsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataAttributeBindingsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataAttributeBindings.delete" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataAttributeBindingsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a DataAttributeBinding resource. All attributes within the DataAttributeBinding must be deleted before the DataAttributeBinding can be deleted.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataAttributeBindings/{dataAttributeBindingsId}",
	//   "httpMethod": "DELETE",
	//   "id": "dataplex.projects.locations.dataAttributeBindings.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "etag": {
	//       "description": "Required. If the client provided etag value does not match the current etag value, the DeleteDataAttributeBindingRequest method returns an ABORTED error response. Etags must be used when calling the DeleteDataAttributeBinding.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. The resource name of the DataAttributeBinding: projects/{project_number}/locations/{location_id}/dataAttributeBindings/{data_attribute_binding_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataAttributeBindings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataAttributeBindings.get":

type ProjectsLocationsDataAttributeBindingsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a DataAttributeBinding resource.
//
//   - name: The resource name of the DataAttributeBinding:
//     projects/{project_number}/locations/{location_id}/dataAttributeBindi
//     ngs/{data_attribute_binding_id}.
func (r *ProjectsLocationsDataAttributeBindingsService) Get(name string) *ProjectsLocationsDataAttributeBindingsGetCall {
	c := &ProjectsLocationsDataAttributeBindingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataAttributeBindingsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataAttributeBindingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataAttributeBindingsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataAttributeBindingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataAttributeBindingsGetCall) Context(ctx context.Context) *ProjectsLocationsDataAttributeBindingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataAttributeBindingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataAttributeBindingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataAttributeBindings.get" call.
// Exactly one of *GoogleCloudDataplexV1DataAttributeBinding or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDataplexV1DataAttributeBinding.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataAttributeBindingsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1DataAttributeBinding, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1DataAttributeBinding{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a DataAttributeBinding resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataAttributeBindings/{dataAttributeBindingsId}",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.dataAttributeBindings.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the DataAttributeBinding: projects/{project_number}/locations/{location_id}/dataAttributeBindings/{data_attribute_binding_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataAttributeBindings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1DataAttributeBinding"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataAttributeBindings.getIamPolicy":

type ProjectsLocationsDataAttributeBindingsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsDataAttributeBindingsService) GetIamPolicy(resource string) *ProjectsLocationsDataAttributeBindingsGetIamPolicyCall {
	c := &ProjectsLocationsDataAttributeBindingsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy.Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected.Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset.The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1.To learn which
// resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsDataAttributeBindingsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsDataAttributeBindingsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataAttributeBindingsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataAttributeBindingsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataAttributeBindingsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataAttributeBindingsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataAttributeBindingsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDataAttributeBindingsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataAttributeBindingsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataAttributeBindingsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataAttributeBindings.getIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataAttributeBindingsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataAttributeBindings/{dataAttributeBindingsId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.dataAttributeBindings.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy.Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset.The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataAttributeBindings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataAttributeBindings.list":

type ProjectsLocationsDataAttributeBindingsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists DataAttributeBinding resources in a project and location.
//
//   - parent: The resource name of the Location:
//     projects/{project_number}/locations/{location_id}.
func (r *ProjectsLocationsDataAttributeBindingsService) List(parent string) *ProjectsLocationsDataAttributeBindingsListCall {
	c := &ProjectsLocationsDataAttributeBindingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter request. Filter
// using resource: filter=resource:"resource-name" Filter using
// attribute: filter=attributes:"attribute-name" Filter using attribute
// in paths list: filter=paths.attributes:"attribute-name"
func (c *ProjectsLocationsDataAttributeBindingsListCall) Filter(filter string) *ProjectsLocationsDataAttributeBindingsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order by fields for
// the result.
func (c *ProjectsLocationsDataAttributeBindingsListCall) OrderBy(orderBy string) *ProjectsLocationsDataAttributeBindingsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// DataAttributeBindings to return. The service may return fewer than
// this value. If unspecified, at most 10 DataAttributeBindings will be
// returned. The maximum value is 1000; values above 1000 will be
// coerced to 1000.
func (c *ProjectsLocationsDataAttributeBindingsListCall) PageSize(pageSize int64) *ProjectsLocationsDataAttributeBindingsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token
// received from a previous ListDataAttributeBindings call. Provide this
// to retrieve the subsequent page. When paginating, all other
// parameters provided to ListDataAttributeBindings must match the call
// that provided the page token.
func (c *ProjectsLocationsDataAttributeBindingsListCall) PageToken(pageToken string) *ProjectsLocationsDataAttributeBindingsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataAttributeBindingsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataAttributeBindingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataAttributeBindingsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataAttributeBindingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataAttributeBindingsListCall) Context(ctx context.Context) *ProjectsLocationsDataAttributeBindingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataAttributeBindingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataAttributeBindingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dataAttributeBindings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataAttributeBindings.list" call.
// Exactly one of
// *GoogleCloudDataplexV1ListDataAttributeBindingsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudDataplexV1ListDataAttributeBindingsResponse.ServerResponse
// .Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataAttributeBindingsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1ListDataAttributeBindingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1ListDataAttributeBindingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists DataAttributeBinding resources in a project and location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataAttributeBindings",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.dataAttributeBindings.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Filter request. Filter using resource: filter=resource:\"resource-name\" Filter using attribute: filter=attributes:\"attribute-name\" Filter using attribute in paths list: filter=paths.attributes:\"attribute-name\"",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Optional. Order by fields for the result.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. Maximum number of DataAttributeBindings to return. The service may return fewer than this value. If unspecified, at most 10 DataAttributeBindings will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. Page token received from a previous ListDataAttributeBindings call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to ListDataAttributeBindings must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the Location: projects/{project_number}/locations/{location_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/dataAttributeBindings",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1ListDataAttributeBindingsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDataAttributeBindingsListCall) Pages(ctx context.Context, f func(*GoogleCloudDataplexV1ListDataAttributeBindingsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dataplex.projects.locations.dataAttributeBindings.patch":

type ProjectsLocationsDataAttributeBindingsPatchCall struct {
	s                                         *Service
	name                                      string
	googleclouddataplexv1dataattributebinding *GoogleCloudDataplexV1DataAttributeBinding
	urlParams_                                gensupport.URLParams
	ctx_                                      context.Context
	header_                                   http.Header
}

// Patch: Updates a DataAttributeBinding resource.
//
//   - name: Output only. The relative resource name of the Data Attribute
//     Binding, of the form:
//     projects/{project_number}/locations/{location}/dataAttributeBindings
//     /{data_attribute_binding_id}.
func (r *ProjectsLocationsDataAttributeBindingsService) Patch(name string, googleclouddataplexv1dataattributebinding *GoogleCloudDataplexV1DataAttributeBinding) *ProjectsLocationsDataAttributeBindingsPatchCall {
	c := &ProjectsLocationsDataAttributeBindingsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddataplexv1dataattributebinding = googleclouddataplexv1dataattributebinding
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask
// of fields to update.
func (c *ProjectsLocationsDataAttributeBindingsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDataAttributeBindingsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsDataAttributeBindingsPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsDataAttributeBindingsPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataAttributeBindingsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataAttributeBindingsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataAttributeBindingsPatchCall) Context(ctx context.Context) *ProjectsLocationsDataAttributeBindingsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataAttributeBindingsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataAttributeBindingsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1dataattributebinding)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataAttributeBindings.patch" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataAttributeBindingsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a DataAttributeBinding resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataAttributeBindings/{dataAttributeBindingsId}",
	//   "httpMethod": "PATCH",
	//   "id": "dataplex.projects.locations.dataAttributeBindings.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The relative resource name of the Data Attribute Binding, of the form: projects/{project_number}/locations/{location}/dataAttributeBindings/{data_attribute_binding_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataAttributeBindings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Mask of fields to update.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1DataAttributeBinding"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataAttributeBindings.setIamPolicy":

type ProjectsLocationsDataAttributeBindingsSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy.Can return NOT_FOUND,
// INVALID_ARGUMENT, and PERMISSION_DENIED errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsDataAttributeBindingsService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsDataAttributeBindingsSetIamPolicyCall {
	c := &ProjectsLocationsDataAttributeBindingsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataAttributeBindingsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataAttributeBindingsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataAttributeBindingsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDataAttributeBindingsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataAttributeBindingsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataAttributeBindingsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataAttributeBindings.setIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataAttributeBindingsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataAttributeBindings/{dataAttributeBindingsId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.dataAttributeBindings.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataAttributeBindings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "GoogleIamV1SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataAttributeBindings.testIamPermissions":

type ProjectsLocationsDataAttributeBindingsTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a NOT_FOUND error.Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsDataAttributeBindingsService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsDataAttributeBindingsTestIamPermissionsCall {
	c := &ProjectsLocationsDataAttributeBindingsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataAttributeBindingsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataAttributeBindingsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataAttributeBindingsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDataAttributeBindingsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataAttributeBindingsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataAttributeBindingsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataAttributeBindings.testIamPermissions" call.
// Exactly one of *GoogleIamV1TestIamPermissionsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataAttributeBindingsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a NOT_FOUND error.Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataAttributeBindings/{dataAttributeBindingsId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.dataAttributeBindings.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataAttributeBindings/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "GoogleIamV1TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataScans.create":

type ProjectsLocationsDataScansCreateCall struct {
	s                             *Service
	parent                        string
	googleclouddataplexv1datascan *GoogleCloudDataplexV1DataScan
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Create: Creates a DataScan resource.
//
//   - parent: The resource name of the parent location:
//     projects/{project}/locations/{location_id} where project refers to
//     a project_id or project_number and location_id refers to a GCP
//     region.
func (r *ProjectsLocationsDataScansService) Create(parent string, googleclouddataplexv1datascan *GoogleCloudDataplexV1DataScan) *ProjectsLocationsDataScansCreateCall {
	c := &ProjectsLocationsDataScansCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddataplexv1datascan = googleclouddataplexv1datascan
	return c
}

// DataScanId sets the optional parameter "dataScanId": Required.
// DataScan identifier. Must contain only lowercase letters, numbers and
// hyphens. Must start with a letter. Must end with a number or a
// letter. Must be between 1-63 characters. Must be unique within the
// customer project / location.
func (c *ProjectsLocationsDataScansCreateCall) DataScanId(dataScanId string) *ProjectsLocationsDataScansCreateCall {
	c.urlParams_.Set("dataScanId", dataScanId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsDataScansCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsDataScansCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataScansCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataScansCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataScansCreateCall) Context(ctx context.Context) *ProjectsLocationsDataScansCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataScansCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataScansCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1datascan)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dataScans")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataScans.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataScansCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a DataScan resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataScans",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.dataScans.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "dataScanId": {
	//       "description": "Required. DataScan identifier. Must contain only lowercase letters, numbers and hyphens. Must start with a letter. Must end with a number or a letter. Must be between 1-63 characters. Must be unique within the customer project / location.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the parent location: projects/{project}/locations/{location_id} where project refers to a project_id or project_number and location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+parent}/dataScans",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1DataScan"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataScans.delete":

type ProjectsLocationsDataScansDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a DataScan resource.
//
//   - name: The resource name of the dataScan:
//     projects/{project}/locations/{location_id}/dataScans/{data_scan_id}
//     where project refers to a project_id or project_number and
//     location_id refers to a GCP region.
func (r *ProjectsLocationsDataScansService) Delete(name string) *ProjectsLocationsDataScansDeleteCall {
	c := &ProjectsLocationsDataScansDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataScansDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataScansDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataScansDeleteCall) Context(ctx context.Context) *ProjectsLocationsDataScansDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataScansDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataScansDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataScans.delete" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataScansDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a DataScan resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataScans/{dataScansId}",
	//   "httpMethod": "DELETE",
	//   "id": "dataplex.projects.locations.dataScans.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the dataScan: projects/{project}/locations/{location_id}/dataScans/{data_scan_id} where project refers to a project_id or project_number and location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataScans/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataScans.generateDataQualityRules":

type ProjectsLocationsDataScansGenerateDataQualityRulesCall struct {
	s                                                    *Service
	name                                                 string
	googleclouddataplexv1generatedataqualityrulesrequest *GoogleCloudDataplexV1GenerateDataQualityRulesRequest
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// GenerateDataQualityRules: Generates recommended DataQualityRule from
// a data profiling DataScan.
//
//   - name: The name should be either * the name of a datascan with at
//     least one successful completed data profiling job, or * the name of
//     a successful completed data profiling datascan job.
func (r *ProjectsLocationsDataScansService) GenerateDataQualityRules(name string, googleclouddataplexv1generatedataqualityrulesrequest *GoogleCloudDataplexV1GenerateDataQualityRulesRequest) *ProjectsLocationsDataScansGenerateDataQualityRulesCall {
	c := &ProjectsLocationsDataScansGenerateDataQualityRulesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddataplexv1generatedataqualityrulesrequest = googleclouddataplexv1generatedataqualityrulesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataScansGenerateDataQualityRulesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataScansGenerateDataQualityRulesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataScansGenerateDataQualityRulesCall) Context(ctx context.Context) *ProjectsLocationsDataScansGenerateDataQualityRulesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataScansGenerateDataQualityRulesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataScansGenerateDataQualityRulesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1generatedataqualityrulesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:generateDataQualityRules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataScans.generateDataQualityRules" call.
// Exactly one of *GoogleCloudDataplexV1GenerateDataQualityRulesResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudDataplexV1GenerateDataQualityRulesResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataScansGenerateDataQualityRulesCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1GenerateDataQualityRulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1GenerateDataQualityRulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Generates recommended DataQualityRule from a data profiling DataScan.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataScans/{dataScansId}:generateDataQualityRules",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.dataScans.generateDataQualityRules",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name should be either * the name of a datascan with at least one successful completed data profiling job, or * the name of a successful completed data profiling datascan job.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataScans/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:generateDataQualityRules",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1GenerateDataQualityRulesRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1GenerateDataQualityRulesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataScans.get":

type ProjectsLocationsDataScansGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a DataScan resource.
//
//   - name: The resource name of the dataScan:
//     projects/{project}/locations/{location_id}/dataScans/{data_scan_id}
//     where project refers to a project_id or project_number and
//     location_id refers to a GCP region.
func (r *ProjectsLocationsDataScansService) Get(name string) *ProjectsLocationsDataScansGetCall {
	c := &ProjectsLocationsDataScansGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": Select the DataScan view to
// return. Defaults to BASIC.
//
// Possible values:
//
//	"DATA_SCAN_VIEW_UNSPECIFIED" - The API will default to the BASIC
//
// view.
//
//	"BASIC" - Basic view that does not include spec and result.
//	"FULL" - Include everything.
func (c *ProjectsLocationsDataScansGetCall) View(view string) *ProjectsLocationsDataScansGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataScansGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataScansGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataScansGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataScansGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataScansGetCall) Context(ctx context.Context) *ProjectsLocationsDataScansGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataScansGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataScansGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataScans.get" call.
// Exactly one of *GoogleCloudDataplexV1DataScan or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudDataplexV1DataScan.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataScansGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1DataScan, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1DataScan{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a DataScan resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataScans/{dataScansId}",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.dataScans.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the dataScan: projects/{project}/locations/{location_id}/dataScans/{data_scan_id} where project refers to a project_id or project_number and location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataScans/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Optional. Select the DataScan view to return. Defaults to BASIC.",
	//       "enum": [
	//         "DATA_SCAN_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "The API will default to the BASIC view.",
	//         "Basic view that does not include spec and result.",
	//         "Include everything."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1DataScan"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataScans.getIamPolicy":

type ProjectsLocationsDataScansGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsDataScansService) GetIamPolicy(resource string) *ProjectsLocationsDataScansGetIamPolicyCall {
	c := &ProjectsLocationsDataScansGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy.Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected.Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset.The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1.To learn which
// resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsDataScansGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsDataScansGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataScansGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataScansGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataScansGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataScansGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataScansGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDataScansGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataScansGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataScansGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataScans.getIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataScansGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataScans/{dataScansId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.dataScans.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy.Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset.The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataScans/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataScans.list":

type ProjectsLocationsDataScansListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists DataScans.
//
//   - parent: The resource name of the parent location:
//     projects/{project}/locations/{location_id} where project refers to
//     a project_id or project_number and location_id refers to a GCP
//     region.
func (r *ProjectsLocationsDataScansService) List(parent string) *ProjectsLocationsDataScansListCall {
	c := &ProjectsLocationsDataScansListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter request.
func (c *ProjectsLocationsDataScansListCall) Filter(filter string) *ProjectsLocationsDataScansListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order by fields (name
// or create_time) for the result. If not specified, the ordering is
// undefined.
func (c *ProjectsLocationsDataScansListCall) OrderBy(orderBy string) *ProjectsLocationsDataScansListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// dataScans to return. The service may return fewer than this value. If
// unspecified, at most 500 scans will be returned. The maximum value is
// 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsDataScansListCall) PageSize(pageSize int64) *ProjectsLocationsDataScansListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token
// received from a previous ListDataScans call. Provide this to retrieve
// the subsequent page. When paginating, all other parameters provided
// to ListDataScans must match the call that provided the page token.
func (c *ProjectsLocationsDataScansListCall) PageToken(pageToken string) *ProjectsLocationsDataScansListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataScansListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataScansListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataScansListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataScansListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataScansListCall) Context(ctx context.Context) *ProjectsLocationsDataScansListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataScansListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataScansListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dataScans")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataScans.list" call.
// Exactly one of *GoogleCloudDataplexV1ListDataScansResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDataplexV1ListDataScansResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataScansListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1ListDataScansResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1ListDataScansResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists DataScans.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataScans",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.dataScans.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Filter request.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Optional. Order by fields (name or create_time) for the result. If not specified, the ordering is undefined.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. Maximum number of dataScans to return. The service may return fewer than this value. If unspecified, at most 500 scans will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. Page token received from a previous ListDataScans call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to ListDataScans must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the parent location: projects/{project}/locations/{location_id} where project refers to a project_id or project_number and location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/dataScans",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1ListDataScansResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDataScansListCall) Pages(ctx context.Context, f func(*GoogleCloudDataplexV1ListDataScansResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dataplex.projects.locations.dataScans.patch":

type ProjectsLocationsDataScansPatchCall struct {
	s                             *Service
	name                          string
	googleclouddataplexv1datascan *GoogleCloudDataplexV1DataScan
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Patch: Updates a DataScan resource.
//
//   - name: Output only. The relative resource name of the scan, of the
//     form:
//     projects/{project}/locations/{location_id}/dataScans/{datascan_id},
//     where project refers to a project_id or project_number and
//     location_id refers to a GCP region.
func (r *ProjectsLocationsDataScansService) Patch(name string, googleclouddataplexv1datascan *GoogleCloudDataplexV1DataScan) *ProjectsLocationsDataScansPatchCall {
	c := &ProjectsLocationsDataScansPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddataplexv1datascan = googleclouddataplexv1datascan
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask
// of fields to update.
func (c *ProjectsLocationsDataScansPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDataScansPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsDataScansPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsDataScansPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataScansPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataScansPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataScansPatchCall) Context(ctx context.Context) *ProjectsLocationsDataScansPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataScansPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataScansPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1datascan)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataScans.patch" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataScansPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a DataScan resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataScans/{dataScansId}",
	//   "httpMethod": "PATCH",
	//   "id": "dataplex.projects.locations.dataScans.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The relative resource name of the scan, of the form: projects/{project}/locations/{location_id}/dataScans/{datascan_id}, where project refers to a project_id or project_number and location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataScans/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Mask of fields to update.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1DataScan"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataScans.run":

type ProjectsLocationsDataScansRunCall struct {
	s                                       *Service
	name                                    string
	googleclouddataplexv1rundatascanrequest *GoogleCloudDataplexV1RunDataScanRequest
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// Run: Runs an on-demand execution of a DataScan
//
//   - name: The resource name of the DataScan:
//     projects/{project}/locations/{location_id}/dataScans/{data_scan_id}.
//     where project refers to a project_id or project_number and
//     location_id refers to a GCP region.Only OnDemand data scans are
//     allowed.
func (r *ProjectsLocationsDataScansService) Run(name string, googleclouddataplexv1rundatascanrequest *GoogleCloudDataplexV1RunDataScanRequest) *ProjectsLocationsDataScansRunCall {
	c := &ProjectsLocationsDataScansRunCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddataplexv1rundatascanrequest = googleclouddataplexv1rundatascanrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataScansRunCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataScansRunCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataScansRunCall) Context(ctx context.Context) *ProjectsLocationsDataScansRunCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataScansRunCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataScansRunCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1rundatascanrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:run")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataScans.run" call.
// Exactly one of *GoogleCloudDataplexV1RunDataScanResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDataplexV1RunDataScanResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataScansRunCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1RunDataScanResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1RunDataScanResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Runs an on-demand execution of a DataScan",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataScans/{dataScansId}:run",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.dataScans.run",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the DataScan: projects/{project}/locations/{location_id}/dataScans/{data_scan_id}. where project refers to a project_id or project_number and location_id refers to a GCP region.Only OnDemand data scans are allowed.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataScans/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:run",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1RunDataScanRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1RunDataScanResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataScans.setIamPolicy":

type ProjectsLocationsDataScansSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy.Can return NOT_FOUND,
// INVALID_ARGUMENT, and PERMISSION_DENIED errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsDataScansService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsDataScansSetIamPolicyCall {
	c := &ProjectsLocationsDataScansSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataScansSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataScansSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataScansSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDataScansSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataScansSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataScansSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataScans.setIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataScansSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataScans/{dataScansId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.dataScans.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataScans/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "GoogleIamV1SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataScans.testIamPermissions":

type ProjectsLocationsDataScansTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a NOT_FOUND error.Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsDataScansService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsDataScansTestIamPermissionsCall {
	c := &ProjectsLocationsDataScansTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataScansTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataScansTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataScansTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDataScansTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataScansTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataScansTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataScans.testIamPermissions" call.
// Exactly one of *GoogleIamV1TestIamPermissionsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataScansTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a NOT_FOUND error.Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataScans/{dataScansId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.dataScans.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataScans/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "GoogleIamV1TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataScans.jobs.generateDataQualityRules":

type ProjectsLocationsDataScansJobsGenerateDataQualityRulesCall struct {
	s                                                    *Service
	name                                                 string
	googleclouddataplexv1generatedataqualityrulesrequest *GoogleCloudDataplexV1GenerateDataQualityRulesRequest
	urlParams_                                           gensupport.URLParams
	ctx_                                                 context.Context
	header_                                              http.Header
}

// GenerateDataQualityRules: Generates recommended DataQualityRule from
// a data profiling DataScan.
//
//   - name: The name should be either * the name of a datascan with at
//     least one successful completed data profiling job, or * the name of
//     a successful completed data profiling datascan job.
func (r *ProjectsLocationsDataScansJobsService) GenerateDataQualityRules(name string, googleclouddataplexv1generatedataqualityrulesrequest *GoogleCloudDataplexV1GenerateDataQualityRulesRequest) *ProjectsLocationsDataScansJobsGenerateDataQualityRulesCall {
	c := &ProjectsLocationsDataScansJobsGenerateDataQualityRulesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddataplexv1generatedataqualityrulesrequest = googleclouddataplexv1generatedataqualityrulesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataScansJobsGenerateDataQualityRulesCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataScansJobsGenerateDataQualityRulesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataScansJobsGenerateDataQualityRulesCall) Context(ctx context.Context) *ProjectsLocationsDataScansJobsGenerateDataQualityRulesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataScansJobsGenerateDataQualityRulesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataScansJobsGenerateDataQualityRulesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1generatedataqualityrulesrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:generateDataQualityRules")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataScans.jobs.generateDataQualityRules" call.
// Exactly one of *GoogleCloudDataplexV1GenerateDataQualityRulesResponse
// or error will be non-nil. Any non-2xx status code is an error.
// Response headers are in either
// *GoogleCloudDataplexV1GenerateDataQualityRulesResponse.ServerResponse.
// Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataScansJobsGenerateDataQualityRulesCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1GenerateDataQualityRulesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1GenerateDataQualityRulesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Generates recommended DataQualityRule from a data profiling DataScan.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataScans/{dataScansId}/jobs/{jobsId}:generateDataQualityRules",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.dataScans.jobs.generateDataQualityRules",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name should be either * the name of a datascan with at least one successful completed data profiling job, or * the name of a successful completed data profiling datascan job.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataScans/[^/]+/jobs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:generateDataQualityRules",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1GenerateDataQualityRulesRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1GenerateDataQualityRulesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataScans.jobs.get":

type ProjectsLocationsDataScansJobsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a DataScanJob resource.
//
//   - name: The resource name of the DataScanJob:
//     projects/{project}/locations/{location_id}/dataScans/{data_scan_id}/
//     jobs/{data_scan_job_id} where project refers to a project_id or
//     project_number and location_id refers to a GCP region.
func (r *ProjectsLocationsDataScansJobsService) Get(name string) *ProjectsLocationsDataScansJobsGetCall {
	c := &ProjectsLocationsDataScansJobsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": Select the DataScanJob view
// to return. Defaults to BASIC.
//
// Possible values:
//
//	"DATA_SCAN_JOB_VIEW_UNSPECIFIED" - The API will default to the
//
// BASIC view.
//
//	"BASIC" - Basic view that does not include spec and result.
//	"FULL" - Include everything.
func (c *ProjectsLocationsDataScansJobsGetCall) View(view string) *ProjectsLocationsDataScansJobsGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataScansJobsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataScansJobsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataScansJobsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataScansJobsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataScansJobsGetCall) Context(ctx context.Context) *ProjectsLocationsDataScansJobsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataScansJobsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataScansJobsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataScans.jobs.get" call.
// Exactly one of *GoogleCloudDataplexV1DataScanJob or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudDataplexV1DataScanJob.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataScansJobsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1DataScanJob, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1DataScanJob{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a DataScanJob resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataScans/{dataScansId}/jobs/{jobsId}",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.dataScans.jobs.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the DataScanJob: projects/{project}/locations/{location_id}/dataScans/{data_scan_id}/jobs/{data_scan_job_id} where project refers to a project_id or project_number and location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataScans/[^/]+/jobs/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Optional. Select the DataScanJob view to return. Defaults to BASIC.",
	//       "enum": [
	//         "DATA_SCAN_JOB_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "The API will default to the BASIC view.",
	//         "Basic view that does not include spec and result.",
	//         "Include everything."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1DataScanJob"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataScans.jobs.list":

type ProjectsLocationsDataScansJobsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists DataScanJobs under the given DataScan.
//
//   - parent: The resource name of the parent environment:
//     projects/{project}/locations/{location_id}/dataScans/{data_scan_id}
//     where project refers to a project_id or project_number and
//     location_id refers to a GCP region.
func (r *ProjectsLocationsDataScansJobsService) List(parent string) *ProjectsLocationsDataScansJobsListCall {
	c := &ProjectsLocationsDataScansJobsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression for
// filtering the results of the ListDataScanJobs request.If unspecified,
// all datascan jobs will be returned. Multiple filters can be applied
// (with AND, OR logical operators). Filters are case-sensitive.Allowed
// fields are: start_time end_timestart_time and end_time expect
// RFC-3339 formatted strings (e.g. 2018-10-08T18:30:00-07:00).For
// instance, 'start_time > 2018-10-08T00:00:00.123456789Z AND end_time <
// 2018-10-09T00:00:00.123456789Z' limits results to DataScanJobs
// between specified start and end times.
func (c *ProjectsLocationsDataScansJobsListCall) Filter(filter string) *ProjectsLocationsDataScansJobsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// DataScanJobs to return. The service may return fewer than this value.
// If unspecified, at most 10 DataScanJobs will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsDataScansJobsListCall) PageSize(pageSize int64) *ProjectsLocationsDataScansJobsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token
// received from a previous ListDataScanJobs call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to ListDataScanJobs must match the call that provided the
// page token.
func (c *ProjectsLocationsDataScansJobsListCall) PageToken(pageToken string) *ProjectsLocationsDataScansJobsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataScansJobsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataScansJobsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataScansJobsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataScansJobsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataScansJobsListCall) Context(ctx context.Context) *ProjectsLocationsDataScansJobsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataScansJobsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataScansJobsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/jobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataScans.jobs.list" call.
// Exactly one of *GoogleCloudDataplexV1ListDataScanJobsResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDataplexV1ListDataScanJobsResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataScansJobsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1ListDataScanJobsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1ListDataScanJobsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists DataScanJobs under the given DataScan.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataScans/{dataScansId}/jobs",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.dataScans.jobs.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. An expression for filtering the results of the ListDataScanJobs request.If unspecified, all datascan jobs will be returned. Multiple filters can be applied (with AND, OR logical operators). Filters are case-sensitive.Allowed fields are: start_time end_timestart_time and end_time expect RFC-3339 formatted strings (e.g. 2018-10-08T18:30:00-07:00).For instance, 'start_time \u003e 2018-10-08T00:00:00.123456789Z AND end_time \u003c 2018-10-09T00:00:00.123456789Z' limits results to DataScanJobs between specified start and end times.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. Maximum number of DataScanJobs to return. The service may return fewer than this value. If unspecified, at most 10 DataScanJobs will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. Page token received from a previous ListDataScanJobs call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to ListDataScanJobs must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the parent environment: projects/{project}/locations/{location_id}/dataScans/{data_scan_id} where project refers to a project_id or project_number and location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataScans/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/jobs",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1ListDataScanJobsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDataScansJobsListCall) Pages(ctx context.Context, f func(*GoogleCloudDataplexV1ListDataScanJobsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dataplex.projects.locations.dataTaxonomies.create":

type ProjectsLocationsDataTaxonomiesCreateCall struct {
	s                                 *Service
	parent                            string
	googleclouddataplexv1datataxonomy *GoogleCloudDataplexV1DataTaxonomy
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Create: Create a DataTaxonomy resource.
//
//   - parent: The resource name of the data taxonomy location, of the
//     form: projects/{project_number}/locations/{location_id} where
//     location_id refers to a GCP region.
func (r *ProjectsLocationsDataTaxonomiesService) Create(parent string, googleclouddataplexv1datataxonomy *GoogleCloudDataplexV1DataTaxonomy) *ProjectsLocationsDataTaxonomiesCreateCall {
	c := &ProjectsLocationsDataTaxonomiesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddataplexv1datataxonomy = googleclouddataplexv1datataxonomy
	return c
}

// DataTaxonomyId sets the optional parameter "dataTaxonomyId":
// Required. DataTaxonomy identifier. * Must contain only lowercase
// letters, numbers and hyphens. * Must start with a letter. * Must be
// between 1-63 characters. * Must end with a number or a letter. * Must
// be unique within the Project.
func (c *ProjectsLocationsDataTaxonomiesCreateCall) DataTaxonomyId(dataTaxonomyId string) *ProjectsLocationsDataTaxonomiesCreateCall {
	c.urlParams_.Set("dataTaxonomyId", dataTaxonomyId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsDataTaxonomiesCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsDataTaxonomiesCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataTaxonomiesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataTaxonomiesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataTaxonomiesCreateCall) Context(ctx context.Context) *ProjectsLocationsDataTaxonomiesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataTaxonomiesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataTaxonomiesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1datataxonomy)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dataTaxonomies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataTaxonomies.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataTaxonomiesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Create a DataTaxonomy resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataTaxonomies",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.dataTaxonomies.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "dataTaxonomyId": {
	//       "description": "Required. DataTaxonomy identifier. * Must contain only lowercase letters, numbers and hyphens. * Must start with a letter. * Must be between 1-63 characters. * Must end with a number or a letter. * Must be unique within the Project.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the data taxonomy location, of the form: projects/{project_number}/locations/{location_id} where location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+parent}/dataTaxonomies",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1DataTaxonomy"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataTaxonomies.delete":

type ProjectsLocationsDataTaxonomiesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a DataTaxonomy resource. All attributes within the
// DataTaxonomy must be deleted before the DataTaxonomy can be deleted.
//
//   - name: The resource name of the DataTaxonomy:
//     projects/{project_number}/locations/{location_id}/dataTaxonomies/{da
//     ta_taxonomy_id}.
func (r *ProjectsLocationsDataTaxonomiesService) Delete(name string) *ProjectsLocationsDataTaxonomiesDeleteCall {
	c := &ProjectsLocationsDataTaxonomiesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": If the client provided etag
// value does not match the current etag value,the DeleteDataTaxonomy
// method returns an ABORTED error.
func (c *ProjectsLocationsDataTaxonomiesDeleteCall) Etag(etag string) *ProjectsLocationsDataTaxonomiesDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataTaxonomiesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataTaxonomiesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataTaxonomiesDeleteCall) Context(ctx context.Context) *ProjectsLocationsDataTaxonomiesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataTaxonomiesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataTaxonomiesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataTaxonomies.delete" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataTaxonomiesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a DataTaxonomy resource. All attributes within the DataTaxonomy must be deleted before the DataTaxonomy can be deleted.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataTaxonomies/{dataTaxonomiesId}",
	//   "httpMethod": "DELETE",
	//   "id": "dataplex.projects.locations.dataTaxonomies.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "etag": {
	//       "description": "Optional. If the client provided etag value does not match the current etag value,the DeleteDataTaxonomy method returns an ABORTED error.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. The resource name of the DataTaxonomy: projects/{project_number}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataTaxonomies/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataTaxonomies.get":

type ProjectsLocationsDataTaxonomiesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a DataTaxonomy resource.
//
//   - name: The resource name of the DataTaxonomy:
//     projects/{project_number}/locations/{location_id}/dataTaxonomies/{da
//     ta_taxonomy_id}.
func (r *ProjectsLocationsDataTaxonomiesService) Get(name string) *ProjectsLocationsDataTaxonomiesGetCall {
	c := &ProjectsLocationsDataTaxonomiesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataTaxonomiesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataTaxonomiesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataTaxonomiesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataTaxonomiesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataTaxonomiesGetCall) Context(ctx context.Context) *ProjectsLocationsDataTaxonomiesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataTaxonomiesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataTaxonomiesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataTaxonomies.get" call.
// Exactly one of *GoogleCloudDataplexV1DataTaxonomy or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudDataplexV1DataTaxonomy.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataTaxonomiesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1DataTaxonomy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1DataTaxonomy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a DataTaxonomy resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataTaxonomies/{dataTaxonomiesId}",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.dataTaxonomies.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the DataTaxonomy: projects/{project_number}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataTaxonomies/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1DataTaxonomy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataTaxonomies.getIamPolicy":

type ProjectsLocationsDataTaxonomiesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsDataTaxonomiesService) GetIamPolicy(resource string) *ProjectsLocationsDataTaxonomiesGetIamPolicyCall {
	c := &ProjectsLocationsDataTaxonomiesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy.Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected.Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset.The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1.To learn which
// resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsDataTaxonomiesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsDataTaxonomiesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataTaxonomiesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataTaxonomiesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataTaxonomiesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataTaxonomiesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataTaxonomiesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDataTaxonomiesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataTaxonomiesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataTaxonomiesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataTaxonomies.getIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataTaxonomiesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataTaxonomies/{dataTaxonomiesId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.dataTaxonomies.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy.Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset.The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataTaxonomies/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataTaxonomies.list":

type ProjectsLocationsDataTaxonomiesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists DataTaxonomy resources in a project and location.
//
//   - parent: The resource name of the DataTaxonomy location, of the
//     form: projects/{project_number}/locations/{location_id} where
//     location_id refers to a GCP region.
func (r *ProjectsLocationsDataTaxonomiesService) List(parent string) *ProjectsLocationsDataTaxonomiesListCall {
	c := &ProjectsLocationsDataTaxonomiesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter request.
func (c *ProjectsLocationsDataTaxonomiesListCall) Filter(filter string) *ProjectsLocationsDataTaxonomiesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order by fields for
// the result.
func (c *ProjectsLocationsDataTaxonomiesListCall) OrderBy(orderBy string) *ProjectsLocationsDataTaxonomiesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// DataTaxonomies to return. The service may return fewer than this
// value. If unspecified, at most 10 DataTaxonomies will be returned.
// The maximum value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsDataTaxonomiesListCall) PageSize(pageSize int64) *ProjectsLocationsDataTaxonomiesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token
// received from a previous ListDataTaxonomies call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to ListDataTaxonomies must match the call that provided the
// page token.
func (c *ProjectsLocationsDataTaxonomiesListCall) PageToken(pageToken string) *ProjectsLocationsDataTaxonomiesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataTaxonomiesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataTaxonomiesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataTaxonomiesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataTaxonomiesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataTaxonomiesListCall) Context(ctx context.Context) *ProjectsLocationsDataTaxonomiesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataTaxonomiesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataTaxonomiesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/dataTaxonomies")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataTaxonomies.list" call.
// Exactly one of *GoogleCloudDataplexV1ListDataTaxonomiesResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDataplexV1ListDataTaxonomiesResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in
//
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataTaxonomiesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1ListDataTaxonomiesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1ListDataTaxonomiesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists DataTaxonomy resources in a project and location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataTaxonomies",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.dataTaxonomies.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Filter request.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Optional. Order by fields for the result.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. Maximum number of DataTaxonomies to return. The service may return fewer than this value. If unspecified, at most 10 DataTaxonomies will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. Page token received from a previous ListDataTaxonomies call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to ListDataTaxonomies must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the DataTaxonomy location, of the form: projects/{project_number}/locations/{location_id} where location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/dataTaxonomies",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1ListDataTaxonomiesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDataTaxonomiesListCall) Pages(ctx context.Context, f func(*GoogleCloudDataplexV1ListDataTaxonomiesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dataplex.projects.locations.dataTaxonomies.patch":

type ProjectsLocationsDataTaxonomiesPatchCall struct {
	s                                 *Service
	name                              string
	googleclouddataplexv1datataxonomy *GoogleCloudDataplexV1DataTaxonomy
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Patch: Updates a DataTaxonomy resource.
//
//   - name: Output only. The relative resource name of the DataTaxonomy,
//     of the form:
//     projects/{project_number}/locations/{location_id}/dataTaxonomies/{da
//     ta_taxonomy_id}.
func (r *ProjectsLocationsDataTaxonomiesService) Patch(name string, googleclouddataplexv1datataxonomy *GoogleCloudDataplexV1DataTaxonomy) *ProjectsLocationsDataTaxonomiesPatchCall {
	c := &ProjectsLocationsDataTaxonomiesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddataplexv1datataxonomy = googleclouddataplexv1datataxonomy
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask
// of fields to update.
func (c *ProjectsLocationsDataTaxonomiesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDataTaxonomiesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsDataTaxonomiesPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsDataTaxonomiesPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataTaxonomiesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataTaxonomiesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataTaxonomiesPatchCall) Context(ctx context.Context) *ProjectsLocationsDataTaxonomiesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataTaxonomiesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataTaxonomiesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1datataxonomy)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataTaxonomies.patch" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataTaxonomiesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a DataTaxonomy resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataTaxonomies/{dataTaxonomiesId}",
	//   "httpMethod": "PATCH",
	//   "id": "dataplex.projects.locations.dataTaxonomies.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The relative resource name of the DataTaxonomy, of the form: projects/{project_number}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataTaxonomies/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Mask of fields to update.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1DataTaxonomy"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataTaxonomies.setIamPolicy":

type ProjectsLocationsDataTaxonomiesSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy.Can return NOT_FOUND,
// INVALID_ARGUMENT, and PERMISSION_DENIED errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsDataTaxonomiesService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsDataTaxonomiesSetIamPolicyCall {
	c := &ProjectsLocationsDataTaxonomiesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataTaxonomiesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataTaxonomiesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataTaxonomiesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDataTaxonomiesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataTaxonomiesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataTaxonomiesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataTaxonomies.setIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataTaxonomiesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataTaxonomies/{dataTaxonomiesId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.dataTaxonomies.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataTaxonomies/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "GoogleIamV1SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataTaxonomies.testIamPermissions":

type ProjectsLocationsDataTaxonomiesTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a NOT_FOUND error.Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsDataTaxonomiesService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsDataTaxonomiesTestIamPermissionsCall {
	c := &ProjectsLocationsDataTaxonomiesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataTaxonomiesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataTaxonomiesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataTaxonomiesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDataTaxonomiesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataTaxonomiesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataTaxonomiesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataTaxonomies.testIamPermissions" call.
// Exactly one of *GoogleIamV1TestIamPermissionsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataTaxonomiesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a NOT_FOUND error.Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataTaxonomies/{dataTaxonomiesId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.dataTaxonomies.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataTaxonomies/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "GoogleIamV1TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataTaxonomies.attributes.create":

type ProjectsLocationsDataTaxonomiesAttributesCreateCall struct {
	s                                  *Service
	parent                             string
	googleclouddataplexv1dataattribute *GoogleCloudDataplexV1DataAttribute
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Create: Create a DataAttribute resource.
//
//   - parent: The resource name of the parent data taxonomy
//     projects/{project_number}/locations/{location_id}/dataTaxonomies/{da
//     ta_taxonomy_id}.
func (r *ProjectsLocationsDataTaxonomiesAttributesService) Create(parent string, googleclouddataplexv1dataattribute *GoogleCloudDataplexV1DataAttribute) *ProjectsLocationsDataTaxonomiesAttributesCreateCall {
	c := &ProjectsLocationsDataTaxonomiesAttributesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddataplexv1dataattribute = googleclouddataplexv1dataattribute
	return c
}

// DataAttributeId sets the optional parameter "dataAttributeId":
// Required. DataAttribute identifier. * Must contain only lowercase
// letters, numbers and hyphens. * Must start with a letter. * Must be
// between 1-63 characters. * Must end with a number or a letter. * Must
// be unique within the DataTaxonomy.
func (c *ProjectsLocationsDataTaxonomiesAttributesCreateCall) DataAttributeId(dataAttributeId string) *ProjectsLocationsDataTaxonomiesAttributesCreateCall {
	c.urlParams_.Set("dataAttributeId", dataAttributeId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsDataTaxonomiesAttributesCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsDataTaxonomiesAttributesCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataTaxonomiesAttributesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataTaxonomiesAttributesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataTaxonomiesAttributesCreateCall) Context(ctx context.Context) *ProjectsLocationsDataTaxonomiesAttributesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataTaxonomiesAttributesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataTaxonomiesAttributesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1dataattribute)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/attributes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataTaxonomies.attributes.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataTaxonomiesAttributesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Create a DataAttribute resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataTaxonomies/{dataTaxonomiesId}/attributes",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.dataTaxonomies.attributes.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "dataAttributeId": {
	//       "description": "Required. DataAttribute identifier. * Must contain only lowercase letters, numbers and hyphens. * Must start with a letter. * Must be between 1-63 characters. * Must end with a number or a letter. * Must be unique within the DataTaxonomy.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the parent data taxonomy projects/{project_number}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataTaxonomies/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+parent}/attributes",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1DataAttribute"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataTaxonomies.attributes.delete":

type ProjectsLocationsDataTaxonomiesAttributesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Data Attribute resource.
//
//   - name: The resource name of the DataAttribute:
//     projects/{project_number}/locations/{location_id}/dataTaxonomies/{da
//     taTaxonomy}/attributes/{data_attribute_id}.
func (r *ProjectsLocationsDataTaxonomiesAttributesService) Delete(name string) *ProjectsLocationsDataTaxonomiesAttributesDeleteCall {
	c := &ProjectsLocationsDataTaxonomiesAttributesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": If the client provided etag
// value does not match the current etag value, the DeleteDataAttribute
// method returns an ABORTED error response.
func (c *ProjectsLocationsDataTaxonomiesAttributesDeleteCall) Etag(etag string) *ProjectsLocationsDataTaxonomiesAttributesDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataTaxonomiesAttributesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataTaxonomiesAttributesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataTaxonomiesAttributesDeleteCall) Context(ctx context.Context) *ProjectsLocationsDataTaxonomiesAttributesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataTaxonomiesAttributesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataTaxonomiesAttributesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataTaxonomies.attributes.delete" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataTaxonomiesAttributesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a Data Attribute resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataTaxonomies/{dataTaxonomiesId}/attributes/{attributesId}",
	//   "httpMethod": "DELETE",
	//   "id": "dataplex.projects.locations.dataTaxonomies.attributes.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "etag": {
	//       "description": "Optional. If the client provided etag value does not match the current etag value, the DeleteDataAttribute method returns an ABORTED error response.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. The resource name of the DataAttribute: projects/{project_number}/locations/{location_id}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataTaxonomies/[^/]+/attributes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataTaxonomies.attributes.get":

type ProjectsLocationsDataTaxonomiesAttributesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a Data Attribute resource.
//
//   - name: The resource name of the dataAttribute:
//     projects/{project_number}/locations/{location_id}/dataTaxonomies/{da
//     taTaxonomy}/attributes/{data_attribute_id}.
func (r *ProjectsLocationsDataTaxonomiesAttributesService) Get(name string) *ProjectsLocationsDataTaxonomiesAttributesGetCall {
	c := &ProjectsLocationsDataTaxonomiesAttributesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataTaxonomiesAttributesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataTaxonomiesAttributesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataTaxonomiesAttributesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataTaxonomiesAttributesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataTaxonomiesAttributesGetCall) Context(ctx context.Context) *ProjectsLocationsDataTaxonomiesAttributesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataTaxonomiesAttributesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataTaxonomiesAttributesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataTaxonomies.attributes.get" call.
// Exactly one of *GoogleCloudDataplexV1DataAttribute or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudDataplexV1DataAttribute.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataTaxonomiesAttributesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1DataAttribute, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1DataAttribute{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a Data Attribute resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataTaxonomies/{dataTaxonomiesId}/attributes/{attributesId}",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.dataTaxonomies.attributes.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the dataAttribute: projects/{project_number}/locations/{location_id}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataTaxonomies/[^/]+/attributes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1DataAttribute"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataTaxonomies.attributes.getIamPolicy":

type ProjectsLocationsDataTaxonomiesAttributesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsDataTaxonomiesAttributesService) GetIamPolicy(resource string) *ProjectsLocationsDataTaxonomiesAttributesGetIamPolicyCall {
	c := &ProjectsLocationsDataTaxonomiesAttributesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy.Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected.Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset.The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1.To learn which
// resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsDataTaxonomiesAttributesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsDataTaxonomiesAttributesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataTaxonomiesAttributesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataTaxonomiesAttributesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataTaxonomiesAttributesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataTaxonomiesAttributesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataTaxonomiesAttributesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDataTaxonomiesAttributesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataTaxonomiesAttributesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataTaxonomiesAttributesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataTaxonomies.attributes.getIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataTaxonomiesAttributesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataTaxonomies/{dataTaxonomiesId}/attributes/{attributesId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.dataTaxonomies.attributes.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy.Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset.The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataTaxonomies/[^/]+/attributes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataTaxonomies.attributes.list":

type ProjectsLocationsDataTaxonomiesAttributesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Data Attribute resources in a DataTaxonomy.
//
//   - parent: The resource name of the DataTaxonomy:
//     projects/{project_number}/locations/{location_id}/dataTaxonomies/{da
//     ta_taxonomy_id}.
func (r *ProjectsLocationsDataTaxonomiesAttributesService) List(parent string) *ProjectsLocationsDataTaxonomiesAttributesListCall {
	c := &ProjectsLocationsDataTaxonomiesAttributesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter request.
func (c *ProjectsLocationsDataTaxonomiesAttributesListCall) Filter(filter string) *ProjectsLocationsDataTaxonomiesAttributesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order by fields for
// the result.
func (c *ProjectsLocationsDataTaxonomiesAttributesListCall) OrderBy(orderBy string) *ProjectsLocationsDataTaxonomiesAttributesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// DataAttributes to return. The service may return fewer than this
// value. If unspecified, at most 10 dataAttributes will be returned.
// The maximum value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsDataTaxonomiesAttributesListCall) PageSize(pageSize int64) *ProjectsLocationsDataTaxonomiesAttributesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token
// received from a previous ListDataAttributes call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to ListDataAttributes must match the call that provided the
// page token.
func (c *ProjectsLocationsDataTaxonomiesAttributesListCall) PageToken(pageToken string) *ProjectsLocationsDataTaxonomiesAttributesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataTaxonomiesAttributesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataTaxonomiesAttributesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsDataTaxonomiesAttributesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDataTaxonomiesAttributesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataTaxonomiesAttributesListCall) Context(ctx context.Context) *ProjectsLocationsDataTaxonomiesAttributesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataTaxonomiesAttributesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataTaxonomiesAttributesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/attributes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataTaxonomies.attributes.list" call.
// Exactly one of *GoogleCloudDataplexV1ListDataAttributesResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDataplexV1ListDataAttributesResponse.ServerResponse.Header
//
//	or (if a response was returned at all) in
//
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsDataTaxonomiesAttributesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1ListDataAttributesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1ListDataAttributesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists Data Attribute resources in a DataTaxonomy.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataTaxonomies/{dataTaxonomiesId}/attributes",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.dataTaxonomies.attributes.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Filter request.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Optional. Order by fields for the result.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. Maximum number of DataAttributes to return. The service may return fewer than this value. If unspecified, at most 10 dataAttributes will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. Page token received from a previous ListDataAttributes call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to ListDataAttributes must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the DataTaxonomy: projects/{project_number}/locations/{location_id}/dataTaxonomies/{data_taxonomy_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataTaxonomies/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/attributes",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1ListDataAttributesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsDataTaxonomiesAttributesListCall) Pages(ctx context.Context, f func(*GoogleCloudDataplexV1ListDataAttributesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dataplex.projects.locations.dataTaxonomies.attributes.patch":

type ProjectsLocationsDataTaxonomiesAttributesPatchCall struct {
	s                                  *Service
	name                               string
	googleclouddataplexv1dataattribute *GoogleCloudDataplexV1DataAttribute
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Patch: Updates a DataAttribute resource.
//
//   - name: Output only. The relative resource name of the dataAttribute,
//     of the form:
//     projects/{project_number}/locations/{location_id}/dataTaxonomies/{da
//     taTaxonomy}/attributes/{data_attribute_id}.
func (r *ProjectsLocationsDataTaxonomiesAttributesService) Patch(name string, googleclouddataplexv1dataattribute *GoogleCloudDataplexV1DataAttribute) *ProjectsLocationsDataTaxonomiesAttributesPatchCall {
	c := &ProjectsLocationsDataTaxonomiesAttributesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddataplexv1dataattribute = googleclouddataplexv1dataattribute
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask
// of fields to update.
func (c *ProjectsLocationsDataTaxonomiesAttributesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsDataTaxonomiesAttributesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsDataTaxonomiesAttributesPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsDataTaxonomiesAttributesPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataTaxonomiesAttributesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataTaxonomiesAttributesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataTaxonomiesAttributesPatchCall) Context(ctx context.Context) *ProjectsLocationsDataTaxonomiesAttributesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataTaxonomiesAttributesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataTaxonomiesAttributesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1dataattribute)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataTaxonomies.attributes.patch" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataTaxonomiesAttributesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a DataAttribute resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataTaxonomies/{dataTaxonomiesId}/attributes/{attributesId}",
	//   "httpMethod": "PATCH",
	//   "id": "dataplex.projects.locations.dataTaxonomies.attributes.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The relative resource name of the dataAttribute, of the form: projects/{project_number}/locations/{location_id}/dataTaxonomies/{dataTaxonomy}/attributes/{data_attribute_id}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataTaxonomies/[^/]+/attributes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Mask of fields to update.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1DataAttribute"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataTaxonomies.attributes.setIamPolicy":

type ProjectsLocationsDataTaxonomiesAttributesSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy.Can return NOT_FOUND,
// INVALID_ARGUMENT, and PERMISSION_DENIED errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsDataTaxonomiesAttributesService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsDataTaxonomiesAttributesSetIamPolicyCall {
	c := &ProjectsLocationsDataTaxonomiesAttributesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataTaxonomiesAttributesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataTaxonomiesAttributesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataTaxonomiesAttributesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsDataTaxonomiesAttributesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataTaxonomiesAttributesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataTaxonomiesAttributesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataTaxonomies.attributes.setIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataTaxonomiesAttributesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataTaxonomies/{dataTaxonomiesId}/attributes/{attributesId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.dataTaxonomies.attributes.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataTaxonomies/[^/]+/attributes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "GoogleIamV1SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.dataTaxonomies.attributes.testIamPermissions":

type ProjectsLocationsDataTaxonomiesAttributesTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a NOT_FOUND error.Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsDataTaxonomiesAttributesService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsDataTaxonomiesAttributesTestIamPermissionsCall {
	c := &ProjectsLocationsDataTaxonomiesAttributesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsDataTaxonomiesAttributesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsDataTaxonomiesAttributesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsDataTaxonomiesAttributesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsDataTaxonomiesAttributesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsDataTaxonomiesAttributesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDataTaxonomiesAttributesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.dataTaxonomies.attributes.testIamPermissions" call.
// Exactly one of *GoogleIamV1TestIamPermissionsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsDataTaxonomiesAttributesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a NOT_FOUND error.Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/dataTaxonomies/{dataTaxonomiesId}/attributes/{attributesId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.dataTaxonomies.attributes.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/dataTaxonomies/[^/]+/attributes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "GoogleIamV1TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryGroups.create":

type ProjectsLocationsEntryGroupsCreateCall struct {
	s                               *Service
	parent                          string
	googleclouddataplexv1entrygroup *GoogleCloudDataplexV1EntryGroup
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Create: Creates an EntryGroup
//
//   - parent: The resource name of the entryGroup, of the form:
//     projects/{project_number}/locations/{location_id} where location_id
//     refers to a GCP region.
func (r *ProjectsLocationsEntryGroupsService) Create(parent string, googleclouddataplexv1entrygroup *GoogleCloudDataplexV1EntryGroup) *ProjectsLocationsEntryGroupsCreateCall {
	c := &ProjectsLocationsEntryGroupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddataplexv1entrygroup = googleclouddataplexv1entrygroup
	return c
}

// EntryGroupId sets the optional parameter "entryGroupId": Required.
// EntryGroup identifier.
func (c *ProjectsLocationsEntryGroupsCreateCall) EntryGroupId(entryGroupId string) *ProjectsLocationsEntryGroupsCreateCall {
	c.urlParams_.Set("entryGroupId", entryGroupId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsEntryGroupsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsEntryGroupsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryGroupsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryGroupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryGroupsCreateCall) Context(ctx context.Context) *ProjectsLocationsEntryGroupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryGroupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryGroupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1entrygroup)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/entryGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryGroups.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryGroupsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an EntryGroup",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryGroups",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.entryGroups.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "entryGroupId": {
	//       "description": "Required. EntryGroup identifier.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the entryGroup, of the form: projects/{project_number}/locations/{location_id} where location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+parent}/entryGroups",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1EntryGroup"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryGroups.delete":

type ProjectsLocationsEntryGroupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a EntryGroup resource.
//
//   - name: The resource name of the EntryGroup:
//     projects/{project_number}/locations/{location_id}/entryGroups/{entry
//     _group_id}.
func (r *ProjectsLocationsEntryGroupsService) Delete(name string) *ProjectsLocationsEntryGroupsDeleteCall {
	c := &ProjectsLocationsEntryGroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": If the client provided etag
// value does not match the current etag value, the
// DeleteEntryGroupRequest method returns an ABORTED error response
func (c *ProjectsLocationsEntryGroupsDeleteCall) Etag(etag string) *ProjectsLocationsEntryGroupsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryGroupsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryGroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryGroupsDeleteCall) Context(ctx context.Context) *ProjectsLocationsEntryGroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryGroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryGroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryGroups.delete" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryGroupsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a EntryGroup resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}",
	//   "httpMethod": "DELETE",
	//   "id": "dataplex.projects.locations.entryGroups.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "etag": {
	//       "description": "Optional. If the client provided etag value does not match the current etag value, the DeleteEntryGroupRequest method returns an ABORTED error response",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. The resource name of the EntryGroup: projects/{project_number}/locations/{location_id}/entryGroups/{entry_group_id}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryGroups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryGroups.get":

type ProjectsLocationsEntryGroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a EntryGroup resource.
//
//   - name: The resource name of the EntryGroup:
//     projects/{project_number}/locations/{location_id}/entryGroups/{entry
//     _group_id}.
func (r *ProjectsLocationsEntryGroupsService) Get(name string) *ProjectsLocationsEntryGroupsGetCall {
	c := &ProjectsLocationsEntryGroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryGroupsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryGroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsEntryGroupsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsEntryGroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryGroupsGetCall) Context(ctx context.Context) *ProjectsLocationsEntryGroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryGroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryGroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryGroups.get" call.
// Exactly one of *GoogleCloudDataplexV1EntryGroup or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudDataplexV1EntryGroup.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryGroupsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1EntryGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1EntryGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a EntryGroup resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.entryGroups.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the EntryGroup: projects/{project_number}/locations/{location_id}/entryGroups/{entry_group_id}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryGroups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1EntryGroup"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryGroups.getIamPolicy":

type ProjectsLocationsEntryGroupsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsEntryGroupsService) GetIamPolicy(resource string) *ProjectsLocationsEntryGroupsGetIamPolicyCall {
	c := &ProjectsLocationsEntryGroupsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy.Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected.Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset.The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1.To learn which
// resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsEntryGroupsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsEntryGroupsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryGroupsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryGroupsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsEntryGroupsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsEntryGroupsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryGroupsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsEntryGroupsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryGroupsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryGroupsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryGroups.getIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryGroupsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.entryGroups.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy.Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset.The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryGroups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryGroups.list":

type ProjectsLocationsEntryGroupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists EntryGroup resources in a project and location.
//
//   - parent: The resource name of the entryGroup location, of the form:
//     projects/{project_number}/locations/{location_id} where location_id
//     refers to a GCP region.
func (r *ProjectsLocationsEntryGroupsService) List(parent string) *ProjectsLocationsEntryGroupsListCall {
	c := &ProjectsLocationsEntryGroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter request.
func (c *ProjectsLocationsEntryGroupsListCall) Filter(filter string) *ProjectsLocationsEntryGroupsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order by fields for
// the result.
func (c *ProjectsLocationsEntryGroupsListCall) OrderBy(orderBy string) *ProjectsLocationsEntryGroupsListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// EntryGroups to return. The service may return fewer than this value.
// If unspecified, at most 10 EntryGroups will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsEntryGroupsListCall) PageSize(pageSize int64) *ProjectsLocationsEntryGroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token
// received from a previous ListEntryGroups call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to ListEntryGroups must match the call that provided the
// page token.
func (c *ProjectsLocationsEntryGroupsListCall) PageToken(pageToken string) *ProjectsLocationsEntryGroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryGroupsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryGroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsEntryGroupsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsEntryGroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryGroupsListCall) Context(ctx context.Context) *ProjectsLocationsEntryGroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryGroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryGroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/entryGroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryGroups.list" call.
// Exactly one of *GoogleCloudDataplexV1ListEntryGroupsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDataplexV1ListEntryGroupsResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsEntryGroupsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1ListEntryGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1ListEntryGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists EntryGroup resources in a project and location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryGroups",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.entryGroups.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Filter request.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Optional. Order by fields for the result.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. Maximum number of EntryGroups to return. The service may return fewer than this value. If unspecified, at most 10 EntryGroups will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. Page token received from a previous ListEntryGroups call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to ListEntryGroups must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the entryGroup location, of the form: projects/{project_number}/locations/{location_id} where location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/entryGroups",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1ListEntryGroupsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsEntryGroupsListCall) Pages(ctx context.Context, f func(*GoogleCloudDataplexV1ListEntryGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dataplex.projects.locations.entryGroups.patch":

type ProjectsLocationsEntryGroupsPatchCall struct {
	s                               *Service
	name                            string
	googleclouddataplexv1entrygroup *GoogleCloudDataplexV1EntryGroup
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Patch: Updates a EntryGroup resource.
//
//   - name: Output only. The relative resource name of the EntryGroup, of
//     the form:
//     projects/{project_number}/locations/{location_id}/entryGroups/{entry
//     _group_id}.
func (r *ProjectsLocationsEntryGroupsService) Patch(name string, googleclouddataplexv1entrygroup *GoogleCloudDataplexV1EntryGroup) *ProjectsLocationsEntryGroupsPatchCall {
	c := &ProjectsLocationsEntryGroupsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddataplexv1entrygroup = googleclouddataplexv1entrygroup
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask
// of fields to update.
func (c *ProjectsLocationsEntryGroupsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsEntryGroupsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsEntryGroupsPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsEntryGroupsPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryGroupsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryGroupsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryGroupsPatchCall) Context(ctx context.Context) *ProjectsLocationsEntryGroupsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryGroupsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryGroupsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1entrygroup)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryGroups.patch" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryGroupsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a EntryGroup resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}",
	//   "httpMethod": "PATCH",
	//   "id": "dataplex.projects.locations.entryGroups.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The relative resource name of the EntryGroup, of the form: projects/{project_number}/locations/{location_id}/entryGroups/{entry_group_id}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryGroups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Mask of fields to update.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1EntryGroup"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryGroups.setIamPolicy":

type ProjectsLocationsEntryGroupsSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy.Can return NOT_FOUND,
// INVALID_ARGUMENT, and PERMISSION_DENIED errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsEntryGroupsService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsEntryGroupsSetIamPolicyCall {
	c := &ProjectsLocationsEntryGroupsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryGroupsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryGroupsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryGroupsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsEntryGroupsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryGroupsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryGroupsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryGroups.setIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryGroupsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.entryGroups.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryGroups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "GoogleIamV1SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryGroups.testIamPermissions":

type ProjectsLocationsEntryGroupsTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a NOT_FOUND error.Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsEntryGroupsService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsEntryGroupsTestIamPermissionsCall {
	c := &ProjectsLocationsEntryGroupsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryGroupsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryGroupsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryGroupsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsEntryGroupsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryGroupsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryGroupsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryGroups.testIamPermissions" call.
// Exactly one of *GoogleIamV1TestIamPermissionsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryGroupsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a NOT_FOUND error.Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.entryGroups.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryGroups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "GoogleIamV1TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryGroups.entries.create":

type ProjectsLocationsEntryGroupsEntriesCreateCall struct {
	s                          *Service
	parent                     string
	googleclouddataplexv1entry *GoogleCloudDataplexV1Entry
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Create: Creates an Entry.
//
//   - parent: The resource name of the parent Entry Group:
//     projects/{project}/locations/{location}/entryGroups/{entry_group}.
func (r *ProjectsLocationsEntryGroupsEntriesService) Create(parent string, googleclouddataplexv1entry *GoogleCloudDataplexV1Entry) *ProjectsLocationsEntryGroupsEntriesCreateCall {
	c := &ProjectsLocationsEntryGroupsEntriesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddataplexv1entry = googleclouddataplexv1entry
	return c
}

// EntryId sets the optional parameter "entryId": Required. Entry
// identifier. It has to be unique within an Entry Group.Entries
// corresponding to Google Cloud resources use Entry ID format based on
// Full Resource Names
// (https://cloud.google.com/apis/design/resource_names#full_resource_name).
// The format is a Full Resource Name of the resource without the prefix
// double slashes in the API Service Name part of Full Resource Name.
// This allows retrieval of entries using their associated resource
// name.For example if the Full Resource Name of a resource is
// //library.googleapis.com/shelves/shelf1/books/book2, then the
// suggested entry_id is
// library.googleapis.com/shelves/shelf1/books/book2.It is also
// suggested to follow the same convention for entries corresponding to
// resources from other providers or systems than Google Cloud.The
// maximum size of the field is 4000 characters.
func (c *ProjectsLocationsEntryGroupsEntriesCreateCall) EntryId(entryId string) *ProjectsLocationsEntryGroupsEntriesCreateCall {
	c.urlParams_.Set("entryId", entryId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryGroupsEntriesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryGroupsEntriesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryGroupsEntriesCreateCall) Context(ctx context.Context) *ProjectsLocationsEntryGroupsEntriesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryGroupsEntriesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryGroupsEntriesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1entry)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/entries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryGroups.entries.create" call.
// Exactly one of *GoogleCloudDataplexV1Entry or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDataplexV1Entry.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryGroupsEntriesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1Entry, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1Entry{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an Entry.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.entryGroups.entries.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "entryId": {
	//       "description": "Required. Entry identifier. It has to be unique within an Entry Group.Entries corresponding to Google Cloud resources use Entry ID format based on Full Resource Names (https://cloud.google.com/apis/design/resource_names#full_resource_name). The format is a Full Resource Name of the resource without the prefix double slashes in the API Service Name part of Full Resource Name. This allows retrieval of entries using their associated resource name.For example if the Full Resource Name of a resource is //library.googleapis.com/shelves/shelf1/books/book2, then the suggested entry_id is library.googleapis.com/shelves/shelf1/books/book2.It is also suggested to follow the same convention for entries corresponding to resources from other providers or systems than Google Cloud.The maximum size of the field is 4000 characters.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the parent Entry Group: projects/{project}/locations/{location}/entryGroups/{entry_group}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryGroups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/entries",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1Entry"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1Entry"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryGroups.entries.delete":

type ProjectsLocationsEntryGroupsEntriesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an Entry.
//
//   - name: The resource name of the Entry:
//     projects/{project}/locations/{location}/entryGroups/{entry_group}/en
//     tries/{entry}.
func (r *ProjectsLocationsEntryGroupsEntriesService) Delete(name string) *ProjectsLocationsEntryGroupsEntriesDeleteCall {
	c := &ProjectsLocationsEntryGroupsEntriesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryGroupsEntriesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryGroupsEntriesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryGroupsEntriesDeleteCall) Context(ctx context.Context) *ProjectsLocationsEntryGroupsEntriesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryGroupsEntriesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryGroupsEntriesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryGroups.entries.delete" call.
// Exactly one of *GoogleCloudDataplexV1Entry or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDataplexV1Entry.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryGroupsEntriesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1Entry, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1Entry{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an Entry.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}",
	//   "httpMethod": "DELETE",
	//   "id": "dataplex.projects.locations.entryGroups.entries.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the Entry: projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryGroups/[^/]+/entries/.*$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1Entry"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryGroups.entries.get":

type ProjectsLocationsEntryGroupsEntriesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets a single entry.
//
//   - name: The resource name of the Entry:
//     projects/{project}/locations/{location}/entryGroups/{entry_group}/en
//     tries/{entry}.
func (r *ProjectsLocationsEntryGroupsEntriesService) Get(name string) *ProjectsLocationsEntryGroupsEntriesGetCall {
	c := &ProjectsLocationsEntryGroupsEntriesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// AspectTypes sets the optional parameter "aspectTypes": Limits the
// aspects returned to the provided aspect types. Only works if the
// CUSTOM view is selected.
func (c *ProjectsLocationsEntryGroupsEntriesGetCall) AspectTypes(aspectTypes ...string) *ProjectsLocationsEntryGroupsEntriesGetCall {
	c.urlParams_.SetMulti("aspectTypes", append([]string{}, aspectTypes...))
	return c
}

// Paths sets the optional parameter "paths": Limits the aspects
// returned to those associated with the provided paths within the
// Entry. Only works if the CUSTOM view is selected.
func (c *ProjectsLocationsEntryGroupsEntriesGetCall) Paths(paths ...string) *ProjectsLocationsEntryGroupsEntriesGetCall {
	c.urlParams_.SetMulti("paths", append([]string{}, paths...))
	return c
}

// View sets the optional parameter "view": View for controlling which
// parts of an entry are to be returned.
//
// Possible values:
//
//	"ENTRY_VIEW_UNSPECIFIED" - Unspecified EntryView. Defaults to FULL.
//	"BASIC" - Returns entry only, without aspects.
//	"FULL" - Returns all required aspects as well as the keys of all
//
// non-required aspects.
//
//	"CUSTOM" - Returns aspects matching custom fields in
//
// GetEntryRequest. If the number of aspects would exceed 100, the first
// 100 will be returned.
//
//	"ALL" - Returns all aspects. If the number of aspects would exceed
//
// 100, the first 100 will be returned.
func (c *ProjectsLocationsEntryGroupsEntriesGetCall) View(view string) *ProjectsLocationsEntryGroupsEntriesGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryGroupsEntriesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryGroupsEntriesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsEntryGroupsEntriesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsEntryGroupsEntriesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryGroupsEntriesGetCall) Context(ctx context.Context) *ProjectsLocationsEntryGroupsEntriesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryGroupsEntriesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryGroupsEntriesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryGroups.entries.get" call.
// Exactly one of *GoogleCloudDataplexV1Entry or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDataplexV1Entry.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryGroupsEntriesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1Entry, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1Entry{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets a single entry.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.entryGroups.entries.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "aspectTypes": {
	//       "description": "Optional. Limits the aspects returned to the provided aspect types. Only works if the CUSTOM view is selected.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. The resource name of the Entry: projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryGroups/[^/]+/entries/.*$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "paths": {
	//       "description": "Optional. Limits the aspects returned to those associated with the provided paths within the Entry. Only works if the CUSTOM view is selected.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Optional. View for controlling which parts of an entry are to be returned.",
	//       "enum": [
	//         "ENTRY_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL",
	//         "CUSTOM",
	//         "ALL"
	//       ],
	//       "enumDescriptions": [
	//         "Unspecified EntryView. Defaults to FULL.",
	//         "Returns entry only, without aspects.",
	//         "Returns all required aspects as well as the keys of all non-required aspects.",
	//         "Returns aspects matching custom fields in GetEntryRequest. If the number of aspects would exceed 100, the first 100 will be returned.",
	//         "Returns all aspects. If the number of aspects would exceed 100, the first 100 will be returned."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1Entry"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryGroups.entries.list":

type ProjectsLocationsEntryGroupsEntriesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists entries within an entry group.
//
//   - parent: The resource name of the parent Entry Group:
//     projects/{project}/locations/{location}/entryGroups/{entry_group}.
func (r *ProjectsLocationsEntryGroupsEntriesService) List(parent string) *ProjectsLocationsEntryGroupsEntriesListCall {
	c := &ProjectsLocationsEntryGroupsEntriesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": A filter on the entries
// to return. Filters are case-sensitive. The request can be filtered by
// the following fields: entry_type, display_name. The comparison
// operators are =, !=, <, >, <=, >= (strings are compared according to
// lexical order) The logical operators AND, OR, NOT can be used in the
// filter. Example filter expressions:
// "display_name=AnExampleDisplayName"
// "entry_type=projects/example-project/locations/global/entryTypes/examp
// le-entry_type" "entry_type=projects/a* OR "entry_type=projects/k*"
// "NOT display_name=AnotherExampleDisplayName"
func (c *ProjectsLocationsEntryGroupsEntriesListCall) Filter(filter string) *ProjectsLocationsEntryGroupsEntriesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize":
func (c *ProjectsLocationsEntryGroupsEntriesListCall) PageSize(pageSize int64) *ProjectsLocationsEntryGroupsEntriesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The pagination
// token returned by a previous request.
func (c *ProjectsLocationsEntryGroupsEntriesListCall) PageToken(pageToken string) *ProjectsLocationsEntryGroupsEntriesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryGroupsEntriesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryGroupsEntriesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsEntryGroupsEntriesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsEntryGroupsEntriesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryGroupsEntriesListCall) Context(ctx context.Context) *ProjectsLocationsEntryGroupsEntriesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryGroupsEntriesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryGroupsEntriesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/entries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryGroups.entries.list" call.
// Exactly one of *GoogleCloudDataplexV1ListEntriesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDataplexV1ListEntriesResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsEntryGroupsEntriesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1ListEntriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1ListEntriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists entries within an entry group.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.entryGroups.entries.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. A filter on the entries to return. Filters are case-sensitive. The request can be filtered by the following fields: entry_type, display_name. The comparison operators are =, !=, \u003c, \u003e, \u003c=, \u003e= (strings are compared according to lexical order) The logical operators AND, OR, NOT can be used in the filter. Example filter expressions: \"display_name=AnExampleDisplayName\" \"entry_type=projects/example-project/locations/global/entryTypes/example-entry_type\" \"entry_type=projects/a* OR \"entry_type=projects/k*\" \"NOT display_name=AnotherExampleDisplayName\"",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. The pagination token returned by a previous request.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the parent Entry Group: projects/{project}/locations/{location}/entryGroups/{entry_group}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryGroups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/entries",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1ListEntriesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsEntryGroupsEntriesListCall) Pages(ctx context.Context, f func(*GoogleCloudDataplexV1ListEntriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dataplex.projects.locations.entryGroups.entries.patch":

type ProjectsLocationsEntryGroupsEntriesPatchCall struct {
	s                          *Service
	name                       string
	googleclouddataplexv1entry *GoogleCloudDataplexV1Entry
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Patch: Updates an Entry.
//
//   - name: Identifier. The relative resource name of the Entry, of the
//     form:
//     projects/{project}/locations/{location}/entryGroups/{entry_group}/en
//     tries/{entry}.
func (r *ProjectsLocationsEntryGroupsEntriesService) Patch(name string, googleclouddataplexv1entry *GoogleCloudDataplexV1Entry) *ProjectsLocationsEntryGroupsEntriesPatchCall {
	c := &ProjectsLocationsEntryGroupsEntriesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddataplexv1entry = googleclouddataplexv1entry
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to
// true and the entry does not exist, it will be created.
func (c *ProjectsLocationsEntryGroupsEntriesPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsEntryGroupsEntriesPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// AspectKeys sets the optional parameter "aspectKeys": The map keys of
// the Aspects which should be modified. Supports the following
// syntaxes: * - matches aspect on given type and empty path * @path -
// matches aspect on given type and specified path * * - matches aspects
// on given type for all paths * *@path - matches aspects of all types
// on the given pathExisting aspects matching the syntax will not be
// removed unless delete_missing_aspects is set to true.If this field is
// left empty, it will be treated as specifying exactly those Aspects
// present in the request.
func (c *ProjectsLocationsEntryGroupsEntriesPatchCall) AspectKeys(aspectKeys ...string) *ProjectsLocationsEntryGroupsEntriesPatchCall {
	c.urlParams_.SetMulti("aspectKeys", append([]string{}, aspectKeys...))
	return c
}

// DeleteMissingAspects sets the optional parameter
// "deleteMissingAspects": If set to true and the aspect_keys specify
// aspect ranges, any existing aspects from that range not provided in
// the request will be deleted.
func (c *ProjectsLocationsEntryGroupsEntriesPatchCall) DeleteMissingAspects(deleteMissingAspects bool) *ProjectsLocationsEntryGroupsEntriesPatchCall {
	c.urlParams_.Set("deleteMissingAspects", fmt.Sprint(deleteMissingAspects))
	return c
}

// UpdateMask sets the optional parameter "updateMask": Mask of fields
// to update. To update Aspects, the update_mask must contain the value
// "aspects".If the update_mask is empty, all modifiable fields present
// in the request will be updated.
func (c *ProjectsLocationsEntryGroupsEntriesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsEntryGroupsEntriesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryGroupsEntriesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryGroupsEntriesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryGroupsEntriesPatchCall) Context(ctx context.Context) *ProjectsLocationsEntryGroupsEntriesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryGroupsEntriesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryGroupsEntriesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1entry)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryGroups.entries.patch" call.
// Exactly one of *GoogleCloudDataplexV1Entry or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDataplexV1Entry.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryGroupsEntriesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1Entry, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1Entry{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an Entry.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryGroups/{entryGroupsId}/entries/{entriesId}",
	//   "httpMethod": "PATCH",
	//   "id": "dataplex.projects.locations.entryGroups.entries.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "allowMissing": {
	//       "description": "Optional. If set to true and the entry does not exist, it will be created.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "aspectKeys": {
	//       "description": "Optional. The map keys of the Aspects which should be modified. Supports the following syntaxes: * - matches aspect on given type and empty path * @path - matches aspect on given type and specified path * * - matches aspects on given type for all paths * *@path - matches aspects of all types on the given pathExisting aspects matching the syntax will not be removed unless delete_missing_aspects is set to true.If this field is left empty, it will be treated as specifying exactly those Aspects present in the request.",
	//       "location": "query",
	//       "repeated": true,
	//       "type": "string"
	//     },
	//     "deleteMissingAspects": {
	//       "description": "Optional. If set to true and the aspect_keys specify aspect ranges, any existing aspects from that range not provided in the request will be deleted.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "name": {
	//       "description": "Identifier. The relative resource name of the Entry, of the form: projects/{project}/locations/{location}/entryGroups/{entry_group}/entries/{entry}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryGroups/[^/]+/entries/.*$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Optional. Mask of fields to update. To update Aspects, the update_mask must contain the value \"aspects\".If the update_mask is empty, all modifiable fields present in the request will be updated.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1Entry"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1Entry"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryTypes.create":

type ProjectsLocationsEntryTypesCreateCall struct {
	s                              *Service
	parent                         string
	googleclouddataplexv1entrytype *GoogleCloudDataplexV1EntryType
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Create: Creates an EntryType
//
//   - parent: The resource name of the EntryType, of the form:
//     projects/{project_number}/locations/{location_id} where location_id
//     refers to a GCP region.
func (r *ProjectsLocationsEntryTypesService) Create(parent string, googleclouddataplexv1entrytype *GoogleCloudDataplexV1EntryType) *ProjectsLocationsEntryTypesCreateCall {
	c := &ProjectsLocationsEntryTypesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddataplexv1entrytype = googleclouddataplexv1entrytype
	return c
}

// EntryTypeId sets the optional parameter "entryTypeId": Required.
// EntryType identifier.
func (c *ProjectsLocationsEntryTypesCreateCall) EntryTypeId(entryTypeId string) *ProjectsLocationsEntryTypesCreateCall {
	c.urlParams_.Set("entryTypeId", entryTypeId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsEntryTypesCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsEntryTypesCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryTypesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryTypesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryTypesCreateCall) Context(ctx context.Context) *ProjectsLocationsEntryTypesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryTypesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryTypesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1entrytype)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/entryTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryTypes.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryTypesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an EntryType",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryTypes",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.entryTypes.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "entryTypeId": {
	//       "description": "Required. EntryType identifier.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the EntryType, of the form: projects/{project_number}/locations/{location_id} where location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+parent}/entryTypes",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1EntryType"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryTypes.delete":

type ProjectsLocationsEntryTypesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a EntryType resource.
//
//   - name: The resource name of the EntryType:
//     projects/{project_number}/locations/{location_id}/entryTypes/{entry_
//     type_id}.
func (r *ProjectsLocationsEntryTypesService) Delete(name string) *ProjectsLocationsEntryTypesDeleteCall {
	c := &ProjectsLocationsEntryTypesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": If the client provided etag
// value does not match the current etag value, the
// DeleteEntryTypeRequest method returns an ABORTED error response
func (c *ProjectsLocationsEntryTypesDeleteCall) Etag(etag string) *ProjectsLocationsEntryTypesDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryTypesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryTypesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryTypesDeleteCall) Context(ctx context.Context) *ProjectsLocationsEntryTypesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryTypesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryTypesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryTypes.delete" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryTypesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a EntryType resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryTypes/{entryTypesId}",
	//   "httpMethod": "DELETE",
	//   "id": "dataplex.projects.locations.entryTypes.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "etag": {
	//       "description": "Optional. If the client provided etag value does not match the current etag value, the DeleteEntryTypeRequest method returns an ABORTED error response",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. The resource name of the EntryType: projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryTypes.get":

type ProjectsLocationsEntryTypesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a EntryType resource.
//
//   - name: The resource name of the EntryType:
//     projects/{project_number}/locations/{location_id}/entryTypes/{entry_
//     type_id}.
func (r *ProjectsLocationsEntryTypesService) Get(name string) *ProjectsLocationsEntryTypesGetCall {
	c := &ProjectsLocationsEntryTypesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryTypesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryTypesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsEntryTypesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsEntryTypesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryTypesGetCall) Context(ctx context.Context) *ProjectsLocationsEntryTypesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryTypesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryTypesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryTypes.get" call.
// Exactly one of *GoogleCloudDataplexV1EntryType or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudDataplexV1EntryType.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryTypesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1EntryType, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1EntryType{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a EntryType resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryTypes/{entryTypesId}",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.entryTypes.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the EntryType: projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1EntryType"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryTypes.getIamPolicy":

type ProjectsLocationsEntryTypesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsEntryTypesService) GetIamPolicy(resource string) *ProjectsLocationsEntryTypesGetIamPolicyCall {
	c := &ProjectsLocationsEntryTypesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy.Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected.Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset.The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1.To learn which
// resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsEntryTypesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsEntryTypesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryTypesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryTypesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsEntryTypesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsEntryTypesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryTypesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsEntryTypesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryTypesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryTypesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryTypes.getIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryTypesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryTypes/{entryTypesId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.entryTypes.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy.Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset.The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryTypes.list":

type ProjectsLocationsEntryTypesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists EntryType resources in a project and location.
//
//   - parent: The resource name of the EntryType location, of the form:
//     projects/{project_number}/locations/{location_id} where location_id
//     refers to a GCP region.
func (r *ProjectsLocationsEntryTypesService) List(parent string) *ProjectsLocationsEntryTypesListCall {
	c := &ProjectsLocationsEntryTypesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter request. Filters
// are case-sensitive. The following formats are supported:labels.key1 =
// "value1" labels:key1 name = "value" These restrictions can be
// coinjoined with AND, OR and NOT conjunctions.
func (c *ProjectsLocationsEntryTypesListCall) Filter(filter string) *ProjectsLocationsEntryTypesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order by fields (name
// or create_time) for the result. If not specified, the ordering is
// undefined.
func (c *ProjectsLocationsEntryTypesListCall) OrderBy(orderBy string) *ProjectsLocationsEntryTypesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// EntryTypes to return. The service may return fewer than this value.
// If unspecified, at most 10 EntryTypes will be returned. The maximum
// value is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsEntryTypesListCall) PageSize(pageSize int64) *ProjectsLocationsEntryTypesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token
// received from a previous ListEntryTypes call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to ListEntryTypes must match the call that provided the page
// token.
func (c *ProjectsLocationsEntryTypesListCall) PageToken(pageToken string) *ProjectsLocationsEntryTypesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryTypesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryTypesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsEntryTypesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsEntryTypesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryTypesListCall) Context(ctx context.Context) *ProjectsLocationsEntryTypesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryTypesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryTypesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/entryTypes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryTypes.list" call.
// Exactly one of *GoogleCloudDataplexV1ListEntryTypesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDataplexV1ListEntryTypesResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsEntryTypesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1ListEntryTypesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1ListEntryTypesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists EntryType resources in a project and location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryTypes",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.entryTypes.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Filter request. Filters are case-sensitive. The following formats are supported:labels.key1 = \"value1\" labels:key1 name = \"value\" These restrictions can be coinjoined with AND, OR and NOT conjunctions.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Optional. Order by fields (name or create_time) for the result. If not specified, the ordering is undefined.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. Maximum number of EntryTypes to return. The service may return fewer than this value. If unspecified, at most 10 EntryTypes will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. Page token received from a previous ListEntryTypes call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to ListEntryTypes must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the EntryType location, of the form: projects/{project_number}/locations/{location_id} where location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/entryTypes",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1ListEntryTypesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsEntryTypesListCall) Pages(ctx context.Context, f func(*GoogleCloudDataplexV1ListEntryTypesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dataplex.projects.locations.entryTypes.patch":

type ProjectsLocationsEntryTypesPatchCall struct {
	s                              *Service
	name                           string
	googleclouddataplexv1entrytype *GoogleCloudDataplexV1EntryType
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Patch: Updates a EntryType resource.
//
//   - name: Output only. The relative resource name of the EntryType, of
//     the form:
//     projects/{project_number}/locations/{location_id}/entryTypes/{entry_
//     type_id}.
func (r *ProjectsLocationsEntryTypesService) Patch(name string, googleclouddataplexv1entrytype *GoogleCloudDataplexV1EntryType) *ProjectsLocationsEntryTypesPatchCall {
	c := &ProjectsLocationsEntryTypesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddataplexv1entrytype = googleclouddataplexv1entrytype
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask
// of fields to update.
func (c *ProjectsLocationsEntryTypesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsEntryTypesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsEntryTypesPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsEntryTypesPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryTypesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryTypesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryTypesPatchCall) Context(ctx context.Context) *ProjectsLocationsEntryTypesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryTypesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryTypesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1entrytype)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryTypes.patch" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryTypesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a EntryType resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryTypes/{entryTypesId}",
	//   "httpMethod": "PATCH",
	//   "id": "dataplex.projects.locations.entryTypes.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The relative resource name of the EntryType, of the form: projects/{project_number}/locations/{location_id}/entryTypes/{entry_type_id}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Mask of fields to update.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1EntryType"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryTypes.setIamPolicy":

type ProjectsLocationsEntryTypesSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy.Can return NOT_FOUND,
// INVALID_ARGUMENT, and PERMISSION_DENIED errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsEntryTypesService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsEntryTypesSetIamPolicyCall {
	c := &ProjectsLocationsEntryTypesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryTypesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryTypesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryTypesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsEntryTypesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryTypesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryTypesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryTypes.setIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryTypesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryTypes/{entryTypesId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.entryTypes.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "GoogleIamV1SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.entryTypes.testIamPermissions":

type ProjectsLocationsEntryTypesTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a NOT_FOUND error.Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsEntryTypesService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsEntryTypesTestIamPermissionsCall {
	c := &ProjectsLocationsEntryTypesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsEntryTypesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsEntryTypesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsEntryTypesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsEntryTypesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsEntryTypesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsEntryTypesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.entryTypes.testIamPermissions" call.
// Exactly one of *GoogleIamV1TestIamPermissionsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsEntryTypesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a NOT_FOUND error.Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/entryTypes/{entryTypesId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.entryTypes.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/entryTypes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "GoogleIamV1TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.governanceRules.getIamPolicy":

type ProjectsLocationsGovernanceRulesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsGovernanceRulesService) GetIamPolicy(resource string) *ProjectsLocationsGovernanceRulesGetIamPolicyCall {
	c := &ProjectsLocationsGovernanceRulesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy.Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected.Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset.The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1.To learn which
// resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsGovernanceRulesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsGovernanceRulesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGovernanceRulesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsGovernanceRulesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsGovernanceRulesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsGovernanceRulesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGovernanceRulesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsGovernanceRulesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGovernanceRulesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGovernanceRulesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.governanceRules.getIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsGovernanceRulesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/governanceRules/{governanceRulesId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.governanceRules.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy.Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset.The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/governanceRules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.governanceRules.setIamPolicy":

type ProjectsLocationsGovernanceRulesSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy.Can return NOT_FOUND,
// INVALID_ARGUMENT, and PERMISSION_DENIED errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsGovernanceRulesService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsGovernanceRulesSetIamPolicyCall {
	c := &ProjectsLocationsGovernanceRulesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGovernanceRulesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsGovernanceRulesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGovernanceRulesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsGovernanceRulesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGovernanceRulesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGovernanceRulesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.governanceRules.setIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsGovernanceRulesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/governanceRules/{governanceRulesId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.governanceRules.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/governanceRules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "GoogleIamV1SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.governanceRules.testIamPermissions":

type ProjectsLocationsGovernanceRulesTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a NOT_FOUND error.Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsGovernanceRulesService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsGovernanceRulesTestIamPermissionsCall {
	c := &ProjectsLocationsGovernanceRulesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsGovernanceRulesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsGovernanceRulesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsGovernanceRulesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsGovernanceRulesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsGovernanceRulesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsGovernanceRulesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.governanceRules.testIamPermissions" call.
// Exactly one of *GoogleIamV1TestIamPermissionsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsGovernanceRulesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a NOT_FOUND error.Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/governanceRules/{governanceRulesId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.governanceRules.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/governanceRules/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "GoogleIamV1TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.lakes.create":

type ProjectsLocationsLakesCreateCall struct {
	s                         *Service
	parent                    string
	googleclouddataplexv1lake *GoogleCloudDataplexV1Lake
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Create: Creates a lake resource.
//
//   - parent: The resource name of the lake location, of the form:
//     projects/{project_number}/locations/{location_id} where location_id
//     refers to a GCP region.
func (r *ProjectsLocationsLakesService) Create(parent string, googleclouddataplexv1lake *GoogleCloudDataplexV1Lake) *ProjectsLocationsLakesCreateCall {
	c := &ProjectsLocationsLakesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddataplexv1lake = googleclouddataplexv1lake
	return c
}

// LakeId sets the optional parameter "lakeId": Required. Lake
// identifier. This ID will be used to generate names such as database
// and dataset names when publishing metadata to Hive Metastore and
// BigQuery. * Must contain only lowercase letters, numbers and hyphens.
// * Must start with a letter. * Must end with a number or a letter. *
// Must be between 1-63 characters. * Must be unique within the customer
// project / location.
func (c *ProjectsLocationsLakesCreateCall) LakeId(lakeId string) *ProjectsLocationsLakesCreateCall {
	c.urlParams_.Set("lakeId", lakeId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsLakesCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsLakesCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsLakesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsLakesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsLakesCreateCall) Context(ctx context.Context) *ProjectsLocationsLakesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsLakesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLakesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1lake)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/lakes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.lakes.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsLakesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a lake resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/lakes",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.lakes.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "lakeId": {
	//       "description": "Required. Lake identifier. This ID will be used to generate names such as database and dataset names when publishing metadata to Hive Metastore and BigQuery. * Must contain only lowercase letters, numbers and hyphens. * Must start with a letter. * Must end with a number or a letter. * Must be between 1-63 characters. * Must be unique within the customer project / location.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the lake location, of the form: projects/{project_number}/locations/{location_id} where location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+parent}/lakes",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1Lake"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.lakes.delete":

type ProjectsLocationsLakesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a lake resource. All zones within the lake must be
// deleted before the lake can be deleted.
//
//   - name: The resource name of the lake:
//     projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
func (r *ProjectsLocationsLakesService) Delete(name string) *ProjectsLocationsLakesDeleteCall {
	c := &ProjectsLocationsLakesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsLakesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsLakesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsLakesDeleteCall) Context(ctx context.Context) *ProjectsLocationsLakesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsLakesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLakesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.lakes.delete" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsLakesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a lake resource. All zones within the lake must be deleted before the lake can be deleted.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/lakes/{lakesId}",
	//   "httpMethod": "DELETE",
	//   "id": "dataplex.projects.locations.lakes.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the lake: projects/{project_number}/locations/{location_id}/lakes/{lake_id}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/lakes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.lakes.get":

type ProjectsLocationsLakesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a lake resource.
//
//   - name: The resource name of the lake:
//     projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
func (r *ProjectsLocationsLakesService) Get(name string) *ProjectsLocationsLakesGetCall {
	c := &ProjectsLocationsLakesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsLakesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsLakesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsLakesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsLakesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsLakesGetCall) Context(ctx context.Context) *ProjectsLocationsLakesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsLakesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLakesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.lakes.get" call.
// Exactly one of *GoogleCloudDataplexV1Lake or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudDataplexV1Lake.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsLakesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1Lake, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1Lake{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieves a lake resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/lakes/{lakesId}",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.lakes.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the lake: projects/{project_number}/locations/{location_id}/lakes/{lake_id}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/lakes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1Lake"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.lakes.getIamPolicy":

type ProjectsLocationsLakesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a resource. Returns
// an empty policy if the resource exists and does not have a policy
// set.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsLakesService) GetIamPolicy(resource string) *ProjectsLocationsLakesGetIamPolicyCall {
	c := &ProjectsLocationsLakesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy.Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected.Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset.The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1.To learn which
// resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsLakesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsLakesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsLakesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsLakesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsLakesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsLakesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsLakesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsLakesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsLakesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLakesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.lakes.getIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsLakesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/lakes/{lakesId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.lakes.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy.Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset.The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/lakes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.lakes.list":

type ProjectsLocationsLakesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists lake resources in a project and location.
//
//   - parent: The resource name of the lake location, of the form:
//     projects/{project_number}/locations/{location_id} where location_id
//     refers to a GCP region.
func (r *ProjectsLocationsLakesService) List(parent string) *ProjectsLocationsLakesListCall {
	c := &ProjectsLocationsLakesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter request.
func (c *ProjectsLocationsLakesListCall) Filter(filter string) *ProjectsLocationsLakesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": Order by fields for
// the result.
func (c *ProjectsLocationsLakesListCall) OrderBy(orderBy string) *ProjectsLocationsLakesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// Lakes to return. The service may return fewer than this value. If
// unspecified, at most 10 lakes will be returned. The maximum value is
// 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsLakesListCall) PageSize(pageSize int64) *ProjectsLocationsLakesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token
// received from a previous ListLakes call. Provide this to retrieve the
// subsequent page. When paginating, all other parameters provided to
// ListLakes must match the call that provided the page token.
func (c *ProjectsLocationsLakesListCall) PageToken(pageToken string) *ProjectsLocationsLakesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsLakesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsLakesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsLakesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsLakesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsLakesListCall) Context(ctx context.Context) *ProjectsLocationsLakesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsLakesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLakesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/lakes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.lakes.list" call.
// Exactly one of *GoogleCloudDataplexV1ListLakesResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleCloudDataplexV1ListLakesResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsLakesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1ListLakesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1ListLakesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists lake resources in a project and location.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/lakes",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.lakes.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Filter request.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "Optional. Order by fields for the result.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. Maximum number of Lakes to return. The service may return fewer than this value. If unspecified, at most 10 lakes will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. Page token received from a previous ListLakes call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to ListLakes must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the lake location, of the form: projects/{project_number}/locations/{location_id} where location_id refers to a GCP region.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/lakes",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1ListLakesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsLakesListCall) Pages(ctx context.Context, f func(*GoogleCloudDataplexV1ListLakesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dataplex.projects.locations.lakes.patch":

type ProjectsLocationsLakesPatchCall struct {
	s                         *Service
	name                      string
	googleclouddataplexv1lake *GoogleCloudDataplexV1Lake
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Patch: Updates a lake resource.
//
//   - name: Output only. The relative resource name of the lake, of the
//     form:
//     projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
func (r *ProjectsLocationsLakesService) Patch(name string, googleclouddataplexv1lake *GoogleCloudDataplexV1Lake) *ProjectsLocationsLakesPatchCall {
	c := &ProjectsLocationsLakesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleclouddataplexv1lake = googleclouddataplexv1lake
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. Mask
// of fields to update.
func (c *ProjectsLocationsLakesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsLakesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsLakesPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsLakesPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsLakesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsLakesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsLakesPatchCall) Context(ctx context.Context) *ProjectsLocationsLakesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsLakesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLakesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1lake)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.lakes.patch" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsLakesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates a lake resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/lakes/{lakesId}",
	//   "httpMethod": "PATCH",
	//   "id": "dataplex.projects.locations.lakes.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Output only. The relative resource name of the lake, of the form: projects/{project_number}/locations/{location_id}/lakes/{lake_id}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/lakes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. Mask of fields to update.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1Lake"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.lakes.setIamPolicy":

type ProjectsLocationsLakesSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the access control policy on the specified
// resource. Replaces any existing policy.Can return NOT_FOUND,
// INVALID_ARGUMENT, and PERMISSION_DENIED errors.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     specified. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsLakesService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsLakesSetIamPolicyCall {
	c := &ProjectsLocationsLakesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsLakesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsLakesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsLakesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsLakesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsLakesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLakesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.lakes.setIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsLakesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the access control policy on the specified resource. Replaces any existing policy.Can return NOT_FOUND, INVALID_ARGUMENT, and PERMISSION_DENIED errors.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/lakes/{lakesId}:setIamPolicy",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.lakes.setIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being specified. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/lakes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:setIamPolicy",
	//   "request": {
	//     "$ref": "GoogleIamV1SetIamPolicyRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.lakes.testIamPermissions":

type ProjectsLocationsLakesTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the
// specified resource. If the resource does not exist, this will return
// an empty set of permissions, not a NOT_FOUND error.Note: This
// operation is designed to be used for building permission-aware UIs
// and command-line tools, not for authorization checking. This
// operation may "fail open" without warning.
//
//   - resource: REQUIRED: The resource for which the policy detail is
//     being requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsLakesService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsLakesTestIamPermissionsCall {
	c := &ProjectsLocationsLakesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsLakesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsLakesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsLakesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsLakesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsLakesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLakesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.lakes.testIamPermissions" call.
// Exactly one of *GoogleIamV1TestIamPermissionsResponse or error will
// be non-nil. Any non-2xx status code is an error. Response headers are
// in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsLakesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a NOT_FOUND error.Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may \"fail open\" without warning.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/lakes/{lakesId}:testIamPermissions",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.lakes.testIamPermissions",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy detail is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/lakes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:testIamPermissions",
	//   "request": {
	//     "$ref": "GoogleIamV1TestIamPermissionsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleIamV1TestIamPermissionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.lakes.actions.list":

type ProjectsLocationsLakesActionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists action resources in a lake.
//
//   - parent: The resource name of the parent lake:
//     projects/{project_number}/locations/{location_id}/lakes/{lake_id}.
func (r *ProjectsLocationsLakesActionsService) List(parent string) *ProjectsLocationsLakesActionsListCall {
	c := &ProjectsLocationsLakesActionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// actions to return. The service may return fewer than this value. If
// unspecified, at most 10 actions will be returned. The maximum value
// is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsLakesActionsListCall) PageSize(pageSize int64) *ProjectsLocationsLakesActionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token
// received from a previous ListLakeActions call. Provide this to
// retrieve the subsequent page. When paginating, all other parameters
// provided to ListLakeActions must match the call that provided the
// page token.
func (c *ProjectsLocationsLakesActionsListCall) PageToken(pageToken string) *ProjectsLocationsLakesActionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsLakesActionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsLakesActionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsLakesActionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsLakesActionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsLakesActionsListCall) Context(ctx context.Context) *ProjectsLocationsLakesActionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsLakesActionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLakesActionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/actions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.lakes.actions.list" call.
// Exactly one of *GoogleCloudDataplexV1ListActionsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDataplexV1ListActionsResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsLakesActionsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1ListActionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1ListActionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists action resources in a lake.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/lakes/{lakesId}/actions",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.lakes.actions.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Optional. Maximum number of actions to return. The service may return fewer than this value. If unspecified, at most 10 actions will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. Page token received from a previous ListLakeActions call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to ListLakeActions must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the parent lake: projects/{project_number}/locations/{location_id}/lakes/{lake_id}.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/lakes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/actions",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1ListActionsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsLakesActionsListCall) Pages(ctx context.Context, f func(*GoogleCloudDataplexV1ListActionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dataplex.projects.locations.lakes.content.create":

type ProjectsLocationsLakesContentCreateCall struct {
	s                            *Service
	parent                       string
	googleclouddataplexv1content *GoogleCloudDataplexV1Content
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Create: Create a content.
//
//   - parent: The resource name of the parent lake:
//     projects/{project_id}/locations/{location_id}/lakes/{lake_id}.
func (r *ProjectsLocationsLakesContentService) Create(parent string, googleclouddataplexv1content *GoogleCloudDataplexV1Content) *ProjectsLocationsLakesContentCreateCall {
	c := &ProjectsLocationsLakesContentCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleclouddataplexv1content = googleclouddataplexv1content
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Only
// validate the request, but do not perform mutations. The default is
// false.
func (c *ProjectsLocationsLakesContentCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsLakesContentCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsLakesContentCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsLakesContentCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsLakesContentCreateCall) Context(ctx context.Context) *ProjectsLocationsLakesContentCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsLakesContentCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLakesContentCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleclouddataplexv1content)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/content")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.lakes.content.create" call.
// Exactly one of *GoogleCloudDataplexV1Content or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudDataplexV1Content.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsLakesContentCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1Content, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1Content{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Create a content.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/lakes/{lakesId}/content",
	//   "httpMethod": "POST",
	//   "id": "dataplex.projects.locations.lakes.content.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The resource name of the parent lake: projects/{project_id}/locations/{location_id}/lakes/{lake_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/lakes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validateOnly": {
	//       "description": "Optional. Only validate the request, but do not perform mutations. The default is false.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+parent}/content",
	//   "request": {
	//     "$ref": "GoogleCloudDataplexV1Content"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1Content"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.lakes.content.delete":

type ProjectsLocationsLakesContentDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a content.
//
//   - name: The resource name of the content:
//     projects/{project_id}/locations/{location_id}/lakes/{lake_id}/conten
//     t/{content_id}.
func (r *ProjectsLocationsLakesContentService) Delete(name string) *ProjectsLocationsLakesContentDeleteCall {
	c := &ProjectsLocationsLakesContentDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsLakesContentDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsLakesContentDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsLakesContentDeleteCall) Context(ctx context.Context) *ProjectsLocationsLakesContentDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsLakesContentDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLakesContentDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.lakes.content.delete" call.
// Exactly one of *Empty or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *ProjectsLocationsLakesContentDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Delete a content.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/lakes/{lakesId}/content/{contentId}",
	//   "httpMethod": "DELETE",
	//   "id": "dataplex.projects.locations.lakes.content.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the content: projects/{project_id}/locations/{location_id}/lakes/{lake_id}/content/{content_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/lakes/[^/]+/content/.*$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "Empty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.lakes.content.get":

type ProjectsLocationsLakesContentGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a content resource.
//
//   - name: The resource name of the content:
//     projects/{project_id}/locations/{location_id}/lakes/{lake_id}/conten
//     t/{content_id}.
func (r *ProjectsLocationsLakesContentService) Get(name string) *ProjectsLocationsLakesContentGetCall {
	c := &ProjectsLocationsLakesContentGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": Specify content view to make
// a partial request.
//
// Possible values:
//
//	"CONTENT_VIEW_UNSPECIFIED" - Content view not specified. Defaults
//
// to BASIC. The API will default to the BASIC view.
//
//	"BASIC" - Will not return the data_text field.
//	"FULL" - Returns the complete proto.
func (c *ProjectsLocationsLakesContentGetCall) View(view string) *ProjectsLocationsLakesContentGetCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsLakesContentGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsLakesContentGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsLakesContentGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsLakesContentGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsLakesContentGetCall) Context(ctx context.Context) *ProjectsLocationsLakesContentGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsLakesContentGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLakesContentGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.lakes.content.get" call.
// Exactly one of *GoogleCloudDataplexV1Content or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudDataplexV1Content.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsLakesContentGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1Content, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1Content{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get a content resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/lakes/{lakesId}/content/{contentId}",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.lakes.content.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of the content: projects/{project_id}/locations/{location_id}/lakes/{lake_id}/content/{content_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/lakes/[^/]+/content/.*$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "Optional. Specify content view to make a partial request.",
	//       "enum": [
	//         "CONTENT_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "Content view not specified. Defaults to BASIC. The API will default to the BASIC view.",
	//         "Will not return the data_text field.",
	//         "Returns the complete proto."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1Content"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.lakes.content.getIamPolicy":

type ProjectsLocationsLakesContentGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the access control policy for a contentitem
// resource. A NOT_FOUND error is returned if the resource does not
// exist. An empty policy is returned if the resource exists but does
// not have a policy set on it.Caller must have Google IAM
// dataplex.content.getIamPolicy permission on the resource.
//
//   - resource: REQUIRED: The resource for which the policy is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the
//     appropriate value for this field.
func (r *ProjectsLocationsLakesContentService) GetIamPolicy(resource string) *ProjectsLocationsLakesContentGetIamPolicyCall {
	c := &ProjectsLocationsLakesContentGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that
// will be used to format the policy.Valid values are 0, 1, and 3.
// Requests specifying an invalid value will be rejected.Requests for
// policies with any conditional role bindings must specify version 3.
// Policies with no conditional role bindings may specify any valid
// value or leave the field unset.The policy in the response might use
// the policy version that you specified, or it might use a lower policy
// version. For example, if you specify version 3, but the policy has no
// conditional role bindings, the response uses version 1.To learn which
// resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsLakesContentGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsLakesContentGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsLakesContentGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsLakesContentGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsLakesContentGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsLakesContentGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsLakesContentGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsLakesContentGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsLakesContentGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLakesContentGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.lakes.content.getIamPolicy" call.
// Exactly one of *GoogleIamV1Policy or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *ProjectsLocationsLakesContentGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the access control policy for a contentitem resource. A NOT_FOUND error is returned if the resource does not exist. An empty policy is returned if the resource exists but does not have a policy set on it.Caller must have Google IAM dataplex.content.getIamPolicy permission on the resource.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/lakes/{lakesId}/content/{contentId}:getIamPolicy",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.lakes.content.getIamPolicy",
	//   "parameterOrder": [
	//     "resource"
	//   ],
	//   "parameters": {
	//     "options.requestedPolicyVersion": {
	//       "description": "Optional. The maximum policy version that will be used to format the policy.Valid values are 0, 1, and 3. Requests specifying an invalid value will be rejected.Requests for policies with any conditional role bindings must specify version 3. Policies with no conditional role bindings may specify any valid value or leave the field unset.The policy in the response might use the policy version that you specified, or it might use a lower policy version. For example, if you specify version 3, but the policy has no conditional role bindings, the response uses version 1.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "resource": {
	//       "description": "REQUIRED: The resource for which the policy is being requested. See Resource names (https://cloud.google.com/apis/design/resource_names) for the appropriate value for this field.",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/lakes/[^/]+/content/.*$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+resource}:getIamPolicy",
	//   "response": {
	//     "$ref": "GoogleIamV1Policy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "dataplex.projects.locations.lakes.content.list":

type ProjectsLocationsLakesContentListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List content.
//
//   - parent: The resource name of the parent lake:
//     projects/{project_id}/locations/{location_id}/lakes/{lake_id}.
func (r *ProjectsLocationsLakesContentService) List(parent string) *ProjectsLocationsLakesContentListCall {
	c := &ProjectsLocationsLakesContentListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Filter request. Filters
// are case-sensitive. The following formats are supported:labels.key1 =
// "value1" labels:key1 type = "NOTEBOOK" type = "SQL_SCRIPT"These
// restrictions can be coinjoined with AND, OR and NOT conjunctions.
func (c *ProjectsLocationsLakesContentListCall) Filter(filter string) *ProjectsLocationsLakesContentListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// content to return. The service may return fewer than this value. If
// unspecified, at most 10 content will be returned. The maximum value
// is 1000; values above 1000 will be coerced to 1000.
func (c *ProjectsLocationsLakesContentListCall) PageSize(pageSize int64) *ProjectsLocationsLakesContentListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token
// received from a previous ListContent call. Provide this to retrieve
// the subsequent page. When paginating, all other parameters provided
// to ListContent must match the call that provided the page token.
func (c *ProjectsLocationsLakesContentListCall) PageToken(pageToken string) *ProjectsLocationsLakesContentListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *ProjectsLocationsLakesContentListCall) Fields(s ...googleapi.Field) *ProjectsLocationsLakesContentListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *ProjectsLocationsLakesContentListCall) IfNoneMatch(entityTag string) *ProjectsLocationsLakesContentListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *ProjectsLocationsLakesContentListCall) Context(ctx context.Context) *ProjectsLocationsLakesContentListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *ProjectsLocationsLakesContentListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsLakesContentListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/content")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "dataplex.projects.locations.lakes.content.list" call.
// Exactly one of *GoogleCloudDataplexV1ListContentResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudDataplexV1ListContentResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsLakesContentListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudDataplexV1ListContentResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudDataplexV1ListContentResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "List content.",
	//   "flatPath": "v1/projects/{projectsId}/locations/{locationsId}/lakes/{lakesId}/content",
	//   "httpMethod": "GET",
	//   "id": "dataplex.projects.locations.lakes.content.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "Optional. Filter request. Filters are case-sensitive. The following formats are supported:labels.key1 = \"value1\" labels:key1 type = \"NOTEBOOK\" type = \"SQL_SCRIPT\"These restrictions can be coinjoined with AND, OR and NOT conjunctions.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Optional. Maximum number of content to return. The service may return fewer than this value. If unspecified, at most 10 content will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. Page token received from a previous ListContent call. Provide this to retrieve the subsequent page. When paginating, all other parameters provided to ListContent must match the call that provided the page token.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of the parent lake: projects/{project_id}/locations/{location_id}/lakes/{lake_id}",
	//       "location": "path",
	//       "pattern": "^projects/[^/]+/locations/[^/]+/lakes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/content",
	//   "response": {
	//     "$ref": "GoogleCloudDataplexV1ListContentResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsLakesContentListCall) Pages(ctx context.Context, f func(*GoogleCloudDataplexV1ListContentResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "dataplex.projects.locations.lakes.content.patch":

type ProjectsLocationsLakesContentPatchCall struct {
	s                            *Service
	name                         string
	googleclouddataplexv1content *GoogleCloudDataplexV1Content
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Patch: Update a content. Only supports full resource update.
//
//   - name: Output only. The relative resource name of the content, of
//     the form:
//     projects/{project_id}/locations/{location_id}/lakes/{l