# How to Contribute

We'd love to accept your patches and contributions to this project. There are
just a few small guidelines you need to follow. If you're looking to start
contributing, see the [New Contributors](#new-contributors) section below.

## Contributor License Agreement

Contributions to this project must be accompanied by a Contributor License
Agreement. You (or your employer) retain the copyright to your contribution,
this simply gives us permission to use and redistribute your contributions as
part of the project. Head over to <https://cla.developers.google.com/> to see
your current agreements on file or to sign a new one.

You generally only need to submit a CLA once, so if you've already submitted one
(even if it was for a different project), you probably don't need to do it
again.

## Proposals and PRs

If you would like to make a large change, please start with a proposal issue that includes:
* What you would like to achieve
* Why you'd like to make this change
* A design overview

A member of the Grafeas core team may reach out to you to schedule a meeting to
discuss the PR, before a formal review takes place. This meeting will be
announced on [grafeas-dev](https://groups.google.com/forum/#!forum/grafeas-dev)
as well, once the date and time have been set.

### New Contributors

If you're enthusiastic about contributing to Grafeas and are looking for ideas,
please check out the issues marked with [`good first
issue`](https://github.com/grafeas/grafeas/labels/good%20first%20issue). Make
sure you join the
[grafeas-dev](https://groups.google.com/forum/#!forum/grafeas-dev) group to stay
up-to-date on the developer community news!

## Code reviews

All submissions, including submissions by project members, require review. We
use GitHub pull requests for this purpose. Consult
[GitHub Help](https://help.github.com/articles/about-pull-requests/) for more
information on using pull requests.

## Community Guidelines

This project follows [Google's Open Source Community
Guidelines](https://opensource.google.com/conduct/).
