// Copyright (C) 2021 Storj Labs, Inc.
// See LICENSE for copying information
//

package location

// Code generated by ./gen/generate.go. DO NOT EDIT.
// original source: https://download.geonames.org/export/dump/countryInfo.txt
// license of the datasource: Creative Commons Attribution 4.0 License,
// https://creativecommons.org/licenses/by/4.0/

// country codes to two letter upper case ISO country code as uint16.
const (
	None                                   = CountryCode(0)
	Afghanistan                            = CountryCode(6)
	AlandIslands                           = CountryCode(24)
	Albania                                = CountryCode(12)
	Algeria                                = CountryCode(104)
	AmericanSamoa                          = CountryCode(19)
	Andorra                                = CountryCode(4)
	Angola                                 = CountryCode(15)
	Anguilla                               = CountryCode(9)
	Antarctica                             = CountryCode(17)
	AntiguaandBarbuda                      = CountryCode(7)
	Argentina                              = CountryCode(18)
	Armenia                                = CountryCode(13)
	Aruba                                  = CountryCode(23)
	Australia                              = CountryCode(21)
	Austria                                = CountryCode(20)
	Azerbaijan                             = CountryCode(26)
	Bahamas                                = CountryCode(45)
	Bahrain                                = CountryCode(34)
	Bangladesh                             = CountryCode(30)
	Barbados                               = CountryCode(28)
	Belarus                                = CountryCode(51)
	Belgium                                = CountryCode(31)
	Belize                                 = CountryCode(52)
	Benin                                  = CountryCode(36)
	Bermuda                                = CountryCode(39)
	Bhutan                                 = CountryCode(46)
	Bolivia                                = CountryCode(41)
	BonaireSaintEustatiusandSaba           = CountryCode(43)
	BosniaandHerzegovina                   = CountryCode(27)
	Botswana                               = CountryCode(49)
	BouvetIsland                           = CountryCode(48)
	Brazil                                 = CountryCode(44)
	BritishIndianOceanTerritory            = CountryCode(223)
	BritishVirginIslands                   = CountryCode(553)
	Brunei                                 = CountryCode(40)
	Bulgaria                               = CountryCode(33)
	BurkinaFaso                            = CountryCode(32)
	Burundi                                = CountryCode(35)
	CaboVerde                              = CountryCode(74)
	Cambodia                               = CountryCode(268)
	Cameroon                               = CountryCode(65)
	Canada                                 = CountryCode(53)
	CaymanIslands                          = CountryCode(285)
	CentralAfricanRepublic                 = CountryCode(58)
	Chad                                   = CountryCode(498)
	Chile                                  = CountryCode(64)
	China                                  = CountryCode(66)
	ChristmasIsland                        = CountryCode(76)
	CocosIslands                           = CountryCode(55)
	Colombia                               = CountryCode(67)
	Comoros                                = CountryCode(273)
	CookIslands                            = CountryCode(63)
	CostaRica                              = CountryCode(70)
	Croatia                                = CountryCode(200)
	Cuba                                   = CountryCode(73)
	Curacao                                = CountryCode(75)
	Cyprus                                 = CountryCode(77)
	Czechia                                = CountryCode(78)
	DemocraticRepublicoftheCongo           = CountryCode(56)
	Denmark                                = CountryCode(89)
	Djibouti                               = CountryCode(88)
	Dominica                               = CountryCode(91)
	DominicanRepublic                      = CountryCode(93)
	Ecuador                                = CountryCode(107)
	Egypt                                  = CountryCode(111)
	ElSalvador                             = CountryCode(490)
	EquatorialGuinea                       = CountryCode(173)
	Eritrea                                = CountryCode(122)
	Estonia                                = CountryCode(109)
	Eswatini                               = CountryCode(494)
	Ethiopia                               = CountryCode(124)
	FalklandIslands                        = CountryCode(141)
	FaroeIslands                           = CountryCode(145)
	Fiji                                   = CountryCode(140)
	Finland                                = CountryCode(139)
	France                                 = CountryCode(148)
	FrenchGuiana                           = CountryCode(162)
	FrenchPolynesia                        = CountryCode(396)
	FrenchSouthernTerritories              = CountryCode(500)
	Gabon                                  = CountryCode(157)
	Gambia                                 = CountryCode(169)
	Georgia                                = CountryCode(161)
	Germany                                = CountryCode(83)
	Ghana                                  = CountryCode(164)
	Gibraltar                              = CountryCode(165)
	Greece                                 = CountryCode(174)
	Greenland                              = CountryCode(168)
	Grenada                                = CountryCode(160)
	Guadeloupe                             = CountryCode(172)
	Guam                                   = CountryCode(177)
	Guatemala                              = CountryCode(176)
	Guernsey                               = CountryCode(163)
	Guinea                                 = CountryCode(170)
	GuineaBissau                           = CountryCode(179)
	Guyana                                 = CountryCode(181)
	Haiti                                  = CountryCode(202)
	HeardIslandandMcDonaldIslands          = CountryCode(195)
	Honduras                               = CountryCode(196)
	HongKong                               = CountryCode(193)
	Hungary                                = CountryCode(203)
	Iceland                                = CountryCode(227)
	India                                  = CountryCode(222)
	Indonesia                              = CountryCode(212)
	Iran                                   = CountryCode(226)
	Iraq                                   = CountryCode(225)
	Ireland                                = CountryCode(213)
	IsleofMan                              = CountryCode(221)
	Israel                                 = CountryCode(220)
	Italy                                  = CountryCode(228)
	IvoryCoast                             = CountryCode(61)
	Jamaica                                = CountryCode(247)
	Japan                                  = CountryCode(250)
	Jersey                                 = CountryCode(239)
	Jordan                                 = CountryCode(249)
	Kazakhstan                             = CountryCode(286)
	Kenya                                  = CountryCode(265)
	Kiribati                               = CountryCode(269)
	Kosovo                                 = CountryCode(609)
	Kuwait                                 = CountryCode(283)
	Kyrgyzstan                             = CountryCode(267)
	Laos                                   = CountryCode(287)
	Latvia                                 = CountryCode(308)
	Lebanon                                = CountryCode(288)
	Lesotho                                = CountryCode(305)
	Liberia                                = CountryCode(304)
	Libya                                  = CountryCode(311)
	Liechtenstein                          = CountryCode(295)
	Lithuania                              = CountryCode(306)
	Luxembourg                             = CountryCode(307)
	Macao                                  = CountryCode(327)
	Madagascar                             = CountryCode(319)
	Malawi                                 = CountryCode(335)
	Malaysia                               = CountryCode(337)
	Maldives                               = CountryCode(334)
	Mali                                   = CountryCode(324)
	Malta                                  = CountryCode(332)
	MarshallIslands                        = CountryCode(320)
	Martinique                             = CountryCode(329)
	Mauritania                             = CountryCode(330)
	Mauritius                              = CountryCode(333)
	Mayotte                                = CountryCode(644)
	Mexico                                 = CountryCode(336)
	Micronesia                             = CountryCode(143)
	Moldova                                = CountryCode(316)
	Monaco                                 = CountryCode(315)
	Mongolia                               = CountryCode(326)
	Montenegro                             = CountryCode(317)
	Montserrat                             = CountryCode(331)
	Morocco                                = CountryCode(313)
	Mozambique                             = CountryCode(338)
	Myanmar                                = CountryCode(325)
	Namibia                                = CountryCode(339)
	Nauru                                  = CountryCode(356)
	Nepal                                  = CountryCode(354)
	Netherlands                            = CountryCode(350)
	NetherlandsAntilles                    = CountryCode(14)
	NewCaledonia                           = CountryCode(341)
	NewZealand                             = CountryCode(364)
	Nicaragua                              = CountryCode(347)
	Niger                                  = CountryCode(343)
	Nigeria                                = CountryCode(345)
	Niue                                   = CountryCode(359)
	NorfolkIsland                          = CountryCode(344)
	NorthKorea                             = CountryCode(276)
	NorthMacedonia                         = CountryCode(323)
	NorthernMarianaIslands                 = CountryCode(328)
	Norway                                 = CountryCode(353)
	Oman                                   = CountryCode(377)
	Pakistan                               = CountryCode(401)
	Palau                                  = CountryCode(413)
	PalestinianTerritory                   = CountryCode(409)
	Panama                                 = CountryCode(391)
	PapuaNewGuinea                         = CountryCode(397)
	Paraguay                               = CountryCode(415)
	Peru                                   = CountryCode(395)
	Philippines                            = CountryCode(398)
	Pitcairn                               = CountryCode(404)
	Poland                                 = CountryCode(402)
	Portugal                               = CountryCode(410)
	PuertoRico                             = CountryCode(408)
	Qatar                                  = CountryCode(417)
	RepublicoftheCongo                     = CountryCode(59)
	Reunion                                = CountryCode(447)
	Romania                                = CountryCode(457)
	Russia                                 = CountryCode(463)
	Rwanda                                 = CountryCode(465)
	SaintBarthelemy                        = CountryCode(38)
	SaintHelena                            = CountryCode(476)
	SaintKittsandNevis                     = CountryCode(274)
	SaintLucia                             = CountryCode(289)
	SaintMartin                            = CountryCode(318)
	SaintPierreandMiquelon                 = CountryCode(403)
	SaintVincentandtheGrenadines           = CountryCode(549)
	Samoa                                  = CountryCode(591)
	SanMarino                              = CountryCode(481)
	SaoTomeandPrincipe                     = CountryCode(488)
	SaudiArabia                            = CountryCode(469)
	Senegal                                = CountryCode(482)
	Serbia                                 = CountryCode(461)
	SerbiaandMontenegro                    = CountryCode(71)
	Seychelles                             = CountryCode(471)
	SierraLeone                            = CountryCode(480)
	Singapore                              = CountryCode(475)
	SintMaarten                            = CountryCode(492)
	Slovakia                               = CountryCode(479)
	Slovenia                               = CountryCode(477)
	SolomonIslands                         = CountryCode(470)
	Somalia                                = CountryCode(483)
	SouthAfrica                            = CountryCode(651)
	SouthGeorgiaandtheSouthSandwichIslands = CountryCode(175)
	SouthKorea                             = CountryCode(278)
	SouthSudan                             = CountryCode(487)
	Spain                                  = CountryCode(123)
	SriLanka                               = CountryCode(297)
	Sudan                                  = CountryCode(472)
	Suriname                               = CountryCode(486)
	SvalbardandJanMayen                    = CountryCode(478)
	Sweden                                 = CountryCode(473)
	Switzerland                            = CountryCode(60)
	Syria                                  = CountryCode(493)
	Taiwan                                 = CountryCode(517)
	Tajikistan                             = CountryCode(504)
	Tanzania                               = CountryCode(520)
	Thailand                               = CountryCode(502)
	TimorLeste                             = CountryCode(506)
	Togo                                   = CountryCode(501)
	Tokelau                                = CountryCode(505)
	Tonga                                  = CountryCode(509)
	TrinidadandTobago                      = CountryCode(514)
	Tunisia                                = CountryCode(508)
	Turkey                                 = CountryCode(512)
	Turkmenistan                           = CountryCode(507)
	TurksandCaicosIslands                  = CountryCode(497)
	Tuvalu                                 = CountryCode(516)
	USVirginIslands                        = CountryCode(555)
	Uganda                                 = CountryCode(527)
	Ukraine                                = CountryCode(521)
	UnitedArabEmirates                     = CountryCode(5)
	UnitedKingdom                          = CountryCode(158)
	UnitedStates                           = CountryCode(539)
	UnitedStatesMinorOutlyingIslands       = CountryCode(533)
	Uruguay                                = CountryCode(545)
	Uzbekistan                             = CountryCode(546)
	Vanuatu                                = CountryCode(567)
	Vatican                                = CountryCode(547)
	Venezuela                              = CountryCode(551)
	Vietnam                                = CountryCode(560)
	WallisandFutuna                        = CountryCode(578)
	WesternSahara                          = CountryCode(112)
	Yemen                                  = CountryCode(629)
	Zambia                                 = CountryCode(663)
	Zimbabwe                               = CountryCode(673)
)

var CountryISOCode = [...]string{
	Afghanistan:                            "AF",
	AlandIslands:                           "AX",
	Albania:                                "AL",
	Algeria:                                "DZ",
	AmericanSamoa:                          "AS",
	Andorra:                                "AD",
	Angola:                                 "AO",
	Anguilla:                               "AI",
	Antarctica:                             "AQ",
	AntiguaandBarbuda:                      "AG",
	Argentina:                              "AR",
	Armenia:                                "AM",
	Aruba:                                  "AW",
	Australia:                              "AU",
	Austria:                                "AT",
	Azerbaijan:                             "AZ",
	Bahamas:                                "BS",
	Bahrain:                                "BH",
	Bangladesh:                             "BD",
	Barbados:                               "BB",
	Belarus:                                "BY",
	Belgium:                                "BE",
	Belize:                                 "BZ",
	Benin:                                  "BJ",
	Bermuda:                                "BM",
	Bhutan:                                 "BT",
	Bolivia:                                "BO",
	BonaireSaintEustatiusandSaba:           "BQ",
	BosniaandHerzegovina:                   "BA",
	Botswana:                               "BW",
	BouvetIsland:                           "BV",
	Brazil:                                 "BR",
	BritishIndianOceanTerritory:            "IO",
	BritishVirginIslands:                   "VG",
	Brunei:                                 "BN",
	Bulgaria:                               "BG",
	BurkinaFaso:                            "BF",
	Burundi:                                "BI",
	CaboVerde:                              "CV",
	Cambodia:                               "KH",
	Cameroon:                               "CM",
	Canada:                                 "CA",
	CaymanIslands:                          "KY",
	CentralAfricanRepublic:                 "CF",
	Chad:                                   "TD",
	Chile:                                  "CL",
	China:                                  "CN",
	ChristmasIsland:                        "CX",
	CocosIslands:                           "CC",
	Colombia:                               "CO",
	Comoros:                                "KM",
	CookIslands:                            "CK",
	CostaRica:                              "CR",
	Croatia:                                "HR",
	Cuba:                                   "CU",
	Curacao:                                "CW",
	Cyprus:                                 "CY",
	Czechia:                                "CZ",
	DemocraticRepublicoftheCongo:           "CD",
	Denmark:                                "DK",
	Djibouti:                               "DJ",
	Dominica:                               "DM",
	DominicanRepublic:                      "DO",
	Ecuador:                                "EC",
	Egypt:                                  "EG",
	ElSalvador:                             "SV",
	EquatorialGuinea:                       "GQ",
	Eritrea:                                "ER",
	Estonia:                                "EE",
	Eswatini:                               "SZ",
	Ethiopia:                               "ET",
	FalklandIslands:                        "FK",
	FaroeIslands:                           "FO",
	Fiji:                                   "FJ",
	Finland:                                "FI",
	France:                                 "FR",
	FrenchGuiana:                           "GF",
	FrenchPolynesia:                        "PF",
	FrenchSouthernTerritories:              "TF",
	Gabon:                                  "GA",
	Gambia:                                 "GM",
	Georgia:                                "GE",
	Germany:                                "DE",
	Ghana:                                  "GH",
	Gibraltar:                              "GI",
	Greece:                                 "GR",
	Greenland:                              "GL",
	Grenada:                                "GD",
	Guadeloupe:                             "GP",
	Guam:                                   "GU",
	Guatemala:                              "GT",
	Guernsey:                               "GG",
	Guinea:                                 "GN",
	GuineaBissau:                           "GW",
	Guyana:                                 "GY",
	Haiti:                                  "HT",
	HeardIslandandMcDonaldIslands:          "HM",
	Honduras:                               "HN",
	HongKong:                               "HK",
	Hungary:                                "HU",
	Iceland:                                "IS",
	India:                                  "IN",
	Indonesia:                              "ID",
	Iran:                                   "IR",
	Iraq:                                   "IQ",
	Ireland:                                "IE",
	IsleofMan:                              "IM",
	Israel:                                 "IL",
	Italy:                                  "IT",
	IvoryCoast:                             "CI",
	Jamaica:                                "JM",
	Japan:                                  "JP",
	Jersey:                                 "JE",
	Jordan:                                 "JO",
	Kazakhstan:                             "KZ",
	Kenya:                                  "KE",
	Kiribati:                               "KI",
	Kosovo:                                 "XK",
	Kuwait:                                 "KW",
	Kyrgyzstan:                             "KG",
	Laos:                                   "LA",
	Latvia:                                 "LV",
	Lebanon:                                "LB",
	Lesotho:                                "LS",
	Liberia:                                "LR",
	Libya:                                  "LY",
	Liechtenstein:                          "LI",
	Lithuania:                              "LT",
	Luxembourg:                             "LU",
	Macao:                                  "MO",
	Madagascar:                             "MG",
	Malawi:                                 "MW",
	Malaysia:                               "MY",
	Maldives:                               "MV",
	Mali:                                   "ML",
	Malta:                                  "MT",
	MarshallIslands:                        "MH",
	Martinique:                             "MQ",
	Mauritania:                             "MR",
	Mauritius:                              "MU",
	Mayotte:                                "YT",
	Mexico:                                 "MX",
	Micronesia:                             "FM",
	Moldova:                                "MD",
	Monaco:                                 "MC",
	Mongolia:                               "MN",
	Montenegro:                             "ME",
	Montserrat:                             "MS",
	Morocco:                                "MA",
	Mozambique:                             "MZ",
	Myanmar:                                "MM",
	Namibia:                                "NA",
	Nauru:                                  "NR",
	Nepal:                                  "NP",
	Netherlands:                            "NL",
	NetherlandsAntilles:                    "AN",
	NewCaledonia:                           "NC",
	NewZealand:                             "NZ",
	Nicaragua:                              "NI",
	Niger:                                  "NE",
	Nigeria:                                "NG",
	Niue:                                   "NU",
	NorfolkIsland:                          "NF",
	NorthKorea:                             "KP",
	NorthMacedonia:                         "MK",
	NorthernMarianaIslands:                 "MP",
	Norway:                                 "NO",
	Oman:                                   "OM",
	Pakistan:                               "PK",
	Palau:                                  "PW",
	PalestinianTerritory:                   "PS",
	Panama:                                 "PA",
	PapuaNewGuinea:                         "PG",
	Paraguay:                               "PY",
	Peru:                                   "PE",
	Philippines:                            "PH",
	Pitcairn:                               "PN",
	Poland:                                 "PL",
	Portugal:                               "PT",
	PuertoRico:                             "PR",
	Qatar:                                  "QA",
	RepublicoftheCongo:                     "CG",
	Reunion:                                "RE",
	Romania:                                "RO",
	Russia:                                 "RU",
	Rwanda:                                 "RW",
	SaintBarthelemy:                        "BL",
	SaintHelena:                            "SH",
	SaintKittsandNevis:                     "KN",
	SaintLucia:                             "LC",
	SaintMartin:                            "MF",
	SaintPierreandMiquelon:                 "PM",
	SaintVincentandtheGrenadines:           "VC",
	Samoa:                                  "WS",
	SanMarino:                              "SM",
	SaoTomeandPrincipe:                     "ST",
	SaudiArabia:                            "SA",
	Senegal:                                "SN",
	Serbia:                                 "RS",
	SerbiaandMontenegro:                    "CS",
	Seychelles:                             "SC",
	SierraLeone:                            "SL",
	Singapore:                              "SG",
	SintMaarten:                            "SX",
	Slovakia:                               "SK",
	Slovenia:                               "SI",
	SolomonIslands:                         "SB",
	Somalia:                                "SO",
	SouthAfrica:                            "ZA",
	SouthGeorgiaandtheSouthSandwichIslands: "GS",
	SouthKorea:                             "KR",
	SouthSudan:                             "SS",
	Spain:                                  "ES",
	SriLanka:                               "LK",
	Sudan:                                  "SD",
	Suriname:                               "SR",
	SvalbardandJanMayen:                    "SJ",
	Sweden:                                 "SE",
	Switzerland:                            "CH",
	Syria:                                  "SY",
	Taiwan:                                 "TW",
	Tajikistan:                             "TJ",
	Tanzania:                               "TZ",
	Thailand:                               "TH",
	TimorLeste:                             "TL",
	Togo:                                   "TG",
	Tokelau:                                "TK",
	Tonga:                                  "TO",
	TrinidadandTobago:                      "TT",
	Tunisia:                                "TN",
	Turkey:                                 "TR",
	Turkmenistan:                           "TM",
	TurksandCaicosIslands:                  "TC",
	Tuvalu:                                 "TV",
	USVirginIslands:                        "VI",
	Uganda:                                 "UG",
	Ukraine:                                "UA",
	UnitedArabEmirates:                     "AE",
	UnitedKingdom:                          "GB",
	UnitedStates:                           "US",
	UnitedStatesMinorOutlyingIslands:       "UM",
	Uruguay:                                "UY",
	Uzbekistan:                             "UZ",
	Vanuatu:                                "VU",
	Vatican:                                "VA",
	Venezuela:                              "VE",
	Vietnam:                                "VN",
	WallisandFutuna:                        "WF",
	WesternSahara:                          "EH",
	Yemen:                                  "YE",
	Zambia:                                 "ZM",
	Zimbabwe:                               "ZW",
}
