/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import com.jidesoft.converter.ObjectConverterManager;

public class EnumConverter
implements ObjectConverter {
    private String _name;
    private Object _default;
    private Class<?> _type;
    private Object[] _objects;
    private String[] _strings;
    private boolean _strict = true;
    private transient ConverterContext _context;

    public EnumConverter(String name, Object[] values, String[] strings) {
        this(name, values[0].getClass(), values, strings);
    }

    public EnumConverter(String name, Class<?> type, Object[] values, String[] strings) {
        this(name, type, values, strings, null);
    }

    public EnumConverter(String name, Class<?> type, Object[] objects, String[] strings, Object defaultValue) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("The \"name\" parameter cannot be null or empty. Please use a unique string to represent the name of the converter.");
        }
        this._name = name;
        if (objects == null) {
            throw new IllegalArgumentException("The \"objects\" parameter cannot be null.");
        }
        if (strings == null) {
            throw new IllegalArgumentException("The \"strings\" parameter cannot be null.");
        }
        if (strings.length != objects.length) {
            throw new IllegalArgumentException("The \"objects\" and \"strings\" parameters should have the same length.");
        }
        this._type = type;
        this._objects = objects;
        this._strings = strings;
        this._default = defaultValue;
    }

    public ConverterContext getContext() {
        if (this._context == null) {
            this._context = new ConverterContext(this._name);
        }
        return this._context;
    }

    @Override
    public String toString(Object object, ConverterContext context) {
        for (int i = 0; i < this._objects.length; ++i) {
            if ((this._objects[i] != null || object != null) && (this._objects[i] == null || !this._objects[i].equals(object)) || i >= this._strings.length) continue;
            return this._strings[i];
        }
        return this.isStrict() ? null : "" + object;
    }

    @Override
    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext context) {
        for (int i = 0; i < this._strings.length; ++i) {
            if (!this._strings[i].equals(string) || i >= this._objects.length) continue;
            return this._objects[i];
        }
        return this.isStrict() ? this._default : string;
    }

    @Override
    public boolean supportFromString(String string, ConverterContext context) {
        return true;
    }

    public String getName() {
        return this._name;
    }

    public Class<?> getType() {
        return this._type;
    }

    public Object getDefault() {
        return this._default;
    }

    public Object[] getObjects() {
        return this._objects;
    }

    public String[] getStrings() {
        return this._strings;
    }

    public static String[] toStrings(Object[] values) {
        return EnumConverter.toStrings(values, null);
    }

    public static String[] toStrings(Object[] values, ConverterContext converterContext) {
        String[] s = new String[values.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = ObjectConverterManager.toString(values[i], values[i].getClass(), converterContext);
        }
        return s;
    }

    public boolean isStrict() {
        return this._strict;
    }

    public void setStrict(boolean strict) {
        this._strict = strict;
    }
}

