/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.sql;

import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ForeignKeyInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;

public class TableInfo
extends DatabaseObjectInfo
implements ITableInfo {
    private final String _tableType;
    private final String _remarks;
    private SortedSet<ITableInfo> _childList;
    private ITableInfo[] _childs;
    ForeignKeyInfo[] exportedKeys = null;
    ForeignKeyInfo[] importedKeys = null;

    public TableInfo(String catalog, String schema, String simpleName, String tableType, String remarks, ISQLDatabaseMetaData md) {
        super(catalog, schema, simpleName, TableInfo.getTableType(tableType), md);
        this._remarks = remarks;
        this._tableType = tableType;
    }

    private static DatabaseObjectType getTableType(String tableType) {
        if (null == tableType) {
            return DatabaseObjectType.TABLE;
        }
        if (!tableType.equalsIgnoreCase("TABLE") && !tableType.equalsIgnoreCase("VIEW")) {
            return DatabaseObjectType.TABLE;
        }
        return tableType.equalsIgnoreCase("VIEW") ? DatabaseObjectType.VIEW : DatabaseObjectType.TABLE;
    }

    public void replaceDatabaseObjectTypeConstantObjectsByConstantObjectsOfThisVM() {
        if (DatabaseObjectType.TABLE.getKeyForSerializationReplace().equals(super.getDatabaseObjectType().getKeyForSerializationReplace())) {
            super.replaceDatabaseObjectTypeConstantObjectsByConstantObjectsOfThisVM(DatabaseObjectType.TABLE);
        } else if (DatabaseObjectType.TABLE.getKeyForSerializationReplace().equals(super.getDatabaseObjectType().getKeyForSerializationReplace())) {
            super.replaceDatabaseObjectTypeConstantObjectsByConstantObjectsOfThisVM(DatabaseObjectType.VIEW);
        }
    }

    @Override
    public String getType() {
        return this._tableType;
    }

    @Override
    public String getRemarks() {
        return this._remarks;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj) && obj instanceof TableInfo) {
            TableInfo info = (TableInfo)obj;
            if (info._tableType == null && this._tableType == null || info._tableType != null && this._tableType != null && info._tableType.equals(this._tableType)) {
                return info._remarks == null && this._remarks == null || info._remarks != null && this._remarks != null && info._remarks.equals(this._remarks);
            }
        }
        return false;
    }

    void addChild(ITableInfo tab) {
        if (this._childList == null) {
            this._childList = new TreeSet<ITableInfo>();
        }
        this._childList.add(tab);
    }

    @Override
    public ITableInfo[] getChildTables() {
        if (this._childs == null && this._childList != null) {
            this._childs = this._childList.toArray(new ITableInfo[this._childList.size()]);
            this._childList = null;
        }
        return this._childs;
    }

    @Override
    public ForeignKeyInfo[] getExportedKeys() {
        return this.exportedKeys;
    }

    @Override
    public void setExportedKeys(ForeignKeyInfo[] foreignKeys) {
        this.exportedKeys = foreignKeys;
    }

    @Override
    public ForeignKeyInfo[] getImportedKeys() {
        return this.importedKeys;
    }

    @Override
    public void setImportedKeys(ForeignKeyInfo[] foreignKeys) {
        this.importedKeys = foreignKeys;
    }
}

