/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dbdiff.gui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.dialects.CreateScriptPreferences;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactoryImpl;
import net.sourceforge.squirrel_sql.fw.dialects.HibernateDialect;
import net.sourceforge.squirrel_sql.fw.dialects.IDialectFactory;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.FileWrapper;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactory;
import net.sourceforge.squirrel_sql.fw.util.FileWrapperFactoryImpl;
import net.sourceforge.squirrel_sql.fw.util.IOUtilities;
import net.sourceforge.squirrel_sql.fw.util.IOUtilitiesImpl;
import net.sourceforge.squirrel_sql.fw.util.Utilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.dbdiff.IScriptFileManager;
import net.sourceforge.squirrel_sql.plugins.dbdiff.gui.AbstractDiffPresentation;

public abstract class AbstractSideBySideDiffPresentation
extends AbstractDiffPresentation {
    private static final ILogger s_log = LoggerController.createLogger(AbstractSideBySideDiffPresentation.class);
    protected FileWrapperFactory fileWrapperFactory = new FileWrapperFactoryImpl();
    protected IOUtilities ioutils = new IOUtilitiesImpl();
    private IDialectFactory dialectFactory = new DialectFactoryImpl();

    protected abstract void executeDiff(String var1, String var2) throws Exception;

    @Override
    public void execute() {
        ISession sourceSession = this.sessionInfoProvider.getSourceSession();
        IScriptFileManager scriptFileManager = this.sessionInfoProvider.getScriptFileManager();
        IDatabaseObjectInfo[] selectedDestObjects = this.sessionInfoProvider.getDestSelectedDatabaseObjects();
        ISession destSession = this.sessionInfoProvider.getDestSession();
        IDatabaseObjectInfo[] selectedSourceObjects = this.sessionInfoProvider.getSourceSelectedDatabaseObjects();
        HibernateDialect dialect = this.dialectFactory.getDialect(sourceSession.getMetaData());
        CreateScriptPreferences csprefs = new CreateScriptPreferences();
        List<ITableInfo> sourcetables = this.convertArrayToList(selectedSourceObjects);
        List<ITableInfo> desttables = this.convertArrayToList(selectedDestObjects);
        try {
            String script1 = this.constructScriptFromList(dialect.getCreateTableSQL(sourcetables, sourceSession.getMetaData(), csprefs, false, this.preferenceBean.isSortColumnsForSideBySideComparison()));
            String script2 = this.constructScriptFromList(dialect.getCreateTableSQL(desttables, destSession.getMetaData(), csprefs, false, this.preferenceBean.isSortColumnsForSideBySideComparison()));
            String sourceFilename = scriptFileManager.getOutputFilenameForSession(sourceSession, 1);
            String destFilename = scriptFileManager.getOutputFilenameForSession(destSession, 2);
            this.writeScriptToFile(script1, sourceFilename);
            this.writeScriptToFile(script2, destFilename);
            this.executeDiff(sourceFilename, destFilename);
        }
        catch (Exception e) {
            s_log.error((Object)("Unexpected exception while generating sql scripts : " + e.getMessage()), (Throwable)e);
        }
    }

    private void writeScriptToFile(String sqlscript, String file) throws IOException {
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)("Writing SQL script to file : " + file));
        }
        FileWrapper sourcefileWrapper = this.fileWrapperFactory.create(file);
        this.ioutils.copyBytesToFile((InputStream)new ByteArrayInputStream(sqlscript.getBytes()), sourcefileWrapper);
    }

    private List<ITableInfo> convertArrayToList(IDatabaseObjectInfo[] dbObjs) {
        ArrayList<ITableInfo> result = new ArrayList<ITableInfo>();
        for (IDatabaseObjectInfo dbObj : dbObjs) {
            if (!(dbObj instanceof ITableInfo)) continue;
            ITableInfo ti = (ITableInfo)dbObj;
            result.add(ti);
        }
        return result;
    }

    private String constructScriptFromList(List<String> sqlscript) {
        StringBuilder script = new StringBuilder();
        for (String sql : sqlscript) {
            script.append(sql);
            script.append(";\n\n");
        }
        return script.toString();
    }

    public void setFileWrapperFactory(FileWrapperFactory fileWrapperFactory) {
        Utilities.checkNull((String)"setFileWrapperFactory", (Object[])new Object[]{"fileWrapperFactory", fileWrapperFactory});
        this.fileWrapperFactory = fileWrapperFactory;
    }

    public void setIoutils(IOUtilities ioutils) {
        Utilities.checkNull((String)"setIoutils", (Object[])new Object[]{"ioutils", ioutils});
        this.ioutils = ioutils;
    }

    public void setDialectFactory(IDialectFactory dialectFactory) {
        Utilities.checkNull((String)"setDialectFactory", (Object[])new Object[]{"dialectFactory", dialectFactory});
        this.dialectFactory = dialectFactory;
    }
}

