/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.fife.rsta.ui.CollapsibleSectionPanel;
import org.fife.rsta.ui.search.AbstractFindReplaceDialog;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rsta.ui.search.FindToolBar;
import org.fife.rsta.ui.search.ReplaceDialog;
import org.fife.rsta.ui.search.ReplaceToolBar;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.ChildWindowListener;
import org.fife.rtext.RText;
import org.fife.rtext.RTextEditorPane;
import org.fife.rtext.RTextUtilities;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.fife.ui.search.FindInFilesSearchContext;

public class SearchManager {
    private RText rtext;
    private SearchingMode searchingMode;
    private FindDialog findDialog;
    private ReplaceDialog replaceDialog;
    public FindToolBar findToolBar;
    public ReplaceToolBar replaceToolBar;

    public SearchManager(RText rtext) {
        this.rtext = rtext;
        this.setSearchingMode(SearchingMode.TOOLBARS);
    }

    public void changeSearchListener(AbstractMainView fromView) {
        AbstractMainView mainView = this.rtext.getMainView();
        if (this.findDialog != null) {
            this.findDialog.removeSearchListener((SearchListener)fromView);
            this.findDialog.addSearchListener((SearchListener)mainView);
            this.replaceDialog.removeSearchListener((SearchListener)fromView);
            this.replaceDialog.addSearchListener((SearchListener)mainView);
        }
        if (this.findToolBar != null) {
            this.findToolBar.removeSearchListener((SearchListener)fromView);
            this.replaceToolBar.addSearchListener((SearchListener)mainView);
        }
    }

    private void configureSearchDialog(AbstractFindReplaceDialog dialog) {
        AbstractMainView mainView = this.rtext.getMainView();
        dialog.setSearchContext((SearchContext)mainView.searchContext);
        this.rtext.registerChildWindowListeners((Window)dialog);
    }

    private void ensureSearchDialogsCreated() {
        if (this.replaceDialog == null) {
            AbstractMainView mainView = this.rtext.getMainView();
            this.findDialog = new FindDialog((Frame)((Object)this.rtext), (SearchListener)mainView);
            this.configureSearchDialog((AbstractFindReplaceDialog)this.findDialog);
            this.replaceDialog = new ReplaceDialog((Frame)((Object)this.rtext), (SearchListener)mainView);
            this.configureSearchDialog((AbstractFindReplaceDialog)this.replaceDialog);
        }
    }

    private void ensureToolbarsCreated() {
        if (this.findToolBar == null) {
            AbstractMainView mainView = this.rtext.getMainView();
            CollapsibleSectionPanel csp = this.rtext.getCollapsibleSectionPanel();
            this.findToolBar = new FindToolBar((SearchListener)mainView);
            this.findToolBar.setSearchContext((SearchContext)mainView.searchContext);
            csp.addBottomComponent((JComponent)this.findToolBar);
            this.replaceToolBar = new ReplaceToolBar((SearchListener)mainView);
            this.replaceToolBar.setSearchContext((SearchContext)mainView.searchContext);
            csp.addBottomComponent((JComponent)this.replaceToolBar);
        }
    }

    public void findNext() {
        AbstractMainView mainView = this.rtext.getMainView();
        FindInFilesSearchContext context = mainView.searchContext;
        String searchString = mainView.searchContext.getSearchFor();
        if (searchString == null || searchString.length() == 0) {
            switch (this.searchingMode) {
                case DIALOGS: {
                    this.ensureSearchDialogsCreated();
                    this.findDialog.setVisible(true);
                    break;
                }
                case TOOLBARS: {
                    this.ensureToolbarsCreated();
                    this.rtext.getCollapsibleSectionPanel().showBottomComponent((JComponent)this.findToolBar);
                }
            }
            return;
        }
        RTextEditorPane textArea = mainView.getCurrentTextArea();
        try {
            SearchResult result = SearchEngine.find(textArea, context);
            if (!result.wasFound()) {
                searchString = RTextUtilities.escapeForHTML(searchString, null);
                String temp = this.rtext.getString("CannotFindString", new Object[]{searchString});
                JOptionPane.showMessageDialog(null, temp, this.rtext.getString("InfoDialogHeader", new Object[0]), 1);
            }
            if (this.isNoSearchUIVisible()) {
                textArea.requestFocusInWindow();
            }
        }
        catch (PatternSyntaxException pse) {
            JOptionPane.showMessageDialog((Component)((Object)this.rtext), "Invalid regular expression:\n" + pse.toString() + "\nPlease check your regular expression search string.", "Error", 0);
        }
    }

    public SearchingMode getSearchingMode() {
        return this.searchingMode;
    }

    private void hideFindDialogIfVisible() {
        if (this.findDialog != null && this.findDialog.isVisible()) {
            this.findDialog.setVisible(false);
        }
    }

    private void hideReplaceDialogIfVisible() {
        if (this.replaceDialog != null && this.replaceDialog.isVisible()) {
            this.replaceDialog.setVisible(false);
        }
    }

    private boolean isNoSearchUIVisible() {
        return !(this.findDialog != null && this.findDialog.isVisible() || this.replaceDialog != null && this.replaceDialog.isVisible() || this.rtext.getCollapsibleSectionPanel().getDisplayedBottomComponent() != null);
    }

    public void refreshDialogTranslucencies(ChildWindowListener listener) {
        if (this.findDialog != null && this.findDialog.isShowing()) {
            listener.refreshTranslucency((Window)this.findDialog);
        }
        if (this.replaceDialog != null && this.replaceDialog.isShowing()) {
            listener.refreshTranslucency((Window)this.replaceDialog);
        }
    }

    public void replaceNext() {
        AbstractMainView mainView = this.rtext.getMainView();
        FindInFilesSearchContext context = mainView.searchContext;
        String searchString = context.getSearchFor();
        if (searchString == null || searchString.length() == 0) {
            switch (this.searchingMode) {
                case DIALOGS: {
                    this.ensureSearchDialogsCreated();
                    this.replaceDialog.setVisible(true);
                    break;
                }
                case TOOLBARS: {
                    this.ensureToolbarsCreated();
                    this.rtext.getCollapsibleSectionPanel().showBottomComponent((JComponent)this.replaceToolBar);
                }
            }
            return;
        }
        RTextEditorPane textArea = mainView.getCurrentTextArea();
        try {
            SearchResult result = SearchEngine.replace(textArea, context);
            if (!result.wasFound()) {
                searchString = RTextUtilities.escapeForHTML(searchString, null);
                String temp = this.rtext.getString("CannotFindString", new Object[]{searchString});
                JOptionPane.showMessageDialog(null, temp, this.rtext.getString("InfoDialogHeader", new Object[0]), 1);
            }
            if (this.isNoSearchUIVisible()) {
                textArea.requestFocusInWindow();
            }
        }
        catch (PatternSyntaxException pse) {
            JOptionPane.showMessageDialog((Component)((Object)this.rtext), "Invalid regular expression:\n" + pse.toString() + "\nPlease check your regular expression search string.", "Error", 0);
        }
        catch (IndexOutOfBoundsException ioobe) {
            JOptionPane.showMessageDialog((Component)((Object)this.rtext), "Invalid group reference in replacement string:\n" + ioobe.getMessage(), "Error", 0);
        }
    }

    public void setSearchingMode(SearchingMode mode) {
        if (mode == null) {
            throw new NullPointerException("mode cannot be null");
        }
        CollapsibleSectionPanel csp = this.rtext.getCollapsibleSectionPanel();
        if (csp != null) {
            switch (mode) {
                case DIALOGS: {
                    csp.hideBottomComponent();
                    break;
                }
                case TOOLBARS: {
                    this.hideFindDialogIfVisible();
                    this.hideReplaceDialogIfVisible();
                }
            }
        }
        this.searchingMode = mode;
    }

    public void showFindUI() {
        if (this.searchingMode == SearchingMode.DIALOGS) {
            this.rtext.getCollapsibleSectionPanel().hideBottomComponent();
            this.ensureSearchDialogsCreated();
            if (this.replaceDialog.isVisible()) {
                this.replaceDialog.setVisible(false);
            }
            if (!this.findDialog.isVisible()) {
                RTextEditorPane editor = this.rtext.getMainView().getCurrentTextArea();
                String selectedText = editor.getSelectedText();
                if (selectedText != null) {
                    this.findDialog.setSearchString(selectedText);
                }
                this.findDialog.setVisible(true);
            } else {
                this.findDialog.requestFocus();
            }
        } else {
            this.hideFindDialogIfVisible();
            this.hideReplaceDialogIfVisible();
            this.ensureToolbarsCreated();
            this.rtext.getCollapsibleSectionPanel().showBottomComponent((JComponent)this.findToolBar);
        }
    }

    public void showReplaceUI() {
        if (this.searchingMode == SearchingMode.DIALOGS) {
            this.rtext.getCollapsibleSectionPanel().hideBottomComponent();
            this.ensureSearchDialogsCreated();
            if (this.findDialog.isVisible()) {
                this.findDialog.setVisible(false);
            }
            if (!this.replaceDialog.isVisible()) {
                RTextEditorPane editor = this.rtext.getMainView().getCurrentTextArea();
                String selectedText = editor.getSelectedText();
                if (selectedText != null) {
                    this.replaceDialog.setSearchString(selectedText);
                }
                this.replaceDialog.setVisible(true);
            } else {
                this.replaceDialog.requestFocus();
            }
        } else {
            this.hideFindDialogIfVisible();
            this.hideReplaceDialogIfVisible();
            this.ensureToolbarsCreated();
            this.rtext.getCollapsibleSectionPanel().showBottomComponent((JComponent)this.replaceToolBar);
        }
    }

    public void updateUI() {
        if (this.findDialog != null) {
            SwingUtilities.updateComponentTreeUI((Component)this.findDialog);
            this.findDialog.updateUI();
            this.findDialog.pack();
            SwingUtilities.updateComponentTreeUI((Component)this.replaceDialog);
            this.replaceDialog.updateUI();
            this.replaceDialog.pack();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchingMode {
        DIALOGS,
        TOOLBARS;

    }
}

