/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2.data;

import com.sshtools.j2ssh.SshClient;
import edu.harvard.mgh.purcell.gCLINE.StartFrame;
import edu.harvard.mgh.purcell.gCLINE.data.AutoUpdater;
import edu.harvard.mgh.purcell.gCLINE.data.Record;
import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class Project
extends Record {
    private static Logger logger = Logger.getLogger(Project.class);
    static String PLINK_PATH = "plink_path";
    static String PLINK_PREFIX = "plink_prefix";
    static String HAPLOVIEW_PATH = "haploview";
    static String HAPLOVIEW_APPEND = "haplo_append";
    public static String GPLINK_EXT = ".gplink";

    public void setHaploAppend(String append) {
        this.globalConfig.setProperty(HAPLOVIEW_APPEND, append);
    }

    public void setHaploPath(String path) {
        this.globalConfig.setProperty(HAPLOVIEW_PATH, path);
    }

    public void setPlinkPath(String path) {
        if (this.isRemote()) {
            this.remoteConfig.setProperty(PLINK_PATH, path);
        } else {
            this.globalConfig.setProperty(PLINK_PATH, path);
        }
    }

    public void setPlinkPrefix(String path) {
        if (this.isRemote()) {
            this.remoteConfig.setProperty(PLINK_PREFIX, path);
        } else {
            this.globalConfig.setProperty(PLINK_PREFIX, path);
        }
    }

    public String getHaploAppend() {
        return this.globalConfig.getProperty(HAPLOVIEW_APPEND, "");
    }

    public String getHaploPath() {
        return this.globalConfig.getProperty(HAPLOVIEW_PATH, "");
    }

    public String getPlinkPath() {
        if (this.isRemote()) {
            return this.remoteConfig.getProperty(PLINK_PATH, "plink");
        }
        return this.globalConfig.getProperty(PLINK_PATH, "plink");
    }

    public String getPlinkPrefix() {
        if (this.isRemote()) {
            return this.remoteConfig.getProperty(PLINK_PREFIX, "");
        }
        return this.globalConfig.getProperty(PLINK_PREFIX, "");
    }

    public Project() {
        logger.info("[Project()] create a Project");
    }

    public Project(GPLINK f) {
        super(f);
        logger.info("[Project(GPLINK)] create a Project");
    }

    public Project(GPLINK f, String localName) {
        super(f, localName);
        logger.info("[Project(GPLINK, String)] Entering...");
        this.setAutoUpdater(new AutoUpdater(f, this, GPLINK_EXT, this.frame.messanger, this.getLocalUpdateSec()));
        logger.info("[Project(GPLINK, String)] ...exiting");
    }

    public Project(GPLINK f, String localName, String remoteFileName, String hostname, String username, String portnum, SshClient c) {
        super(f, localName, remoteFileName, hostname, username, portnum, c);
        logger.info("[Project(GPLINK, String,... SshClient)] Entering...");
        this.setAutoUpdater(new AutoUpdater(f, this, GPLINK_EXT, this.frame.messanger, this.getRemoteUpdateSec()));
        logger.info("[Project(GPLINK, String,... SshClient)] ...exiting");
    }

    public void setAutoUpdater(AutoUpdater given) {
        if (this.update != null) {
            this.update.cancel();
            this.update = null;
        }
        this.update = given;
    }

    protected void saveRemoteConfig() {
        logger.info("[saveRemoteConfig()] Entering...");
        Properties oldConfig = this.globalConfig;
        if (!this.isRemote()) {
            return;
        }
        logger.info("[saveRemoteConfig()] saving remote");
        StartFrame startFrame = this.frame;
        startFrame.getClass();
        Thread downloader = new Thread(startFrame.new StartFrame.Download(this, true, this.getLocalFolder(), new String[]{".gplink_config"}));
        downloader.start();
        try {
            downloader.join();
        }
        catch (InterruptedException e) {
            logger.error("[saveRemoteConfig()] InterruptedException occured downloading the global configuration file on the remote machine.");
            this.frame.messanger.createError("InterruptedException occured downloading the global configuration file on the remote machine", "saveRemoteConfig()@Project.java");
        }
        Properties remoteConfig = new Properties();
        File config = new File(this.getLocalFolder(), ".gplink_config");
        try {
            remoteConfig.load(new FileInputStream(config));
        }
        catch (FileNotFoundException e) {
            logger.warn("[saveRemoteConfig()] FileNotFoundException occured trying to load downloaded configuration file. {" + config.getAbsolutePath() + "}");
        }
        catch (IOException e) {
            logger.warn("[saveRemoteConfig()] IOException occured trying to load downloaded configuration file.");
        }
        Properties localConfig = new Properties();
        File localConfigFile = new File(GLOBAL_CONFIG);
        try {
            localConfig.load(new FileInputStream(localConfigFile));
        }
        catch (FileNotFoundException e) {
            logger.error("[saveRemoteConfig()] FileNotFoundException occured trying to load local configuration file. {" + localConfigFile.getAbsolutePath() + "}");
            this.frame.messanger.createError("FileNotFoundException occured trying to load local configuration file. {" + localConfigFile.getAbsolutePath() + "}", "saveRemoteConfig()@Project.java");
        }
        catch (IOException e) {
            logger.error("[saveRemoteConfig()] IOException occured trying to load local configuration file.");
            this.frame.messanger.createError("IOException occured trying to load local configuration file.", "saveRemoteConfig()@Project.java");
        }
        logger.info("[saveRemoteConfig()] setting the remote plink: {" + this.getPlinkPrefix() + "} {" + this.getPlinkPath() + "}");
        remoteConfig.setProperty(PLINK_PATH, this.getPlinkPath());
        remoteConfig.setProperty(PLINK_PREFIX, this.getPlinkPrefix());
        this.globalConfig.setProperty(PLINK_PATH, localConfig.getProperty(PLINK_PATH, "plink"));
        this.globalConfig.setProperty(PLINK_PREFIX, localConfig.getProperty(PLINK_PREFIX, ""));
        try {
            remoteConfig.store(new FileOutputStream(config), "");
        }
        catch (FileNotFoundException e) {
            logger.error("[saveRemoteConfig()] FileNotFoundException occured trying to store remote configuration file. {" + config.getAbsolutePath() + "}");
            this.frame.messanger.createError("FileNotFoundException occured trying to store remote configuration file. {" + config.getAbsolutePath() + "}", "saveRemoteConfig()@Project.java");
        }
        catch (IOException e) {
            logger.error("[saveRemoteConfig()] IOException occured trying to store remote configuration file.");
            this.frame.messanger.createError("IOException occured trying to store remote configuration file.", "saveRemoteConfig()@Project.java");
        }
        StartFrame startFrame2 = this.frame;
        startFrame2.getClass();
        Thread uploader = new Thread(startFrame2.new StartFrame.Upload(this, false, "", new File[]{config}));
        uploader.start();
        try {
            uploader.join();
        }
        catch (InterruptedException e1) {
            logger.error("[saveRemoteConfig()] InterruptedException occured uploading the global configuration file on the remote machine.");
            this.frame.messanger.createError("InterruptedException occured uploading the global configuration file on the remote machine", "saveRemoteConfig()@Project.java");
        }
        try {
            this.globalConfig.store(new FileOutputStream(localConfigFile), "");
        }
        catch (FileNotFoundException e) {
            logger.error("[saveRemoteConfig()] FileNotFoundException occured trying to store local configuration file. {" + localConfigFile.getAbsolutePath() + "}");
            this.frame.messanger.createError("FileNotFoundException occured trying to store local configuration file. {" + localConfigFile.getAbsolutePath() + "}", "saveRemoteConfig()@Project.java");
        }
        catch (IOException e) {
            logger.error("[saveRemoteConfig()] IOException occured trying to store local configuration file.");
            this.frame.messanger.createError("IOException occured trying to store local configuration file.", "saveRemoteConfig()@Project.java");
        }
        this.globalConfig = oldConfig;
        logger.info("[saveRemoteConfig()] ...Exiting");
    }

    protected void loadRemoteConfig() {
        logger.info("[loadRemoteConfig()] Entering...");
        if (this.isRemote()) {
            StartFrame startFrame = this.frame;
            startFrame.getClass();
            Thread downloader = new Thread(startFrame.new StartFrame.Download(this, true, this.getLocalFolder(), new String[]{".gplink_config"}));
            downloader.start();
            try {
                downloader.join();
            }
            catch (InterruptedException e) {
                logger.error("[loadRemoteConfig()] InteruptionException occured trying to download remote global configuration file.");
                this.frame.messanger.createError("InteruptionException occured trying to download remote global configuration file.", "loadRemoteConfig()@Project.java");
            }
            Properties tempConfig = new Properties();
            File config = new File(this.getLocalFolder(), ".gplink_config");
            try {
                tempConfig.load(new FileInputStream(config));
            }
            catch (FileNotFoundException e) {
                logger.warn("[loadRemoteConfig()] FileNotFoundException occured trying to load remote global configuration file.");
            }
            catch (IOException e) {
                logger.warn("[loadRemoteConfig()] IOException occured trying to load remote global configuration file.");
            }
            String path = tempConfig.getProperty(PLINK_PATH, "plink");
            String prefix = tempConfig.getProperty(PLINK_PREFIX, "");
            logger.info("[loadRemoteConfig()] replacing plink: {" + prefix + "} {" + path + "}");
            this.setPlinkPath(path);
            this.setPlinkPrefix(prefix);
            config.delete();
        }
        logger.info("[loadRemoteConfig] ...exiting");
    }
}

