/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.mgh.purcell.gPLINK2.baseForm;

import edu.harvard.mgh.purcell.gCLINE.data.FileInfo;
import edu.harvard.mgh.purcell.gPLINK2.GPLINK;
import edu.harvard.mgh.purcell.gPLINK2.baseForm.Form;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InputPane
extends JTabbedPane {
    private static Logger logger = Logger.getLogger(InputPane.class);
    private GPLINK parent;
    private Form parentForm;
    public boolean validInput = false;
    private static float my_alignment = 1.0f;
    private JCheckBox binCheck;
    private JComboBox binShort;
    private JTextField bedField;
    private Form.BrowseButton bedBrowse;
    private JTextField bimField;
    private Form.BrowseButton bimBrowse;
    private JTextField famField;
    private Form.BrowseButton famBrowse;
    private JCheckBox stdCheck;
    private JComboBox stdShort;
    private JTextField pedField;
    private Form.BrowseButton pedBrowse;
    private JTextField mapField;
    private Form.BrowseButton mapBrowse;
    private JCheckBox useAlt;
    private JTextField altField;
    private Form.BrowseButton altBrowse;
    private JCheckBox useColm;
    private JTextField mphenoText;
    DocumentListener checkFields = new DocumentListener(){

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            if (InputPane.this.okInput() != InputPane.this.validInput) {
                InputPane.this.validInput = !InputPane.this.validInput;
                InputPane.this.parentForm.okForm();
            }
        }

        public void removeUpdate(DocumentEvent e) {
            if (InputPane.this.okInput() != InputPane.this.validInput) {
                InputPane.this.validInput = !InputPane.this.validInput;
                InputPane.this.parentForm.okForm();
            }
        }
    };

    private JPanel bundle(JLabel label, JTextField field, Form.BrowseButton browse) {
        JPanel ans = new JPanel();
        ans.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        ans.setAlignmentX(my_alignment);
        ans.add((Component)label, c);
        c.gridx = 1;
        c.weightx = 1.0;
        ans.add((Component)field, c);
        c.gridx = 2;
        c.weightx = 0.0;
        ans.add((Component)browse, c);
        return ans;
    }

    private JPanel createStd() {
        JPanel ans = new JPanel();
        ans.setLayout(new BoxLayout(ans, 3));
        ans.setAlignmentX(my_alignment);
        JPanel quick = new JPanel();
        quick.setLayout(new BoxLayout(quick, 2));
        quick.setBorder(new TitledBorder("Quick Fileset"));
        quick.setAlignmentX(my_alignment);
        quick.add(this.stdCheck);
        this.stdCheck.setAlignmentX(my_alignment);
        quick.add(this.stdShort);
        this.stdShort.setAlignmentX(my_alignment);
        ans.add(quick);
        ans.add(this.bundle(new JLabel(".ped file"), this.pedField, this.pedBrowse));
        ans.add(this.bundle(new JLabel(".map file"), this.mapField, this.mapBrowse));
        return ans;
    }

    private JPanel createBinary() {
        JPanel ans = new JPanel();
        ans.setAlignmentX(my_alignment);
        ans.setLayout(new BoxLayout(ans, 3));
        JPanel quick = new JPanel();
        quick.setLayout(new BoxLayout(quick, 2));
        quick.setBorder(new TitledBorder("Quick Fileset"));
        quick.setAlignmentX(my_alignment);
        quick.add(this.binCheck);
        this.binCheck.setAlignmentX(my_alignment);
        quick.add(this.binShort);
        this.binShort.setAlignmentX(my_alignment);
        ans.add(quick);
        ans.add(this.bundle(new JLabel(".bed file"), this.bedField, this.bedBrowse));
        ans.add(this.bundle(new JLabel(".bim file"), this.bimField, this.bimBrowse));
        ans.add(this.bundle(new JLabel(".fam file"), this.famField, this.famBrowse));
        return ans;
    }

    private JPanel createAltPheno() {
        JPanel ans = new JPanel();
        ans.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weightx = 1.0;
        ans.setAlignmentX(my_alignment);
        JPanel altPanel = new JPanel();
        altPanel.setLayout(new BoxLayout(altPanel, 2));
        altPanel.setAlignmentX(my_alignment);
        altPanel.add(this.useAlt);
        altPanel.add(this.altField);
        altPanel.add(this.altBrowse);
        ans.add((Component)altPanel, c);
        JPanel colPanel = new JPanel();
        colPanel.setLayout(new BoxLayout(colPanel, 2));
        colPanel.setAlignmentX(my_alignment);
        colPanel.add(this.useColm);
        colPanel.add(this.mphenoText);
        this.mphenoText.setMaximumSize(this.mphenoText.getPreferredSize());
        colPanel.add(Box.createHorizontalGlue());
        c.gridy = 1;
        ans.add((Component)colPanel, c);
        c.gridy = 2;
        ans.add((Component)new JLabel("Note: You must tab to the Standard/Binary Input tabs after setting the alternative phenotype."), c);
        return ans;
    }

    public Vector<String> getStdRoots() {
        Vector<String> fileList = this.parent.data.getHomeFiles();
        HashMap<String, Integer> allfileroots = new HashMap<String, Integer>();
        for (String file : fileList) {
            if (!file.endsWith(".ped") && !file.endsWith(".map")) continue;
            String fileroot = FileInfo.fileName(file);
            if (allfileroots.containsKey(fileroot = fileroot.substring(0, fileroot.length() - 4))) {
                allfileroots.put(fileroot, (Integer)allfileroots.get(fileroot) + 1);
                continue;
            }
            allfileroots.put(fileroot, new Integer(1));
        }
        Vector<String> ans = new Vector<String>();
        if (allfileroots.isEmpty()) {
            ans.add("");
        } else {
            for (String key : allfileroots.keySet()) {
                if (!((Integer)allfileroots.get(key)).equals(new Integer(2))) continue;
                ans.add(key);
            }
        }
        Collections.sort(ans);
        return ans;
    }

    public Vector<String> getBinRoots() {
        Vector<String> fileList = this.parent.data.getHomeFiles();
        HashMap<String, Integer> allfileroots = new HashMap<String, Integer>();
        for (String file : fileList) {
            if (!file.endsWith(".bed") && !file.endsWith(".fam") && !file.endsWith("bim")) continue;
            String fileroot = FileInfo.fileName(file);
            if (allfileroots.containsKey(fileroot = fileroot.substring(0, fileroot.length() - 4))) {
                allfileroots.put(fileroot, (Integer)allfileroots.get(fileroot) + 1);
                continue;
            }
            allfileroots.put(fileroot, new Integer(1));
        }
        Vector<String> ans = new Vector<String>();
        if (allfileroots.isEmpty()) {
            ans.add("");
        } else {
            for (String key : allfileroots.keySet()) {
                if (!((Integer)allfileroots.get(key)).equals(new Integer(3))) continue;
                ans.add(key);
            }
        }
        Collections.sort(ans);
        return ans;
    }

    private void intialize() {
        this.stdShort = new JComboBox<String>(this.getStdRoots());
        this.pedField = new JTextField(30);
        this.pedField.getDocument().addDocumentListener(this.checkFields);
        Form form = this.parentForm;
        form.getClass();
        this.pedBrowse = form.new Form.BrowseButton(this.pedField, ".ped", "PED file");
        this.mapField = new JTextField(30);
        this.mapField.getDocument().addDocumentListener(this.checkFields);
        Form form2 = this.parentForm;
        form2.getClass();
        this.mapBrowse = form2.new Form.BrowseButton(this.mapField, ".map", "MAP file");
        this.stdCheck = new JCheckBox();
        this.stdCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                logger.info("(itemStateChanged) standard check box toggled");
                boolean state = InputPane.this.stdCheck.isSelected();
                InputPane.this.stdShort.setEnabled(state);
                InputPane.this.pedField.setEnabled(!state);
                InputPane.this.pedBrowse.setEnabled(!state);
                InputPane.this.mapField.setEnabled(!state);
                InputPane.this.mapBrowse.setEnabled(!state);
                if (InputPane.this.okInput() != InputPane.this.validInput) {
                    InputPane.this.validInput = !InputPane.this.validInput;
                    InputPane.this.parentForm.okForm();
                }
            }
        });
        this.stdCheck.setSelected(true);
        this.binShort = new JComboBox<String>(this.getBinRoots());
        this.bedField = new JTextField(30);
        this.bedField.getDocument().addDocumentListener(this.checkFields);
        Form form3 = this.parentForm;
        form3.getClass();
        this.bedBrowse = form3.new Form.BrowseButton(this.bedField, ".bed", "BED file");
        this.bimField = new JTextField(30);
        this.bimField.getDocument().addDocumentListener(this.checkFields);
        Form form4 = this.parentForm;
        form4.getClass();
        this.bimBrowse = form4.new Form.BrowseButton(this.bimField, ".bim", "BIM file");
        this.famField = new JTextField(30);
        this.famField.getDocument().addDocumentListener(this.checkFields);
        Form form5 = this.parentForm;
        form5.getClass();
        this.famBrowse = form5.new Form.BrowseButton(this.famField, ".fam", "FAM file");
        this.binCheck = new JCheckBox();
        this.binCheck.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                logger.info("(itemStateChanged) binary check box toggled");
                boolean state = InputPane.this.binCheck.isSelected();
                InputPane.this.binShort.setEnabled(state);
                InputPane.this.bedField.setEnabled(!state);
                InputPane.this.bedBrowse.setEnabled(!state);
                InputPane.this.bimField.setEnabled(!state);
                InputPane.this.bimBrowse.setEnabled(!state);
                InputPane.this.famField.setEnabled(!state);
                InputPane.this.famBrowse.setEnabled(!state);
                if (InputPane.this.okInput() != InputPane.this.validInput) {
                    InputPane.this.validInput = !InputPane.this.validInput;
                    InputPane.this.parentForm.okForm();
                }
            }
        });
        this.binCheck.setSelected(true);
        this.altField = new JTextField(20);
        this.altField.getDocument().addDocumentListener(this.checkFields);
        Form form6 = this.parentForm;
        form6.getClass();
        this.altBrowse = form6.new Form.BrowseButton(this.altField, "phe", "PHE file");
        this.mphenoText = new JTextField(5);
        this.mphenoText.getDocument().addDocumentListener(this.checkFields);
        this.useColm = new JCheckBox("use column (--mpheno)");
        this.useColm.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                logger.info("(itemStateChanged) column check box toggled");
                boolean state = InputPane.this.useColm.isSelected();
                InputPane.this.mphenoText.setEnabled(state);
                if (InputPane.this.okInput() != InputPane.this.validInput) {
                    InputPane.this.validInput = !InputPane.this.validInput;
                    InputPane.this.parentForm.okForm();
                }
            }
        });
        this.useColm.setSelected(false);
        this.useAlt = new JCheckBox("use alternative phenotype");
        this.useAlt.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                logger.info("(itemStateChanged) alternative phenotype check box toggled");
                boolean state = InputPane.this.useAlt.isSelected();
                InputPane.this.altField.setEnabled(state);
                InputPane.this.altBrowse.setEnabled(state);
                InputPane.this.useColm.setEnabled(state);
                if (InputPane.this.okInput() != InputPane.this.validInput) {
                    InputPane.this.validInput = !InputPane.this.validInput;
                    InputPane.this.parentForm.okForm();
                }
            }
        });
        this.useAlt.setSelected(false);
    }

    public InputPane(GPLINK p, Form p2) {
        this.parent = p;
        this.parentForm = p2;
        this.intialize();
        this.addTab("Binary Input", this.createBinary());
        this.addTab("Standard Input", this.createStd());
        this.addTab("Alternate Phenotype", this.createAltPheno());
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                logger.info("(stateChanged) shifting tabs.");
                if (InputPane.this.okInput() != InputPane.this.validInput) {
                    InputPane.this.validInput = !InputPane.this.validInput;
                    InputPane.this.parentForm.okForm();
                }
            }
        });
        this.validInput = this.okInput();
    }

    public String process() {
        String ans = "";
        if (this.getSelectedIndex() == 0) {
            ans = this.binCheck.isSelected() ? "--bfile " + FileInfo.quote(String.valueOf(this.parent.data.getHomeFolder()) + this.binShort.getSelectedItem().toString()) : "--bed " + FileInfo.quote(this.bedField.getText()) + " --bim " + FileInfo.quote(this.bimField.getText()) + " --fam " + FileInfo.quote(this.famField.getText());
        } else if (this.getSelectedIndex() == 1) {
            ans = this.stdCheck.isSelected() ? "--file " + FileInfo.quote(String.valueOf(this.parent.data.getHomeFolder()) + this.stdShort.getSelectedItem().toString()) : "--map " + FileInfo.quote(this.mapField.getText()) + " --ped " + FileInfo.quote(this.pedField.getText());
        }
        if (this.useAlt.isSelected()) {
            ans = String.valueOf(ans) + " --pheno " + FileInfo.quote(this.altField.getText());
            if (this.useColm.isSelected()) {
                ans = String.valueOf(ans) + " --mpheno " + this.mphenoText.getText();
            }
        }
        return ans;
    }

    public boolean okInput() {
        logger.info("(okInput()) entering input pane check");
        if (this.getSelectedIndex() != 0 && this.getSelectedIndex() != 1) {
            return false;
        }
        if (this.getSelectedIndex() == 0 && (this.binCheck.isSelected() ? this.binShort.getSelectedItem() == null || this.binShort.getSelectedItem().toString().matches("^\\s*$") : this.bedField.getText().matches("^\\s*$") || this.bedField.getText().equals("") || this.bimField.getText().matches("^\\s*$") || this.bimField.getText().equals("") || this.famField.getText().matches("^\\s*$") || this.famField.getText().equals(""))) {
            return false;
        }
        return this.getSelectedIndex() != 1 || !(this.stdCheck.isSelected() ? this.stdShort.getSelectedItem() == null || this.stdShort.getSelectedItem().toString().matches("\\s") : this.mapField.getText().matches("\\s") || this.mapField.getText().equals("") || this.pedField.getText().matches("\\s") || this.pedField.getText().equals(""));
    }
}

