/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.transport.kex;

import com.sshtools.j2ssh.SshException;
import com.sshtools.j2ssh.transport.AlgorithmNotSupportedException;
import com.sshtools.j2ssh.transport.AlgorithmOperationException;
import com.sshtools.j2ssh.transport.kex.KeyExchangeException;
import com.sshtools.j2ssh.transport.kex.SshKeyExchange;
import com.sshtools.j2ssh.transport.kex.SshMsgKexDhInit;
import com.sshtools.j2ssh.transport.kex.SshMsgKexDhReply;
import com.sshtools.j2ssh.transport.publickey.SshPrivateKey;
import com.sshtools.j2ssh.util.Hash;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DhGroup1Sha1
extends SshKeyExchange {
    private static Log log = LogFactory.getLog(DhGroup1Sha1.class);
    private static BigInteger g = new BigInteger("2");
    private static BigInteger p;
    private BigInteger e = null;
    private BigInteger f = null;
    private BigInteger x = null;
    private BigInteger y = null;
    private String clientId;
    private String serverId;
    private byte[] clientKexInit;
    private byte[] serverKexInit;
    private KeyPairGenerator dhKeyPairGen;
    private KeyAgreement dhKeyAgreement;

    static {
        byte[] byArray = new byte[129];
        byArray[1] = -1;
        byArray[2] = -1;
        byArray[3] = -1;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byArray[9] = -55;
        byArray[10] = 15;
        byArray[11] = -38;
        byArray[12] = -94;
        byArray[13] = 33;
        byArray[14] = 104;
        byArray[15] = -62;
        byArray[16] = 52;
        byArray[17] = -60;
        byArray[18] = -58;
        byArray[19] = 98;
        byArray[20] = -117;
        byArray[21] = -128;
        byArray[22] = -36;
        byArray[23] = 28;
        byArray[24] = -47;
        byArray[25] = 41;
        byArray[26] = 2;
        byArray[27] = 78;
        byArray[28] = 8;
        byArray[29] = -118;
        byArray[30] = 103;
        byArray[31] = -52;
        byArray[32] = 116;
        byArray[33] = 2;
        byArray[34] = 11;
        byArray[35] = -66;
        byArray[36] = -90;
        byArray[37] = 59;
        byArray[38] = 19;
        byArray[39] = -101;
        byArray[40] = 34;
        byArray[41] = 81;
        byArray[42] = 74;
        byArray[43] = 8;
        byArray[44] = 121;
        byArray[45] = -114;
        byArray[46] = 52;
        byArray[47] = 4;
        byArray[48] = -35;
        byArray[49] = -17;
        byArray[50] = -107;
        byArray[51] = 25;
        byArray[52] = -77;
        byArray[53] = -51;
        byArray[54] = 58;
        byArray[55] = 67;
        byArray[56] = 27;
        byArray[57] = 48;
        byArray[58] = 43;
        byArray[59] = 10;
        byArray[60] = 109;
        byArray[61] = -14;
        byArray[62] = 95;
        byArray[63] = 20;
        byArray[64] = 55;
        byArray[65] = 79;
        byArray[66] = -31;
        byArray[67] = 53;
        byArray[68] = 109;
        byArray[69] = 109;
        byArray[70] = 81;
        byArray[71] = -62;
        byArray[72] = 69;
        byArray[73] = -28;
        byArray[74] = -123;
        byArray[75] = -75;
        byArray[76] = 118;
        byArray[77] = 98;
        byArray[78] = 94;
        byArray[79] = 126;
        byArray[80] = -58;
        byArray[81] = -12;
        byArray[82] = 76;
        byArray[83] = 66;
        byArray[84] = -23;
        byArray[85] = -90;
        byArray[86] = 55;
        byArray[87] = -19;
        byArray[88] = 107;
        byArray[89] = 11;
        byArray[90] = -1;
        byArray[91] = 92;
        byArray[92] = -74;
        byArray[93] = -12;
        byArray[94] = 6;
        byArray[95] = -73;
        byArray[96] = -19;
        byArray[97] = -18;
        byArray[98] = 56;
        byArray[99] = 107;
        byArray[100] = -5;
        byArray[101] = 90;
        byArray[102] = -119;
        byArray[103] = -97;
        byArray[104] = -91;
        byArray[105] = -82;
        byArray[106] = -97;
        byArray[107] = 36;
        byArray[108] = 17;
        byArray[109] = 124;
        byArray[110] = 75;
        byArray[111] = 31;
        byArray[112] = -26;
        byArray[113] = 73;
        byArray[114] = 40;
        byArray[115] = 102;
        byArray[116] = 81;
        byArray[117] = -20;
        byArray[118] = -26;
        byArray[119] = 83;
        byArray[120] = -127;
        byArray[121] = -1;
        byArray[122] = -1;
        byArray[123] = -1;
        byArray[124] = -1;
        byArray[125] = -1;
        byArray[126] = -1;
        byArray[127] = -1;
        byArray[128] = -1;
        p = new BigInteger(byArray);
    }

    protected void onInit() throws IOException {
        this.messageStore.registerMessage(30, SshMsgKexDhInit.class);
        this.messageStore.registerMessage(31, SshMsgKexDhReply.class);
        try {
            this.dhKeyPairGen = KeyPairGenerator.getInstance("DH");
            this.dhKeyAgreement = KeyAgreement.getInstance("DH");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AlgorithmNotSupportedException(ex.getMessage());
        }
    }

    public void performClientExchange(String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit) throws IOException {
        log.info("Starting client side key exchange.");
        this.clientId = clientId;
        this.serverId = serverId;
        this.clientKexInit = clientKexInit;
        this.serverKexInit = serverKexInit;
        try {
            DHParameterSpec dhSkipParamSpec = new DHParameterSpec(p, g);
            this.dhKeyPairGen.initialize(dhSkipParamSpec);
            KeyPair dhKeyPair = this.dhKeyPairGen.generateKeyPair();
            this.dhKeyAgreement.init(dhKeyPair.getPrivate());
            this.x = ((DHPrivateKey)dhKeyPair.getPrivate()).getX();
            this.e = ((DHPublicKey)dhKeyPair.getPublic()).getY();
        }
        catch (InvalidKeyException ex) {
            throw new AlgorithmOperationException("Failed to generate DH value");
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new AlgorithmOperationException("Failed to generate DH value");
        }
        SshMsgKexDhInit msg = new SshMsgKexDhInit(this.e);
        try {
            this.transport.sendMessage(msg, this);
        }
        catch (SshException tpe) {
            throw new KeyExchangeException("Failed to send key exchange initialization message");
        }
        int[] messageId = new int[]{31};
        SshMsgKexDhReply reply = (SshMsgKexDhReply)this.transport.readMessage(messageId);
        this.hostKey = reply.getHostKey();
        this.signature = reply.getSignature();
        this.f = reply.getF();
        this.secret = this.f.modPow(this.x, p);
        this.calculateExchangeHash();
    }

    public void performServerExchange(String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit, SshPrivateKey prvKey) throws IOException {
        try {
            this.clientId = clientId;
            this.serverId = serverId;
            this.clientKexInit = clientKexInit;
            this.serverKexInit = serverKexInit;
            try {
                DHParameterSpec dhSkipParamSpec = new DHParameterSpec(p, g);
                this.dhKeyPairGen.initialize(dhSkipParamSpec);
                KeyPair dhKeyPair = this.dhKeyPairGen.generateKeyPair();
                this.dhKeyAgreement.init(dhKeyPair.getPrivate());
                this.y = ((DHPrivateKey)dhKeyPair.getPrivate()).getX();
                this.f = ((DHPublicKey)dhKeyPair.getPublic()).getY();
            }
            catch (InvalidKeyException ex) {
                throw new AlgorithmOperationException("Failed to generate DH y value");
            }
            catch (InvalidAlgorithmParameterException ex) {
                throw new AlgorithmOperationException("Failed to generate DH y value");
            }
            int[] messageId = new int[]{30};
            SshMsgKexDhInit msg = (SshMsgKexDhInit)this.transport.readMessage(messageId);
            this.e = msg.getE();
            this.secret = this.e.modPow(this.y, p);
            this.hostKey = prvKey.getPublicKey().getEncoded();
            this.calculateExchangeHash();
            this.signature = prvKey.generateSignature(this.exchangeHash);
            SshMsgKexDhReply reply = new SshMsgKexDhReply(this.hostKey, this.f, this.signature);
            this.transport.sendMessage(reply, this);
        }
        catch (SshException e) {
            throw new KeyExchangeException(e.getMessage());
        }
    }

    protected void calculateExchangeHash() throws KeyExchangeException {
        Hash hash;
        try {
            hash = new Hash("SHA");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new KeyExchangeException("SHA algorithm not supported");
        }
        hash.putString(this.clientId);
        hash.putString(this.serverId);
        hash.putInt(this.clientKexInit.length);
        hash.putBytes(this.clientKexInit);
        hash.putInt(this.serverKexInit.length);
        hash.putBytes(this.serverKexInit);
        hash.putInt(this.hostKey.length);
        hash.putBytes(this.hostKey);
        hash.putBigInteger(this.e);
        hash.putBigInteger(this.f);
        hash.putBigInteger(this.secret);
        this.exchangeHash = hash.doFinal();
    }
}

