/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.j2ssh.sftp;

import com.sshtools.j2ssh.io.ByteArrayReader;
import com.sshtools.j2ssh.io.ByteArrayWriter;
import com.sshtools.j2ssh.io.UnsignedInteger32;
import com.sshtools.j2ssh.sftp.FileAttributes;
import com.sshtools.j2ssh.sftp.MessageRequestId;
import com.sshtools.j2ssh.sftp.SftpFile;
import com.sshtools.j2ssh.subsystem.SubsystemMessage;
import com.sshtools.j2ssh.transport.InvalidMessageException;
import java.io.IOException;

public class SshFxpName
extends SubsystemMessage
implements MessageRequestId {
    public static final int SSH_FXP_NAME = 104;
    private UnsignedInteger32 id;
    private SftpFile[] files;

    public SshFxpName(UnsignedInteger32 id, SftpFile[] files) {
        super(104);
        this.id = id;
        this.files = files;
    }

    public SshFxpName() {
        super(104);
    }

    public UnsignedInteger32 getId() {
        return this.id;
    }

    public SftpFile[] getFiles() {
        return this.files;
    }

    public void constructMessage(ByteArrayReader bar) throws IOException, InvalidMessageException {
        this.id = bar.readUINT32();
        UnsignedInteger32 count = bar.readUINT32();
        this.files = new SftpFile[count.intValue()];
        int i = 0;
        while (i < this.files.length) {
            String shortname = bar.readString();
            String longname = bar.readString();
            this.files[i] = new SftpFile(shortname, new FileAttributes(bar));
            ++i;
        }
    }

    public String getMessageName() {
        return "SSH_FXP_NAME";
    }

    public void constructByteArray(ByteArrayWriter baw) throws IOException, InvalidMessageException {
        baw.writeUINT32(this.id);
        baw.writeUINT32(new UnsignedInteger32(this.files.length));
        int i = 0;
        while (i < this.files.length) {
            baw.writeString(this.files[i].getAbsolutePath());
            baw.writeString(this.files[i].getLongname());
            baw.write(this.files[i].getAttributes().toByteArray());
            ++i;
        }
    }
}

