/*
 * Decompiled with CFR 0.152.
 */
package com.sshtools.common.ui;

import com.sshtools.common.ui.ResourceIcon;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private ResourceIcon icon;
    private boolean alignBottomRight = false;

    public ImagePanel(String imageName) {
        this.icon = new ResourceIcon(imageName);
    }

    public ImagePanel(ResourceIcon icon, int bottom) {
        this.icon = icon;
        this.alignBottomRight = true;
    }

    public ImagePanel(String imageName, int bottom) {
        this.icon = new ResourceIcon(imageName);
        this.alignBottomRight = true;
    }

    public ImagePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Dimension getPreferedSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.icon.getIconWidth() + insets.left + insets.right, this.icon.getIconHeight() + insets.top + insets.bottom);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.icon != null) {
            Insets insets = this.getInsets();
            if (!this.alignBottomRight) {
                this.icon.paintIcon(this, g, insets.left, insets.top);
            } else {
                this.icon.paintIcon(this, g, this.getWidth() - this.icon.getIconWidth(), this.getHeight() - this.icon.getIconHeight());
            }
        }
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.white);
    }
}

