
Name:		logrider
Version:	0.2
Release:	2

%define		    bin_dir	/usr/bin
%define		crontab_dir	/etc/cron.daily
%define		 config_dir	/etc/%{name}
%define		filters_dir	%{config_dir}
%define		   temp_dir	/var/lib/%{name}

Summary:	Check log files for security violations
Group:		Monitoring
Packager:	Ilya Evseev <ilya_evseev@mail.ru>
URL:		http://ilya-evseev.narod.ru
Vendor:		UCVT
License:	GPL
BuildArch:	noarch
Requires:	grep, crontabs, fileutils, bash
Source:		%{name}-%{version}.zip

%define		dir1 %{crontab_dir}
%define		src1    %{name}.cron
%define		dir2 %{bin_dir}
%define		src2    %{name}.sh
%define		dir3 %{config_dir}
%define		src3    %{name}.conf
%define		dir4 %{bin_dir}
%define		src4    logtail.sh
%define		dir5 %{filters_dir}
%define		src5    hacking
%define		dir6 %{filters_dir}
%define		src6    ignore
%define		dir7 %{filters_dir}
%define		src7    violations
%define		dir8 %{filters_dir}
%define		src8    violations_ignore

%description
LogRider is my attepmpt to improve a popular LogCheck/LogSentry utility.
LogCheck uses egrep for periodically scanning system logs
for specific alert/hacking signatures based on set of static filters.
LogRider is rewritten from scratch with lot of important features added:

 1) Strings caught by any filter are excluded from processing by next filters.
 2) Actual filters are composed from the set of small sub-filters
    located in directories that name is given as filter name.
    Each subfilter contains messages generated by one service.
    You can easily put additional filters for checking additional services
    without modification of already existing program and configuration.
 3) Configuration is separated from program and moved to standalone file.
    This means that LogRider may be easily adopted to new platform
    without modification of program core, and may be easily used
    for checking multiple logfiles by different filters.
 4) LogTail is now shell script, not binary.
    This means that LogRider don't requires building stage
    and is ready-for-use immediately after installation.

%files
%{dir1}/%{src1}
%{dir2}/%{src2}
%config %attr(640,root,root) %{dir3}/%{src3}
%{dir4}/%{src4}
%config %attr(640,root,root) %{dir5}/%{src5}
%config %attr(640,root,root) %{dir6}/%{src6}
%config %attr(640,root,root) %{dir7}/%{src7}
%{dir8}/%{src8}
%dir %attr(0700,root,root) %{temp_dir}
%{bin_dir}/%{name}

#-----------------------------------------------------------------------

%prep
%setup -q -c

#-----------------------------------------------------------------------

%install

function my_install() {   #  $1 = perms, $2 = srcname, $3 = destdir
	if [ -d $2 ]; then
		install -pd -m$1 $2 ${RPM_BUILD_ROOT}$3/$2
		cp -a $2/* ${RPM_BUILD_ROOT}$3/$2
	else
		install -pD -m$1 $2 ${RPM_BUILD_ROOT}$3/$2
	fi
}

my_install 755 %{src1} %{dir1}    # *.cron
my_install 755 %{src2} %{dir2}    # bin
my_install 640 %{src3} %{dir3}    # *.conf
my_install 755 %{src4} %{dir4}    # logtail
my_install 640 %{src5} %{dir5}    # filters...
my_install 640 %{src6} %{dir6}
my_install 640 %{src7} %{dir7}
my_install 750 %{src8} %{dir8}    # violations_ignore/
%__mkdir_p ${RPM_BUILD_ROOT}%{temp_dir}

cd ${RPM_BUILD_ROOT}%{bin_dir}
ln -fs %src2 %name             # logrider => logrider.sh

#-----------------------------------------------------------------------

%changelog
* Mon Feb  9 2004 Ilya Evseev <ilya_evseev@mail.ru> 0.2-2
- changed URL and e-Mail
- lot of syntax fixes in description

* Mon Apr 14 2003 Ilya Evseev <evseev@ucvt.ru> 0.2-1ucvt
- new command line switch: -V, --version
- sources are placed to Zip-archive before building of RPM package
- logrider symlink is added to source tree
- new violations_ignore/ filters: microbackup, nsfbackup,
  lot of additional postfix rules
- new algorithm for logtail.sh, should work significantly faster

* Fri Feb 28 2003 Ilya Evseev <evseev@ucvt.ru> 0.1-9ucvt
- changed description because author of LogCheck prohibites
  phrase about "LogRider is successor of LogCheck";-)

* Thu Feb  6 2003 Ilya Evseev <evseev@ucvt.ru> 0.1-8ucvt
- new config option: KEEP_TEMP_FILES

* Thu Feb  6 2003 Ilya Evseev <evseev@ucvt.ru> 0.1-7ucvt
- bugfix: change day number mask for egrep from "[0-9]{2}" to "[ 0-9][0-9]"
          for processing expressions like "Feb  1 00:15:01"
- cleanup description

* Mon Jan 27 2003 Ilya Evseev <evseev@ucvt.ru> 0.1-6ucvt
- bugfix: add EOL to end of violations_ignore/named;
  without EOL this line is merged with first line of next file (PAM filter)
  
* Sat Jan 25 2003 Ilya Evseev <evseev@ucvt.ru> 0.1-5ucvt
- bugfix: logtail stats actual file behind symlink
- additional rules in violations_ignore/
- add symlink /usr/bin/logrider that points to logrider.sh

* Thu Jan 23 2003 Ilya Evseev <evseev@ucvt.ru> 0.1-4ucvt
- bugfix in configuration file: invalid directory name of violations_ignore
- abort if filter file/directory is not found

* Mon Jan 20 2003 Ilya Evseev <evseev@ucvt.ru> 0.1-3ucvt
- bugfix: create %{temp_dir} at installation

* Fri Jan 17 2003 Ilya Evseev <evseev@ucvt.ru> 0.1-2ucvt
- renames sub filter from "cvs" to "cvspserver" for preventing CVS mistakes

* Fri Jan 17 2003 Ilya Evseev <evseev@ucvt.ru> 0.1-1ucvt
- initial build

## EOF ##
