/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.fast.visitor;

import java.util.List;
import jd.core.model.classfile.LocalVariable;
import jd.core.model.classfile.LocalVariables;
import jd.core.model.instruction.bytecode.instruction.ANewArray;
import jd.core.model.instruction.bytecode.instruction.AThrow;
import jd.core.model.instruction.bytecode.instruction.ArrayLength;
import jd.core.model.instruction.bytecode.instruction.ArrayLoadInstruction;
import jd.core.model.instruction.bytecode.instruction.ArrayStoreInstruction;
import jd.core.model.instruction.bytecode.instruction.AssignmentInstruction;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.CheckCast;
import jd.core.model.instruction.bytecode.instruction.ComplexConditionalBranchInstruction;
import jd.core.model.instruction.bytecode.instruction.ConvertInstruction;
import jd.core.model.instruction.bytecode.instruction.DupStore;
import jd.core.model.instruction.bytecode.instruction.GetField;
import jd.core.model.instruction.bytecode.instruction.IfCmp;
import jd.core.model.instruction.bytecode.instruction.IfInstruction;
import jd.core.model.instruction.bytecode.instruction.IncInstruction;
import jd.core.model.instruction.bytecode.instruction.InitArrayInstruction;
import jd.core.model.instruction.bytecode.instruction.InstanceOf;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.model.instruction.bytecode.instruction.InvokeInstruction;
import jd.core.model.instruction.bytecode.instruction.InvokeNew;
import jd.core.model.instruction.bytecode.instruction.InvokeNoStaticInstruction;
import jd.core.model.instruction.bytecode.instruction.LoadInstruction;
import jd.core.model.instruction.bytecode.instruction.LookupSwitch;
import jd.core.model.instruction.bytecode.instruction.MonitorEnter;
import jd.core.model.instruction.bytecode.instruction.MonitorExit;
import jd.core.model.instruction.bytecode.instruction.MultiANewArray;
import jd.core.model.instruction.bytecode.instruction.NewArray;
import jd.core.model.instruction.bytecode.instruction.Pop;
import jd.core.model.instruction.bytecode.instruction.PutField;
import jd.core.model.instruction.bytecode.instruction.PutStatic;
import jd.core.model.instruction.bytecode.instruction.ReturnInstruction;
import jd.core.model.instruction.bytecode.instruction.StoreInstruction;
import jd.core.model.instruction.bytecode.instruction.TableSwitch;
import jd.core.model.instruction.bytecode.instruction.TernaryOpStore;
import jd.core.model.instruction.bytecode.instruction.TernaryOperator;
import jd.core.model.instruction.bytecode.instruction.UnaryOperatorInstruction;
import jd.core.model.instruction.fast.instruction.FastDeclaration;
import jd.core.model.instruction.fast.instruction.FastFor;
import jd.core.model.instruction.fast.instruction.FastForEach;
import jd.core.model.instruction.fast.instruction.FastInstruction;
import jd.core.model.instruction.fast.instruction.FastLabel;
import jd.core.model.instruction.fast.instruction.FastList;
import jd.core.model.instruction.fast.instruction.FastSwitch;
import jd.core.model.instruction.fast.instruction.FastSynchronized;
import jd.core.model.instruction.fast.instruction.FastTest2Lists;
import jd.core.model.instruction.fast.instruction.FastTestList;
import jd.core.model.instruction.fast.instruction.FastTry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckLocalVariableUsedVisitor {
    public static boolean Visit(LocalVariables localVariables, int maxOffset, Instruction instruction) {
        switch (instruction.opcode) {
            case 190: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((ArrayLength)instruction).arrayref);
            }
            case 83: 
            case 272: {
                ArrayStoreInstruction asi = (ArrayStoreInstruction)instruction;
                if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, asi.indexref)) {
                    return true;
                }
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, asi.valueref);
            }
            case 191: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((AThrow)instruction).value);
            }
            case 266: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((UnaryOperatorInstruction)instruction).value);
            }
            case 267: {
                BinaryOperatorInstruction boi = (BinaryOperatorInstruction)instruction;
                if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, boi.value1)) {
                    return true;
                }
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, boi.value2);
            }
            case 192: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((CheckCast)instruction).objectref);
            }
            case 21: 
            case 25: 
            case 268: {
                LoadInstruction li = (LoadInstruction)instruction;
                LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(li.index, li.offset);
                return lv != null && maxOffset <= lv.start_pc;
            }
            case 54: 
            case 58: 
            case 269: {
                StoreInstruction si = (StoreInstruction)instruction;
                LocalVariable lv = localVariables.getLocalVariableWithIndexAndOffset(si.index, si.offset);
                if (lv != null && maxOffset <= lv.start_pc) {
                    return true;
                }
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, si.valueref);
            }
            case 264: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((DupStore)instruction).objectref);
            }
            case 275: 
            case 276: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((ConvertInstruction)instruction).value);
            }
            case 261: {
                IfCmp ifCmp = (IfCmp)instruction;
                if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ifCmp.value1)) {
                    return true;
                }
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ifCmp.value2);
            }
            case 260: 
            case 262: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((IfInstruction)instruction).value);
            }
            case 284: {
                List<Instruction> branchList = ((ComplexConditionalBranchInstruction)instruction).instructions;
                int i = branchList.size() - 1;
                while (i >= 0) {
                    if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, branchList.get(i))) {
                        return true;
                    }
                    --i;
                }
                return false;
            }
            case 193: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((InstanceOf)instruction).objectref);
            }
            case 182: 
            case 183: 
            case 185: {
                if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((InvokeNoStaticInstruction)instruction).objectref)) {
                    return true;
                }
            }
            case 184: {
                List<Instruction> list = ((InvokeInstruction)instruction).args;
                int i = list.size() - 1;
                while (i >= 0) {
                    if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, list.get(i))) {
                        return true;
                    }
                    --i;
                }
                return false;
            }
            case 274: {
                List list = ((InvokeNew)instruction).args;
                int i = list.size() - 1;
                while (i >= 0) {
                    if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, (Instruction)list.get(i))) {
                        return true;
                    }
                    --i;
                }
                return false;
            }
            case 171: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((LookupSwitch)instruction).key);
            }
            case 194: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((MonitorEnter)instruction).objectref);
            }
            case 195: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((MonitorExit)instruction).objectref);
            }
            case 197: {
                Instruction[] dimensions = ((MultiANewArray)instruction).dimensions;
                int i = dimensions.length - 1;
                while (i >= 0) {
                    if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, dimensions[i])) {
                        return true;
                    }
                    --i;
                }
                return false;
            }
            case 188: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((NewArray)instruction).dimension);
            }
            case 189: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((ANewArray)instruction).dimension);
            }
            case 87: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((Pop)instruction).objectref);
            }
            case 181: {
                PutField putField = (PutField)instruction;
                if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, putField.objectref)) {
                    return true;
                }
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, putField.valueref);
            }
            case 179: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((PutStatic)instruction).valueref);
            }
            case 273: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((ReturnInstruction)instruction).valueref);
            }
            case 170: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((TableSwitch)instruction).key);
            }
            case 280: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((TernaryOpStore)instruction).objectref);
            }
            case 281: {
                TernaryOperator to = (TernaryOperator)instruction;
                if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, to.value1)) {
                    return true;
                }
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, to.value2);
            }
            case 265: {
                AssignmentInstruction ai = (AssignmentInstruction)instruction;
                if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ai.value1)) {
                    return true;
                }
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ai.value2);
            }
            case 271: {
                ArrayLoadInstruction ali = (ArrayLoadInstruction)instruction;
                if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ali.arrayref)) {
                    return true;
                }
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ali.indexref);
            }
            case 277: 
            case 278: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((IncInstruction)instruction).value);
            }
            case 180: {
                return CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ((GetField)instruction).objectref);
            }
            case 282: 
            case 283: {
                InitArrayInstruction iai = (InitArrayInstruction)instruction;
                if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, iai.newArray)) {
                    return true;
                }
                return iai.values != null && CheckLocalVariableUsedVisitor.visit(localVariables, maxOffset, iai.values);
            }
            case 304: {
                FastFor ff = (FastFor)instruction;
                if (ff.init != null && CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ff.init)) {
                    return true;
                }
                return ff.inc != null && CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ff.inc);
            }
            case 301: 
            case 302: 
            case 306: {
                Instruction test = ((FastTestList)instruction).test;
                return test != null && CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, test);
            }
            case 303: {
                List<Instruction> instructions = ((FastList)instruction).instructions;
                if (instructions != null) {
                    return CheckLocalVariableUsedVisitor.visit(localVariables, maxOffset, instructions);
                }
                return false;
            }
            case 305: {
                FastForEach ffe = (FastForEach)instruction;
                if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ffe.variable)) {
                    return true;
                }
                if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ffe.values)) {
                    return true;
                }
                return CheckLocalVariableUsedVisitor.visit(localVariables, maxOffset, ffe.instructions);
            }
            case 307: {
                FastTest2Lists ft2l = (FastTest2Lists)instruction;
                if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, ft2l.test)) {
                    return true;
                }
                if (CheckLocalVariableUsedVisitor.visit(localVariables, maxOffset, ft2l.instructions)) {
                    return true;
                }
                return CheckLocalVariableUsedVisitor.visit(localVariables, maxOffset, ft2l.instructions2);
            }
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: {
                FastInstruction fi = (FastInstruction)instruction;
                return fi.instruction != null && CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, fi.instruction);
            }
            case 314: 
            case 315: 
            case 316: {
                FastSwitch fs = (FastSwitch)instruction;
                if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, fs.test)) {
                    return true;
                }
                FastSwitch.Pair[] pairs = fs.pairs;
                int i = pairs.length - 1;
                while (i >= 0) {
                    List<Instruction> instructions = pairs[i].getInstructions();
                    if (instructions != null && CheckLocalVariableUsedVisitor.visit(localVariables, maxOffset, instructions)) {
                        return true;
                    }
                    --i;
                }
                return false;
            }
            case 318: {
                FastTry ft = (FastTry)instruction;
                if (CheckLocalVariableUsedVisitor.visit(localVariables, maxOffset, ft.instructions)) {
                    return true;
                }
                if (ft.finallyInstructions != null && CheckLocalVariableUsedVisitor.visit(localVariables, maxOffset, ft.finallyInstructions)) {
                    return true;
                }
                List<FastTry.FastCatch> catchs = ft.catches;
                int i = catchs.size() - 1;
                while (i >= 0) {
                    if (CheckLocalVariableUsedVisitor.visit(localVariables, maxOffset, catchs.get((int)i).instructions)) {
                        return true;
                    }
                    --i;
                }
                return false;
            }
            case 319: {
                FastSynchronized fsd = (FastSynchronized)instruction;
                if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, fsd.monitor)) {
                    return true;
                }
                return CheckLocalVariableUsedVisitor.visit(localVariables, maxOffset, fsd.instructions);
            }
            case 320: {
                FastLabel fl = (FastLabel)instruction;
                return fl.instruction != null && CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, fl.instruction);
            }
            case 317: {
                FastDeclaration fd = (FastDeclaration)instruction;
                return fd.instruction != null && CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, fd.instruction);
            }
            case 0: 
            case 1: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 132: 
            case 167: 
            case 168: 
            case 169: 
            case 177: 
            case 178: 
            case 187: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 270: 
            case 279: 
            case 285: {
                return false;
            }
        }
        System.err.println("Can not find local variable used in " + instruction.getClass().getName() + ", opcode=" + instruction.opcode);
        return false;
    }

    private static boolean visit(LocalVariables localVariables, int maxOffset, List<Instruction> instructions) {
        int i = instructions.size() - 1;
        while (i >= 0) {
            if (CheckLocalVariableUsedVisitor.Visit(localVariables, maxOffset, instructions.get(i))) {
                return true;
            }
            --i;
        }
        return false;
    }
}

