// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package places provides access to the Places API (New).
//
// For product documentation, see: https://mapsplatform.google.com/maps-products/#places-section
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/places/v1"
//	...
//	ctx := context.Background()
//	placesService, err := places.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	placesService, err := places.NewService(ctx, option.WithScopes(places.MapsPlatformPlacesTextsearchScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	placesService, err := places.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	placesService, err := places.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package places // import "google.golang.org/api/places/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "places:v1"
const apiName = "places"
const apiVersion = "v1"
const basePath = "https://places.googleapis.com/"
const basePathTemplate = "https://places.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://places.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// Private Service: https://www.googleapis.com/auth/maps-platform.places
	MapsPlatformPlacesScope = "https://www.googleapis.com/auth/maps-platform.places"

	// Private Service:
	// https://www.googleapis.com/auth/maps-platform.places.autocomplete
	MapsPlatformPlacesAutocompleteScope = "https://www.googleapis.com/auth/maps-platform.places.autocomplete"

	// Private Service:
	// https://www.googleapis.com/auth/maps-platform.places.details
	MapsPlatformPlacesDetailsScope = "https://www.googleapis.com/auth/maps-platform.places.details"

	// Private Service:
	// https://www.googleapis.com/auth/maps-platform.places.getphotomedia
	MapsPlatformPlacesGetphotomediaScope = "https://www.googleapis.com/auth/maps-platform.places.getphotomedia"

	// Private Service:
	// https://www.googleapis.com/auth/maps-platform.places.nearbysearch
	MapsPlatformPlacesNearbysearchScope = "https://www.googleapis.com/auth/maps-platform.places.nearbysearch"

	// Private Service:
	// https://www.googleapis.com/auth/maps-platform.places.textsearch
	MapsPlatformPlacesTextsearchScope = "https://www.googleapis.com/auth/maps-platform.places.textsearch"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/maps-platform.places",
		"https://www.googleapis.com/auth/maps-platform.places.autocomplete",
		"https://www.googleapis.com/auth/maps-platform.places.details",
		"https://www.googleapis.com/auth/maps-platform.places.getphotomedia",
		"https://www.googleapis.com/auth/maps-platform.places.nearbysearch",
		"https://www.googleapis.com/auth/maps-platform.places.textsearch",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Places = NewPlacesService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Places *PlacesService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewPlacesService(s *Service) *PlacesService {
	rs := &PlacesService{s: s}
	rs.Photos = NewPlacesPhotosService(s)
	return rs
}

type PlacesService struct {
	s *Service

	Photos *PlacesPhotosService
}

func NewPlacesPhotosService(s *Service) *PlacesPhotosService {
	rs := &PlacesPhotosService{s: s}
	return rs
}

type PlacesPhotosService struct {
	s *Service
}

// GoogleGeoTypeViewport: A latitude-longitude viewport, represented as two
// diagonally opposite `low` and `high` points. A viewport is considered a
// closed region, i.e. it includes its boundary. The latitude bounds must range
// between -90 to 90 degrees inclusive, and the longitude bounds must range
// between -180 to 180 degrees inclusive. Various cases include: - If `low` =
// `high`, the viewport consists of that single point. - If `low.longitude` >
// `high.longitude`, the longitude range is inverted (the viewport crosses the
// 180 degree longitude line). - If `low.longitude` = -180 degrees and
// `high.longitude` = 180 degrees, the viewport includes all longitudes. - If
// `low.longitude` = 180 degrees and `high.longitude` = -180 degrees, the
// longitude range is empty. - If `low.latitude` > `high.latitude`, the
// latitude range is empty. Both `low` and `high` must be populated, and the
// represented box cannot be empty (as specified by the definitions above). An
// empty viewport will result in an error. For example, this viewport fully
// encloses New York City: { "low": { "latitude": 40.477398, "longitude":
// -74.259087 }, "high": { "latitude": 40.91618, "longitude": -73.70018 } }
type GoogleGeoTypeViewport struct {
	// High: Required. The high point of the viewport.
	High *GoogleTypeLatLng `json:"high,omitempty"`
	// Low: Required. The low point of the viewport.
	Low *GoogleTypeLatLng `json:"low,omitempty"`
	// ForceSendFields is a list of field names (e.g. "High") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "High") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleGeoTypeViewport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleGeoTypeViewport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1AuthorAttribution: Information about the author of the UGC
// data. Used in Photo, and Review.
type GoogleMapsPlacesV1AuthorAttribution struct {
	// DisplayName: Name of the author of the Photo or Review.
	DisplayName string `json:"displayName,omitempty"`
	// PhotoUri: Profile photo URI of the author of the Photo or Review.
	PhotoUri string `json:"photoUri,omitempty"`
	// Uri: URI of the author of the Photo or Review.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1AuthorAttribution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1AuthorAttribution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1AutocompletePlacesRequest: Request proto for
// AutocompletePlaces.
type GoogleMapsPlacesV1AutocompletePlacesRequest struct {
	// IncludeQueryPredictions: Optional. If true, the response will include both
	// Place and query predictions. Otherwise the response will only return Place
	// predictions.
	IncludeQueryPredictions bool `json:"includeQueryPredictions,omitempty"`
	// IncludedPrimaryTypes: Optional. Included primary Place type (for example,
	// "restaurant" or "gas_station") in Place Types
	// (https://developers.google.com/maps/documentation/places/web-service/place-types),
	// or only `(regions)`, or only `(cities)`. A Place is only returned if its
	// primary type is included in this list. Up to 5 values can be specified. If
	// no types are specified, all Place types are returned.
	IncludedPrimaryTypes []string `json:"includedPrimaryTypes,omitempty"`
	// IncludedRegionCodes: Optional. Only include results in the specified
	// regions, specified as up to 15 CLDR two-character region codes. An empty set
	// will not restrict the results. If both `location_restriction` and
	// `included_region_codes` are set, the results will be located in the area of
	// intersection.
	IncludedRegionCodes []string `json:"includedRegionCodes,omitempty"`
	// Input: Required. The text string on which to search.
	Input string `json:"input,omitempty"`
	// InputOffset: Optional. A zero-based Unicode character offset of `input`
	// indicating the cursor position in `input`. The cursor position may influence
	// what predictions are returned. If empty, defaults to the length of `input`.
	InputOffset int64 `json:"inputOffset,omitempty"`
	// LanguageCode: Optional. The language in which to return results. Defaults to
	// en-US. The results may be in mixed languages if the language used in `input`
	// is different from `language_code` or if the returned Place does not have a
	// translation from the local language to `language_code`.
	LanguageCode string `json:"languageCode,omitempty"`
	// LocationBias: Optional. Bias results to a specified location. At most one of
	// `location_bias` or `location_restriction` should be set. If neither are set,
	// the results will be biased by IP address, meaning the IP address will be
	// mapped to an imprecise location and used as a biasing signal.
	LocationBias *GoogleMapsPlacesV1AutocompletePlacesRequestLocationBias `json:"locationBias,omitempty"`
	// LocationRestriction: Optional. Restrict results to a specified location. At
	// most one of `location_bias` or `location_restriction` should be set. If
	// neither are set, the results will be biased by IP address, meaning the IP
	// address will be mapped to an imprecise location and used as a biasing
	// signal.
	LocationRestriction *GoogleMapsPlacesV1AutocompletePlacesRequestLocationRestriction `json:"locationRestriction,omitempty"`
	// Origin: Optional. The origin point from which to calculate geodesic distance
	// to the destination (returned as `distance_meters`). If this value is
	// omitted, geodesic distance will not be returned.
	Origin *GoogleTypeLatLng `json:"origin,omitempty"`
	// RegionCode: Optional. The region code, specified as a CLDR two-character
	// region code. This affects address formatting, result ranking, and may
	// influence what results are returned. This does not restrict results to the
	// specified region. To restrict results to a region, use
	// `region_code_restriction`.
	RegionCode string `json:"regionCode,omitempty"`
	// SessionToken: Optional. A string which identifies an Autocomplete session
	// for billing purposes. Must be a URL and filename safe base64 string with at
	// most 36 ASCII characters in length. Otherwise an INVALID_ARGUMENT error is
	// returned. The session begins when the user starts typing a query, and
	// concludes when they select a place and a call to Place Details or Address
	// Validation is made. Each session can have multiple queries, followed by one
	// Place Details or Address Validation request. The credentials used for each
	// request within a session must belong to the same Google Cloud Console
	// project. Once a session has concluded, the token is no longer valid; your
	// app must generate a fresh token for each session. If the `session_token`
	// parameter is omitted, or if you reuse a session token, the session is
	// charged as if no session token was provided (each request is billed
	// separately). We recommend the following guidelines: * Use session tokens for
	// all Place Autocomplete calls. * Generate a fresh token for each session.
	// Using a version 4 UUID is recommended. * Ensure that the credentials used
	// for all Place Autocomplete, Place Details, and Address Validation requests
	// within a session belong to the same Cloud Console project. * Be sure to pass
	// a unique session token for each new session. Using the same token for more
	// than one session will result in each request being billed individually.
	SessionToken string `json:"sessionToken,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IncludeQueryPredictions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IncludeQueryPredictions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1AutocompletePlacesRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1AutocompletePlacesRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1AutocompletePlacesRequestLocationBias: The region to
// search. The results may be biased around the specified region.
type GoogleMapsPlacesV1AutocompletePlacesRequestLocationBias struct {
	// Circle: A circle defined by a center point and radius.
	Circle *GoogleMapsPlacesV1Circle `json:"circle,omitempty"`
	// Rectangle: A viewport defined by a northeast and a southwest corner.
	Rectangle *GoogleGeoTypeViewport `json:"rectangle,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Circle") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Circle") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1AutocompletePlacesRequestLocationBias) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1AutocompletePlacesRequestLocationBias
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1AutocompletePlacesRequestLocationRestriction: The region
// to search. The results will be restricted to the specified region.
type GoogleMapsPlacesV1AutocompletePlacesRequestLocationRestriction struct {
	// Circle: A circle defined by a center point and radius.
	Circle *GoogleMapsPlacesV1Circle `json:"circle,omitempty"`
	// Rectangle: A viewport defined by a northeast and a southwest corner.
	Rectangle *GoogleGeoTypeViewport `json:"rectangle,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Circle") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Circle") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1AutocompletePlacesRequestLocationRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1AutocompletePlacesRequestLocationRestriction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1AutocompletePlacesResponse: Response proto for
// AutocompletePlaces.
type GoogleMapsPlacesV1AutocompletePlacesResponse struct {
	// Suggestions: Contains a list of suggestions, ordered in descending order of
	// relevance.
	Suggestions []*GoogleMapsPlacesV1AutocompletePlacesResponseSuggestion `json:"suggestions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Suggestions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Suggestions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1AutocompletePlacesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1AutocompletePlacesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1AutocompletePlacesResponseSuggestion: An Autocomplete
// suggestion result.
type GoogleMapsPlacesV1AutocompletePlacesResponseSuggestion struct {
	// PlacePrediction: A prediction for a Place.
	PlacePrediction *GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionPlacePrediction `json:"placePrediction,omitempty"`
	// QueryPrediction: A prediction for a query.
	QueryPrediction *GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionQueryPrediction `json:"queryPrediction,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PlacePrediction") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PlacePrediction") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1AutocompletePlacesResponseSuggestion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1AutocompletePlacesResponseSuggestion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionFormattableText: Text
// representing a Place or query prediction. The text may be used as is or
// formatted.
type GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionFormattableText struct {
	// Matches: A list of string ranges identifying where the input request matched
	// in `text`. The ranges can be used to format specific parts of `text`. The
	// substrings may not be exact matches of `input` if the matching was
	// determined by criteria other than string matching (for example, spell
	// corrections or transliterations). These values are Unicode character offsets
	// of `text`. The ranges are guaranteed to be ordered in increasing offset
	// values.
	Matches []*GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionStringRange `json:"matches,omitempty"`
	// Text: Text that may be used as is or formatted with `matches`.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Matches") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Matches") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionFormattableText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionFormattableText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionPlacePrediction:
// Prediction results for a Place Autocomplete prediction.
type GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionPlacePrediction struct {
	// DistanceMeters: The length of the geodesic in meters from `origin` if
	// `origin` is specified. Certain predictions such as routes may not populate
	// this field.
	DistanceMeters int64 `json:"distanceMeters,omitempty"`
	// Place: The resource name of the suggested Place. This name can be used in
	// other APIs that accept Place names.
	Place string `json:"place,omitempty"`
	// PlaceId: The unique identifier of the suggested Place. This identifier can
	// be used in other APIs that accept Place IDs.
	PlaceId string `json:"placeId,omitempty"`
	// StructuredFormat: A breakdown of the Place prediction into main text
	// containing the name of the Place and secondary text containing additional
	// disambiguating features (such as a city or region). `structured_format` is
	// recommended for developers who wish to show two separate, but related, UI
	// elements. Developers who wish to show a single UI element may want to use
	// `text` instead. They are two different ways to represent a Place prediction.
	// Users should not try to parse `structured_format` into `text` or vice versa.
	StructuredFormat *GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionStructuredFormat `json:"structuredFormat,omitempty"`
	// Text: Contains the human-readable name for the returned result. For
	// establishment results, this is usually the business name and address. `text`
	// is recommended for developers who wish to show a single UI element.
	// Developers who wish to show two separate, but related, UI elements may want
	// to use `structured_format` instead. They are two different ways to represent
	// a Place prediction. Users should not try to parse `structured_format` into
	// `text` or vice versa. This text may be different from the `display_name`
	// returned by GetPlace. May be in mixed languages if the request `input` and
	// `language_code` are in different languages or if the Place does not have a
	// translation from the local language to `language_code`.
	Text *GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionFormattableText `json:"text,omitempty"`
	// Types: List of types that apply to this Place from Table A or Table B in
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	// A type is a categorization of a Place. Places with shared types will share
	// similar characteristics.
	Types []string `json:"types,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DistanceMeters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DistanceMeters") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionPlacePrediction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionPlacePrediction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionQueryPrediction:
// Prediction results for a Query Autocomplete prediction.
type GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionQueryPrediction struct {
	// StructuredFormat: A breakdown of the query prediction into main text
	// containing the query and secondary text containing additional disambiguating
	// features (such as a city or region). `structured_format` is recommended for
	// developers who wish to show two separate, but related, UI elements.
	// Developers who wish to show a single UI element may want to use `text`
	// instead. They are two different ways to represent a query prediction. Users
	// should not try to parse `structured_format` into `text` or vice versa.
	StructuredFormat *GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionStructuredFormat `json:"structuredFormat,omitempty"`
	// Text: The predicted text. This text does not represent a Place, but rather a
	// text query that could be used in a search endpoint (for example, Text
	// Search). `text` is recommended for developers who wish to show a single UI
	// element. Developers who wish to show two separate, but related, UI elements
	// may want to use `structured_format` instead. They are two different ways to
	// represent a query prediction. Users should not try to parse
	// `structured_format` into `text` or vice versa. May be in mixed languages if
	// the request `input` and `language_code` are in different languages or if
	// part of the query does not have a translation from the local language to
	// `language_code`.
	Text *GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionFormattableText `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "StructuredFormat") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "StructuredFormat") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionQueryPrediction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionQueryPrediction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionStringRange:
// Identifies a substring within a given text.
type GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionStringRange struct {
	// EndOffset: Zero-based offset of the last Unicode character (exclusive).
	EndOffset int64 `json:"endOffset,omitempty"`
	// StartOffset: Zero-based offset of the first Unicode character of the string
	// (inclusive).
	StartOffset int64 `json:"startOffset,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndOffset") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndOffset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionStringRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionStringRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionStructuredFormat:
// Contains a breakdown of a Place or query prediction into main text and
// secondary text. For Place predictions, the main text contains the specific
// name of the Place. For query predictions, the main text contains the query.
// The secondary text contains additional disambiguating features (such as a
// city or region) to further identify the Place or refine the query.
type GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionStructuredFormat struct {
	// MainText: Represents the name of the Place or query.
	MainText *GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionFormattableText `json:"mainText,omitempty"`
	// SecondaryText: Represents additional disambiguating features (such as a city
	// or region) to further identify the Place or refine the query.
	SecondaryText *GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionFormattableText `json:"secondaryText,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MainText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MainText") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionStructuredFormat) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionStructuredFormat
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1Circle: Circle with a LatLng as center and radius.
type GoogleMapsPlacesV1Circle struct {
	// Center: Required. Center latitude and longitude. The range of latitude must
	// be within [-90.0, 90.0]. The range of the longitude must be within [-180.0,
	// 180.0].
	Center *GoogleTypeLatLng `json:"center,omitempty"`
	// Radius: Required. Radius measured in meters. The radius must be within [0.0,
	// 50000.0].
	Radius float64 `json:"radius,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Center") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Center") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1Circle) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1Circle
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleMapsPlacesV1Circle) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleMapsPlacesV1Circle
	var s1 struct {
		Radius gensupport.JSONFloat64 `json:"radius"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Radius = float64(s1.Radius)
	return nil
}

// GoogleMapsPlacesV1ContentBlock: A block of content that can be served
// individually.
type GoogleMapsPlacesV1ContentBlock struct {
	// Content: Content related to the topic.
	Content *GoogleTypeLocalizedText `json:"content,omitempty"`
	// References: Experimental: See
	// https://developers.google.com/maps/documentation/places/web-service/experimental/places-generative
	// for more details. References that are related to this block of content.
	References *GoogleMapsPlacesV1References `json:"references,omitempty"`
	// Topic: The topic of the content, for example "overview" or "restaurant".
	Topic string `json:"topic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Content") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Content") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1ContentBlock) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1ContentBlock
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1ContextualContent: Experimental: See
// https://developers.google.com/maps/documentation/places/web-service/experimental/places-generative
// for more details. Content that is contextual to the place query.
type GoogleMapsPlacesV1ContextualContent struct {
	// Justifications: Experimental: See
	// https://developers.google.com/maps/documentation/places/web-service/experimental/places-generative
	// for more details. Justifications for the place.
	Justifications []*GoogleMapsPlacesV1ContextualContentJustification `json:"justifications,omitempty"`
	// Photos: Information (including references) about photos of this place,
	// contexual to the place query.
	Photos []*GoogleMapsPlacesV1Photo `json:"photos,omitempty"`
	// Reviews: List of reviews about this place, contexual to the place query.
	Reviews []*GoogleMapsPlacesV1Review `json:"reviews,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Justifications") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Justifications") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1ContextualContent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1ContextualContent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1ContextualContentJustification: Experimental: See
// https://developers.google.com/maps/documentation/places/web-service/experimental/places-generative
// for more details. Justifications for the place. Justifications answers the
// question of why a place could interest an end user.
type GoogleMapsPlacesV1ContextualContentJustification struct {
	// BusinessAvailabilityAttributesJustification: Experimental: See
	// https://developers.google.com/maps/documentation/places/web-service/experimental/places-generative
	// for more details.
	BusinessAvailabilityAttributesJustification *GoogleMapsPlacesV1ContextualContentJustificationBusinessAvailabilityAttributesJustification `json:"businessAvailabilityAttributesJustification,omitempty"`
	// ReviewJustification: Experimental: See
	// https://developers.google.com/maps/documentation/places/web-service/experimental/places-generative
	// for more details.
	ReviewJustification *GoogleMapsPlacesV1ContextualContentJustificationReviewJustification `json:"reviewJustification,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "BusinessAvailabilityAttributesJustification") to unconditionally include in
	// API requests. By default, fields with empty or default values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "BusinessAvailabilityAttributesJustification") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1ContextualContentJustification) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1ContextualContentJustification
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1ContextualContentJustificationBusinessAvailabilityAttribute
// sJustification: Experimental: See
// https://developers.google.com/maps/documentation/places/web-service/experimental/places-generative
// for more details. BusinessAvailabilityAttributes justifications. This shows
// some attributes a business has that could interest an end user.
type GoogleMapsPlacesV1ContextualContentJustificationBusinessAvailabilityAttributesJustification struct {
	// Delivery: If a place provides delivery.
	Delivery bool `json:"delivery,omitempty"`
	// DineIn: If a place provides dine-in.
	DineIn bool `json:"dineIn,omitempty"`
	// Takeout: If a place provides takeout.
	Takeout bool `json:"takeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Delivery") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Delivery") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1ContextualContentJustificationBusinessAvailabilityAttributesJustification) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1ContextualContentJustificationBusinessAvailabilityAttributesJustification
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1ContextualContentJustificationReviewJustification:
// Experimental: See
// https://developers.google.com/maps/documentation/places/web-service/experimental/places-generative
// for more details. User review justifications. This highlights a section of
// the user review that would interest an end user. For instance, if the search
// query is "firewood pizza", the review justification highlights the text
// relevant to the search query.
type GoogleMapsPlacesV1ContextualContentJustificationReviewJustification struct {
	HighlightedText *GoogleMapsPlacesV1ContextualContentJustificationReviewJustificationHighlightedText `json:"highlightedText,omitempty"`
	// Review: The review that the highlighted text is generated from.
	Review *GoogleMapsPlacesV1Review `json:"review,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HighlightedText") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HighlightedText") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1ContextualContentJustificationReviewJustification) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1ContextualContentJustificationReviewJustification
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1ContextualContentJustificationReviewJustificationHighlighte
// dText: The text highlighted by the justification. This is a subset of the
// review itself. The exact word to highlight is marked by the
// HighlightedTextRange. There could be several words in the text being
// highlighted.
type GoogleMapsPlacesV1ContextualContentJustificationReviewJustificationHighlightedText struct {
	// HighlightedTextRanges: The list of the ranges of the highlighted text.
	HighlightedTextRanges []*GoogleMapsPlacesV1ContextualContentJustificationReviewJustificationHighlightedTextHighlightedTextRange `json:"highlightedTextRanges,omitempty"`
	Text                  string                                                                                                    `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HighlightedTextRanges") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HighlightedTextRanges") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1ContextualContentJustificationReviewJustificationHighlightedText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1ContextualContentJustificationReviewJustificationHighlightedText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1ContextualContentJustificationReviewJustificationHighlighte
// dTextHighlightedTextRange: The range of highlighted text.
type GoogleMapsPlacesV1ContextualContentJustificationReviewJustificationHighlightedTextHighlightedTextRange struct {
	EndIndex   int64 `json:"endIndex,omitempty"`
	StartIndex int64 `json:"startIndex,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndIndex") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndIndex") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1ContextualContentJustificationReviewJustificationHighlightedTextHighlightedTextRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1ContextualContentJustificationReviewJustificationHighlightedTextHighlightedTextRange
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1EVChargeOptions: Information about the EV Charge Station
// hosted in Place. Terminology follows
// https://afdc.energy.gov/fuels/electricity_infrastructure.html One port could
// charge one car at a time. One port has one or more connectors. One station
// has one or more ports.
type GoogleMapsPlacesV1EVChargeOptions struct {
	// ConnectorAggregation: A list of EV charging connector aggregations that
	// contain connectors of the same type and same charge rate.
	ConnectorAggregation []*GoogleMapsPlacesV1EVChargeOptionsConnectorAggregation `json:"connectorAggregation,omitempty"`
	// ConnectorCount: Number of connectors at this station. However, because some
	// ports can have multiple connectors but only be able to charge one car at a
	// time (e.g.) the number of connectors may be greater than the total number of
	// cars which can charge simultaneously.
	ConnectorCount int64 `json:"connectorCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectorAggregation") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectorAggregation") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1EVChargeOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1EVChargeOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1EVChargeOptionsConnectorAggregation: EV charging
// information grouped by [type, max_charge_rate_kw]. Shows EV charge
// aggregation of connectors that have the same type and max charge rate in kw.
type GoogleMapsPlacesV1EVChargeOptionsConnectorAggregation struct {
	// AvailabilityLastUpdateTime: The timestamp when the connector availability
	// information in this aggregation was last updated.
	AvailabilityLastUpdateTime string `json:"availabilityLastUpdateTime,omitempty"`
	// AvailableCount: Number of connectors in this aggregation that are currently
	// available.
	AvailableCount int64 `json:"availableCount,omitempty"`
	// Count: Number of connectors in this aggregation.
	Count int64 `json:"count,omitempty"`
	// MaxChargeRateKw: The static max charging rate in kw of each connector in the
	// aggregation.
	MaxChargeRateKw float64 `json:"maxChargeRateKw,omitempty"`
	// OutOfServiceCount: Number of connectors in this aggregation that are
	// currently out of service.
	OutOfServiceCount int64 `json:"outOfServiceCount,omitempty"`
	// Type: The connector type of this aggregation.
	//
	// Possible values:
	//   "EV_CONNECTOR_TYPE_UNSPECIFIED" - Unspecified connector.
	//   "EV_CONNECTOR_TYPE_OTHER" - Other connector types.
	//   "EV_CONNECTOR_TYPE_J1772" - J1772 type 1 connector.
	//   "EV_CONNECTOR_TYPE_TYPE_2" - IEC 62196 type 2 connector. Often referred to
	// as MENNEKES.
	//   "EV_CONNECTOR_TYPE_CHADEMO" - CHAdeMO type connector.
	//   "EV_CONNECTOR_TYPE_CCS_COMBO_1" - Combined Charging System (AC and DC).
	// Based on SAE. Type-1 J-1772 connector
	//   "EV_CONNECTOR_TYPE_CCS_COMBO_2" - Combined Charging System (AC and DC).
	// Based on Type-2 Mennekes connector
	//   "EV_CONNECTOR_TYPE_TESLA" - The generic TESLA connector. This is NACS in
	// the North America but can be non-NACS in other parts of the world (e.g. CCS
	// Combo 2 (CCS2) or GB/T). This value is less representative of an actual
	// connector type, and more represents the ability to charge a Tesla brand
	// vehicle at a Tesla owned charging station.
	//   "EV_CONNECTOR_TYPE_UNSPECIFIED_GB_T" - GB/T type corresponds to the GB/T
	// standard in China. This type covers all GB_T types.
	//   "EV_CONNECTOR_TYPE_UNSPECIFIED_WALL_OUTLET" - Unspecified wall outlet.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvailabilityLastUpdateTime")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvailabilityLastUpdateTime") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1EVChargeOptionsConnectorAggregation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1EVChargeOptionsConnectorAggregation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleMapsPlacesV1EVChargeOptionsConnectorAggregation) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleMapsPlacesV1EVChargeOptionsConnectorAggregation
	var s1 struct {
		MaxChargeRateKw gensupport.JSONFloat64 `json:"maxChargeRateKw"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MaxChargeRateKw = float64(s1.MaxChargeRateKw)
	return nil
}

// GoogleMapsPlacesV1FuelOptions: The most recent information about fuel
// options in a gas station. This information is updated regularly.
type GoogleMapsPlacesV1FuelOptions struct {
	// FuelPrices: The last known fuel price for each type of fuel this station
	// has. There is one entry per fuel type this station has. Order is not
	// important.
	FuelPrices []*GoogleMapsPlacesV1FuelOptionsFuelPrice `json:"fuelPrices,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FuelPrices") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FuelPrices") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1FuelOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1FuelOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1FuelOptionsFuelPrice: Fuel price information for a given
// type.
type GoogleMapsPlacesV1FuelOptionsFuelPrice struct {
	// Price: The price of the fuel.
	Price *GoogleTypeMoney `json:"price,omitempty"`
	// Type: The type of fuel.
	//
	// Possible values:
	//   "FUEL_TYPE_UNSPECIFIED" - Unspecified fuel type.
	//   "DIESEL" - Diesel fuel.
	//   "REGULAR_UNLEADED" - Regular unleaded.
	//   "MIDGRADE" - Midgrade.
	//   "PREMIUM" - Premium.
	//   "SP91" - SP 91.
	//   "SP91_E10" - SP 91 E10.
	//   "SP92" - SP 92.
	//   "SP95" - SP 95.
	//   "SP95_E10" - SP95 E10.
	//   "SP98" - SP 98.
	//   "SP99" - SP 99.
	//   "SP100" - SP 100.
	//   "LPG" - LPG.
	//   "E80" - E 80.
	//   "E85" - E 85.
	//   "METHANE" - Methane.
	//   "BIO_DIESEL" - Bio-diesel.
	//   "TRUCK_DIESEL" - Truck diesel.
	Type string `json:"type,omitempty"`
	// UpdateTime: The time the fuel price was last updated.
	UpdateTime string `json:"updateTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Price") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Price") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1FuelOptionsFuelPrice) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1FuelOptionsFuelPrice
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1Photo: Information about a photo of a place.
type GoogleMapsPlacesV1Photo struct {
	// AuthorAttributions: This photo's authors.
	AuthorAttributions []*GoogleMapsPlacesV1AuthorAttribution `json:"authorAttributions,omitempty"`
	// HeightPx: The maximum available height, in pixels.
	HeightPx int64 `json:"heightPx,omitempty"`
	// Name: Identifier. A reference representing this place photo which may be
	// used to look up this place photo again (also called the API "resource" name:
	// `places/{place_id}/photos/{photo}`).
	Name string `json:"name,omitempty"`
	// WidthPx: The maximum available width, in pixels.
	WidthPx int64 `json:"widthPx,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuthorAttributions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthorAttributions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1Photo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1Photo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PhotoMedia: A photo media from Places API.
type GoogleMapsPlacesV1PhotoMedia struct {
	// Name: The resource name of a photo media in the format:
	// `places/{place_id}/photos/{photo_reference}/media`.
	Name string `json:"name,omitempty"`
	// PhotoUri: A short-lived uri that can be used to render the photo.
	PhotoUri string `json:"photoUri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1PhotoMedia) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PhotoMedia
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1Place: All the information representing a Place.
type GoogleMapsPlacesV1Place struct {
	// AccessibilityOptions: Information about the accessibility options a place
	// offers.
	AccessibilityOptions *GoogleMapsPlacesV1PlaceAccessibilityOptions `json:"accessibilityOptions,omitempty"`
	// AddressComponents: Repeated components for each locality level. Note the
	// following facts about the address_components[] array: - The array of address
	// components may contain more components than the formatted_address. - The
	// array does not necessarily include all the political entities that contain
	// an address, apart from those included in the formatted_address. To retrieve
	// all the political entities that contain a specific address, you should use
	// reverse geocoding, passing the latitude/longitude of the address as a
	// parameter to the request. - The format of the response is not guaranteed to
	// remain the same between requests. In particular, the number of
	// address_components varies based on the address requested and can change over
	// time for the same address. A component can change position in the array. The
	// type of the component can change. A particular component may be missing in a
	// later response.
	AddressComponents []*GoogleMapsPlacesV1PlaceAddressComponent `json:"addressComponents,omitempty"`
	// AdrFormatAddress: The place's address in adr microformat:
	// http://microformats.org/wiki/adr.
	AdrFormatAddress string `json:"adrFormatAddress,omitempty"`
	// AllowsDogs: Place allows dogs.
	AllowsDogs bool `json:"allowsDogs,omitempty"`
	// AreaSummary: Experimental: See
	// https://developers.google.com/maps/documentation/places/web-service/experimental/places-generative
	// for more details. AI-generated summary of the area that the place is in.
	AreaSummary *GoogleMapsPlacesV1PlaceAreaSummary `json:"areaSummary,omitempty"`
	// Attributions: A set of data provider that must be shown with this result.
	Attributions []*GoogleMapsPlacesV1PlaceAttribution `json:"attributions,omitempty"`
	// BusinessStatus: The business status for the place.
	//
	// Possible values:
	//   "BUSINESS_STATUS_UNSPECIFIED" - Default value. This value is unused.
	//   "OPERATIONAL" - The establishment is operational, not necessarily open
	// now.
	//   "CLOSED_TEMPORARILY" - The establishment is temporarily closed.
	//   "CLOSED_PERMANENTLY" - The establishment is permanently closed.
	BusinessStatus string `json:"businessStatus,omitempty"`
	// CurbsidePickup: Specifies if the business supports curbside pickup.
	CurbsidePickup bool `json:"curbsidePickup,omitempty"`
	// CurrentOpeningHours: The hours of operation for the next seven days
	// (including today). The time period starts at midnight on the date of the
	// request and ends at 11:59 pm six days later. This field includes the
	// special_days subfield of all hours, set for dates that have exceptional
	// hours.
	CurrentOpeningHours *GoogleMapsPlacesV1PlaceOpeningHours `json:"currentOpeningHours,omitempty"`
	// CurrentSecondaryOpeningHours: Contains an array of entries for the next
	// seven days including information about secondary hours of a business.
	// Secondary hours are different from a business's main hours. For example, a
	// restaurant can specify drive through hours or delivery hours as its
	// secondary hours. This field populates the type subfield, which draws from a
	// predefined list of opening hours types (such as DRIVE_THROUGH, PICKUP, or
	// TAKEOUT) based on the types of the place. This field includes the
	// special_days subfield of all hours, set for dates that have exceptional
	// hours.
	CurrentSecondaryOpeningHours []*GoogleMapsPlacesV1PlaceOpeningHours `json:"currentSecondaryOpeningHours,omitempty"`
	// Delivery: Specifies if the business supports delivery.
	Delivery bool `json:"delivery,omitempty"`
	// DineIn: Specifies if the business supports indoor or outdoor seating
	// options.
	DineIn bool `json:"dineIn,omitempty"`
	// DisplayName: The localized name of the place, suitable as a short
	// human-readable description. For example, "Google Sydney", "Starbucks",
	// "Pyrmont", etc.
	DisplayName *GoogleTypeLocalizedText `json:"displayName,omitempty"`
	// EditorialSummary: Contains a summary of the place. A summary is comprised of
	// a textual overview, and also includes the language code for these if
	// applicable. Summary text must be presented as-is and can not be modified or
	// altered.
	EditorialSummary *GoogleTypeLocalizedText `json:"editorialSummary,omitempty"`
	// EvChargeOptions: Information of ev charging options.
	EvChargeOptions *GoogleMapsPlacesV1EVChargeOptions `json:"evChargeOptions,omitempty"`
	// FormattedAddress: A full, human-readable address for this place.
	FormattedAddress string `json:"formattedAddress,omitempty"`
	// FuelOptions: The most recent information about fuel options in a gas
	// station. This information is updated regularly.
	FuelOptions *GoogleMapsPlacesV1FuelOptions `json:"fuelOptions,omitempty"`
	// GenerativeSummary: Experimental: See
	// https://developers.google.com/maps/documentation/places/web-service/experimental/places-generative
	// for more details. AI-generated summary of the place.
	GenerativeSummary *GoogleMapsPlacesV1PlaceGenerativeSummary `json:"generativeSummary,omitempty"`
	// GoodForChildren: Place is good for children.
	GoodForChildren bool `json:"goodForChildren,omitempty"`
	// GoodForGroups: Place accommodates groups.
	GoodForGroups bool `json:"goodForGroups,omitempty"`
	// GoodForWatchingSports: Place is suitable for watching sports.
	GoodForWatchingSports bool `json:"goodForWatchingSports,omitempty"`
	// GoogleMapsUri: A URL providing more information about this place.
	GoogleMapsUri string `json:"googleMapsUri,omitempty"`
	// IconBackgroundColor: Background color for icon_mask in hex format, e.g.
	// #909CE1.
	IconBackgroundColor string `json:"iconBackgroundColor,omitempty"`
	// IconMaskBaseUri: A truncated URL to an icon mask. User can access different
	// icon type by appending type suffix to the end (eg, ".svg" or ".png").
	IconMaskBaseUri string `json:"iconMaskBaseUri,omitempty"`
	// Id: The unique identifier of a place.
	Id string `json:"id,omitempty"`
	// InternationalPhoneNumber: A human-readable phone number for the place, in
	// international format.
	InternationalPhoneNumber string `json:"internationalPhoneNumber,omitempty"`
	// LiveMusic: Place provides live music.
	LiveMusic bool `json:"liveMusic,omitempty"`
	// Location: The position of this place.
	Location *GoogleTypeLatLng `json:"location,omitempty"`
	// MenuForChildren: Place has a children's menu.
	MenuForChildren bool `json:"menuForChildren,omitempty"`
	// Name: This Place's resource name, in `places/{place_id}` format. Can be used
	// to look up the Place.
	Name string `json:"name,omitempty"`
	// NationalPhoneNumber: A human-readable phone number for the place, in
	// national format.
	NationalPhoneNumber string `json:"nationalPhoneNumber,omitempty"`
	// OutdoorSeating: Place provides outdoor seating.
	OutdoorSeating bool `json:"outdoorSeating,omitempty"`
	// ParkingOptions: Options of parking provided by the place.
	ParkingOptions *GoogleMapsPlacesV1PlaceParkingOptions `json:"parkingOptions,omitempty"`
	// PaymentOptions: Payment options the place accepts. If a payment option data
	// is not available, the payment option field will be unset.
	PaymentOptions *GoogleMapsPlacesV1PlacePaymentOptions `json:"paymentOptions,omitempty"`
	// Photos: Information (including references) about photos of this place. A
	// maximum of 10 photos can be returned.
	Photos []*GoogleMapsPlacesV1Photo `json:"photos,omitempty"`
	// PlusCode: Plus code of the place location lat/long.
	PlusCode *GoogleMapsPlacesV1PlacePlusCode `json:"plusCode,omitempty"`
	// PriceLevel: Price level of the place.
	//
	// Possible values:
	//   "PRICE_LEVEL_UNSPECIFIED" - Place price level is unspecified or unknown.
	//   "PRICE_LEVEL_FREE" - Place provides free services.
	//   "PRICE_LEVEL_INEXPENSIVE" - Place provides inexpensive services.
	//   "PRICE_LEVEL_MODERATE" - Place provides moderately priced services.
	//   "PRICE_LEVEL_EXPENSIVE" - Place provides expensive services.
	//   "PRICE_LEVEL_VERY_EXPENSIVE" - Place provides very expensive services.
	PriceLevel string `json:"priceLevel,omitempty"`
	// PrimaryType: The primary type of the given result. This type must one of the
	// Places API supported types. For example, "restaurant", "cafe", "airport",
	// etc. A place can only have a single primary type. For the complete list of
	// possible values, see Table A and Table B at
	// https://developers.google.com/maps/documentation/places/web-service/place-types
	PrimaryType string `json:"primaryType,omitempty"`
	// PrimaryTypeDisplayName: The display name of the primary type, localized to
	// the request language if applicable. For the complete list of possible
	// values, see Table A and Table B at
	// https://developers.google.com/maps/documentation/places/web-service/place-types
	PrimaryTypeDisplayName *GoogleTypeLocalizedText `json:"primaryTypeDisplayName,omitempty"`
	// Rating: A rating between 1.0 and 5.0, based on user reviews of this place.
	Rating float64 `json:"rating,omitempty"`
	// RegularOpeningHours: The regular hours of operation.
	RegularOpeningHours *GoogleMapsPlacesV1PlaceOpeningHours `json:"regularOpeningHours,omitempty"`
	// RegularSecondaryOpeningHours: Contains an array of entries for information
	// about regular secondary hours of a business. Secondary hours are different
	// from a business's main hours. For example, a restaurant can specify drive
	// through hours or delivery hours as its secondary hours. This field populates
	// the type subfield, which draws from a predefined list of opening hours types
	// (such as DRIVE_THROUGH, PICKUP, or TAKEOUT) based on the types of the place.
	RegularSecondaryOpeningHours []*GoogleMapsPlacesV1PlaceOpeningHours `json:"regularSecondaryOpeningHours,omitempty"`
	// Reservable: Specifies if the place supports reservations.
	Reservable bool `json:"reservable,omitempty"`
	// Restroom: Place has restroom.
	Restroom bool `json:"restroom,omitempty"`
	// Reviews: List of reviews about this place, sorted by relevance. A maximum of
	// 5 reviews can be returned.
	Reviews []*GoogleMapsPlacesV1Review `json:"reviews,omitempty"`
	// ServesBeer: Specifies if the place serves beer.
	ServesBeer bool `json:"servesBeer,omitempty"`
	// ServesBreakfast: Specifies if the place serves breakfast.
	ServesBreakfast bool `json:"servesBreakfast,omitempty"`
	// ServesBrunch: Specifies if the place serves brunch.
	ServesBrunch bool `json:"servesBrunch,omitempty"`
	// ServesCocktails: Place serves cocktails.
	ServesCocktails bool `json:"servesCocktails,omitempty"`
	// ServesCoffee: Place serves coffee.
	ServesCoffee bool `json:"servesCoffee,omitempty"`
	// ServesDessert: Place serves dessert.
	ServesDessert bool `json:"servesDessert,omitempty"`
	// ServesDinner: Specifies if the place serves dinner.
	ServesDinner bool `json:"servesDinner,omitempty"`
	// ServesLunch: Specifies if the place serves lunch.
	ServesLunch bool `json:"servesLunch,omitempty"`
	// ServesVegetarianFood: Specifies if the place serves vegetarian food.
	ServesVegetarianFood bool `json:"servesVegetarianFood,omitempty"`
	// ServesWine: Specifies if the place serves wine.
	ServesWine bool `json:"servesWine,omitempty"`
	// ShortFormattedAddress: A short, human-readable address for this place.
	ShortFormattedAddress string `json:"shortFormattedAddress,omitempty"`
	// SubDestinations: A list of sub destinations related to the place.
	SubDestinations []*GoogleMapsPlacesV1PlaceSubDestination `json:"subDestinations,omitempty"`
	// Takeout: Specifies if the business supports takeout.
	Takeout bool `json:"takeout,omitempty"`
	// Types: A set of type tags for this result. For example, "political" and
	// "locality". For the complete list of possible values, see Table A and Table
	// B at
	// https://developers.google.com/maps/documentation/places/web-service/place-types
	Types []string `json:"types,omitempty"`
	// UserRatingCount: The total number of reviews (with or without text) for this
	// place.
	UserRatingCount int64 `json:"userRatingCount,omitempty"`
	// UtcOffsetMinutes: Number of minutes this place's timezone is currently
	// offset from UTC. This is expressed in minutes to support timezones that are
	// offset by fractions of an hour, e.g. X hours and 15 minutes.
	UtcOffsetMinutes int64 `json:"utcOffsetMinutes,omitempty"`
	// Viewport: A viewport suitable for displaying the place on an average-sized
	// map.
	Viewport *GoogleGeoTypeViewport `json:"viewport,omitempty"`
	// WebsiteUri: The authoritative website for this place, e.g. a business'
	// homepage. Note that for places that are part of a chain (e.g. an IKEA
	// store), this will usually be the website for the individual store, not the
	// overall chain.
	WebsiteUri string `json:"websiteUri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AccessibilityOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessibilityOptions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1Place) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1Place
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleMapsPlacesV1Place) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleMapsPlacesV1Place
	var s1 struct {
		Rating gensupport.JSONFloat64 `json:"rating"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Rating = float64(s1.Rating)
	return nil
}

// GoogleMapsPlacesV1PlaceAccessibilityOptions: Information about the
// accessibility options a place offers.
type GoogleMapsPlacesV1PlaceAccessibilityOptions struct {
	// WheelchairAccessibleEntrance: Places has wheelchair accessible entrance.
	WheelchairAccessibleEntrance bool `json:"wheelchairAccessibleEntrance,omitempty"`
	// WheelchairAccessibleParking: Place offers wheelchair accessible parking.
	WheelchairAccessibleParking bool `json:"wheelchairAccessibleParking,omitempty"`
	// WheelchairAccessibleRestroom: Place has wheelchair accessible restroom.
	WheelchairAccessibleRestroom bool `json:"wheelchairAccessibleRestroom,omitempty"`
	// WheelchairAccessibleSeating: Place has wheelchair accessible seating.
	WheelchairAccessibleSeating bool `json:"wheelchairAccessibleSeating,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "WheelchairAccessibleEntrance") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "WheelchairAccessibleEntrance") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1PlaceAccessibilityOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceAccessibilityOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlaceAddressComponent: The structured components that form
// the formatted address, if this information is available.
type GoogleMapsPlacesV1PlaceAddressComponent struct {
	// LanguageCode: The language used to format this components, in CLDR notation.
	LanguageCode string `json:"languageCode,omitempty"`
	// LongText: The full text description or name of the address component. For
	// example, an address component for the country Australia may have a long_name
	// of "Australia".
	LongText string `json:"longText,omitempty"`
	// ShortText: An abbreviated textual name for the address component, if
	// available. For example, an address component for the country of Australia
	// may have a short_name of "AU".
	ShortText string `json:"shortText,omitempty"`
	// Types: An array indicating the type(s) of the address component.
	Types []string `json:"types,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1PlaceAddressComponent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceAddressComponent
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlaceAreaSummary: Experimental: See
// https://developers.google.com/maps/documentation/places/web-service/experimental/places-generative
// for more details. AI-generated summary of the area that the place is in.
type GoogleMapsPlacesV1PlaceAreaSummary struct {
	// ContentBlocks: Content blocks that compose the area summary. Each block has
	// a separate topic about the area.
	ContentBlocks []*GoogleMapsPlacesV1ContentBlock `json:"contentBlocks,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContentBlocks") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContentBlocks") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1PlaceAreaSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceAreaSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlaceAttribution: Information about data providers of this
// place.
type GoogleMapsPlacesV1PlaceAttribution struct {
	// Provider: Name of the Place's data provider.
	Provider string `json:"provider,omitempty"`
	// ProviderUri: URI to the Place's data provider.
	ProviderUri string `json:"providerUri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Provider") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Provider") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1PlaceAttribution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceAttribution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlaceGenerativeSummary: Experimental: See
// https://developers.google.com/maps/documentation/places/web-service/experimental/places-generative
// for more details. AI-generated summary of the place.
type GoogleMapsPlacesV1PlaceGenerativeSummary struct {
	// Description: The detailed description of the place.
	Description *GoogleTypeLocalizedText `json:"description,omitempty"`
	// Overview: The overview of the place.
	Overview *GoogleTypeLocalizedText `json:"overview,omitempty"`
	// References: References that are used to generate the summary description.
	References *GoogleMapsPlacesV1References `json:"references,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1PlaceGenerativeSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceGenerativeSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlaceOpeningHours: Information about business hour of the
// place.
type GoogleMapsPlacesV1PlaceOpeningHours struct {
	// OpenNow: Whether the opening hours period is currently active. For regular
	// opening hours and current opening hours, this field means whether the place
	// is open. For secondary opening hours and current secondary opening hours,
	// this field means whether the secondary hours of this place is active.
	OpenNow bool `json:"openNow,omitempty"`
	// Periods: The periods that this place is open during the week. The periods
	// are in chronological order, starting with Sunday in the place-local
	// timezone. An empty (but not absent) value indicates a place that is never
	// open, e.g. because it is closed temporarily for renovations.
	Periods []*GoogleMapsPlacesV1PlaceOpeningHoursPeriod `json:"periods,omitempty"`
	// SecondaryHoursType: A type string used to identify the type of secondary
	// hours.
	//
	// Possible values:
	//   "SECONDARY_HOURS_TYPE_UNSPECIFIED" - Default value when secondary hour
	// type is not specified.
	//   "DRIVE_THROUGH" - The drive-through hour for banks, restaurants, or
	// pharmacies.
	//   "HAPPY_HOUR" - The happy hour.
	//   "DELIVERY" - The delivery hour.
	//   "TAKEOUT" - The takeout hour.
	//   "KITCHEN" - The kitchen hour.
	//   "BREAKFAST" - The breakfast hour.
	//   "LUNCH" - The lunch hour.
	//   "DINNER" - The dinner hour.
	//   "BRUNCH" - The brunch hour.
	//   "PICKUP" - The pickup hour.
	//   "ACCESS" - The access hours for storage places.
	//   "SENIOR_HOURS" - The special hours for seniors.
	//   "ONLINE_SERVICE_HOURS" - The online service hours.
	SecondaryHoursType string `json:"secondaryHoursType,omitempty"`
	// SpecialDays: Structured information for special days that fall within the
	// period that the returned opening hours cover. Special days are days that
	// could impact the business hours of a place, e.g. Christmas day. Set for
	// current_opening_hours and current_secondary_opening_hours if there are
	// exceptional hours.
	SpecialDays []*GoogleMapsPlacesV1PlaceOpeningHoursSpecialDay `json:"specialDays,omitempty"`
	// WeekdayDescriptions: Localized strings describing the opening hours of this
	// place, one string for each day of the week. Will be empty if the hours are
	// unknown or could not be converted to localized text. Example: "Sun:
	// 18:00–06:00"
	WeekdayDescriptions []string `json:"weekdayDescriptions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "OpenNow") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OpenNow") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1PlaceOpeningHours) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceOpeningHours
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlaceOpeningHoursPeriod: A period the place remains in
// open_now status.
type GoogleMapsPlacesV1PlaceOpeningHoursPeriod struct {
	// Close: The time that the place starts to be closed.
	Close *GoogleMapsPlacesV1PlaceOpeningHoursPeriodPoint `json:"close,omitempty"`
	// Open: The time that the place starts to be open.
	Open *GoogleMapsPlacesV1PlaceOpeningHoursPeriodPoint `json:"open,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Close") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Close") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1PlaceOpeningHoursPeriod) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceOpeningHoursPeriod
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlaceOpeningHoursPeriodPoint: Status changing points.
type GoogleMapsPlacesV1PlaceOpeningHoursPeriodPoint struct {
	// Date: Date in the local timezone for the place.
	Date *GoogleTypeDate `json:"date,omitempty"`
	// Day: A day of the week, as an integer in the range 0-6. 0 is Sunday, 1 is
	// Monday, etc.
	Day int64 `json:"day,omitempty"`
	// Hour: The hour in 2 digits. Ranges from 00 to 23.
	Hour int64 `json:"hour,omitempty"`
	// Minute: The minute in 2 digits. Ranges from 00 to 59.
	Minute int64 `json:"minute,omitempty"`
	// Truncated: Whether or not this endpoint was truncated. Truncation occurs
	// when the real hours are outside the times we are willing to return hours
	// between, so we truncate the hours back to these boundaries. This ensures
	// that at most 24 * 7 hours from midnight of the day of the request are
	// returned.
	Truncated bool `json:"truncated,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Date") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Date") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1PlaceOpeningHoursPeriodPoint) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceOpeningHoursPeriodPoint
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlaceOpeningHoursSpecialDay: Structured information for
// special days that fall within the period that the returned opening hours
// cover. Special days are days that could impact the business hours of a
// place, e.g. Christmas day.
type GoogleMapsPlacesV1PlaceOpeningHoursSpecialDay struct {
	// Date: The date of this special day.
	Date *GoogleTypeDate `json:"date,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Date") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Date") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1PlaceOpeningHoursSpecialDay) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceOpeningHoursSpecialDay
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlaceParkingOptions: Information about parking options for
// the place. A parking lot could support more than one option at the same
// time.
type GoogleMapsPlacesV1PlaceParkingOptions struct {
	// FreeGarageParking: Place offers free garage parking.
	FreeGarageParking bool `json:"freeGarageParking,omitempty"`
	// FreeParkingLot: Place offers free parking lots.
	FreeParkingLot bool `json:"freeParkingLot,omitempty"`
	// FreeStreetParking: Place offers free street parking.
	FreeStreetParking bool `json:"freeStreetParking,omitempty"`
	// PaidGarageParking: Place offers paid garage parking.
	PaidGarageParking bool `json:"paidGarageParking,omitempty"`
	// PaidParkingLot: Place offers paid parking lots.
	PaidParkingLot bool `json:"paidParkingLot,omitempty"`
	// PaidStreetParking: Place offers paid street parking.
	PaidStreetParking bool `json:"paidStreetParking,omitempty"`
	// ValetParking: Place offers valet parking.
	ValetParking bool `json:"valetParking,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FreeGarageParking") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FreeGarageParking") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1PlaceParkingOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceParkingOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlacePaymentOptions: Payment options the place accepts.
type GoogleMapsPlacesV1PlacePaymentOptions struct {
	// AcceptsCashOnly: Place accepts cash only as payment. Places with this
	// attribute may still accept other payment methods.
	AcceptsCashOnly bool `json:"acceptsCashOnly,omitempty"`
	// AcceptsCreditCards: Place accepts credit cards as payment.
	AcceptsCreditCards bool `json:"acceptsCreditCards,omitempty"`
	// AcceptsDebitCards: Place accepts debit cards as payment.
	AcceptsDebitCards bool `json:"acceptsDebitCards,omitempty"`
	// AcceptsNfc: Place accepts NFC payments.
	AcceptsNfc bool `json:"acceptsNfc,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcceptsCashOnly") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcceptsCashOnly") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1PlacePaymentOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlacePaymentOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlacePlusCode: Plus code (http://plus.codes) is a location
// reference with two formats: global code defining a 14mx14m (1/8000th of a
// degree) or smaller rectangle, and compound code, replacing the prefix with a
// reference location.
type GoogleMapsPlacesV1PlacePlusCode struct {
	// CompoundCode: Place's compound code, such as "33GV+HQ, Ramberg, Norway",
	// containing the suffix of the global code and replacing the prefix with a
	// formatted name of a reference entity.
	CompoundCode string `json:"compoundCode,omitempty"`
	// GlobalCode: Place's global (full) code, such as "9FWM33GV+HQ", representing
	// an 1/8000 by 1/8000 degree area (~14 by 14 meters).
	GlobalCode string `json:"globalCode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompoundCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompoundCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1PlacePlusCode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlacePlusCode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1PlaceSubDestination: Place resource name and id of sub
// destinations that relate to the place. For example, different terminals are
// different destinations of an airport.
type GoogleMapsPlacesV1PlaceSubDestination struct {
	// Id: The place id of the sub destination.
	Id string `json:"id,omitempty"`
	// Name: The resource name of the sub destination.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1PlaceSubDestination) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1PlaceSubDestination
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1Polyline: A route polyline. Only supports an encoded
// polyline
// (https://developers.google.com/maps/documentation/utilities/polylinealgorithm),
// which can be passed as a string and includes compression with minimal
// lossiness. This is the Routes API default output.
type GoogleMapsPlacesV1Polyline struct {
	// EncodedPolyline: An encoded polyline
	// (https://developers.google.com/maps/documentation/utilities/polylinealgorithm),
	// as returned by the Routes API by default
	// (https://developers.google.com/maps/documentation/routes/reference/rest/v2/TopLevel/computeRoutes#polylineencoding).
	// See the encoder
	// (https://developers.google.com/maps/documentation/utilities/polylineutility)
	// and decoder
	// (https://developers.google.com/maps/documentation/routes/polylinedecoder)
	// tools.
	EncodedPolyline string `json:"encodedPolyline,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EncodedPolyline") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EncodedPolyline") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1Polyline) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1Polyline
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1References: Experimental: See
// https://developers.google.com/maps/documentation/places/web-service/experimental/places-generative
// for more details. Reference that the generative content is related to.
type GoogleMapsPlacesV1References struct {
	// Places: The list of resource names of the referenced places. This name can
	// be used in other APIs that accept Place resource names.
	Places []string `json:"places,omitempty"`
	// Reviews: Reviews that serve as references.
	Reviews []*GoogleMapsPlacesV1Review `json:"reviews,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Places") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Places") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1References) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1References
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1Review: Information about a review of a place.
type GoogleMapsPlacesV1Review struct {
	// AuthorAttribution: This review's author.
	AuthorAttribution *GoogleMapsPlacesV1AuthorAttribution `json:"authorAttribution,omitempty"`
	// Name: A reference representing this place review which may be used to look
	// up this place review again (also called the API "resource" name:
	// `places/{place_id}/reviews/{review}`).
	Name string `json:"name,omitempty"`
	// OriginalText: The review text in its original language.
	OriginalText *GoogleTypeLocalizedText `json:"originalText,omitempty"`
	// PublishTime: Timestamp for the review.
	PublishTime string `json:"publishTime,omitempty"`
	// Rating: A number between 1.0 and 5.0, also called the number of stars.
	Rating float64 `json:"rating,omitempty"`
	// RelativePublishTimeDescription: A string of formatted recent time,
	// expressing the review time relative to the current time in a form
	// appropriate for the language and country.
	RelativePublishTimeDescription string `json:"relativePublishTimeDescription,omitempty"`
	// Text: The localized text of the review.
	Text *GoogleTypeLocalizedText `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuthorAttribution") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuthorAttribution") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1Review) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1Review
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleMapsPlacesV1Review) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleMapsPlacesV1Review
	var s1 struct {
		Rating gensupport.JSONFloat64 `json:"rating"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Rating = float64(s1.Rating)
	return nil
}

// GoogleMapsPlacesV1RouteModifiers: Encapsulates a set of optional conditions
// to satisfy when calculating the routes.
type GoogleMapsPlacesV1RouteModifiers struct {
	// AvoidFerries: Optional. When set to true, avoids ferries where reasonable,
	// giving preference to routes not containing ferries. Applies only to the
	// `DRIVE` and `TWO_WHEELER` `TravelMode`.
	AvoidFerries bool `json:"avoidFerries,omitempty"`
	// AvoidHighways: Optional. When set to true, avoids highways where reasonable,
	// giving preference to routes not containing highways. Applies only to the
	// `DRIVE` and `TWO_WHEELER` `TravelMode`.
	AvoidHighways bool `json:"avoidHighways,omitempty"`
	// AvoidIndoor: Optional. When set to true, avoids navigating indoors where
	// reasonable, giving preference to routes not containing indoor navigation.
	// Applies only to the `WALK` `TravelMode`.
	AvoidIndoor bool `json:"avoidIndoor,omitempty"`
	// AvoidTolls: Optional. When set to true, avoids toll roads where reasonable,
	// giving preference to routes not containing toll roads. Applies only to the
	// `DRIVE` and `TWO_WHEELER` `TravelMode`.
	AvoidTolls bool `json:"avoidTolls,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AvoidFerries") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvoidFerries") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1RouteModifiers) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1RouteModifiers
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1RoutingParameters: Parameters to configure the routing
// calculations to the places in the response, both along a route (where result
// ranking will be influenced) and for calculating travel times on results.
type GoogleMapsPlacesV1RoutingParameters struct {
	// Origin: Optional. An explicit routing origin that overrides the origin
	// defined in the polyline. By default, the polyline origin is used.
	Origin *GoogleTypeLatLng `json:"origin,omitempty"`
	// RouteModifiers: Optional. The route modifiers.
	RouteModifiers *GoogleMapsPlacesV1RouteModifiers `json:"routeModifiers,omitempty"`
	// RoutingPreference: Optional. Specifies how to compute the routing summaries.
	// The server attempts to use the selected routing preference to compute the
	// route. The traffic aware routing preference is only available for the
	// `DRIVE` or `TWO_WHEELER` `travelMode`.
	//
	// Possible values:
	//   "ROUTING_PREFERENCE_UNSPECIFIED" - No routing preference specified.
	// Default to `TRAFFIC_UNAWARE`.
	//   "TRAFFIC_UNAWARE" - Computes routes without taking live traffic conditions
	// into consideration. Suitable when traffic conditions don't matter or are not
	// applicable. Using this value produces the lowest latency. Note: For
	// `TravelMode` `DRIVE` and `TWO_WHEELER`, the route and duration chosen are
	// based on road network and average time-independent traffic conditions, not
	// current road conditions. Consequently, routes may include roads that are
	// temporarily closed. Results for a given request may vary over time due to
	// changes in the road network, updated average traffic conditions, and the
	// distributed nature of the service. Results may also vary between
	// nearly-equivalent routes at any time or frequency.
	//   "TRAFFIC_AWARE" - Calculates routes taking live traffic conditions into
	// consideration. In contrast to `TRAFFIC_AWARE_OPTIMAL`, some optimizations
	// are applied to significantly reduce latency.
	//   "TRAFFIC_AWARE_OPTIMAL" - Calculates the routes taking live traffic
	// conditions into consideration, without applying most performance
	// optimizations. Using this value produces the highest latency.
	RoutingPreference string `json:"routingPreference,omitempty"`
	// TravelMode: Optional. The travel mode.
	//
	// Possible values:
	//   "TRAVEL_MODE_UNSPECIFIED" - No travel mode specified. Defaults to `DRIVE`.
	//   "DRIVE" - Travel by passenger car.
	//   "BICYCLE" - Travel by bicycle. Not supported with
	// `search_along_route_parameters`.
	//   "WALK" - Travel by walking. Not supported with
	// `search_along_route_parameters`.
	//   "TWO_WHEELER" - Motorized two wheeled vehicles of all kinds such as
	// scooters and motorcycles. Note that this is distinct from the `BICYCLE`
	// travel mode which covers human-powered transport. Not supported with
	// `search_along_route_parameters`. Only supported in those countries listed at
	// [Countries and regions supported for two-wheeled
	// vehicles](https://developers.google.com/maps/documentation/routes/coverage-tw
	// o-wheeled).
	TravelMode string `json:"travelMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Origin") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Origin") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1RoutingParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1RoutingParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1RoutingSummary: The duration and distance from the routing
// origin to a place in the response, and a second leg from that place to the
// destination, if requested. **Note:** Adding `routingSummaries` in the field
// mask without also including either the `routingParameters.origin` parameter
// or the `searchAlongRouteParameters.polyline.encodedPolyline` parameter in
// the request causes an error.
type GoogleMapsPlacesV1RoutingSummary struct {
	// Legs: The legs of the trip. When you calculate travel duration and distance
	// from a set origin, `legs` contains a single leg containing the duration and
	// distance from the origin to the destination. When you do a search along
	// route, `legs` contains two legs: one from the origin to place, and one from
	// the place to the destination.
	Legs []*GoogleMapsPlacesV1RoutingSummaryLeg `json:"legs,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Legs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Legs") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1RoutingSummary) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1RoutingSummary
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1RoutingSummaryLeg: A leg is a single portion of a journey
// from one location to another.
type GoogleMapsPlacesV1RoutingSummaryLeg struct {
	// DistanceMeters: The distance of this leg of the trip.
	DistanceMeters int64 `json:"distanceMeters,omitempty"`
	// Duration: The time it takes to complete this leg of the trip.
	Duration string `json:"duration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DistanceMeters") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DistanceMeters") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1RoutingSummaryLeg) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1RoutingSummaryLeg
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1SearchNearbyRequest: Request proto for Search Nearby.
type GoogleMapsPlacesV1SearchNearbyRequest struct {
	// ExcludedPrimaryTypes: Excluded primary Place type (e.g. "restaurant" or
	// "gas_station") from
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	// Up to 50 types from Table A
	// (https://developers.google.com/maps/documentation/places/web-service/place-types#table-a)
	// may be specified. If there are any conflicting primary types, i.e. a type
	// appears in both included_primary_types and excluded_primary_types, an
	// INVALID_ARGUMENT error is returned. If a Place type is specified with
	// multiple type restrictions, only places that satisfy all of the restrictions
	// are returned. For example, if we have {included_types = ["restaurant"],
	// excluded_primary_types = ["restaurant"]}, the returned places provide
	// "restaurant" related services but do not operate primarily as "restaurants".
	ExcludedPrimaryTypes []string `json:"excludedPrimaryTypes,omitempty"`
	// ExcludedTypes: Excluded Place type (eg, "restaurant" or "gas_station") from
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	// Up to 50 types from Table A
	// (https://developers.google.com/maps/documentation/places/web-service/place-types#table-a)
	// may be specified. If the client provides both included_types (e.g.
	// restaurant) and excluded_types (e.g. cafe), then the response should include
	// places that are restaurant but not cafe. The response includes places that
	// match at least one of the included_types and none of the excluded_types. If
	// there are any conflicting types, i.e. a type appears in both included_types
	// and excluded_types, an INVALID_ARGUMENT error is returned. If a Place type
	// is specified with multiple type restrictions, only places that satisfy all
	// of the restrictions are returned. For example, if we have {included_types =
	// ["restaurant"], excluded_primary_types = ["restaurant"]}, the returned
	// places provide "restaurant" related services but do not operate primarily as
	// "restaurants".
	ExcludedTypes []string `json:"excludedTypes,omitempty"`
	// IncludedPrimaryTypes: Included primary Place type (e.g. "restaurant" or
	// "gas_station") from
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	// A place can only have a single primary type from the supported types table
	// associated with it. Up to 50 types from Table A
	// (https://developers.google.com/maps/documentation/places/web-service/place-types#table-a)
	// may be specified. If there are any conflicting primary types, i.e. a type
	// appears in both included_primary_types and excluded_primary_types, an
	// INVALID_ARGUMENT error is returned. If a Place type is specified with
	// multiple type restrictions, only places that satisfy all of the restrictions
	// are returned. For example, if we have {included_types = ["restaurant"],
	// excluded_primary_types = ["restaurant"]}, the returned places provide
	// "restaurant" related services but do not operate primarily as "restaurants".
	IncludedPrimaryTypes []string `json:"includedPrimaryTypes,omitempty"`
	// IncludedTypes: Included Place type (eg, "restaurant" or "gas_station") from
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	// Up to 50 types from Table A
	// (https://developers.google.com/maps/documentation/places/web-service/place-types#table-a)
	// may be specified. If there are any conflicting types, i.e. a type appears in
	// both included_types and excluded_types, an INVALID_ARGUMENT error is
	// returned. If a Place type is specified with multiple type restrictions, only
	// places that satisfy all of the restrictions are returned. For example, if we
	// have {included_types = ["restaurant"], excluded_primary_types =
	// ["restaurant"]}, the returned places provide "restaurant" related services
	// but do not operate primarily as "restaurants".
	IncludedTypes []string `json:"includedTypes,omitempty"`
	// LanguageCode: Place details will be displayed with the preferred language if
	// available. If the language code is unspecified or unrecognized, place
	// details of any language may be returned, with a preference for English if
	// such details exist. Current list of supported languages:
	// https://developers.google.com/maps/faq#languagesupport.
	LanguageCode string `json:"languageCode,omitempty"`
	// LocationRestriction: Required. The region to search.
	LocationRestriction *GoogleMapsPlacesV1SearchNearbyRequestLocationRestriction `json:"locationRestriction,omitempty"`
	// MaxResultCount: Maximum number of results to return. It must be between 1
	// and 20 (default), inclusively. If the number is unset, it falls back to the
	// upper limit. If the number is set to negative or exceeds the upper limit, an
	// INVALID_ARGUMENT error is returned.
	MaxResultCount int64 `json:"maxResultCount,omitempty"`
	// RankPreference: How results will be ranked in the response.
	//
	// Possible values:
	//   "RANK_PREFERENCE_UNSPECIFIED" - RankPreference value not set. Will use
	// rank by POPULARITY by default.
	//   "DISTANCE" - Ranks results by distance.
	//   "POPULARITY" - Ranks results by popularity.
	RankPreference string `json:"rankPreference,omitempty"`
	// RegionCode: The Unicode country/region code (CLDR) of the location where the
	// request is coming from. This parameter is used to display the place details,
	// like region-specific place name, if available. The parameter can affect
	// results based on applicable law. For more information, see
	// https://www.unicode.org/cldr/charts/latest/supplemental/territory_language_information.html.
	// Note that 3-digit region codes are not currently supported.
	RegionCode string `json:"regionCode,omitempty"`
	// RoutingParameters: Optional. Parameters that affect the routing to the
	// search results.
	RoutingParameters *GoogleMapsPlacesV1RoutingParameters `json:"routingParameters,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExcludedPrimaryTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExcludedPrimaryTypes") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1SearchNearbyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1SearchNearbyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1SearchNearbyRequestLocationRestriction: The region to
// search.
type GoogleMapsPlacesV1SearchNearbyRequestLocationRestriction struct {
	// Circle: A circle defined by center point and radius.
	Circle *GoogleMapsPlacesV1Circle `json:"circle,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Circle") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Circle") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1SearchNearbyRequestLocationRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1SearchNearbyRequestLocationRestriction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1SearchNearbyResponse: Response proto for Search Nearby.
type GoogleMapsPlacesV1SearchNearbyResponse struct {
	// Places: A list of places that meets user's requirements like places types,
	// number of places and specific location restriction.
	Places []*GoogleMapsPlacesV1Place `json:"places,omitempty"`
	// RoutingSummaries: A list of routing summaries where each entry associates to
	// the corresponding place in the same index in the `places` field. If the
	// routing summary is not available for one of the places, it will contain an
	// empty entry. This list should have as many entries as the list of places if
	// requested.
	RoutingSummaries []*GoogleMapsPlacesV1RoutingSummary `json:"routingSummaries,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Places") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Places") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1SearchNearbyResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1SearchNearbyResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1SearchTextRequest: Request proto for SearchText.
type GoogleMapsPlacesV1SearchTextRequest struct {
	// EvOptions: Optional. Set the searchable EV options of a place search
	// request.
	EvOptions *GoogleMapsPlacesV1SearchTextRequestEVOptions `json:"evOptions,omitempty"`
	// IncludedType: The requested place type. Full list of types supported:
	// https://developers.google.com/maps/documentation/places/web-service/place-types.
	// Only support one included type.
	IncludedType string `json:"includedType,omitempty"`
	// LanguageCode: Place details will be displayed with the preferred language if
	// available. If the language code is unspecified or unrecognized, place
	// details of any language may be returned, with a preference for English if
	// such details exist. Current list of supported languages:
	// https://developers.google.com/maps/faq#languagesupport.
	LanguageCode string `json:"languageCode,omitempty"`
	// LocationBias: The region to search. This location serves as a bias which
	// means results around given location might be returned. Cannot be set along
	// with location_restriction.
	LocationBias *GoogleMapsPlacesV1SearchTextRequestLocationBias `json:"locationBias,omitempty"`
	// LocationRestriction: The region to search. This location serves as a
	// restriction which means results outside given location will not be returned.
	// Cannot be set along with location_bias.
	LocationRestriction *GoogleMapsPlacesV1SearchTextRequestLocationRestriction `json:"locationRestriction,omitempty"`
	// MaxResultCount: Deprecated: Use `page_size` instead. The maximum number of
	// results per page that can be returned. If the number of available results is
	// larger than `max_result_count`, a `next_page_token` is returned which can be
	// passed to `page_token` to get the next page of results in subsequent
	// requests. If 0 or no value is provided, a default of 20 is used. The maximum
	// value is 20; values above 20 will be coerced to 20. Negative values will
	// return an INVALID_ARGUMENT error. If both `max_result_count` and `page_size`
	// are specified, `max_result_count` will be ignored.
	MaxResultCount int64 `json:"maxResultCount,omitempty"`
	// MinRating: Filter out results whose average user rating is strictly less
	// than this limit. A valid value must be a float between 0 and 5 (inclusively)
	// at a 0.5 cadence i.e. [0, 0.5, 1.0, ... , 5.0] inclusively. The input rating
	// will round up to the nearest 0.5(ceiling). For instance, a rating of 0.6
	// will eliminate all results with a less than 1.0 rating.
	MinRating float64 `json:"minRating,omitempty"`
	// OpenNow: Used to restrict the search to places that are currently open. The
	// default is false.
	OpenNow bool `json:"openNow,omitempty"`
	// PageSize: Optional. The maximum number of results per page that can be
	// returned. If the number of available results is larger than `page_size`, a
	// `next_page_token` is returned which can be passed to `page_token` to get the
	// next page of results in subsequent requests. If 0 or no value is provided, a
	// default of 20 is used. The maximum value is 20; values above 20 will be set
	// to 20. Negative values will return an INVALID_ARGUMENT error. If both
	// `max_result_count` and `page_size` are specified, `max_result_count` will be
	// ignored.
	PageSize int64 `json:"pageSize,omitempty"`
	// PageToken: Optional. A page token, received from a previous TextSearch call.
	// Provide this to retrieve the subsequent page. When paginating, all
	// parameters other than `page_token`, `page_size`, and `max_result_count`
	// provided to TextSearch must match the initial call that provided the page
	// token. Otherwise an INVALID_ARGUMENT error is returned.
	PageToken string `json:"pageToken,omitempty"`
	// PriceLevels: Used to restrict the search to places that are marked as
	// certain price levels. Users can choose any combinations of price levels.
	// Default to select all price levels.
	//
	// Possible values:
	//   "PRICE_LEVEL_UNSPECIFIED" - Place price level is unspecified or unknown.
	//   "PRICE_LEVEL_FREE" - Place provides free services.
	//   "PRICE_LEVEL_INEXPENSIVE" - Place provides inexpensive services.
	//   "PRICE_LEVEL_MODERATE" - Place provides moderately priced services.
	//   "PRICE_LEVEL_EXPENSIVE" - Place provides expensive services.
	//   "PRICE_LEVEL_VERY_EXPENSIVE" - Place provides very expensive services.
	PriceLevels []string `json:"priceLevels,omitempty"`
	// RankPreference: How results will be ranked in the response.
	//
	// Possible values:
	//   "RANK_PREFERENCE_UNSPECIFIED" - For a categorical query such as
	// "Restaurants in New York City", RELEVANCE is the default. For
	// non-categorical queries such as "Mountain View, CA" we recommend that you
	// leave rankPreference unset.
	//   "DISTANCE" - Ranks results by distance.
	//   "RELEVANCE" - Ranks results by relevance. Sort order determined by normal
	// ranking stack.
	RankPreference string `json:"rankPreference,omitempty"`
	// RegionCode: The Unicode country/region code (CLDR) of the location where the
	// request is coming from. This parameter is used to display the place details,
	// like region-specific place name, if available. The parameter can affect
	// results based on applicable law. For more information, see
	// https://www.unicode.org/cldr/charts/latest/supplemental/territory_language_information.html.
	// Note that 3-digit region codes are not currently supported.
	RegionCode string `json:"regionCode,omitempty"`
	// RoutingParameters: Optional. Additional parameters for routing to results.
	RoutingParameters *GoogleMapsPlacesV1RoutingParameters `json:"routingParameters,omitempty"`
	// SearchAlongRouteParameters: Optional. Additional parameters proto for
	// searching along a route.
	SearchAlongRouteParameters *GoogleMapsPlacesV1SearchTextRequestSearchAlongRouteParameters `json:"searchAlongRouteParameters,omitempty"`
	// StrictTypeFiltering: Used to set strict type filtering for included_type. If
	// set to true, only results of the same type will be returned. Default to
	// false.
	StrictTypeFiltering bool `json:"strictTypeFiltering,omitempty"`
	// TextQuery: Required. The text query for textual search.
	TextQuery string `json:"textQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EvOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EvOptions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1SearchTextRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1SearchTextRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleMapsPlacesV1SearchTextRequest) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleMapsPlacesV1SearchTextRequest
	var s1 struct {
		MinRating gensupport.JSONFloat64 `json:"minRating"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MinRating = float64(s1.MinRating)
	return nil
}

// GoogleMapsPlacesV1SearchTextRequestEVOptions: Searchable EV options of a
// place search request.
type GoogleMapsPlacesV1SearchTextRequestEVOptions struct {
	// ConnectorTypes: Optional. The list of preferred EV connector types. A place
	// that does not support any of the listed connector types is filtered out.
	//
	// Possible values:
	//   "EV_CONNECTOR_TYPE_UNSPECIFIED" - Unspecified connector.
	//   "EV_CONNECTOR_TYPE_OTHER" - Other connector types.
	//   "EV_CONNECTOR_TYPE_J1772" - J1772 type 1 connector.
	//   "EV_CONNECTOR_TYPE_TYPE_2" - IEC 62196 type 2 connector. Often referred to
	// as MENNEKES.
	//   "EV_CONNECTOR_TYPE_CHADEMO" - CHAdeMO type connector.
	//   "EV_CONNECTOR_TYPE_CCS_COMBO_1" - Combined Charging System (AC and DC).
	// Based on SAE. Type-1 J-1772 connector
	//   "EV_CONNECTOR_TYPE_CCS_COMBO_2" - Combined Charging System (AC and DC).
	// Based on Type-2 Mennekes connector
	//   "EV_CONNECTOR_TYPE_TESLA" - The generic TESLA connector. This is NACS in
	// the North America but can be non-NACS in other parts of the world (e.g. CCS
	// Combo 2 (CCS2) or GB/T). This value is less representative of an actual
	// connector type, and more represents the ability to charge a Tesla brand
	// vehicle at a Tesla owned charging station.
	//   "EV_CONNECTOR_TYPE_UNSPECIFIED_GB_T" - GB/T type corresponds to the GB/T
	// standard in China. This type covers all GB_T types.
	//   "EV_CONNECTOR_TYPE_UNSPECIFIED_WALL_OUTLET" - Unspecified wall outlet.
	ConnectorTypes []string `json:"connectorTypes,omitempty"`
	// MinimumChargingRateKw: Optional. Minimum required charging rate in
	// kilowatts. A place with a charging rate less than the specified rate is
	// filtered out.
	MinimumChargingRateKw float64 `json:"minimumChargingRateKw,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectorTypes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectorTypes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1SearchTextRequestEVOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1SearchTextRequestEVOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleMapsPlacesV1SearchTextRequestEVOptions) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleMapsPlacesV1SearchTextRequestEVOptions
	var s1 struct {
		MinimumChargingRateKw gensupport.JSONFloat64 `json:"minimumChargingRateKw"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.MinimumChargingRateKw = float64(s1.MinimumChargingRateKw)
	return nil
}

// GoogleMapsPlacesV1SearchTextRequestLocationBias: The region to search. This
// location serves as a bias which means results around given location might be
// returned.
type GoogleMapsPlacesV1SearchTextRequestLocationBias struct {
	// Circle: A circle defined by center point and radius.
	Circle *GoogleMapsPlacesV1Circle `json:"circle,omitempty"`
	// Rectangle: A rectangle box defined by northeast and southwest corner.
	// `rectangle.high()` must be the northeast point of the rectangle viewport.
	// `rectangle.low()` must be the southwest point of the rectangle viewport.
	// `rectangle.low().latitude()` cannot be greater than
	// `rectangle.high().latitude()`. This will result in an empty latitude range.
	// A rectangle viewport cannot be wider than 180 degrees.
	Rectangle *GoogleGeoTypeViewport `json:"rectangle,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Circle") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Circle") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1SearchTextRequestLocationBias) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1SearchTextRequestLocationBias
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1SearchTextRequestLocationRestriction: The region to
// search. This location serves as a restriction which means results outside
// given location will not be returned.
type GoogleMapsPlacesV1SearchTextRequestLocationRestriction struct {
	// Rectangle: A rectangle box defined by northeast and southwest corner.
	// `rectangle.high()` must be the northeast point of the rectangle viewport.
	// `rectangle.low()` must be the southwest point of the rectangle viewport.
	// `rectangle.low().latitude()` cannot be greater than
	// `rectangle.high().latitude()`. This will result in an empty latitude range.
	// A rectangle viewport cannot be wider than 180 degrees.
	Rectangle *GoogleGeoTypeViewport `json:"rectangle,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Rectangle") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Rectangle") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1SearchTextRequestLocationRestriction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1SearchTextRequestLocationRestriction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1SearchTextRequestSearchAlongRouteParameters: Specifies a
// precalculated polyline from the Routes API
// (https://developers.google.com/maps/documentation/routes) defining the route
// to search. Searching along a route is similar to using the `locationBias` or
// `locationRestriction` request option to bias the search results. However,
// while the `locationBias` and `locationRestriction` options let you specify a
// region to bias the search results, this option lets you bias the results
// along a trip route. Results are not guaranteed to be along the route
// provided, but rather are ranked within the search area defined by the
// polyline and, optionally, by the `locationBias` or `locationRestriction`
// based on minimal detour times from origin to destination. The results might
// be along an alternate route, especially if the provided polyline does not
// define an optimal route from origin to destination.
type GoogleMapsPlacesV1SearchTextRequestSearchAlongRouteParameters struct {
	// Polyline: Required. The route polyline.
	Polyline *GoogleMapsPlacesV1Polyline `json:"polyline,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Polyline") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Polyline") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1SearchTextRequestSearchAlongRouteParameters) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1SearchTextRequestSearchAlongRouteParameters
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleMapsPlacesV1SearchTextResponse: Response proto for SearchText.
type GoogleMapsPlacesV1SearchTextResponse struct {
	// ContextualContents: Experimental: See
	// https://developers.google.com/maps/documentation/places/web-service/experimental/places-generative
	// for more details. A list of contextual contents where each entry associates
	// to the corresponding place in the same index in the places field. The
	// contents that are relevant to the `text_query` in the request are preferred.
	// If the contextual content is not available for one of the places, it will
	// return non-contextual content. It will be empty only when the content is
	// unavailable for this place. This list will have as many entries as the list
	// of places if requested.
	ContextualContents []*GoogleMapsPlacesV1ContextualContent `json:"contextualContents,omitempty"`
	// NextPageToken: A token that can be sent as `page_token` to retrieve the next
	// page. If this field is omitted or empty, there are no subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Places: A list of places that meet the user's text search criteria.
	Places []*GoogleMapsPlacesV1Place `json:"places,omitempty"`
	// RoutingSummaries: A list of routing summaries where each entry associates to
	// the corresponding place in the same index in the `places` field. If the
	// routing summary is not available for one of the places, it will contain an
	// empty entry. This list will have as many entries as the list of places if
	// requested.
	RoutingSummaries []*GoogleMapsPlacesV1RoutingSummary `json:"routingSummaries,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ContextualContents") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContextualContents") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleMapsPlacesV1SearchTextResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleMapsPlacesV1SearchTextResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeDate: Represents a whole or partial calendar date, such as a
// birthday. The time of day and time zone are either specified elsewhere or
// are insignificant. The date is relative to the Gregorian Calendar. This can
// represent one of the following: * A full date, with non-zero year, month,
// and day values. * A month and day, with a zero year (for example, an
// anniversary). * A year on its own, with a zero month and a zero day. * A
// year and month, with a zero day (for example, a credit card expiration
// date). Related types: * google.type.TimeOfDay * google.type.DateTime *
// google.protobuf.Timestamp
type GoogleTypeDate struct {
	// Day: Day of a month. Must be from 1 to 31 and valid for the year and month,
	// or 0 to specify a year by itself or a year and month where the day isn't
	// significant.
	Day int64 `json:"day,omitempty"`
	// Month: Month of a year. Must be from 1 to 12, or 0 to specify a year without
	// a month and day.
	Month int64 `json:"month,omitempty"`
	// Year: Year of the date. Must be from 1 to 9999, or 0 to specify a date
	// without a year.
	Year int64 `json:"year,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeDate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeDate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeLatLng: An object that represents a latitude/longitude pair. This
// is expressed as a pair of doubles to represent degrees latitude and degrees
// longitude. Unless specified otherwise, this object must conform to the WGS84
// standard. Values must be within normalized ranges.
type GoogleTypeLatLng struct {
	// Latitude: The latitude in degrees. It must be in the range [-90.0, +90.0].
	Latitude float64 `json:"latitude,omitempty"`
	// Longitude: The longitude in degrees. It must be in the range [-180.0,
	// +180.0].
	Longitude float64 `json:"longitude,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Latitude") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Latitude") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeLatLng) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeLatLng
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *GoogleTypeLatLng) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleTypeLatLng
	var s1 struct {
		Latitude  gensupport.JSONFloat64 `json:"latitude"`
		Longitude gensupport.JSONFloat64 `json:"longitude"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.Latitude = float64(s1.Latitude)
	s.Longitude = float64(s1.Longitude)
	return nil
}

// GoogleTypeLocalizedText: Localized variant of a text in a particular
// language.
type GoogleTypeLocalizedText struct {
	// LanguageCode: The text's BCP-47 language code, such as "en-US" or "sr-Latn".
	// For more information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
	LanguageCode string `json:"languageCode,omitempty"`
	// Text: Localized string in the language corresponding to language_code below.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LanguageCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LanguageCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeLocalizedText) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeLocalizedText
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeMoney: Represents an amount of money with its currency type.
type GoogleTypeMoney struct {
	// CurrencyCode: The three-letter currency code defined in ISO 4217.
	CurrencyCode string `json:"currencyCode,omitempty"`
	// Nanos: Number of nano (10^-9) units of the amount. The value must be between
	// -999,999,999 and +999,999,999 inclusive. If `units` is positive, `nanos`
	// must be positive or zero. If `units` is zero, `nanos` can be positive, zero,
	// or negative. If `units` is negative, `nanos` must be negative or zero. For
	// example $-1.75 is represented as `units`=-1 and `nanos`=-750,000,000.
	Nanos int64 `json:"nanos,omitempty"`
	// Units: The whole units of the amount. For example if `currencyCode` is
	// "USD", then 1 unit is one US dollar.
	Units int64 `json:"units,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CurrencyCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeMoney) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeMoney
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type PlacesAutocompleteCall struct {
	s                                           *Service
	googlemapsplacesv1autocompleteplacesrequest *GoogleMapsPlacesV1AutocompletePlacesRequest
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// Autocomplete: Returns predictions for the given input.
func (r *PlacesService) Autocomplete(googlemapsplacesv1autocompleteplacesrequest *GoogleMapsPlacesV1AutocompletePlacesRequest) *PlacesAutocompleteCall {
	c := &PlacesAutocompleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlemapsplacesv1autocompleteplacesrequest = googlemapsplacesv1autocompleteplacesrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PlacesAutocompleteCall) Fields(s ...googleapi.Field) *PlacesAutocompleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PlacesAutocompleteCall) Context(ctx context.Context) *PlacesAutocompleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PlacesAutocompleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PlacesAutocompleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlemapsplacesv1autocompleteplacesrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/places:autocomplete")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "places.places.autocomplete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleMapsPlacesV1AutocompletePlacesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PlacesAutocompleteCall) Do(opts ...googleapi.CallOption) (*GoogleMapsPlacesV1AutocompletePlacesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleMapsPlacesV1AutocompletePlacesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type PlacesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get the details of a place based on its resource name, which is a
// string in the `places/{place_id}` format.
//
// - name: The resource name of a place, in the `places/{place_id}` format.
func (r *PlacesService) Get(name string) *PlacesGetCall {
	c := &PlacesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// LanguageCode sets the optional parameter "languageCode": Place details will
// be displayed with the preferred language if available. Current list of
// supported languages: https://developers.google.com/maps/faq#languagesupport.
func (c *PlacesGetCall) LanguageCode(languageCode string) *PlacesGetCall {
	c.urlParams_.Set("languageCode", languageCode)
	return c
}

// RegionCode sets the optional parameter "regionCode": The Unicode
// country/region code (CLDR) of the location where the request is coming from.
// This parameter is used to display the place details, like region-specific
// place name, if available. The parameter can affect results based on
// applicable law. For more information, see
// https://www.unicode.org/cldr/charts/latest/supplemental/territory_language_information.html.
// Note that 3-digit region codes are not currently supported.
func (c *PlacesGetCall) RegionCode(regionCode string) *PlacesGetCall {
	c.urlParams_.Set("regionCode", regionCode)
	return c
}

// SessionToken sets the optional parameter "sessionToken": A string which
// identifies an Autocomplete session for billing purposes. Must be a URL and
// filename safe base64 string with at most 36 ASCII characters in length.
// Otherwise an INVALID_ARGUMENT error is returned. The session begins when the
// user starts typing a query, and concludes when they select a place and a
// call to Place Details or Address Validation is made. Each session can have
// multiple queries, followed by one Place Details or Address Validation
// request. The credentials used for each request within a session must belong
// to the same Google Cloud Console project. Once a session has concluded, the
// token is no longer valid; your app must generate a fresh token for each
// session. If the `session_token` parameter is omitted, or if you reuse a
// session token, the session is charged as if no session token was provided
// (each request is billed separately). We recommend the following guidelines:
// * Use session tokens for all Place Autocomplete calls. * Generate a fresh
// token for each session. Using a version 4 UUID is recommended. * Ensure that
// the credentials used for all Place Autocomplete, Place Details, and Address
// Validation requests within a session belong to the same Cloud Console
// project. * Be sure to pass a unique session token for each new session.
// Using the same token for more than one session will result in each request
// being billed individually.
func (c *PlacesGetCall) SessionToken(sessionToken string) *PlacesGetCall {
	c.urlParams_.Set("sessionToken", sessionToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PlacesGetCall) Fields(s ...googleapi.Field) *PlacesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PlacesGetCall) IfNoneMatch(entityTag string) *PlacesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PlacesGetCall) Context(ctx context.Context) *PlacesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PlacesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PlacesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "places.places.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleMapsPlacesV1Place.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PlacesGetCall) Do(opts ...googleapi.CallOption) (*GoogleMapsPlacesV1Place, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleMapsPlacesV1Place{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type PlacesSearchNearbyCall struct {
	s                                     *Service
	googlemapsplacesv1searchnearbyrequest *GoogleMapsPlacesV1SearchNearbyRequest
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// SearchNearby: Search for places near locations.
func (r *PlacesService) SearchNearby(googlemapsplacesv1searchnearbyrequest *GoogleMapsPlacesV1SearchNearbyRequest) *PlacesSearchNearbyCall {
	c := &PlacesSearchNearbyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlemapsplacesv1searchnearbyrequest = googlemapsplacesv1searchnearbyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PlacesSearchNearbyCall) Fields(s ...googleapi.Field) *PlacesSearchNearbyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PlacesSearchNearbyCall) Context(ctx context.Context) *PlacesSearchNearbyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PlacesSearchNearbyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PlacesSearchNearbyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlemapsplacesv1searchnearbyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/places:searchNearby")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "places.places.searchNearby" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleMapsPlacesV1SearchNearbyResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PlacesSearchNearbyCall) Do(opts ...googleapi.CallOption) (*GoogleMapsPlacesV1SearchNearbyResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleMapsPlacesV1SearchNearbyResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

type PlacesSearchTextCall struct {
	s                                   *Service
	googlemapsplacesv1searchtextrequest *GoogleMapsPlacesV1SearchTextRequest
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// SearchText: Text query based place search.
func (r *PlacesService) SearchText(googlemapsplacesv1searchtextrequest *GoogleMapsPlacesV1SearchTextRequest) *PlacesSearchTextCall {
	c := &PlacesSearchTextCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlemapsplacesv1searchtextrequest = googlemapsplacesv1searchtextrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PlacesSearchTextCall) Fields(s ...googleapi.Field) *PlacesSearchTextCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PlacesSearchTextCall) Context(ctx context.Context) *PlacesSearchTextCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PlacesSearchTextCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PlacesSearchTextCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlemapsplacesv1searchtextrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/places:searchText")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "places.places.searchText" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleMapsPlacesV1SearchTextResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PlacesSearchTextCall) Do(opts ...googleapi.CallOption) (*GoogleMapsPlacesV1SearchTextResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleMapsPlacesV1SearchTextResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *PlacesSearchTextCall) Pages(ctx context.Context, f func(*GoogleMapsPlacesV1SearchTextResponse) error) error {
	c.ctx_ = ctx
	defer func(pt string) { c.googlemapsplacesv1searchtextrequest.PageToken = pt }(c.googlemapsplacesv1searchtextrequest.PageToken)
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.googlemapsplacesv1searchtextrequest.PageToken = x.NextPageToken
	}
}

type PlacesPhotosGetMediaCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetMedia: Get a photo media with a photo reference string.
//
//   - name: The resource name of a photo media in the format:
//     `places/{place_id}/photos/{photo_reference}/media`. The resource name of a
//     photo as returned in a Place object's `photos.name` field comes with the
//     format `places/{place_id}/photos/{photo_reference}`. You need to append
//     `/media` at the end of the photo resource to get the photo media resource
//     name.
func (r *PlacesPhotosService) GetMedia(name string) *PlacesPhotosGetMediaCall {
	c := &PlacesPhotosGetMediaCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// MaxHeightPx sets the optional parameter "maxHeightPx": Specifies the maximum
// desired height, in pixels, of the image. If the image is smaller than the
// values specified, the original image will be returned. If the image is
// larger in either dimension, it will be scaled to match the smaller of the
// two dimensions, restricted to its original aspect ratio. Both the
// max_height_px and max_width_px properties accept an integer between 1 and
// 4800, inclusively. If the value is not within the allowed range, an
// INVALID_ARGUMENT error will be returned. At least one of max_height_px or
// max_width_px needs to be specified. If neither max_height_px nor
// max_width_px is specified, an INVALID_ARGUMENT error will be returned.
func (c *PlacesPhotosGetMediaCall) MaxHeightPx(maxHeightPx int64) *PlacesPhotosGetMediaCall {
	c.urlParams_.Set("maxHeightPx", fmt.Sprint(maxHeightPx))
	return c
}

// MaxWidthPx sets the optional parameter "maxWidthPx": Specifies the maximum
// desired width, in pixels, of the image. If the image is smaller than the
// values specified, the original image will be returned. If the image is
// larger in either dimension, it will be scaled to match the smaller of the
// two dimensions, restricted to its original aspect ratio. Both the
// max_height_px and max_width_px properties accept an integer between 1 and
// 4800, inclusively. If the value is not within the allowed range, an
// INVALID_ARGUMENT error will be returned. At least one of max_height_px or
// max_width_px needs to be specified. If neither max_height_px nor
// max_width_px is specified, an INVALID_ARGUMENT error will be returned.
func (c *PlacesPhotosGetMediaCall) MaxWidthPx(maxWidthPx int64) *PlacesPhotosGetMediaCall {
	c.urlParams_.Set("maxWidthPx", fmt.Sprint(maxWidthPx))
	return c
}

// SkipHttpRedirect sets the optional parameter "skipHttpRedirect": If set,
// skip the default HTTP redirect behavior and render a text format (for
// example, in JSON format for HTTP use case) response. If not set, an HTTP
// redirect will be issued to redirect the call to the image media. This option
// is ignored for non-HTTP requests.
func (c *PlacesPhotosGetMediaCall) SkipHttpRedirect(skipHttpRedirect bool) *PlacesPhotosGetMediaCall {
	c.urlParams_.Set("skipHttpRedirect", fmt.Sprint(skipHttpRedirect))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *PlacesPhotosGetMediaCall) Fields(s ...googleapi.Field) *PlacesPhotosGetMediaCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *PlacesPhotosGetMediaCall) IfNoneMatch(entityTag string) *PlacesPhotosGetMediaCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *PlacesPhotosGetMediaCall) Context(ctx context.Context) *PlacesPhotosGetMediaCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *PlacesPhotosGetMediaCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *PlacesPhotosGetMediaCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "places.places.photos.getMedia" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleMapsPlacesV1PhotoMedia.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *PlacesPhotosGetMediaCall) Do(opts ...googleapi.CallOption) (*GoogleMapsPlacesV1PhotoMedia, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleMapsPlacesV1PhotoMedia{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
}
