// Code generated by Fiat Cryptography. DO NOT EDIT.
//
// Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Go --no-wide-int --relax-primitive-carry-to-bitwidth 32,64 --cmovznz-by-mul --internal-static --package-case flatcase --public-function-case UpperCamelCase --private-function-case camelCase --public-type-case UpperCamelCase --private-type-case camelCase --no-prefix-fiat --doc-newline-in-typedef-bounds --doc-prepend-header 'Code generated by Fiat Cryptography. DO NOT EDIT.' --doc-text-before-function-name ” --doc-text-before-type-name ” --package-name secp256k1montgomeryscalar ” 64 '2^256 - 432420386565659656852420866394968145599' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp
//
// curve description (via package name): secp256k1montgomeryscalar
//
// machine_wordsize = 64 (from "64")
//
// requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp
//
// m = 0xfffffffffffffffffffffffffffffffebaaedce6af48a03bbfd25e8cd0364141 (from "2^256 - 432420386565659656852420866394968145599")
//
// NOTE: In addition to the bounds specified above each function, all
//
//	functions synthesized for this Montgomery arithmetic require the
//
//	input to be strictly less than the prime modulus (m), and also
//
//	require the input to be in the unique saturated representation.
//
//	All functions also ensure that these two properties are true of
//
//	return values.
//
// Computed values:
//
//	eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192)
//
//	bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248)
//
//	twos_complement_eval z = let x1 := z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) in
//
//	                         if x1 & (2^256-1) < 2^255 then x1 & (2^256-1) else (x1 & (2^256-1)) - 2^256
package secp256k1montgomeryscalar

import "math/bits"

type uint1 uint64 // We use uint64 instead of a more narrow type for performance reasons; see https://github.com/mit-plv/fiat-crypto/pull/1006#issuecomment-892625927
type int1 int64   // We use uint64 instead of a more narrow type for performance reasons; see https://github.com/mit-plv/fiat-crypto/pull/1006#issuecomment-892625927

// MontgomeryDomainFieldElement is a field element in the Montgomery domain.
//
// Bounds:
//
//	[[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
type MontgomeryDomainFieldElement [4]uint64

// NonMontgomeryDomainFieldElement is a field element NOT in the Montgomery domain.
//
// Bounds:
//
//	[[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
type NonMontgomeryDomainFieldElement [4]uint64

// cmovznzU64 is a single-word conditional move.
//
// Postconditions:
//
//	out1 = (if arg1 = 0 then arg2 else arg3)
//
// Input Bounds:
//
//	arg1: [0x0 ~> 0x1]
//	arg2: [0x0 ~> 0xffffffffffffffff]
//	arg3: [0x0 ~> 0xffffffffffffffff]
//
// Output Bounds:
//
//	out1: [0x0 ~> 0xffffffffffffffff]
func cmovznzU64(out1 *uint64, arg1 uint1, arg2 uint64, arg3 uint64) {
	x1 := (uint64(arg1) * 0xffffffffffffffff)
	x2 := ((x1 & arg3) | ((^x1) & arg2))
	*out1 = x2
}

// Mul multiplies two field elements in the Montgomery domain.
//
// Preconditions:
//
//	0 ≤ eval arg1 < m
//	0 ≤ eval arg2 < m
//
// Postconditions:
//
//	eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m
//	0 ≤ eval out1 < m
func Mul(out1 *MontgomeryDomainFieldElement, arg1 *MontgomeryDomainFieldElement, arg2 *MontgomeryDomainFieldElement) {
	x1 := arg1[1]
	x2 := arg1[2]
	x3 := arg1[3]
	x4 := arg1[0]
	var x5 uint64
	var x6 uint64
	x6, x5 = bits.Mul64(x4, arg2[3])
	var x7 uint64
	var x8 uint64
	x8, x7 = bits.Mul64(x4, arg2[2])
	var x9 uint64
	var x10 uint64
	x10, x9 = bits.Mul64(x4, arg2[1])
	var x11 uint64
	var x12 uint64
	x12, x11 = bits.Mul64(x4, arg2[0])
	var x13 uint64
	var x14 uint64
	x13, x14 = bits.Add64(x12, x9, uint64(0x0))
	var x15 uint64
	var x16 uint64
	x15, x16 = bits.Add64(x10, x7, uint64(uint1(x14)))
	var x17 uint64
	var x18 uint64
	x17, x18 = bits.Add64(x8, x5, uint64(uint1(x16)))
	x19 := (uint64(uint1(x18)) + x6)
	var x20 uint64
	_, x20 = bits.Mul64(x11, 0x4b0dff665588b13f)
	var x22 uint64
	var x23 uint64
	x23, x22 = bits.Mul64(x20, 0xffffffffffffffff)
	var x24 uint64
	var x25 uint64
	x25, x24 = bits.Mul64(x20, 0xfffffffffffffffe)
	var x26 uint64
	var x27 uint64
	x27, x26 = bits.Mul64(x20, 0xbaaedce6af48a03b)
	var x28 uint64
	var x29 uint64
	x29, x28 = bits.Mul64(x20, 0xbfd25e8cd0364141)
	var x30 uint64
	var x31 uint64
	x30, x31 = bits.Add64(x29, x26, uint64(0x0))
	var x32 uint64
	var x33 uint64
	x32, x33 = bits.Add64(x27, x24, uint64(uint1(x31)))
	var x34 uint64
	var x35 uint64
	x34, x35 = bits.Add64(x25, x22, uint64(uint1(x33)))
	x36 := (uint64(uint1(x35)) + x23)
	var x38 uint64
	_, x38 = bits.Add64(x11, x28, uint64(0x0))
	var x39 uint64
	var x40 uint64
	x39, x40 = bits.Add64(x13, x30, uint64(uint1(x38)))
	var x41 uint64
	var x42 uint64
	x41, x42 = bits.Add64(x15, x32, uint64(uint1(x40)))
	var x43 uint64
	var x44 uint64
	x43, x44 = bits.Add64(x17, x34, uint64(uint1(x42)))
	var x45 uint64
	var x46 uint64
	x45, x46 = bits.Add64(x19, x36, uint64(uint1(x44)))
	var x47 uint64
	var x48 uint64
	x48, x47 = bits.Mul64(x1, arg2[3])
	var x49 uint64
	var x50 uint64
	x50, x49 = bits.Mul64(x1, arg2[2])
	var x51 uint64
	var x52 uint64
	x52, x51 = bits.Mul64(x1, arg2[1])
	var x53 uint64
	var x54 uint64
	x54, x53 = bits.Mul64(x1, arg2[0])
	var x55 uint64
	var x56 uint64
	x55, x56 = bits.Add64(x54, x51, uint64(0x0))
	var x57 uint64
	var x58 uint64
	x57, x58 = bits.Add64(x52, x49, uint64(uint1(x56)))
	var x59 uint64
	var x60 uint64
	x59, x60 = bits.Add64(x50, x47, uint64(uint1(x58)))
	x61 := (uint64(uint1(x60)) + x48)
	var x62 uint64
	var x63 uint64
	x62, x63 = bits.Add64(x39, x53, uint64(0x0))
	var x64 uint64
	var x65 uint64
	x64, x65 = bits.Add64(x41, x55, uint64(uint1(x63)))
	var x66 uint64
	var x67 uint64
	x66, x67 = bits.Add64(x43, x57, uint64(uint1(x65)))
	var x68 uint64
	var x69 uint64
	x68, x69 = bits.Add64(x45, x59, uint64(uint1(x67)))
	var x70 uint64
	var x71 uint64
	x70, x71 = bits.Add64(uint64(uint1(x46)), x61, uint64(uint1(x69)))
	var x72 uint64
	_, x72 = bits.Mul64(x62, 0x4b0dff665588b13f)
	var x74 uint64
	var x75 uint64
	x75, x74 = bits.Mul64(x72, 0xffffffffffffffff)
	var x76 uint64
	var x77 uint64
	x77, x76 = bits.Mul64(x72, 0xfffffffffffffffe)
	var x78 uint64
	var x79 uint64
	x79, x78 = bits.Mul64(x72, 0xbaaedce6af48a03b)
	var x80 uint64
	var x81 uint64
	x81, x80 = bits.Mul64(x72, 0xbfd25e8cd0364141)
	var x82 uint64
	var x83 uint64
	x82, x83 = bits.Add64(x81, x78, uint64(0x0))
	var x84 uint64
	var x85 uint64
	x84, x85 = bits.Add64(x79, x76, uint64(uint1(x83)))
	var x86 uint64
	var x87 uint64
	x86, x87 = bits.Add64(x77, x74, uint64(uint1(x85)))
	x88 := (uint64(uint1(x87)) + x75)
	var x90 uint64
	_, x90 = bits.Add64(x62, x80, uint64(0x0))
	var x91 uint64
	var x92 uint64
	x91, x92 = bits.Add64(x64, x82, uint64(uint1(x90)))
	var x93 uint64
	var x94 uint64
	x93, x94 = bits.Add64(x66, x84, uint64(uint1(x92)))
	var x95 uint64
	var x96 uint64
	x95, x96 = bits.Add64(x68, x86, uint64(uint1(x94)))
	var x97 uint64
	var x98 uint64
	x97, x98 = bits.Add64(x70, x88, uint64(uint1(x96)))
	x99 := (uint64(uint1(x98)) + uint64(uint1(x71)))
	var x100 uint64
	var x101 uint64
	x101, x100 = bits.Mul64(x2, arg2[3])
	var x102 uint64
	var x103 uint64
	x103, x102 = bits.Mul64(x2, arg2[2])
	var x104 uint64
	var x105 uint64
	x105, x104 = bits.Mul64(x2, arg2[1])
	var x106 uint64
	var x107 uint64
	x107, x106 = bits.Mul64(x2, arg2[0])
	var x108 uint64
	var x109 uint64
	x108, x109 = bits.Add64(x107, x104, uint64(0x0))
	var x110 uint64
	var x111 uint64
	x110, x111 = bits.Add64(x105, x102, uint64(uint1(x109)))
	var x112 uint64
	var x113 uint64
	x112, x113 = bits.Add64(x103, x100, uint64(uint1(x111)))
	x114 := (uint64(uint1(x113)) + x101)
	var x115 uint64
	var x116 uint64
	x115, x116 = bits.Add64(x91, x106, uint64(0x0))
	var x117 uint64
	var x118 uint64
	x117, x118 = bits.Add64(x93, x108, uint64(uint1(x116)))
	var x119 uint64
	var x120 uint64
	x119, x120 = bits.Add64(x95, x110, uint64(uint1(x118)))
	var x121 uint64
	var x122 uint64
	x121, x122 = bits.Add64(x97, x112, uint64(uint1(x120)))
	var x123 uint64
	var x124 uint64
	x123, x124 = bits.Add64(x99, x114, uint64(uint1(x122)))
	var x125 uint64
	_, x125 = bits.Mul64(x115, 0x4b0dff665588b13f)
	var x127 uint64
	var x128 uint64
	x128, x127 = bits.Mul64(x125, 0xffffffffffffffff)
	var x129 uint64
	var x130 uint64
	x130, x129 = bits.Mul64(x125, 0xfffffffffffffffe)
	var x131 uint64
	var x132 uint64
	x132, x131 = bits.Mul64(x125, 0xbaaedce6af48a03b)
	var x133 uint64
	var x134 uint64
	x134, x133 = bits.Mul64(x125, 0xbfd25e8cd0364141)
	var x135 uint64
	var x136 uint64
	x135, x136 = bits.Add64(x134, x131, uint64(0x0))
	var x137 uint64
	var x138 uint64
	x137, x138 = bits.Add64(x132, x129, uint64(uint1(x136)))
	var x139 uint64
	var x140 uint64
	x139, x140 = bits.Add64(x130, x127, uint64(uint1(x138)))
	x141 := (uint64(uint1(x140)) + x128)
	var x143 uint64
	_, x143 = bits.Add64(x115, x133, uint64(0x0))
	var x144 uint64
	var x145 uint64
	x144, x145 = bits.Add64(x117, x135, uint64(uint1(x143)))
	var x146 uint64
	var x147 uint64
	x146, x147 = bits.Add64(x119, x137, uint64(uint1(x145)))
	var x148 uint64
	var x149 uint64
	x148, x149 = bits.Add64(x121, x139, uint64(uint1(x147)))
	var x150 uint64
	var x151 uint64
	x150, x151 = bits.Add64(x123, x141, uint64(uint1(x149)))
	x152 := (uint64(uint1(x151)) + uint64(uint1(x124)))
	var x153 uint64
	var x154 uint64
	x154, x153 = bits.Mul64(x3, arg2[3])
	var x155 uint64
	var x156 uint64
	x156, x155 = bits.Mul64(x3, arg2[2])
	var x157 uint64
	var x158 uint64
	x158, x157 = bits.Mul64(x3, arg2[1])
	var x159 uint64
	var x160 uint64
	x160, x159 = bits.Mul64(x3, arg2[0])
	var x161 uint64
	var x162 uint64
	x161, x162 = bits.Add64(x160, x157, uint64(0x0))
	var x163 uint64
	var x164 uint64
	x163, x164 = bits.Add64(x158, x155, uint64(uint1(x162)))
	var x165 uint64
	var x166 uint64
	x165, x166 = bits.Add64(x156, x153, uint64(uint1(x164)))
	x167 := (uint64(uint1(x166)) + x154)
	var x168 uint64
	var x169 uint64
	x168, x169 = bits.Add64(x144, x159, uint64(0x0))
	var x170 uint64
	var x171 uint64
	x170, x171 = bits.Add64(x146, x161, uint64(uint1(x169)))
	var x172 uint64
	var x173 uint64
	x172, x173 = bits.Add64(x148, x163, uint64(uint1(x171)))
	var x174 uint64
	var x175 uint64
	x174, x175 = bits.Add64(x150, x165, uint64(uint1(x173)))
	var x176 uint64
	var x177 uint64
	x176, x177 = bits.Add64(x152, x167, uint64(uint1(x175)))
	var x178 uint64
	_, x178 = bits.Mul64(x168, 0x4b0dff665588b13f)
	var x180 uint64
	var x181 uint64
	x181, x180 = bits.Mul64(x178, 0xffffffffffffffff)
	var x182 uint64
	var x183 uint64
	x183, x182 = bits.Mul64(x178, 0xfffffffffffffffe)
	var x184 uint64
	var x185 uint64
	x185, x184 = bits.Mul64(x178, 0xbaaedce6af48a03b)
	var x186 uint64
	var x187 uint64
	x187, x186 = bits.Mul64(x178, 0xbfd25e8cd0364141)
	var x188 uint64
	var x189 uint64
	x188, x189 = bits.Add64(x187, x184, uint64(0x0))
	var x190 uint64
	var x191 uint64
	x190, x191 = bits.Add64(x185, x182, uint64(uint1(x189)))
	var x192 uint64
	var x193 uint64
	x192, x193 = bits.Add64(x183, x180, uint64(uint1(x191)))
	x194 := (uint64(uint1(x193)) + x181)
	var x196 uint64
	_, x196 = bits.Add64(x168, x186, uint64(0x0))
	var x197 uint64
	var x198 uint64
	x197, x198 = bits.Add64(x170, x188, uint64(uint1(x196)))
	var x199 uint64
	var x200 uint64
	x199, x200 = bits.Add64(x172, x190, uint64(uint1(x198)))
	var x201 uint64
	var x202 uint64
	x201, x202 = bits.Add64(x174, x192, uint64(uint1(x200)))
	var x203 uint64
	var x204 uint64
	x203, x204 = bits.Add64(x176, x194, uint64(uint1(x202)))
	x205 := (uint64(uint1(x204)) + uint64(uint1(x177)))
	var x206 uint64
	var x207 uint64
	x206, x207 = bits.Sub64(x197, 0xbfd25e8cd0364141, uint64(0x0))
	var x208 uint64
	var x209 uint64
	x208, x209 = bits.Sub64(x199, 0xbaaedce6af48a03b, uint64(uint1(x207)))
	var x210 uint64
	var x211 uint64
	x210, x211 = bits.Sub64(x201, 0xfffffffffffffffe, uint64(uint1(x209)))
	var x212 uint64
	var x213 uint64
	x212, x213 = bits.Sub64(x203, 0xffffffffffffffff, uint64(uint1(x211)))
	var x215 uint64
	_, x215 = bits.Sub64(x205, uint64(0x0), uint64(uint1(x213)))
	var x216 uint64
	cmovznzU64(&x216, uint1(x215), x206, x197)
	var x217 uint64
	cmovznzU64(&x217, uint1(x215), x208, x199)
	var x218 uint64
	cmovznzU64(&x218, uint1(x215), x210, x201)
	var x219 uint64
	cmovznzU64(&x219, uint1(x215), x212, x203)
	out1[0] = x216
	out1[1] = x217
	out1[2] = x218
	out1[3] = x219
}

// Square squares a field element in the Montgomery domain.
//
// Preconditions:
//
//	0 ≤ eval arg1 < m
//
// Postconditions:
//
//	eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m
//	0 ≤ eval out1 < m
func Square(out1 *MontgomeryDomainFieldElement, arg1 *MontgomeryDomainFieldElement) {
	x1 := arg1[1]
	x2 := arg1[2]
	x3 := arg1[3]
	x4 := arg1[0]
	var x5 uint64
	var x6 uint64
	x6, x5 = bits.Mul64(x4, arg1[3])
	var x7 uint64
	var x8 uint64
	x8, x7 = bits.Mul64(x4, arg1[2])
	var x9 uint64
	var x10 uint64
	x10, x9 = bits.Mul64(x4, arg1[1])
	var x11 uint64
	var x12 uint64
	x12, x11 = bits.Mul64(x4, arg1[0])
	var x13 uint64
	var x14 uint64
	x13, x14 = bits.Add64(x12, x9, uint64(0x0))
	var x15 uint64
	var x16 uint64
	x15, x16 = bits.Add64(x10, x7, uint64(uint1(x14)))
	var x17 uint64
	var x18 uint64
	x17, x18 = bits.Add64(x8, x5, uint64(uint1(x16)))
	x19 := (uint64(uint1(x18)) + x6)
	var x20 uint64
	_, x20 = bits.Mul64(x11, 0x4b0dff665588b13f)
	var x22 uint64
	var x23 uint64
	x23, x22 = bits.Mul64(x20, 0xffffffffffffffff)
	var x24 uint64
	var x25 uint64
	x25, x24 = bits.Mul64(x20, 0xfffffffffffffffe)
	var x26 uint64
	var x27 uint64
	x27, x26 = bits.Mul64(x20, 0xbaaedce6af48a03b)
	var x28 uint64
	var x29 uint64
	x29, x28 = bits.Mul64(x20, 0xbfd25e8cd0364141)
	var x30 uint64
	var x31 uint64
	x30, x31 = bits.Add64(x29, x26, uint64(0x0))
	var x32 uint64
	var x33 uint64
	x32, x33 = bits.Add64(x27, x24, uint64(uint1(x31)))
	var x34 uint64
	var x35 uint64
	x34, x35 = bits.Add64(x25, x22, uint64(uint1(x33)))
	x36 := (uint64(uint1(x35)) + x23)
	var x38 uint64
	_, x38 = bits.Add64(x11, x28, uint64(0x0))
	var x39 uint64
	var x40 uint64
	x39, x40 = bits.Add64(x13, x30, uint64(uint1(x38)))
	var x41 uint64
	var x42 uint64
	x41, x42 = bits.Add64(x15, x32, uint64(uint1(x40)))
	var x43 uint64
	var x44 uint64
	x43, x44 = bits.Add64(x17, x34, uint64(uint1(x42)))
	var x45 uint64
	var x46 uint64
	x45, x46 = bits.Add64(x19, x36, uint64(uint1(x44)))
	var x47 uint64
	var x48 uint64
	x48, x47 = bits.Mul64(x1, arg1[3])
	var x49 uint64
	var x50 uint64
	x50, x49 = bits.Mul64(x1, arg1[2])
	var x51 uint64
	var x52 uint64
	x52, x51 = bits.Mul64(x1, arg1[1])
	var x53 uint64
	var x54 uint64
	x54, x53 = bits.Mul64(x1, arg1[0])
	var x55 uint64
	var x56 uint64
	x55, x56 = bits.Add64(x54, x51, uint64(0x0))
	var x57 uint64
	var x58 uint64
	x57, x58 = bits.Add64(x52, x49, uint64(uint1(x56)))
	var x59 uint64
	var x60 uint64
	x59, x60 = bits.Add64(x50, x47, uint64(uint1(x58)))
	x61 := (uint64(uint1(x60)) + x48)
	var x62 uint64
	var x63 uint64
	x62, x63 = bits.Add64(x39, x53, uint64(0x0))
	var x64 uint64
	var x65 uint64
	x64, x65 = bits.Add64(x41, x55, uint64(uint1(x63)))
	var x66 uint64
	var x67 uint64
	x66, x67 = bits.Add64(x43, x57, uint64(uint1(x65)))
	var x68 uint64
	var x69 uint64
	x68, x69 = bits.Add64(x45, x59, uint64(uint1(x67)))
	var x70 uint64
	var x71 uint64
	x70, x71 = bits.Add64(uint64(uint1(x46)), x61, uint64(uint1(x69)))
	var x72 uint64
	_, x72 = bits.Mul64(x62, 0x4b0dff665588b13f)
	var x74 uint64
	var x75 uint64
	x75, x74 = bits.Mul64(x72, 0xffffffffffffffff)
	var x76 uint64
	var x77 uint64
	x77, x76 = bits.Mul64(x72, 0xfffffffffffffffe)
	var x78 uint64
	var x79 uint64
	x79, x78 = bits.Mul64(x72, 0xbaaedce6af48a03b)
	var x80 uint64
	var x81 uint64
	x81, x80 = bits.Mul64(x72, 0xbfd25e8cd0364141)
	var x82 uint64
	var x83 uint64
	x82, x83 = bits.Add64(x81, x78, uint64(0x0))
	var x84 uint64
	var x85 uint64
	x84, x85 = bits.Add64(x79, x76, uint64(uint1(x83)))
	var x86 uint64
	var x87 uint64
	x86, x87 = bits.Add64(x77, x74, uint64(uint1(x85)))
	x88 := (uint64(uint1(x87)) + x75)
	var x90 uint64
	_, x90 = bits.Add64(x62, x80, uint64(0x0))
	var x91 uint64
	var x92 uint64
	x91, x92 = bits.Add64(x64, x82, uint64(uint1(x90)))
	var x93 uint64
	var x94 uint64
	x93, x94 = bits.Add64(x66, x84, uint64(uint1(x92)))
	var x95 uint64
	var x96 uint64
	x95, x96 = bits.Add64(x68, x86, uint64(uint1(x94)))
	var x97 uint64
	var x98 uint64
	x97, x98 = bits.Add64(x70, x88, uint64(uint1(x96)))
	x99 := (uint64(uint1(x98)) + uint64(uint1(x71)))
	var x100 uint64
	var x101 uint64
	x101, x100 = bits.Mul64(x2, arg1[3])
	var x102 uint64
	var x103 uint64
	x103, x102 = bits.Mul64(x2, arg1[2])
	var x104 uint64
	var x105 uint64
	x105, x104 = bits.Mul64(x2, arg1[1])
	var x106 uint64
	var x107 uint64
	x107, x106 = bits.Mul64(x2, arg1[0])
	var x108 uint64
	var x109 uint64
	x108, x109 = bits.Add64(x107, x104, uint64(0x0))
	var x110 uint64
	var x111 uint64
	x110, x111 = bits.Add64(x105, x102, uint64(uint1(x109)))
	var x112 uint64
	var x113 uint64
	x112, x113 = bits.Add64(x103, x100, uint64(uint1(x111)))
	x114 := (uint64(uint1(x113)) + x101)
	var x115 uint64
	var x116 uint64
	x115, x116 = bits.Add64(x91, x106, uint64(0x0))
	var x117 uint64
	var x118 uint64
	x117, x118 = bits.Add64(x93, x108, uint64(uint1(x116)))
	var x119 uint64
	var x120 uint64
	x119, x120 = bits.Add64(x95, x110, uint64(uint1(x118)))
	var x121 uint64
	var x122 uint64
	x121, x122 = bits.Add64(x97, x112, uint64(uint1(x120)))
	var x123 uint64
	var x124 uint64
	x123, x124 = bits.Add64(x99, x114, uint64(uint1(x122)))
	var x125 uint64
	_, x125 = bits.Mul64(x115, 0x4b0dff665588b13f)
	var x127 uint64
	var x128 uint64
	x128, x127 = bits.Mul64(x125, 0xffffffffffffffff)
	var x129 uint64
	var x130 uint64
	x130, x129 = bits.Mul64(x125, 0xfffffffffffffffe)
	var x131 uint64
	var x132 uint64
	x132, x131 = bits.Mul64(x125, 0xbaaedce6af48a03b)
	var x133 uint64
	var x134 uint64
	x134, x133 = bits.Mul64(x125, 0xbfd25e8cd0364141)
	var x135 uint64
	var x136 uint64
	x135, x136 = bits.Add64(x134, x131, uint64(0x0))
	var x137 uint64
	var x138 uint64
	x137, x138 = bits.Add64(x132, x129, uint64(uint1(x136)))
	var x139 uint64
	var x140 uint64
	x139, x140 = bits.Add64(x130, x127, uint64(uint1(x138)))
	x141 := (uint64(uint1(x140)) + x128)
	var x143 uint64
	_, x143 = bits.Add64(x115, x133, uint64(0x0))
	var x144 uint64
	var x145 uint64
	x144, x145 = bits.Add64(x117, x135, uint64(uint1(x143)))
	var x146 uint64
	var x147 uint64
	x146, x147 = bits.Add64(x119, x137, uint64(uint1(x145)))
	var x148 uint64
	var x149 uint64
	x148, x149 = bits.Add64(x121, x139, uint64(uint1(x147)))
	var x150 uint64
	var x151 uint64
	x150, x151 = bits.Add64(x123, x141, uint64(uint1(x149)))
	x152 := (uint64(uint1(x151)) + uint64(uint1(x124)))
	var x153 uint64
	var x154 uint64
	x154, x153 = bits.Mul64(x3, arg1[3])
	var x155 uint64
	var x156 uint64
	x156, x155 = bits.Mul64(x3, arg1[2])
	var x157 uint64
	var x158 uint64
	x158, x157 = bits.Mul64(x3, arg1[1])
	var x159 uint64
	var x160 uint64
	x160, x159 = bits.Mul64(x3, arg1[0])
	var x161 uint64
	var x162 uint64
	x161, x162 = bits.Add64(x160, x157, uint64(0x0))
	var x163 uint64
	var x164 uint64
	x163, x164 = bits.Add64(x158, x155, uint64(uint1(x162)))
	var x165 uint64
	var x166 uint64
	x165, x166 = bits.Add64(x156, x153, uint64(uint1(x164)))
	x167 := (uint64(uint1(x166)) + x154)
	var x168 uint64
	var x169 uint64
	x168, x169 = bits.Add64(x144, x159, uint64(0x0))
	var x170 uint64
	var x171 uint64
	x170, x171 = bits.Add64(x146, x161, uint64(uint1(x169)))
	var x172 uint64
	var x173 uint64
	x172, x173 = bits.Add64(x148, x163, uint64(uint1(x171)))
	var x174 uint64
	var x175 uint64
	x174, x175 = bits.Add64(x150, x165, uint64(uint1(x173)))
	var x176 uint64
	var x177 uint64
	x176, x177 = bits.Add64(x152, x167, uint64(uint1(x175)))
	var x178 uint64
	_, x178 = bits.Mul64(x168, 0x4b0dff665588b13f)
	var x180 uint64
	var x181 uint64
	x181, x180 = bits.Mul64(x178, 0xffffffffffffffff)
	var x182 uint64
	var x183 uint64
	x183, x182 = bits.Mul64(x178, 0xfffffffffffffffe)
	var x184 uint64
	var x185 uint64
	x185, x184 = bits.Mul64(x178, 0xbaaedce6af48a03b)
	var x186 uint64
	var x187 uint64
	x187, x186 = bits.Mul64(x178, 0xbfd25e8cd0364141)
	var x188 uint64
	var x189 uint64
	x188, x189 = bits.Add64(x187, x184, uint64(0x0))
	var x190 uint64
	var x191 uint64
	x190, x191 = bits.Add64(x185, x182, uint64(uint1(x189)))
	var x192 uint64
	var x193 uint64
	x192, x193 = bits.Add64(x183, x180, uint64(uint1(x191)))
	x194 := (uint64(uint1(x193)) + x181)
	var x196 uint64
	_, x196 = bits.Add64(x168, x186, uint64(0x0))
	var x197 uint64
	var x198 uint64
	x197, x198 = bits.Add64(x170, x188, uint64(uint1(x196)))
	var x199 uint64
	var x200 uint64
	x199, x200 = bits.Add64(x172, x190, uint64(uint1(x198)))
	var x201 uint64
	var x202 uint64
	x201, x202 = bits.Add64(x174, x192, uint64(uint1(x200)))
	var x203 uint64
	var x204 uint64
	x203, x204 = bits.Add64(x176, x194, uint64(uint1(x202)))
	x205 := (uint64(uint1(x204)) + uint64(uint1(x177)))
	var x206 uint64
	var x207 uint64
	x206, x207 = bits.Sub64(x197, 0xbfd25e8cd0364141, uint64(0x0))
	var x208 uint64
	var x209 uint64
	x208, x209 = bits.Sub64(x199, 0xbaaedce6af48a03b, uint64(uint1(x207)))
	var x210 uint64
	var x211 uint64
	x210, x211 = bits.Sub64(x201, 0xfffffffffffffffe, uint64(uint1(x209)))
	var x212 uint64
	var x213 uint64
	x212, x213 = bits.Sub64(x203, 0xffffffffffffffff, uint64(uint1(x211)))
	var x215 uint64
	_, x215 = bits.Sub64(x205, uint64(0x0), uint64(uint1(x213)))
	var x216 uint64
	cmovznzU64(&x216, uint1(x215), x206, x197)
	var x217 uint64
	cmovznzU64(&x217, uint1(x215), x208, x199)
	var x218 uint64
	cmovznzU64(&x218, uint1(x215), x210, x201)
	var x219 uint64
	cmovznzU64(&x219, uint1(x215), x212, x203)
	out1[0] = x216
	out1[1] = x217
	out1[2] = x218
	out1[3] = x219
}

// Add adds two field elements in the Montgomery domain.
//
// Preconditions:
//
//	0 ≤ eval arg1 < m
//	0 ≤ eval arg2 < m
//
// Postconditions:
//
//	eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m
//	0 ≤ eval out1 < m
func Add(out1 *MontgomeryDomainFieldElement, arg1 *MontgomeryDomainFieldElement, arg2 *MontgomeryDomainFieldElement) {
	var x1 uint64
	var x2 uint64
	x1, x2 = bits.Add64(arg1[0], arg2[0], uint64(0x0))
	var x3 uint64
	var x4 uint64
	x3, x4 = bits.Add64(arg1[1], arg2[1], uint64(uint1(x2)))
	var x5 uint64
	var x6 uint64
	x5, x6 = bits.Add64(arg1[2], arg2[2], uint64(uint1(x4)))
	var x7 uint64
	var x8 uint64
	x7, x8 = bits.Add64(arg1[3], arg2[3], uint64(uint1(x6)))
	var x9 uint64
	var x10 uint64
	x9, x10 = bits.Sub64(x1, 0xbfd25e8cd0364141, uint64(0x0))
	var x11 uint64
	var x12 uint64
	x11, x12 = bits.Sub64(x3, 0xbaaedce6af48a03b, uint64(uint1(x10)))
	var x13 uint64
	var x14 uint64
	x13, x14 = bits.Sub64(x5, 0xfffffffffffffffe, uint64(uint1(x12)))
	var x15 uint64
	var x16 uint64
	x15, x16 = bits.Sub64(x7, 0xffffffffffffffff, uint64(uint1(x14)))
	var x18 uint64
	_, x18 = bits.Sub64(uint64(uint1(x8)), uint64(0x0), uint64(uint1(x16)))
	var x19 uint64
	cmovznzU64(&x19, uint1(x18), x9, x1)
	var x20 uint64
	cmovznzU64(&x20, uint1(x18), x11, x3)
	var x21 uint64
	cmovznzU64(&x21, uint1(x18), x13, x5)
	var x22 uint64
	cmovznzU64(&x22, uint1(x18), x15, x7)
	out1[0] = x19
	out1[1] = x20
	out1[2] = x21
	out1[3] = x22
}

// Sub subtracts two field elements in the Montgomery domain.
//
// Preconditions:
//
//	0 ≤ eval arg1 < m
//	0 ≤ eval arg2 < m
//
// Postconditions:
//
//	eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m
//	0 ≤ eval out1 < m
func Sub(out1 *MontgomeryDomainFieldElement, arg1 *MontgomeryDomainFieldElement, arg2 *MontgomeryDomainFieldElement) {
	var x1 uint64
	var x2 uint64
	x1, x2 = bits.Sub64(arg1[0], arg2[0], uint64(0x0))
	var x3 uint64
	var x4 uint64
	x3, x4 = bits.Sub64(arg1[1], arg2[1], uint64(uint1(x2)))
	var x5 uint64
	var x6 uint64
	x5, x6 = bits.Sub64(arg1[2], arg2[2], uint64(uint1(x4)))
	var x7 uint64
	var x8 uint64
	x7, x8 = bits.Sub64(arg1[3], arg2[3], uint64(uint1(x6)))
	var x9 uint64
	cmovznzU64(&x9, uint1(x8), uint64(0x0), 0xffffffffffffffff)
	var x10 uint64
	var x11 uint64
	x10, x11 = bits.Add64(x1, (x9 & 0xbfd25e8cd0364141), uint64(0x0))
	var x12 uint64
	var x13 uint64
	x12, x13 = bits.Add64(x3, (x9 & 0xbaaedce6af48a03b), uint64(uint1(x11)))
	var x14 uint64
	var x15 uint64
	x14, x15 = bits.Add64(x5, (x9 & 0xfffffffffffffffe), uint64(uint1(x13)))
	var x16 uint64
	x16, _ = bits.Add64(x7, x9, uint64(uint1(x15)))
	out1[0] = x10
	out1[1] = x12
	out1[2] = x14
	out1[3] = x16
}

// Opp negates a field element in the Montgomery domain.
//
// Preconditions:
//
//	0 ≤ eval arg1 < m
//
// Postconditions:
//
//	eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m
//	0 ≤ eval out1 < m
func Opp(out1 *MontgomeryDomainFieldElement, arg1 *MontgomeryDomainFieldElement) {
	var x1 uint64
	var x2 uint64
	x1, x2 = bits.Sub64(uint64(0x0), arg1[0], uint64(0x0))
	var x3 uint64
	var x4 uint64
	x3, x4 = bits.Sub64(uint64(0x0), arg1[1], uint64(uint1(x2)))
	var x5 uint64
	var x6 uint64
	x5, x6 = bits.Sub64(uint64(0x0), arg1[2], uint64(uint1(x4)))
	var x7 uint64
	var x8 uint64
	x7, x8 = bits.Sub64(uint64(0x0), arg1[3], uint64(uint1(x6)))
	var x9 uint64
	cmovznzU64(&x9, uint1(x8), uint64(0x0), 0xffffffffffffffff)
	var x10 uint64
	var x11 uint64
	x10, x11 = bits.Add64(x1, (x9 & 0xbfd25e8cd0364141), uint64(0x0))
	var x12 uint64
	var x13 uint64
	x12, x13 = bits.Add64(x3, (x9 & 0xbaaedce6af48a03b), uint64(uint1(x11)))
	var x14 uint64
	var x15 uint64
	x14, x15 = bits.Add64(x5, (x9 & 0xfffffffffffffffe), uint64(uint1(x13)))
	var x16 uint64
	x16, _ = bits.Add64(x7, x9, uint64(uint1(x15)))
	out1[0] = x10
	out1[1] = x12
	out1[2] = x14
	out1[3] = x16
}

// FromMontgomery translates a field element out of the Montgomery domain.
//
// Preconditions:
//
//	0 ≤ eval arg1 < m
//
// Postconditions:
//
//	eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^4) mod m
//	0 ≤ eval out1 < m
func FromMontgomery(out1 *NonMontgomeryDomainFieldElement, arg1 *MontgomeryDomainFieldElement) {
	x1 := arg1[0]
	var x2 uint64
	_, x2 = bits.Mul64(x1, 0x4b0dff665588b13f)
	var x4 uint64
	var x5 uint64
	x5, x4 = bits.Mul64(x2, 0xffffffffffffffff)
	var x6 uint64
	var x7 uint64
	x7, x6 = bits.Mul64(x2, 0xfffffffffffffffe)
	var x8 uint64
	var x9 uint64
	x9, x8 = bits.Mul64(x2, 0xbaaedce6af48a03b)
	var x10 uint64
	var x11 uint64
	x11, x10 = bits.Mul64(x2, 0xbfd25e8cd0364141)
	var x12 uint64
	var x13 uint64
	x12, x13 = bits.Add64(x11, x8, uint64(0x0))
	var x14 uint64
	var x15 uint64
	x14, x15 = bits.Add64(x9, x6, uint64(uint1(x13)))
	var x16 uint64
	var x17 uint64
	x16, x17 = bits.Add64(x7, x4, uint64(uint1(x15)))
	var x19 uint64
	_, x19 = bits.Add64(x1, x10, uint64(0x0))
	var x20 uint64
	var x21 uint64
	x20, x21 = bits.Add64(uint64(0x0), x12, uint64(uint1(x19)))
	var x22 uint64
	var x23 uint64
	x22, x23 = bits.Add64(uint64(0x0), x14, uint64(uint1(x21)))
	var x24 uint64
	var x25 uint64
	x24, x25 = bits.Add64(uint64(0x0), x16, uint64(uint1(x23)))
	var x26 uint64
	var x27 uint64
	x26, x27 = bits.Add64(uint64(0x0), (uint64(uint1(x17)) + x5), uint64(uint1(x25)))
	var x28 uint64
	var x29 uint64
	x28, x29 = bits.Add64(x20, arg1[1], uint64(0x0))
	var x30 uint64
	var x31 uint64
	x30, x31 = bits.Add64(x22, uint64(0x0), uint64(uint1(x29)))
	var x32 uint64
	var x33 uint64
	x32, x33 = bits.Add64(x24, uint64(0x0), uint64(uint1(x31)))
	var x34 uint64
	var x35 uint64
	x34, x35 = bits.Add64(x26, uint64(0x0), uint64(uint1(x33)))
	var x36 uint64
	_, x36 = bits.Mul64(x28, 0x4b0dff665588b13f)
	var x38 uint64
	var x39 uint64
	x39, x38 = bits.Mul64(x36, 0xffffffffffffffff)
	var x40 uint64
	var x41 uint64
	x41, x40 = bits.Mul64(x36, 0xfffffffffffffffe)
	var x42 uint64
	var x43 uint64
	x43, x42 = bits.Mul64(x36, 0xbaaedce6af48a03b)
	var x44 uint64
	var x45 uint64
	x45, x44 = bits.Mul64(x36, 0xbfd25e8cd0364141)
	var x46 uint64
	var x47 uint64
	x46, x47 = bits.Add64(x45, x42, uint64(0x0))
	var x48 uint64
	var x49 uint64
	x48, x49 = bits.Add64(x43, x40, uint64(uint1(x47)))
	var x50 uint64
	var x51 uint64
	x50, x51 = bits.Add64(x41, x38, uint64(uint1(x49)))
	var x53 uint64
	_, x53 = bits.Add64(x28, x44, uint64(0x0))
	var x54 uint64
	var x55 uint64
	x54, x55 = bits.Add64(x30, x46, uint64(uint1(x53)))
	var x56 uint64
	var x57 uint64
	x56, x57 = bits.Add64(x32, x48, uint64(uint1(x55)))
	var x58 uint64
	var x59 uint64
	x58, x59 = bits.Add64(x34, x50, uint64(uint1(x57)))
	var x60 uint64
	var x61 uint64
	x60, x61 = bits.Add64((uint64(uint1(x35)) + uint64(uint1(x27))), (uint64(uint1(x51)) + x39), uint64(uint1(x59)))
	var x62 uint64
	var x63 uint64
	x62, x63 = bits.Add64(x54, arg1[2], uint64(0x0))
	var x64 uint64
	var x65 uint64
	x64, x65 = bits.Add64(x56, uint64(0x0), uint64(uint1(x63)))
	var x66 uint64
	var x67 uint64
	x66, x67 = bits.Add64(x58, uint64(0x0), uint64(uint1(x65)))
	var x68 uint64
	var x69 uint64
	x68, x69 = bits.Add64(x60, uint64(0x0), uint64(uint1(x67)))
	var x70 uint64
	_, x70 = bits.Mul64(x62, 0x4b0dff665588b13f)
	var x72 uint64
	var x73 uint64
	x73, x72 = bits.Mul64(x70, 0xffffffffffffffff)
	var x74 uint64
	var x75 uint64
	x75, x74 = bits.Mul64(x70, 0xfffffffffffffffe)
	var x76 uint64
	var x77 uint64
	x77, x76 = bits.Mul64(x70, 0xbaaedce6af48a03b)
	var x78 uint64
	var x79 uint64
	x79, x78 = bits.Mul64(x70, 0xbfd25e8cd0364141)
	var x80 uint64
	var x81 uint64
	x80, x81 = bits.Add64(x79, x76, uint64(0x0))
	var x82 uint64
	var x83 uint64
	x82, x83 = bits.Add64(x77, x74, uint64(uint1(x81)))
	var x84 uint64
	var x85 uint64
	x84, x85 = bits.Add64(x75, x72, uint64(uint1(x83)))
	var x87 uint64
	_, x87 = bits.Add64(x62, x78, uint64(0x0))
	var x88 uint64
	var x89 uint64
	x88, x89 = bits.Add64(x64, x80, uint64(uint1(x87)))
	var x90 uint64
	var x91 uint64
	x90, x91 = bits.Add64(x66, x82, uint64(uint1(x89)))
	var x92 uint64
	var x93 uint64
	x92, x93 = bits.Add64(x68, x84, uint64(uint1(x91)))
	var x94 uint64
	var x95 uint64
	x94, x95 = bits.Add64((uint64(uint1(x69)) + uint64(uint1(x61))), (uint64(uint1(x85)) + x73), uint64(uint1(x93)))
	var x96 uint64
	var x97 uint64
	x96, x97 = bits.Add64(x88, arg1[3], uint64(0x0))
	var x98 uint64
	var x99 uint64
	x98, x99 = bits.Add64(x90, uint64(0x0), uint64(uint1(x97)))
	var x100 uint64
	var x101 uint64
	x100, x101 = bits.Add64(x92, uint64(0x0), uint64(uint1(x99)))
	var x102 uint64
	var x103 uint64
	x102, x103 = bits.Add64(x94, uint64(0x0), uint64(uint1(x101)))
	var x104 uint64
	_, x104 = bits.Mul64(x96, 0x4b0dff665588b13f)
	var x106 uint64
	var x107 uint64
	x107, x106 = bits.Mul64(x104, 0xffffffffffffffff)
	var x108 uint64
	var x109 uint64
	x109, x108 = bits.Mul64(x104, 0xfffffffffffffffe)
	var x110 uint64
	var x111 uint64
	x111, x110 = bits.Mul64(x104, 0xbaaedce6af48a03b)
	var x112 uint64
	var x113 uint64
	x113, x112 = bits.Mul64(x104, 0xbfd25e8cd0364141)
	var x114 uint64
	var x115 uint64
	x114, x115 = bits.Add64(x113, x110, uint64(0x0))
	var x116 uint64
	var x117 uint64
	x116, x117 = bits.Add64(x111, x108, uint64(uint1(x115)))
	var x118 uint64
	var x119 uint64
	x118, x119 = bits.Add64(x109, x106, uint64(uint1(x117)))
	var x121 uint64
	_, x121 = bits.Add64(x96, x112, uint64(0x0))
	var x122 uint64
	var x123 uint64
	x122, x123 = bits.Add64(x98, x114, uint64(uint1(x121)))
	var x124 uint64
	var x125 uint64
	x124, x125 = bits.Add64(x100, x116, uint64(uint1(x123)))
	var x126 uint64
	var x127 uint64
	x126, x127 = bits.Add64(x102, x118, uint64(uint1(x125)))
	var x128 uint64
	var x129 uint64
	x128, x129 = bits.Add64((uint64(uint1(x103)) + uint64(uint1(x95))), (uint64(uint1(x119)) + x107), uint64(uint1(x127)))
	var x130 uint64
	var x131 uint64
	x130, x131 = bits.Sub64(x122, 0xbfd25e8cd0364141, uint64(0x0))
	var x132 uint64
	var x133 uint64
	x132, x133 = bits.Sub64(x124, 0xbaaedce6af48a03b, uint64(uint1(x131)))
	var x134 uint64
	var x135 uint64
	x134, x135 = bits.Sub64(x126, 0xfffffffffffffffe, uint64(uint1(x133)))
	var x136 uint64
	var x137 uint64
	x136, x137 = bits.Sub64(x128, 0xffffffffffffffff, uint64(uint1(x135)))
	var x139 uint64
	_, x139 = bits.Sub64(uint64(uint1(x129)), uint64(0x0), uint64(uint1(x137)))
	var x140 uint64
	cmovznzU64(&x140, uint1(x139), x130, x122)
	var x141 uint64
	cmovznzU64(&x141, uint1(x139), x132, x124)
	var x142 uint64
	cmovznzU64(&x142, uint1(x139), x134, x126)
	var x143 uint64
	cmovznzU64(&x143, uint1(x139), x136, x128)
	out1[0] = x140
	out1[1] = x141
	out1[2] = x142
	out1[3] = x143
}

// ToMontgomery translates a field element into the Montgomery domain.
//
// Preconditions:
//
//	0 ≤ eval arg1 < m
//
// Postconditions:
//
//	eval (from_montgomery out1) mod m = eval arg1 mod m
//	0 ≤ eval out1 < m
func ToMontgomery(out1 *MontgomeryDomainFieldElement, arg1 *NonMontgomeryDomainFieldElement) {
	x1 := arg1[1]
	x2 := arg1[2]
	x3 := arg1[3]
	x4 := arg1[0]
	var x5 uint64
	var x6 uint64
	x6, x5 = bits.Mul64(x4, 0x9d671cd581c69bc5)
	var x7 uint64
	var x8 uint64
	x8, x7 = bits.Mul64(x4, 0xe697f5e45bcd07c6)
	var x9 uint64
	var x10 uint64
	x10, x9 = bits.Mul64(x4, 0x741496c20e7cf878)
	var x11 uint64
	var x12 uint64
	x12, x11 = bits.Mul64(x4, 0x896cf21467d7d140)
	var x13 uint64
	var x14 uint64
	x13, x14 = bits.Add64(x12, x9, uint64(0x0))
	var x15 uint64
	var x16 uint64
	x15, x16 = bits.Add64(x10, x7, uint64(uint1(x14)))
	var x17 uint64
	var x18 uint64
	x17, x18 = bits.Add64(x8, x5, uint64(uint1(x16)))
	var x19 uint64
	_, x19 = bits.Mul64(x11, 0x4b0dff665588b13f)
	var x21 uint64
	var x22 uint64
	x22, x21 = bits.Mul64(x19, 0xffffffffffffffff)
	var x23 uint64
	var x24 uint64
	x24, x23 = bits.Mul64(x19, 0xfffffffffffffffe)
	var x25 uint64
	var x26 uint64
	x26, x25 = bits.Mul64(x19, 0xbaaedce6af48a03b)
	var x27 uint64
	var x28 uint64
	x28, x27 = bits.Mul64(x19, 0xbfd25e8cd0364141)
	var x29 uint64
	var x30 uint64
	x29, x30 = bits.Add64(x28, x25, uint64(0x0))
	var x31 uint64
	var x32 uint64
	x31, x32 = bits.Add64(x26, x23, uint64(uint1(x30)))
	var x33 uint64
	var x34 uint64
	x33, x34 = bits.Add64(x24, x21, uint64(uint1(x32)))
	var x36 uint64
	_, x36 = bits.Add64(x11, x27, uint64(0x0))
	var x37 uint64
	var x38 uint64
	x37, x38 = bits.Add64(x13, x29, uint64(uint1(x36)))
	var x39 uint64
	var x40 uint64
	x39, x40 = bits.Add64(x15, x31, uint64(uint1(x38)))
	var x41 uint64
	var x42 uint64
	x41, x42 = bits.Add64(x17, x33, uint64(uint1(x40)))
	var x43 uint64
	var x44 uint64
	x43, x44 = bits.Add64((uint64(uint1(x18)) + x6), (uint64(uint1(x34)) + x22), uint64(uint1(x42)))
	var x45 uint64
	var x46 uint64
	x46, x45 = bits.Mul64(x1, 0x9d671cd581c69bc5)
	var x47 uint64
	var x48 uint64
	x48, x47 = bits.Mul64(x1, 0xe697f5e45bcd07c6)
	var x49 uint64
	var x50 uint64
	x50, x49 = bits.Mul64(x1, 0x741496c20e7cf878)
	var x51 uint64
	var x52 uint64
	x52, x51 = bits.Mul64(x1, 0x896cf21467d7d140)
	var x53 uint64
	var x54 uint64
	x53, x54 = bits.Add64(x52, x49, uint64(0x0))
	var x55 uint64
	var x56 uint64
	x55, x56 = bits.Add64(x50, x47, uint64(uint1(x54)))
	var x57 uint64
	var x58 uint64
	x57, x58 = bits.Add64(x48, x45, uint64(uint1(x56)))
	var x59 uint64
	var x60 uint64
	x59, x60 = bits.Add64(x37, x51, uint64(0x0))
	var x61 uint64
	var x62 uint64
	x61, x62 = bits.Add64(x39, x53, uint64(uint1(x60)))
	var x63 uint64
	var x64 uint64
	x63, x64 = bits.Add64(x41, x55, uint64(uint1(x62)))
	var x65 uint64
	var x66 uint64
	x65, x66 = bits.Add64(x43, x57, uint64(uint1(x64)))
	var x67 uint64
	_, x67 = bits.Mul64(x59, 0x4b0dff665588b13f)
	var x69 uint64
	var x70 uint64
	x70, x69 = bits.Mul64(x67, 0xffffffffffffffff)
	var x71 uint64
	var x72 uint64
	x72, x71 = bits.Mul64(x67, 0xfffffffffffffffe)
	var x73 uint64
	var x74 uint64
	x74, x73 = bits.Mul64(x67, 0xbaaedce6af48a03b)
	var x75 uint64
	var x76 uint64
	x76, x75 = bits.Mul64(x67, 0xbfd25e8cd0364141)
	var x77 uint64
	var x78 uint64
	x77, x78 = bits.Add64(x76, x73, uint64(0x0))
	var x79 uint64
	var x80 uint64
	x79, x80 = bits.Add64(x74, x71, uint64(uint1(x78)))
	var x81 uint64
	var x82 uint64
	x81, x82 = bits.Add64(x72, x69, uint64(uint1(x80)))
	var x84 uint64
	_, x84 = bits.Add64(x59, x75, uint64(0x0))
	var x85 uint64
	var x86 uint64
	x85, x86 = bits.Add64(x61, x77, uint64(uint1(x84)))
	var x87 uint64
	var x88 uint64
	x87, x88 = bits.Add64(x63, x79, uint64(uint1(x86)))
	var x89 uint64
	var x90 uint64
	x89, x90 = bits.Add64(x65, x81, uint64(uint1(x88)))
	var x91 uint64
	var x92 uint64
	x91, x92 = bits.Add64(((uint64(uint1(x66)) + uint64(uint1(x44))) + (uint64(uint1(x58)) + x46)), (uint64(uint1(x82)) + x70), uint64(uint1(x90)))
	var x93 uint64
	var x94 uint64
	x94, x93 = bits.Mul64(x2, 0x9d671cd581c69bc5)
	var x95 uint64
	var x96 uint64
	x96, x95 = bits.Mul64(x2, 0xe697f5e45bcd07c6)
	var x97 uint64
	var x98 uint64
	x98, x97 = bits.Mul64(x2, 0x741496c20e7cf878)
	var x99 uint64
	var x100 uint64
	x100, x99 = bits.Mul64(x2, 0x896cf21467d7d140)
	var x101 uint64
	var x102 uint64
	x101, x102 = bits.Add64(x100, x97, uint64(0x0))
	var x103 uint64
	var x104 uint64
	x103, x104 = bits.Add64(x98, x95, uint64(uint1(x102)))
	var x105 uint64
	var x106 uint64
	x105, x106 = bits.Add64(x96, x93, uint64(uint1(x104)))
	var x107 uint64
	var x108 uint64
	x107, x108 = bits.Add64(x85, x99, uint64(0x0))
	var x109 uint64
	var x110 uint64
	x109, x110 = bits.Add64(x87, x101, uint64(uint1(x108)))
	var x111 uint64
	var x112 uint64
	x111, x112 = bits.Add64(x89, x103, uint64(uint1(x110)))
	var x113 uint64
	var x114 uint64
	x113, x114 = bits.Add64(x91, x105, uint64(uint1(x112)))
	var x115 uint64
	_, x115 = bits.Mul64(x107, 0x4b0dff665588b13f)
	var x117 uint64
	var x118 uint64
	x118, x117 = bits.Mul64(x115, 0xffffffffffffffff)
	var x119 uint64
	var x120 uint64
	x120, x119 = bits.Mul64(x115, 0xfffffffffffffffe)
	var x121 uint64
	var x122 uint64
	x122, x121 = bits.Mul64(x115, 0xbaaedce6af48a03b)
	var x123 uint64
	var x124 uint64
	x124, x123 = bits.Mul64(x115, 0xbfd25e8cd0364141)
	var x125 uint64
	var x126 uint64
	x125, x126 = bits.Add64(x124, x121, uint64(0x0))
	var x127 uint64
	var x128 uint64
	x127, x128 = bits.Add64(x122, x119, uint64(uint1(x126)))
	var x129 uint64
	var x130 uint64
	x129, x130 = bits.Add64(x120, x117, uint64(uint1(x128)))
	var x132 uint64
	_, x132 = bits.Add64(x107, x123, uint64(0x0))
	var x133 uint64
	var x134 uint64
	x133, x134 = bits.Add64(x109, x125, uint64(uint1(x132)))
	var x135 uint64
	var x136 uint64
	x135, x136 = bits.Add64(x111, x127, uint64(uint1(x134)))
	var x137 uint64
	var x138 uint64
	x137, x138 = bits.Add64(x113, x129, uint64(uint1(x136)))
	var x139 uint64
	var x140 uint64
	x139, x140 = bits.Add64(((uint64(uint1(x114)) + uint64(uint1(x92))) + (uint64(uint1(x106)) + x94)), (uint64(uint1(x130)) + x118), uint64(uint1(x138)))
	var x141 uint64
	var x142 uint64
	x142, x141 = bits.Mul64(x3, 0x9d671cd581c69bc5)
	var x143 uint64
	var x144 uint64
	x144, x143 = bits.Mul64(x3, 0xe697f5e45bcd07c6)
	var x145 uint64
	var x146 uint64
	x146, x145 = bits.Mul64(x3, 0x741496c20e7cf878)
	var x147 uint64
	var x148 uint64
	x148, x147 = bits.Mul64(x3, 0x896cf21467d7d140)
	var x149 uint64
	var x150 uint64
	x149, x150 = bits.Add64(x148, x145, uint64(0x0))
	var x151 uint64
	var x152 uint64
	x151, x152 = bits.Add64(x146, x143, uint64(uint1(x150)))
	var x153 uint64
	var x154 uint64
	x153, x154 = bits.Add64(x144, x141, uint64(uint1(x152)))
	var x155 uint64
	var x156 uint64
	x155, x156 = bits.Add64(x133, x147, uint64(0x0))
	var x157 uint64
	var x158 uint64
	x157, x158 = bits.Add64(x135, x149, uint64(uint1(x156)))
	var x159 uint64
	var x160 uint64
	x159, x160 = bits.Add64(x137, x151, uint64(uint1(x158)))
	var x161 uint64
	var x162 uint64
	x161, x162 = bits.Add64(x139, x153, uint64(uint1(x160)))
	var x163 uint64
	_, x163 = bits.Mul64(x155, 0x4b0dff665588b13f)
	var x165 uint64
	var x166 uint64
	x166, x165 = bits.Mul64(x163, 0xffffffffffffffff)
	var x167 uint64
	var x168 uint64
	x168, x167 = bits.Mul64(x163, 0xfffffffffffffffe)
	var x169 uint64
	var x170 uint64
	x170, x169 = bits.Mul64(x163, 0xbaaedce6af48a03b)
	var x171 uint64
	var x172 uint64
	x172, x171 = bits.Mul64(x163, 0xbfd25e8cd0364141)
	var x173 uint64
	var x174 uint64
	x173, x174 = bits.Add64(x172, x169, uint64(0x0))
	var x175 uint64
	var x176 uint64
	x175, x176 = bits.Add64(x170, x167, uint64(uint1(x174)))
	var x177 uint64
	var x178 uint64
	x177, x178 = bits.Add64(x168, x165, uint64(uint1(x176)))
	var x180 uint64
	_, x180 = bits.Add64(x155, x171, uint64(0x0))
	var x181 uint64
	var x182 uint64
	x181, x182 = bits.Add64(x157, x173, uint64(uint1(x180)))
	var x183 uint64
	var x184 uint64
	x183, x184 = bits.Add64(x159, x175, uint64(uint1(x182)))
	var x185 uint64
	var x186 uint64
	x185, x186 = bits.Add64(x161, x177, uint64(uint1(x184)))
	var x187 uint64
	var x188 uint64
	x187, x188 = bits.Add64(((uint64(uint1(x162)) + uint64(uint1(x140))) + (uint64(uint1(x154)) + x142)), (uint64(uint1(x178)) + x166), uint64(uint1(x186)))
	var x189 uint64
	var x190 uint64
	x189, x190 = bits.Sub64(x181, 0xbfd25e8cd0364141, uint64(0x0))
	var x191 uint64
	var x192 uint64
	x191, x192 = bits.Sub64(x183, 0xbaaedce6af48a03b, uint64(uint1(x190)))
	var x193 uint64
	var x194 uint64
	x193, x194 = bits.Sub64(x185, 0xfffffffffffffffe, uint64(uint1(x192)))
	var x195 uint64
	var x196 uint64
	x195, x196 = bits.Sub64(x187, 0xffffffffffffffff, uint64(uint1(x194)))
	var x198 uint64
	_, x198 = bits.Sub64(uint64(uint1(x188)), uint64(0x0), uint64(uint1(x196)))
	var x199 uint64
	cmovznzU64(&x199, uint1(x198), x189, x181)
	var x200 uint64
	cmovznzU64(&x200, uint1(x198), x191, x183)
	var x201 uint64
	cmovznzU64(&x201, uint1(x198), x193, x185)
	var x202 uint64
	cmovznzU64(&x202, uint1(x198), x195, x187)
	out1[0] = x199
	out1[1] = x200
	out1[2] = x201
	out1[3] = x202
}

// Nonzero outputs a single non-zero word if the input is non-zero and zero otherwise.
//
// Preconditions:
//
//	0 ≤ eval arg1 < m
//
// Postconditions:
//
//	out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0
//
// Input Bounds:
//
//	arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//
// Output Bounds:
//
//	out1: [0x0 ~> 0xffffffffffffffff]
func Nonzero(out1 *uint64, arg1 *[4]uint64) {
	x1 := (arg1[0] | (arg1[1] | (arg1[2] | arg1[3])))
	*out1 = x1
}

// Selectznz is a multi-limb conditional select.
//
// Postconditions:
//
//	out1 = (if arg1 = 0 then arg2 else arg3)
//
// Input Bounds:
//
//	arg1: [0x0 ~> 0x1]
//	arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//	arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//
// Output Bounds:
//
//	out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
func Selectznz(out1 *[4]uint64, arg1 uint1, arg2 *[4]uint64, arg3 *[4]uint64) {
	var x1 uint64
	cmovznzU64(&x1, arg1, arg2[0], arg3[0])
	var x2 uint64
	cmovznzU64(&x2, arg1, arg2[1], arg3[1])
	var x3 uint64
	cmovznzU64(&x3, arg1, arg2[2], arg3[2])
	var x4 uint64
	cmovznzU64(&x4, arg1, arg2[3], arg3[3])
	out1[0] = x1
	out1[1] = x2
	out1[2] = x3
	out1[3] = x4
}

// ToBytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order.
//
// Preconditions:
//
//	0 ≤ eval arg1 < m
//
// Postconditions:
//
//	out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..31]
//
// Input Bounds:
//
//	arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//
// Output Bounds:
//
//	out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
func ToBytes(out1 *[32]uint8, arg1 *[4]uint64) {
	x1 := arg1[3]
	x2 := arg1[2]
	x3 := arg1[1]
	x4 := arg1[0]
	x5 := (uint8(x4) & 0xff)
	x6 := (x4 >> 8)
	x7 := (uint8(x6) & 0xff)
	x8 := (x6 >> 8)
	x9 := (uint8(x8) & 0xff)
	x10 := (x8 >> 8)
	x11 := (uint8(x10) & 0xff)
	x12 := (x10 >> 8)
	x13 := (uint8(x12) & 0xff)
	x14 := (x12 >> 8)
	x15 := (uint8(x14) & 0xff)
	x16 := (x14 >> 8)
	x17 := (uint8(x16) & 0xff)
	x18 := uint8((x16 >> 8))
	x19 := (uint8(x3) & 0xff)
	x20 := (x3 >> 8)
	x21 := (uint8(x20) & 0xff)
	x22 := (x20 >> 8)
	x23 := (uint8(x22) & 0xff)
	x24 := (x22 >> 8)
	x25 := (uint8(x24) & 0xff)
	x26 := (x24 >> 8)
	x27 := (uint8(x26) & 0xff)
	x28 := (x26 >> 8)
	x29 := (uint8(x28) & 0xff)
	x30 := (x28 >> 8)
	x31 := (uint8(x30) & 0xff)
	x32 := uint8((x30 >> 8))
	x33 := (uint8(x2) & 0xff)
	x34 := (x2 >> 8)
	x35 := (uint8(x34) & 0xff)
	x36 := (x34 >> 8)
	x37 := (uint8(x36) & 0xff)
	x38 := (x36 >> 8)
	x39 := (uint8(x38) & 0xff)
	x40 := (x38 >> 8)
	x41 := (uint8(x40) & 0xff)
	x42 := (x40 >> 8)
	x43 := (uint8(x42) & 0xff)
	x44 := (x42 >> 8)
	x45 := (uint8(x44) & 0xff)
	x46 := uint8((x44 >> 8))
	x47 := (uint8(x1) & 0xff)
	x48 := (x1 >> 8)
	x49 := (uint8(x48) & 0xff)
	x50 := (x48 >> 8)
	x51 := (uint8(x50) & 0xff)
	x52 := (x50 >> 8)
	x53 := (uint8(x52) & 0xff)
	x54 := (x52 >> 8)
	x55 := (uint8(x54) & 0xff)
	x56 := (x54 >> 8)
	x57 := (uint8(x56) & 0xff)
	x58 := (x56 >> 8)
	x59 := (uint8(x58) & 0xff)
	x60 := uint8((x58 >> 8))
	out1[0] = x5
	out1[1] = x7
	out1[2] = x9
	out1[3] = x11
	out1[4] = x13
	out1[5] = x15
	out1[6] = x17
	out1[7] = x18
	out1[8] = x19
	out1[9] = x21
	out1[10] = x23
	out1[11] = x25
	out1[12] = x27
	out1[13] = x29
	out1[14] = x31
	out1[15] = x32
	out1[16] = x33
	out1[17] = x35
	out1[18] = x37
	out1[19] = x39
	out1[20] = x41
	out1[21] = x43
	out1[22] = x45
	out1[23] = x46
	out1[24] = x47
	out1[25] = x49
	out1[26] = x51
	out1[27] = x53
	out1[28] = x55
	out1[29] = x57
	out1[30] = x59
	out1[31] = x60
}

// FromBytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order.
//
// Preconditions:
//
//	0 ≤ bytes_eval arg1 < m
//
// Postconditions:
//
//	eval out1 mod m = bytes_eval arg1 mod m
//	0 ≤ eval out1 < m
//
// Input Bounds:
//
//	arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]
//
// Output Bounds:
//
//	out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
func FromBytes(out1 *[4]uint64, arg1 *[32]uint8) {
	x1 := (uint64(arg1[31]) << 56)
	x2 := (uint64(arg1[30]) << 48)
	x3 := (uint64(arg1[29]) << 40)
	x4 := (uint64(arg1[28]) << 32)
	x5 := (uint64(arg1[27]) << 24)
	x6 := (uint64(arg1[26]) << 16)
	x7 := (uint64(arg1[25]) << 8)
	x8 := arg1[24]
	x9 := (uint64(arg1[23]) << 56)
	x10 := (uint64(arg1[22]) << 48)
	x11 := (uint64(arg1[21]) << 40)
	x12 := (uint64(arg1[20]) << 32)
	x13 := (uint64(arg1[19]) << 24)
	x14 := (uint64(arg1[18]) << 16)
	x15 := (uint64(arg1[17]) << 8)
	x16 := arg1[16]
	x17 := (uint64(arg1[15]) << 56)
	x18 := (uint64(arg1[14]) << 48)
	x19 := (uint64(arg1[13]) << 40)
	x20 := (uint64(arg1[12]) << 32)
	x21 := (uint64(arg1[11]) << 24)
	x22 := (uint64(arg1[10]) << 16)
	x23 := (uint64(arg1[9]) << 8)
	x24 := arg1[8]
	x25 := (uint64(arg1[7]) << 56)
	x26 := (uint64(arg1[6]) << 48)
	x27 := (uint64(arg1[5]) << 40)
	x28 := (uint64(arg1[4]) << 32)
	x29 := (uint64(arg1[3]) << 24)
	x30 := (uint64(arg1[2]) << 16)
	x31 := (uint64(arg1[1]) << 8)
	x32 := arg1[0]
	x33 := (x31 + uint64(x32))
	x34 := (x30 + x33)
	x35 := (x29 + x34)
	x36 := (x28 + x35)
	x37 := (x27 + x36)
	x38 := (x26 + x37)
	x39 := (x25 + x38)
	x40 := (x23 + uint64(x24))
	x41 := (x22 + x40)
	x42 := (x21 + x41)
	x43 := (x20 + x42)
	x44 := (x19 + x43)
	x45 := (x18 + x44)
	x46 := (x17 + x45)
	x47 := (x15 + uint64(x16))
	x48 := (x14 + x47)
	x49 := (x13 + x48)
	x50 := (x12 + x49)
	x51 := (x11 + x50)
	x52 := (x10 + x51)
	x53 := (x9 + x52)
	x54 := (x7 + uint64(x8))
	x55 := (x6 + x54)
	x56 := (x5 + x55)
	x57 := (x4 + x56)
	x58 := (x3 + x57)
	x59 := (x2 + x58)
	x60 := (x1 + x59)
	out1[0] = x39
	out1[1] = x46
	out1[2] = x53
	out1[3] = x60
}

// SetOne returns the field element one in the Montgomery domain.
//
// Postconditions:
//
//	eval (from_montgomery out1) mod m = 1 mod m
//	0 ≤ eval out1 < m
func SetOne(out1 *MontgomeryDomainFieldElement) {
	out1[0] = 0x402da1732fc9bebf
	out1[1] = 0x4551231950b75fc4
	out1[2] = uint64(0x1)
	out1[3] = uint64(0x0)
}

// Msat returns the saturated representation of the prime modulus.
//
// Postconditions:
//
//	twos_complement_eval out1 = m
//	0 ≤ eval out1 < m
//
// Output Bounds:
//
//	out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
func Msat(out1 *[5]uint64) {
	out1[0] = 0xbfd25e8cd0364141
	out1[1] = 0xbaaedce6af48a03b
	out1[2] = 0xfffffffffffffffe
	out1[3] = 0xffffffffffffffff
	out1[4] = uint64(0x0)
}

// Divstep computes a divstep.
//
// Preconditions:
//
//	0 ≤ eval arg4 < m
//	0 ≤ eval arg5 < m
//
// Postconditions:
//
//	out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)
//	twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)
//	twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)
//	eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)
//	eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)
//	0 ≤ eval out5 < m
//	0 ≤ eval out5 < m
//	0 ≤ eval out2 < m
//	0 ≤ eval out3 < m
//
// Input Bounds:
//
//	arg1: [0x0 ~> 0xffffffffffffffff]
//	arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//	arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//	arg4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//	arg5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//
// Output Bounds:
//
//	out1: [0x0 ~> 0xffffffffffffffff]
//	out2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//	out3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//	out4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
//	out5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
func Divstep(out1 *uint64, out2 *[5]uint64, out3 *[5]uint64, out4 *[4]uint64, out5 *[4]uint64, arg1 uint64, arg2 *[5]uint64, arg3 *[5]uint64, arg4 *[4]uint64, arg5 *[4]uint64) {
	var x1 uint64
	x1, _ = bits.Add64((^arg1), uint64(0x1), uint64(0x0))
	x3 := (uint1((x1 >> 63)) & (uint1(arg3[0]) & 0x1))
	var x4 uint64
	x4, _ = bits.Add64((^arg1), uint64(0x1), uint64(0x0))
	var x6 uint64
	cmovznzU64(&x6, x3, arg1, x4)
	var x7 uint64
	cmovznzU64(&x7, x3, arg2[0], arg3[0])
	var x8 uint64
	cmovznzU64(&x8, x3, arg2[1], arg3[1])
	var x9 uint64
	cmovznzU64(&x9, x3, arg2[2], arg3[2])
	var x10 uint64
	cmovznzU64(&x10, x3, arg2[3], arg3[3])
	var x11 uint64
	cmovznzU64(&x11, x3, arg2[4], arg3[4])
	var x12 uint64
	var x13 uint64
	x12, x13 = bits.Add64(uint64(0x1), (^arg2[0]), uint64(0x0))
	var x14 uint64
	var x15 uint64
	x14, x15 = bits.Add64(uint64(0x0), (^arg2[1]), uint64(uint1(x13)))
	var x16 uint64
	var x17 uint64
	x16, x17 = bits.Add64(uint64(0x0), (^arg2[2]), uint64(uint1(x15)))
	var x18 uint64
	var x19 uint64
	x18, x19 = bits.Add64(uint64(0x0), (^arg2[3]), uint64(uint1(x17)))
	var x20 uint64
	x20, _ = bits.Add64(uint64(0x0), (^arg2[4]), uint64(uint1(x19)))
	var x22 uint64
	cmovznzU64(&x22, x3, arg3[0], x12)
	var x23 uint64
	cmovznzU64(&x23, x3, arg3[1], x14)
	var x24 uint64
	cmovznzU64(&x24, x3, arg3[2], x16)
	var x25 uint64
	cmovznzU64(&x25, x3, arg3[3], x18)
	var x26 uint64
	cmovznzU64(&x26, x3, arg3[4], x20)
	var x27 uint64
	cmovznzU64(&x27, x3, arg4[0], arg5[0])
	var x28 uint64
	cmovznzU64(&x28, x3, arg4[1], arg5[1])
	var x29 uint64
	cmovznzU64(&x29, x3, arg4[2], arg5[2])
	var x30 uint64
	cmovznzU64(&x30, x3, arg4[3], arg5[3])
	var x31 uint64
	var x32 uint64
	x31, x32 = bits.Add64(x27, x27, uint64(0x0))
	var x33 uint64
	var x34 uint64
	x33, x34 = bits.Add64(x28, x28, uint64(uint1(x32)))
	var x35 uint64
	var x36 uint64
	x35, x36 = bits.Add64(x29, x29, uint64(uint1(x34)))
	var x37 uint64
	var x38 uint64
	x37, x38 = bits.Add64(x30, x30, uint64(uint1(x36)))
	var x39 uint64
	var x40 uint64
	x39, x40 = bits.Sub64(x31, 0xbfd25e8cd0364141, uint64(0x0))
	var x41 uint64
	var x42 uint64
	x41, x42 = bits.Sub64(x33, 0xbaaedce6af48a03b, uint64(uint1(x40)))
	var x43 uint64
	var x44 uint64
	x43, x44 = bits.Sub64(x35, 0xfffffffffffffffe, uint64(uint1(x42)))
	var x45 uint64
	var x46 uint64
	x45, x46 = bits.Sub64(x37, 0xffffffffffffffff, uint64(uint1(x44)))
	var x48 uint64
	_, x48 = bits.Sub64(uint64(uint1(x38)), uint64(0x0), uint64(uint1(x46)))
	x49 := arg4[3]
	x50 := arg4[2]
	x51 := arg4[1]
	x52 := arg4[0]
	var x53 uint64
	var x54 uint64
	x53, x54 = bits.Sub64(uint64(0x0), x52, uint64(0x0))
	var x55 uint64
	var x56 uint64
	x55, x56 = bits.Sub64(uint64(0x0), x51, uint64(uint1(x54)))
	var x57 uint64
	var x58 uint64
	x57, x58 = bits.Sub64(uint64(0x0), x50, uint64(uint1(x56)))
	var x59 uint64
	var x60 uint64
	x59, x60 = bits.Sub64(uint64(0x0), x49, uint64(uint1(x58)))
	var x61 uint64
	cmovznzU64(&x61, uint1(x60), uint64(0x0), 0xffffffffffffffff)
	var x62 uint64
	var x63 uint64
	x62, x63 = bits.Add64(x53, (x61 & 0xbfd25e8cd0364141), uint64(0x0))
	var x64 uint64
	var x65 uint64
	x64, x65 = bits.Add64(x55, (x61 & 0xbaaedce6af48a03b), uint64(uint1(x63)))
	var x66 uint64
	var x67 uint64
	x66, x67 = bits.Add64(x57, (x61 & 0xfffffffffffffffe), uint64(uint1(x65)))
	var x68 uint64
	x68, _ = bits.Add64(x59, x61, uint64(uint1(x67)))
	var x70 uint64
	cmovznzU64(&x70, x3, arg5[0], x62)
	var x71 uint64
	cmovznzU64(&x71, x3, arg5[1], x64)
	var x72 uint64
	cmovznzU64(&x72, x3, arg5[2], x66)
	var x73 uint64
	cmovznzU64(&x73, x3, arg5[3], x68)
	x74 := (uint1(x22) & 0x1)
	var x75 uint64
	cmovznzU64(&x75, x74, uint64(0x0), x7)
	var x76 uint64
	cmovznzU64(&x76, x74, uint64(0x0), x8)
	var x77 uint64
	cmovznzU64(&x77, x74, uint64(0x0), x9)
	var x78 uint64
	cmovznzU64(&x78, x74, uint64(0x0), x10)
	var x79 uint64
	cmovznzU64(&x79, x74, uint64(0x0), x11)
	var x80 uint64
	var x81 uint64
	x80, x81 = bits.Add64(x22, x75, uint64(0x0))
	var x82 uint64
	var x83 uint64
	x82, x83 = bits.Add64(x23, x76, uint64(uint1(x81)))
	var x84 uint64
	var x85 uint64
	x84, x85 = bits.Add64(x24, x77, uint64(uint1(x83)))
	var x86 uint64
	var x87 uint64
	x86, x87 = bits.Add64(x25, x78, uint64(uint1(x85)))
	var x88 uint64
	x88, _ = bits.Add64(x26, x79, uint64(uint1(x87)))
	var x90 uint64
	cmovznzU64(&x90, x74, uint64(0x0), x27)
	var x91 uint64
	cmovznzU64(&x91, x74, uint64(0x0), x28)
	var x92 uint64
	cmovznzU64(&x92, x74, uint64(0x0), x29)
	var x93 uint64
	cmovznzU64(&x93, x74, uint64(0x0), x30)
	var x94 uint64
	var x95 uint64
	x94, x95 = bits.Add64(x70, x90, uint64(0x0))
	var x96 uint64
	var x97 uint64
	x96, x97 = bits.Add64(x71, x91, uint64(uint1(x95)))
	var x98 uint64
	var x99 uint64
	x98, x99 = bits.Add64(x72, x92, uint64(uint1(x97)))
	var x100 uint64
	var x101 uint64
	x100, x101 = bits.Add64(x73, x93, uint64(uint1(x99)))
	var x102 uint64
	var x103 uint64
	x102, x103 = bits.Sub64(x94, 0xbfd25e8cd0364141, uint64(0x0))
	var x104 uint64
	var x105 uint64
	x104, x105 = bits.Sub64(x96, 0xbaaedce6af48a03b, uint64(uint1(x103)))
	var x106 uint64
	var x107 uint64
	x106, x107 = bits.Sub64(x98, 0xfffffffffffffffe, uint64(uint1(x105)))
	var x108 uint64
	var x109 uint64
	x108, x109 = bits.Sub64(x100, 0xffffffffffffffff, uint64(uint1(x107)))
	var x111 uint64
	_, x111 = bits.Sub64(uint64(uint1(x101)), uint64(0x0), uint64(uint1(x109)))
	var x112 uint64
	x112, _ = bits.Add64(x6, uint64(0x1), uint64(0x0))
	x114 := ((x80 >> 1) | ((x82 << 63) & 0xffffffffffffffff))
	x115 := ((x82 >> 1) | ((x84 << 63) & 0xffffffffffffffff))
	x116 := ((x84 >> 1) | ((x86 << 63) & 0xffffffffffffffff))
	x117 := ((x86 >> 1) | ((x88 << 63) & 0xffffffffffffffff))
	x118 := ((x88 & 0x8000000000000000) | (x88 >> 1))
	var x119 uint64
	cmovznzU64(&x119, uint1(x48), x39, x31)
	var x120 uint64
	cmovznzU64(&x120, uint1(x48), x41, x33)
	var x121 uint64
	cmovznzU64(&x121, uint1(x48), x43, x35)
	var x122 uint64
	cmovznzU64(&x122, uint1(x48), x45, x37)
	var x123 uint64
	cmovznzU64(&x123, uint1(x111), x102, x94)
	var x124 uint64
	cmovznzU64(&x124, uint1(x111), x104, x96)
	var x125 uint64
	cmovznzU64(&x125, uint1(x111), x106, x98)
	var x126 uint64
	cmovznzU64(&x126, uint1(x111), x108, x100)
	*out1 = x112
	out2[0] = x7
	out2[1] = x8
	out2[2] = x9
	out2[3] = x10
	out2[4] = x11
	out3[0] = x114
	out3[1] = x115
	out3[2] = x116
	out3[3] = x117
	out3[4] = x118
	out4[0] = x119
	out4[1] = x120
	out4[2] = x121
	out4[3] = x122
	out5[0] = x123
	out5[1] = x124
	out5[2] = x125
	out5[3] = x126
}

// DivstepPrecomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form).
//
// Postconditions:
//
//	eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)
//	0 ≤ eval out1 < m
//
// Output Bounds:
//
//	out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]
func DivstepPrecomp(out1 *[4]uint64) {
	out1[0] = 0xd7431a4d2b9cb4e9
	out1[1] = 0xab67d35a32d9c503
	out1[2] = 0xadf6c7e5859ce35f
	out1[3] = 0x615441451df6c379
}
