package search

import (
	"github.com/Masterminds/semver"
	"github.com/vulncheck-oss/go-exploit/output"
)

// Compare a version to a semantic version constraint using the [Masterminds semver constraints](https://github.com/Masterminds/semver?tab=readme-ov-file#checking-version-constraints).
// Provide a version string and a constraint and if the semver is within the constraint a boolean
// response of whether the version is constrained or not will occur. Any errors from the constraint
// or version will propagate through the framework errors and the value will be false.
func CheckSemVer(version string, constraint string) bool {
	c, err := semver.NewConstraint(constraint)
	if err != nil {
		output.PrintfFrameworkError("Invalid constraint: %s", err.Error())

		return false
	}
	v, err := semver.NewVersion(version)
	if err != nil {
		output.PrintfFrameworkError("Invalid version: %s", err.Error())

		return false
	}

	return c.Check(v)
}
