// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListHostScanTargetErrorsRequest wrapper for the ListHostScanTargetErrors operation
//
// # See also
//
// Click https://docs.cloud.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostScanTargetErrors.go.html to see an example of how to use ListHostScanTargetErrorsRequest.
type ListHostScanTargetErrorsRequest struct {

	// The ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// unique HostScanTarget identifier
	HostScanTargetId *string `mandatory:"true" contributesTo:"path" name:"hostScanTargetId"`

	// A filter to return only resources whose lifecycleState matches the given lifecycleState.
	LifecycleState ListHostScanTargetErrorsLifecycleStateEnum `mandatory:"false" contributesTo:"query" name:"lifecycleState" omitEmpty:"true"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListHostScanTargetErrorsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order for timeUpdated is descending. If no value is specified timeUpdated is default.
	SortBy ListHostScanTargetErrorsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListHostScanTargetErrorsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListHostScanTargetErrorsRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListHostScanTargetErrorsRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListHostScanTargetErrorsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListHostScanTargetErrorsRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListHostScanTargetErrorsLifecycleStateEnum(string(request.LifecycleState)); !ok && request.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", request.LifecycleState, strings.Join(GetListHostScanTargetErrorsLifecycleStateEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostScanTargetErrorsSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListHostScanTargetErrorsSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostScanTargetErrorsSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListHostScanTargetErrorsSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListHostScanTargetErrorsResponse wrapper for the ListHostScanTargetErrors operation
type ListHostScanTargetErrorsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of HostScanTargetErrorSummaryCollection instances
	HostScanTargetErrorSummaryCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListHostScanTargetErrorsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListHostScanTargetErrorsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListHostScanTargetErrorsLifecycleStateEnum Enum with underlying type: string
type ListHostScanTargetErrorsLifecycleStateEnum string

// Set of constants representing the allowable values for ListHostScanTargetErrorsLifecycleStateEnum
const (
	ListHostScanTargetErrorsLifecycleStateCreating ListHostScanTargetErrorsLifecycleStateEnum = "CREATING"
	ListHostScanTargetErrorsLifecycleStateUpdating ListHostScanTargetErrorsLifecycleStateEnum = "UPDATING"
	ListHostScanTargetErrorsLifecycleStateActive   ListHostScanTargetErrorsLifecycleStateEnum = "ACTIVE"
	ListHostScanTargetErrorsLifecycleStateDeleting ListHostScanTargetErrorsLifecycleStateEnum = "DELETING"
	ListHostScanTargetErrorsLifecycleStateDeleted  ListHostScanTargetErrorsLifecycleStateEnum = "DELETED"
	ListHostScanTargetErrorsLifecycleStateFailed   ListHostScanTargetErrorsLifecycleStateEnum = "FAILED"
)

var mappingListHostScanTargetErrorsLifecycleStateEnum = map[string]ListHostScanTargetErrorsLifecycleStateEnum{
	"CREATING": ListHostScanTargetErrorsLifecycleStateCreating,
	"UPDATING": ListHostScanTargetErrorsLifecycleStateUpdating,
	"ACTIVE":   ListHostScanTargetErrorsLifecycleStateActive,
	"DELETING": ListHostScanTargetErrorsLifecycleStateDeleting,
	"DELETED":  ListHostScanTargetErrorsLifecycleStateDeleted,
	"FAILED":   ListHostScanTargetErrorsLifecycleStateFailed,
}

var mappingListHostScanTargetErrorsLifecycleStateEnumLowerCase = map[string]ListHostScanTargetErrorsLifecycleStateEnum{
	"creating": ListHostScanTargetErrorsLifecycleStateCreating,
	"updating": ListHostScanTargetErrorsLifecycleStateUpdating,
	"active":   ListHostScanTargetErrorsLifecycleStateActive,
	"deleting": ListHostScanTargetErrorsLifecycleStateDeleting,
	"deleted":  ListHostScanTargetErrorsLifecycleStateDeleted,
	"failed":   ListHostScanTargetErrorsLifecycleStateFailed,
}

// GetListHostScanTargetErrorsLifecycleStateEnumValues Enumerates the set of values for ListHostScanTargetErrorsLifecycleStateEnum
func GetListHostScanTargetErrorsLifecycleStateEnumValues() []ListHostScanTargetErrorsLifecycleStateEnum {
	values := make([]ListHostScanTargetErrorsLifecycleStateEnum, 0)
	for _, v := range mappingListHostScanTargetErrorsLifecycleStateEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostScanTargetErrorsLifecycleStateEnumStringValues Enumerates the set of values in String for ListHostScanTargetErrorsLifecycleStateEnum
func GetListHostScanTargetErrorsLifecycleStateEnumStringValues() []string {
	return []string{
		"CREATING",
		"UPDATING",
		"ACTIVE",
		"DELETING",
		"DELETED",
		"FAILED",
	}
}

// GetMappingListHostScanTargetErrorsLifecycleStateEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostScanTargetErrorsLifecycleStateEnum(val string) (ListHostScanTargetErrorsLifecycleStateEnum, bool) {
	enum, ok := mappingListHostScanTargetErrorsLifecycleStateEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostScanTargetErrorsSortOrderEnum Enum with underlying type: string
type ListHostScanTargetErrorsSortOrderEnum string

// Set of constants representing the allowable values for ListHostScanTargetErrorsSortOrderEnum
const (
	ListHostScanTargetErrorsSortOrderAsc  ListHostScanTargetErrorsSortOrderEnum = "ASC"
	ListHostScanTargetErrorsSortOrderDesc ListHostScanTargetErrorsSortOrderEnum = "DESC"
)

var mappingListHostScanTargetErrorsSortOrderEnum = map[string]ListHostScanTargetErrorsSortOrderEnum{
	"ASC":  ListHostScanTargetErrorsSortOrderAsc,
	"DESC": ListHostScanTargetErrorsSortOrderDesc,
}

var mappingListHostScanTargetErrorsSortOrderEnumLowerCase = map[string]ListHostScanTargetErrorsSortOrderEnum{
	"asc":  ListHostScanTargetErrorsSortOrderAsc,
	"desc": ListHostScanTargetErrorsSortOrderDesc,
}

// GetListHostScanTargetErrorsSortOrderEnumValues Enumerates the set of values for ListHostScanTargetErrorsSortOrderEnum
func GetListHostScanTargetErrorsSortOrderEnumValues() []ListHostScanTargetErrorsSortOrderEnum {
	values := make([]ListHostScanTargetErrorsSortOrderEnum, 0)
	for _, v := range mappingListHostScanTargetErrorsSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostScanTargetErrorsSortOrderEnumStringValues Enumerates the set of values in String for ListHostScanTargetErrorsSortOrderEnum
func GetListHostScanTargetErrorsSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListHostScanTargetErrorsSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostScanTargetErrorsSortOrderEnum(val string) (ListHostScanTargetErrorsSortOrderEnum, bool) {
	enum, ok := mappingListHostScanTargetErrorsSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostScanTargetErrorsSortByEnum Enum with underlying type: string
type ListHostScanTargetErrorsSortByEnum string

// Set of constants representing the allowable values for ListHostScanTargetErrorsSortByEnum
const (
	ListHostScanTargetErrorsSortByTimeupdated ListHostScanTargetErrorsSortByEnum = "timeUpdated"
)

var mappingListHostScanTargetErrorsSortByEnum = map[string]ListHostScanTargetErrorsSortByEnum{
	"timeUpdated": ListHostScanTargetErrorsSortByTimeupdated,
}

var mappingListHostScanTargetErrorsSortByEnumLowerCase = map[string]ListHostScanTargetErrorsSortByEnum{
	"timeupdated": ListHostScanTargetErrorsSortByTimeupdated,
}

// GetListHostScanTargetErrorsSortByEnumValues Enumerates the set of values for ListHostScanTargetErrorsSortByEnum
func GetListHostScanTargetErrorsSortByEnumValues() []ListHostScanTargetErrorsSortByEnum {
	values := make([]ListHostScanTargetErrorsSortByEnum, 0)
	for _, v := range mappingListHostScanTargetErrorsSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostScanTargetErrorsSortByEnumStringValues Enumerates the set of values in String for ListHostScanTargetErrorsSortByEnum
func GetListHostScanTargetErrorsSortByEnumStringValues() []string {
	return []string{
		"timeUpdated",
	}
}

// GetMappingListHostScanTargetErrorsSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostScanTargetErrorsSortByEnum(val string) (ListHostScanTargetErrorsSortByEnum, bool) {
	enum, ok := mappingListHostScanTargetErrorsSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
