// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListHostAgentScanResultsRequest wrapper for the ListHostAgentScanResults operation
//
// # See also
//
// Click https://docs.cloud.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostAgentScanResults.go.html to see an example of how to use ListHostAgentScanResultsRequest.
type ListHostAgentScanResultsRequest struct {

	// The ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// The ID of a compute instance
	InstanceId *string `mandatory:"false" contributesTo:"query" name:"instanceId"`

	// Parameter to filter by highestProblemSeverity for scan results
	HighestProblemSeverity ListHostAgentScanResultsHighestProblemSeverityEnum `mandatory:"false" contributesTo:"query" name:"highestProblemSeverity" omitEmpty:"true"`

	// Parameter to filter by operating system for scan results
	OperatingSystem *string `mandatory:"false" contributesTo:"query" name:"operatingSystem"`

	// Date and time on or after which scans were started, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeStartedGreaterThanOrEqualTo *common.SDKTime `mandatory:"false" contributesTo:"query" name:"timeStartedGreaterThanOrEqualTo"`

	// Date and time on or before which scans were started, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeStartedLessThanOrEqualTo *common.SDKTime `mandatory:"false" contributesTo:"query" name:"timeStartedLessThanOrEqualTo"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListHostAgentScanResultsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order is descending. If no value is specified timeStarted is default.
	SortBy ListHostAgentScanResultsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// A filter to return only resources that match the entire display name given.
	DisplayName *string `mandatory:"false" contributesTo:"query" name:"displayName"`

	// A flag to return only the latest scan result of an instance.
	IsLatestOnly *bool `mandatory:"false" contributesTo:"query" name:"isLatestOnly"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListHostAgentScanResultsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListHostAgentScanResultsRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListHostAgentScanResultsRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListHostAgentScanResultsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListHostAgentScanResultsRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListHostAgentScanResultsHighestProblemSeverityEnum(string(request.HighestProblemSeverity)); !ok && request.HighestProblemSeverity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for HighestProblemSeverity: %s. Supported values are: %s.", request.HighestProblemSeverity, strings.Join(GetListHostAgentScanResultsHighestProblemSeverityEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostAgentScanResultsSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListHostAgentScanResultsSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostAgentScanResultsSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListHostAgentScanResultsSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListHostAgentScanResultsResponse wrapper for the ListHostAgentScanResults operation
type ListHostAgentScanResultsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of HostAgentScanResultSummaryCollection instances
	HostAgentScanResultSummaryCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListHostAgentScanResultsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListHostAgentScanResultsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListHostAgentScanResultsHighestProblemSeverityEnum Enum with underlying type: string
type ListHostAgentScanResultsHighestProblemSeverityEnum string

// Set of constants representing the allowable values for ListHostAgentScanResultsHighestProblemSeverityEnum
const (
	ListHostAgentScanResultsHighestProblemSeverityNone     ListHostAgentScanResultsHighestProblemSeverityEnum = "NONE"
	ListHostAgentScanResultsHighestProblemSeverityLow      ListHostAgentScanResultsHighestProblemSeverityEnum = "LOW"
	ListHostAgentScanResultsHighestProblemSeverityMedium   ListHostAgentScanResultsHighestProblemSeverityEnum = "MEDIUM"
	ListHostAgentScanResultsHighestProblemSeverityHigh     ListHostAgentScanResultsHighestProblemSeverityEnum = "HIGH"
	ListHostAgentScanResultsHighestProblemSeverityCritical ListHostAgentScanResultsHighestProblemSeverityEnum = "CRITICAL"
)

var mappingListHostAgentScanResultsHighestProblemSeverityEnum = map[string]ListHostAgentScanResultsHighestProblemSeverityEnum{
	"NONE":     ListHostAgentScanResultsHighestProblemSeverityNone,
	"LOW":      ListHostAgentScanResultsHighestProblemSeverityLow,
	"MEDIUM":   ListHostAgentScanResultsHighestProblemSeverityMedium,
	"HIGH":     ListHostAgentScanResultsHighestProblemSeverityHigh,
	"CRITICAL": ListHostAgentScanResultsHighestProblemSeverityCritical,
}

var mappingListHostAgentScanResultsHighestProblemSeverityEnumLowerCase = map[string]ListHostAgentScanResultsHighestProblemSeverityEnum{
	"none":     ListHostAgentScanResultsHighestProblemSeverityNone,
	"low":      ListHostAgentScanResultsHighestProblemSeverityLow,
	"medium":   ListHostAgentScanResultsHighestProblemSeverityMedium,
	"high":     ListHostAgentScanResultsHighestProblemSeverityHigh,
	"critical": ListHostAgentScanResultsHighestProblemSeverityCritical,
}

// GetListHostAgentScanResultsHighestProblemSeverityEnumValues Enumerates the set of values for ListHostAgentScanResultsHighestProblemSeverityEnum
func GetListHostAgentScanResultsHighestProblemSeverityEnumValues() []ListHostAgentScanResultsHighestProblemSeverityEnum {
	values := make([]ListHostAgentScanResultsHighestProblemSeverityEnum, 0)
	for _, v := range mappingListHostAgentScanResultsHighestProblemSeverityEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostAgentScanResultsHighestProblemSeverityEnumStringValues Enumerates the set of values in String for ListHostAgentScanResultsHighestProblemSeverityEnum
func GetListHostAgentScanResultsHighestProblemSeverityEnumStringValues() []string {
	return []string{
		"NONE",
		"LOW",
		"MEDIUM",
		"HIGH",
		"CRITICAL",
	}
}

// GetMappingListHostAgentScanResultsHighestProblemSeverityEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostAgentScanResultsHighestProblemSeverityEnum(val string) (ListHostAgentScanResultsHighestProblemSeverityEnum, bool) {
	enum, ok := mappingListHostAgentScanResultsHighestProblemSeverityEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostAgentScanResultsSortOrderEnum Enum with underlying type: string
type ListHostAgentScanResultsSortOrderEnum string

// Set of constants representing the allowable values for ListHostAgentScanResultsSortOrderEnum
const (
	ListHostAgentScanResultsSortOrderAsc  ListHostAgentScanResultsSortOrderEnum = "ASC"
	ListHostAgentScanResultsSortOrderDesc ListHostAgentScanResultsSortOrderEnum = "DESC"
)

var mappingListHostAgentScanResultsSortOrderEnum = map[string]ListHostAgentScanResultsSortOrderEnum{
	"ASC":  ListHostAgentScanResultsSortOrderAsc,
	"DESC": ListHostAgentScanResultsSortOrderDesc,
}

var mappingListHostAgentScanResultsSortOrderEnumLowerCase = map[string]ListHostAgentScanResultsSortOrderEnum{
	"asc":  ListHostAgentScanResultsSortOrderAsc,
	"desc": ListHostAgentScanResultsSortOrderDesc,
}

// GetListHostAgentScanResultsSortOrderEnumValues Enumerates the set of values for ListHostAgentScanResultsSortOrderEnum
func GetListHostAgentScanResultsSortOrderEnumValues() []ListHostAgentScanResultsSortOrderEnum {
	values := make([]ListHostAgentScanResultsSortOrderEnum, 0)
	for _, v := range mappingListHostAgentScanResultsSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostAgentScanResultsSortOrderEnumStringValues Enumerates the set of values in String for ListHostAgentScanResultsSortOrderEnum
func GetListHostAgentScanResultsSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListHostAgentScanResultsSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostAgentScanResultsSortOrderEnum(val string) (ListHostAgentScanResultsSortOrderEnum, bool) {
	enum, ok := mappingListHostAgentScanResultsSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostAgentScanResultsSortByEnum Enum with underlying type: string
type ListHostAgentScanResultsSortByEnum string

// Set of constants representing the allowable values for ListHostAgentScanResultsSortByEnum
const (
	ListHostAgentScanResultsSortByTimestarted            ListHostAgentScanResultsSortByEnum = "timeStarted"
	ListHostAgentScanResultsSortByTimefinished           ListHostAgentScanResultsSortByEnum = "timeFinished"
	ListHostAgentScanResultsSortByProblemcount           ListHostAgentScanResultsSortByEnum = "problemCount"
	ListHostAgentScanResultsSortByHighestproblemseverity ListHostAgentScanResultsSortByEnum = "highestProblemSeverity"
	ListHostAgentScanResultsSortByTimecompleted          ListHostAgentScanResultsSortByEnum = "timeCompleted"
)

var mappingListHostAgentScanResultsSortByEnum = map[string]ListHostAgentScanResultsSortByEnum{
	"timeStarted":            ListHostAgentScanResultsSortByTimestarted,
	"timeFinished":           ListHostAgentScanResultsSortByTimefinished,
	"problemCount":           ListHostAgentScanResultsSortByProblemcount,
	"highestProblemSeverity": ListHostAgentScanResultsSortByHighestproblemseverity,
	"timeCompleted":          ListHostAgentScanResultsSortByTimecompleted,
}

var mappingListHostAgentScanResultsSortByEnumLowerCase = map[string]ListHostAgentScanResultsSortByEnum{
	"timestarted":            ListHostAgentScanResultsSortByTimestarted,
	"timefinished":           ListHostAgentScanResultsSortByTimefinished,
	"problemcount":           ListHostAgentScanResultsSortByProblemcount,
	"highestproblemseverity": ListHostAgentScanResultsSortByHighestproblemseverity,
	"timecompleted":          ListHostAgentScanResultsSortByTimecompleted,
}

// GetListHostAgentScanResultsSortByEnumValues Enumerates the set of values for ListHostAgentScanResultsSortByEnum
func GetListHostAgentScanResultsSortByEnumValues() []ListHostAgentScanResultsSortByEnum {
	values := make([]ListHostAgentScanResultsSortByEnum, 0)
	for _, v := range mappingListHostAgentScanResultsSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostAgentScanResultsSortByEnumStringValues Enumerates the set of values in String for ListHostAgentScanResultsSortByEnum
func GetListHostAgentScanResultsSortByEnumStringValues() []string {
	return []string{
		"timeStarted",
		"timeFinished",
		"problemCount",
		"highestProblemSeverity",
		"timeCompleted",
	}
}

// GetMappingListHostAgentScanResultsSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostAgentScanResultsSortByEnum(val string) (ListHostAgentScanResultsSortByEnum, bool) {
	enum, ok := mappingListHostAgentScanResultsSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
