// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.cloud.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// HostCisBenchmarkScanLevelEnum Enum with underlying type: string
type HostCisBenchmarkScanLevelEnum string

// Set of constants representing the allowable values for HostCisBenchmarkScanLevelEnum
const (
	HostCisBenchmarkScanLevelNone   HostCisBenchmarkScanLevelEnum = "NONE"
	HostCisBenchmarkScanLevelLight  HostCisBenchmarkScanLevelEnum = "LIGHT"
	HostCisBenchmarkScanLevelMedium HostCisBenchmarkScanLevelEnum = "MEDIUM"
	HostCisBenchmarkScanLevelStrict HostCisBenchmarkScanLevelEnum = "STRICT"
)

var mappingHostCisBenchmarkScanLevelEnum = map[string]HostCisBenchmarkScanLevelEnum{
	"NONE":   HostCisBenchmarkScanLevelNone,
	"LIGHT":  HostCisBenchmarkScanLevelLight,
	"MEDIUM": HostCisBenchmarkScanLevelMedium,
	"STRICT": HostCisBenchmarkScanLevelStrict,
}

var mappingHostCisBenchmarkScanLevelEnumLowerCase = map[string]HostCisBenchmarkScanLevelEnum{
	"none":   HostCisBenchmarkScanLevelNone,
	"light":  HostCisBenchmarkScanLevelLight,
	"medium": HostCisBenchmarkScanLevelMedium,
	"strict": HostCisBenchmarkScanLevelStrict,
}

// GetHostCisBenchmarkScanLevelEnumValues Enumerates the set of values for HostCisBenchmarkScanLevelEnum
func GetHostCisBenchmarkScanLevelEnumValues() []HostCisBenchmarkScanLevelEnum {
	values := make([]HostCisBenchmarkScanLevelEnum, 0)
	for _, v := range mappingHostCisBenchmarkScanLevelEnum {
		values = append(values, v)
	}
	return values
}

// GetHostCisBenchmarkScanLevelEnumStringValues Enumerates the set of values in String for HostCisBenchmarkScanLevelEnum
func GetHostCisBenchmarkScanLevelEnumStringValues() []string {
	return []string{
		"NONE",
		"LIGHT",
		"MEDIUM",
		"STRICT",
	}
}

// GetMappingHostCisBenchmarkScanLevelEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingHostCisBenchmarkScanLevelEnum(val string) (HostCisBenchmarkScanLevelEnum, bool) {
	enum, ok := mappingHostCisBenchmarkScanLevelEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
