// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package marketplacepublisher

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListAttachmentsRequest wrapper for the ListAttachments operation
//
// # See also
//
// Click https://docs.cloud.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/marketplacepublisher/ListAttachments.go.html to see an example of how to use ListAttachmentsRequest.
type ListAttachmentsRequest struct {

	// unique Offer identifier
	OfferId *string `mandatory:"true" contributesTo:"path" name:"offerId"`

	// The ID of the buyer compartment this offer is associated with.
	BuyerCompartmentId *string `mandatory:"false" contributesTo:"query" name:"buyerCompartmentId"`

	// The ID of the seller compartment this offer is associated with.
	SellerCompartmentId *string `mandatory:"false" contributesTo:"query" name:"sellerCompartmentId"`

	// A filter to return only resources their lifecycleState matches the given lifecycleState.
	LifecycleState AttachmentLifecycleStateEnum `mandatory:"false" contributesTo:"query" name:"lifecycleState" omitEmpty:"true"`

	// A filter to return only resources that match the entire display name given.
	DisplayName *string `mandatory:"false" contributesTo:"query" name:"displayName"`

	// unique Offer identifier
	Id *string `mandatory:"false" contributesTo:"query" name:"id"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// A token representing the position at which to start retrieving results. This must come from the `opc-next-page` header field of a previous response.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListAttachmentsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order for timeCreated is descending. Default order for displayName is ascending.
	SortBy ListAttachmentsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListAttachmentsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListAttachmentsRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListAttachmentsRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListAttachmentsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListAttachmentsRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingAttachmentLifecycleStateEnum(string(request.LifecycleState)); !ok && request.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", request.LifecycleState, strings.Join(GetAttachmentLifecycleStateEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListAttachmentsSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListAttachmentsSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListAttachmentsSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListAttachmentsSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListAttachmentsResponse wrapper for the ListAttachments operation
type ListAttachmentsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of AttachmentCollection instances
	AttachmentCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListAttachmentsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListAttachmentsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListAttachmentsSortOrderEnum Enum with underlying type: string
type ListAttachmentsSortOrderEnum string

// Set of constants representing the allowable values for ListAttachmentsSortOrderEnum
const (
	ListAttachmentsSortOrderAsc  ListAttachmentsSortOrderEnum = "ASC"
	ListAttachmentsSortOrderDesc ListAttachmentsSortOrderEnum = "DESC"
)

var mappingListAttachmentsSortOrderEnum = map[string]ListAttachmentsSortOrderEnum{
	"ASC":  ListAttachmentsSortOrderAsc,
	"DESC": ListAttachmentsSortOrderDesc,
}

var mappingListAttachmentsSortOrderEnumLowerCase = map[string]ListAttachmentsSortOrderEnum{
	"asc":  ListAttachmentsSortOrderAsc,
	"desc": ListAttachmentsSortOrderDesc,
}

// GetListAttachmentsSortOrderEnumValues Enumerates the set of values for ListAttachmentsSortOrderEnum
func GetListAttachmentsSortOrderEnumValues() []ListAttachmentsSortOrderEnum {
	values := make([]ListAttachmentsSortOrderEnum, 0)
	for _, v := range mappingListAttachmentsSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListAttachmentsSortOrderEnumStringValues Enumerates the set of values in String for ListAttachmentsSortOrderEnum
func GetListAttachmentsSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListAttachmentsSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListAttachmentsSortOrderEnum(val string) (ListAttachmentsSortOrderEnum, bool) {
	enum, ok := mappingListAttachmentsSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListAttachmentsSortByEnum Enum with underlying type: string
type ListAttachmentsSortByEnum string

// Set of constants representing the allowable values for ListAttachmentsSortByEnum
const (
	ListAttachmentsSortByTimecreated ListAttachmentsSortByEnum = "timeCreated"
	ListAttachmentsSortByDisplayname ListAttachmentsSortByEnum = "displayName"
)

var mappingListAttachmentsSortByEnum = map[string]ListAttachmentsSortByEnum{
	"timeCreated": ListAttachmentsSortByTimecreated,
	"displayName": ListAttachmentsSortByDisplayname,
}

var mappingListAttachmentsSortByEnumLowerCase = map[string]ListAttachmentsSortByEnum{
	"timecreated": ListAttachmentsSortByTimecreated,
	"displayname": ListAttachmentsSortByDisplayname,
}

// GetListAttachmentsSortByEnumValues Enumerates the set of values for ListAttachmentsSortByEnum
func GetListAttachmentsSortByEnumValues() []ListAttachmentsSortByEnum {
	values := make([]ListAttachmentsSortByEnum, 0)
	for _, v := range mappingListAttachmentsSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListAttachmentsSortByEnumStringValues Enumerates the set of values in String for ListAttachmentsSortByEnum
func GetListAttachmentsSortByEnumStringValues() []string {
	return []string{
		"timeCreated",
		"displayName",
	}
}

// GetMappingListAttachmentsSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListAttachmentsSortByEnum(val string) (ListAttachmentsSortByEnum, bool) {
	enum, ok := mappingListAttachmentsSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
