// Copyright (c) 2016, 2018, 2021, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Data Catalog API
//
// Use the Data Catalog APIs to collect, organize, find, access, understand, enrich, and activate technical, business, and operational metadata.
//

package datacatalog

import (
	"github.com/oracle/oci-go-sdk/v32/common"
)

// FacetedSearchDateFilterRequest Object with date filter criteria
type FacetedSearchDateFilterRequest struct {

	// Date field name that needs to be filtered by.
	FieldName *string `mandatory:"false" json:"fieldName"`

	// The date and time the request was created, as described in
	// RFC 3339 (https://tools.ietf.org/rfc/rfc3339), section 14.29.
	TimeAfter *common.SDKTime `mandatory:"false" json:"timeAfter"`

	// The date and time the request was created, as described in
	// RFC 3339 (https://tools.ietf.org/rfc/rfc3339), section 14.29.
	TimeBefore *common.SDKTime `mandatory:"false" json:"timeBefore"`
}

func (m FacetedSearchDateFilterRequest) String() string {
	return common.PointerString(m)
}
