// Copyright (c) 2016, 2018, 2021, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// API Gateway API
//
// API for the API Gateway service. Use this API to manage gateways, deployments, and related items.
// For more information, see
// Overview of API Gateway (https://docs.cloud.oracle.com/iaas/Content/APIGateway/Concepts/apigatewayoverview.htm).
//

package apigateway

import (
	"encoding/json"
	"github.com/oracle/oci-go-sdk/v32/common"
)

// StockResponseBackend Send the request to a mock backend.
type StockResponseBackend struct {

	// The status code of the stock response from the mock backend.
	Status *int `mandatory:"true" json:"status"`

	// The body of the stock response from the mock backend.
	Body *string `mandatory:"false" json:"body"`

	// The headers of the stock response from the mock backend.
	Headers []HeaderFieldSpecification `mandatory:"false" json:"headers"`
}

func (m StockResponseBackend) String() string {
	return common.PointerString(m)
}

// MarshalJSON marshals to json representation
func (m StockResponseBackend) MarshalJSON() (buff []byte, e error) {
	type MarshalTypeStockResponseBackend StockResponseBackend
	s := struct {
		DiscriminatorParam string `json:"type"`
		MarshalTypeStockResponseBackend
	}{
		"STOCK_RESPONSE_BACKEND",
		(MarshalTypeStockResponseBackend)(m),
	}

	return json.Marshal(&s)
}
