packer {
  required_version = ">1.7.0"

  required_plugins {
    docker = {
      source = "github.com/hashicorp/docker"
      version = ">=0.0.7"
    }
  }
}

source "docker" "autogenerated_1" {
  discard = true
  image   = "williamyeh/ansible:centos7"
}

build {
  sources = ["source.docker.autogenerated_1"]

  provisioner "ansible-local" {
    playbook_dir   = "test-fixtures"
    playbook_files = ["test-fixtures/hello.yml", "test-fixtures/world.yml"]
  }

  provisioner "file" {
    destination = "hello_world"
    direction   = "download"
    source      = "/tmp/hello_world"
  }

}
