// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// LinkedClusterNodeVersionStatus  - VERSION_UP_TO_DATE: VERSION_UP_TO_DATE is used when node is running the latest Vault Version.
//   - UPGRADE_AVAILABLE: UPGRADE_AVAILABLE is used when node is running the latest minor release of a Vault Version, but there is a new major Vault version available for upgrade.
//   - UPGRADE_RECOMMENDED: UPGRADE_RECOMMENDED is used when node is running an outdated but still supported version, but there is a new minor or major Vault versions available for upgrade.
//   - UPGRADE_REQUIRED: UPGRADE_REQUIRED is used when node is running a no longer supported version and there are minor and major versions available for upgrade.
//
// swagger:model LinkedClusterNodeVersionStatus
type LinkedClusterNodeVersionStatus string

func NewLinkedClusterNodeVersionStatus(value LinkedClusterNodeVersionStatus) *LinkedClusterNodeVersionStatus {
	return &value
}

// Pointer returns a pointer to a freshly-allocated LinkedClusterNodeVersionStatus.
func (m LinkedClusterNodeVersionStatus) Pointer() *LinkedClusterNodeVersionStatus {
	return &m
}

const (

	// LinkedClusterNodeVersionStatusLINKEDCLUSTERNODEVERSIONSTATUSINVALID captures enum value "LINKED_CLUSTER_NODE_VERSION_STATUS_INVALID"
	LinkedClusterNodeVersionStatusLINKEDCLUSTERNODEVERSIONSTATUSINVALID LinkedClusterNodeVersionStatus = "LINKED_CLUSTER_NODE_VERSION_STATUS_INVALID"

	// LinkedClusterNodeVersionStatusVERSIONUPTODATE captures enum value "VERSION_UP_TO_DATE"
	LinkedClusterNodeVersionStatusVERSIONUPTODATE LinkedClusterNodeVersionStatus = "VERSION_UP_TO_DATE"

	// LinkedClusterNodeVersionStatusUPGRADEAVAILABLE captures enum value "UPGRADE_AVAILABLE"
	LinkedClusterNodeVersionStatusUPGRADEAVAILABLE LinkedClusterNodeVersionStatus = "UPGRADE_AVAILABLE"

	// LinkedClusterNodeVersionStatusUPGRADERECOMMENDED captures enum value "UPGRADE_RECOMMENDED"
	LinkedClusterNodeVersionStatusUPGRADERECOMMENDED LinkedClusterNodeVersionStatus = "UPGRADE_RECOMMENDED"

	// LinkedClusterNodeVersionStatusUPGRADEREQUIRED captures enum value "UPGRADE_REQUIRED"
	LinkedClusterNodeVersionStatusUPGRADEREQUIRED LinkedClusterNodeVersionStatus = "UPGRADE_REQUIRED"
)

// for schema
var linkedClusterNodeVersionStatusEnum []interface{}

func init() {
	var res []LinkedClusterNodeVersionStatus
	if err := json.Unmarshal([]byte(`["LINKED_CLUSTER_NODE_VERSION_STATUS_INVALID","VERSION_UP_TO_DATE","UPGRADE_AVAILABLE","UPGRADE_RECOMMENDED","UPGRADE_REQUIRED"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		linkedClusterNodeVersionStatusEnum = append(linkedClusterNodeVersionStatusEnum, v)
	}
}

func (m LinkedClusterNodeVersionStatus) validateLinkedClusterNodeVersionStatusEnum(path, location string, value LinkedClusterNodeVersionStatus) error {
	if err := validate.EnumCase(path, location, value, linkedClusterNodeVersionStatusEnum, true); err != nil {
		return err
	}
	return nil
}

// Validate validates this linked cluster node version status
func (m LinkedClusterNodeVersionStatus) Validate(formats strfmt.Registry) error {
	var res []error

	// value enum
	if err := m.validateLinkedClusterNodeVersionStatusEnum("", "body", m); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validates this linked cluster node version status based on context it is used
func (m LinkedClusterNodeVersionStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}
