xk6-dashboard `v0.7.3` is here 🎉! This release includes:

- Breaking Changes
- Bug Fixes
- Enablers

## Breaking Changes

As of v0.49.0, k6 includes xk6-dashboard as a built-in output extension. The name of the built-in module is the same as was the output name (`web-dashboard`) registered by the extension. Therefore, if you try to use it as an extension (for example, a newer version), you will get the following error:

```
$ ./k6 run -o web-dashboard script.js
.
.
.
ERRO[0000] invalid output extension web-dashboard, built-in output with the same type already exists
```

From now on, the registered name of the extension is again the previously used `dashboard`. Thus, it is possible (for example, built with xk6) to use a version of the xk6-dashboard that is newer than the one integrated in k6. In this case, the `dashboard` name must be used as the output name.

```
$ ./k6 run -o dashboard script.js
```

**Related issue**

 - [xk6-dashboard no longer works as an extension](https://github.com/grafana/xk6-dashboard/issues/162)

## Bug Fixes

 - [xk6-dashboard no longer works as an extension](https://github.com/grafana/xk6-dashboard/issues/162)
 - [Report charts remain empty with short test](https://github.com/grafana/xk6-dashboard/issues/159)
 - [Increase tooltip text size](https://github.com/grafana/xk6-dashboard/issues/148)
 - [Selected timeframe resets on next data refresh](https://github.com/grafana/xk6-dashboard/issues/153)


## Enablers

The following enhancements enable various future dashboard UI feature developments.

### SSE Stream Optimization

Previously on the SSE stream, the `snapshot` and `cumulative` events are sent as JSON objects, where the metric names are the property names. The property values are also JSON objects, in which the property names are the names of the aggregation function (`avg`, `min`, `max`, etc.). This two-level object hierarchy has not caused any problems so far, the amount of data has been acceptable.

Until now, aggregate counting per tag is still supported, but by default it is only allowed for the `group` tag. It would be necessary to turn on the aggregate calculation for the `url` and `name` tags as well (per URL graphs, summary, etc.). With the previous SSE stream format, this would significantly increase the amount of data. This would have a direct impact on the k6 memory requirement, so it is a problem.

Based on measurements, it can be concluded that using a two-level array structure instead of the two-level object structure used in `snapshot` and `cumulative` events significantly reduces the size of the events and thus also the memory requirement.

Therefore, instead of the two-level object structure, a two-level array structure implemented in the `snapshot` and `cumulative` events. The `packages/model` package also updated so it hides SSE stream changes from the rest of the dashboard UI.

**Related issues**

  - [Adding a URL table panel to the timings tab](https://github.com/grafana/xk6-dashboard/issues/98)
  - [Dashboards representing individual transactions' metrics rather than TOTALs](https://github.com/grafana/xk6-dashboard/issues/160)

### Thresholds Evaluation

The display of threshold values on the dashboard UI is greatly simplified if the SSE stream includes threshold expression evaluation results. If the evaluation of a threshold expression belonging to a metric fails, it is included in the new `threshold` event.

**Related issue**

- [Displaying thresholds](https://github.com/grafana/xk6-dashboard/issues/58)

### Custom Metrics

In the various metrics tables, it is advisable to display the custom metrics before the built-in metrics, because the reader is likely to be more interested. This requires marking individual metrics on the event stream. The `true` value of the `custom` property indicates the custom metric.

### Test Script Name

It is advisable to display the name of the currently running test script on the dashboard. Therefore, the  `scriptPath` (script name) parameter has been added to the `param` event.
