// Code generated by go-swagger; DO NOT EDIT.

package folders

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// New creates a new folders API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for folders API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	CreateFolder(body *models.CreateFolderCommand, opts ...ClientOption) (*CreateFolderOK, error)
	CreateFolderWithParams(params *CreateFolderParams, opts ...ClientOption) (*CreateFolderOK, error)

	DeleteFolder(params *DeleteFolderParams, opts ...ClientOption) (*DeleteFolderOK, error)

	GetFolderByID(folderID int64, opts ...ClientOption) (*GetFolderByIDOK, error)
	GetFolderByIDWithParams(params *GetFolderByIDParams, opts ...ClientOption) (*GetFolderByIDOK, error)

	GetFolderByUID(folderUID string, opts ...ClientOption) (*GetFolderByUIDOK, error)
	GetFolderByUIDWithParams(params *GetFolderByUIDParams, opts ...ClientOption) (*GetFolderByUIDOK, error)

	GetFolderDescendantCounts(folderUID string, opts ...ClientOption) (*GetFolderDescendantCountsOK, error)
	GetFolderDescendantCountsWithParams(params *GetFolderDescendantCountsParams, opts ...ClientOption) (*GetFolderDescendantCountsOK, error)

	GetFolders(params *GetFoldersParams, opts ...ClientOption) (*GetFoldersOK, error)

	MoveFolder(folderUID string, body *models.MoveFolderCommand, opts ...ClientOption) (*MoveFolderOK, error)
	MoveFolderWithParams(params *MoveFolderParams, opts ...ClientOption) (*MoveFolderOK, error)

	UpdateFolder(folderUID string, body *models.UpdateFolderCommand, opts ...ClientOption) (*UpdateFolderOK, error)
	UpdateFolderWithParams(params *UpdateFolderParams, opts ...ClientOption) (*UpdateFolderOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
CreateFolder creates folder

If nested folders are enabled then it additionally expects the parent folder UID.
*/
func (a *Client) CreateFolder(body *models.CreateFolderCommand, opts ...ClientOption) (*CreateFolderOK, error) {
	params := NewCreateFolderParams().WithBody(body)
	return a.CreateFolderWithParams(params, opts...)
}

func (a *Client) CreateFolderWithParams(params *CreateFolderParams, opts ...ClientOption) (*CreateFolderOK, error) {
	if params == nil {
		params = NewCreateFolderParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "createFolder",
		Method:             "POST",
		PathPattern:        "/folders",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &CreateFolderReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateFolderOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for createFolder: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
DeleteFolder deletes folder

Deletes an existing folder identified by UID along with all dashboards (and their alerts) stored in the folder. This operation cannot be reverted.
If nested folders are enabled then it also deletes all the subfolders.
*/

func (a *Client) DeleteFolder(params *DeleteFolderParams, opts ...ClientOption) (*DeleteFolderOK, error) {
	if params == nil {
		params = NewDeleteFolderParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "deleteFolder",
		Method:             "DELETE",
		PathPattern:        "/folders/{folder_uid}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &DeleteFolderReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteFolderOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for deleteFolder: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetFolderByID gets folder by id

Returns the folder identified by id. This is deprecated.
Please refer to [updated API](#/folders/getFolderByUID) instead
*/
func (a *Client) GetFolderByID(folderID int64, opts ...ClientOption) (*GetFolderByIDOK, error) {
	params := NewGetFolderByIDParams().WithFolderID(folderID)
	return a.GetFolderByIDWithParams(params, opts...)
}

func (a *Client) GetFolderByIDWithParams(params *GetFolderByIDParams, opts ...ClientOption) (*GetFolderByIDOK, error) {
	if params == nil {
		params = NewGetFolderByIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getFolderByID",
		Method:             "GET",
		PathPattern:        "/folders/id/{folder_id}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetFolderByIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetFolderByIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getFolderByID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetFolderByUID gets folder by uid
*/
func (a *Client) GetFolderByUID(folderUID string, opts ...ClientOption) (*GetFolderByUIDOK, error) {
	params := NewGetFolderByUIDParams().WithFolderUID(folderUID)
	return a.GetFolderByUIDWithParams(params, opts...)
}

func (a *Client) GetFolderByUIDWithParams(params *GetFolderByUIDParams, opts ...ClientOption) (*GetFolderByUIDOK, error) {
	if params == nil {
		params = NewGetFolderByUIDParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getFolderByUID",
		Method:             "GET",
		PathPattern:        "/folders/{folder_uid}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetFolderByUIDReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetFolderByUIDOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getFolderByUID: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetFolderDescendantCounts gets the count of each descendant of a folder by kind the folder is identified by UID
*/
func (a *Client) GetFolderDescendantCounts(folderUID string, opts ...ClientOption) (*GetFolderDescendantCountsOK, error) {
	params := NewGetFolderDescendantCountsParams().WithFolderUID(folderUID)
	return a.GetFolderDescendantCountsWithParams(params, opts...)
}

func (a *Client) GetFolderDescendantCountsWithParams(params *GetFolderDescendantCountsParams, opts ...ClientOption) (*GetFolderDescendantCountsOK, error) {
	if params == nil {
		params = NewGetFolderDescendantCountsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getFolderDescendantCounts",
		Method:             "GET",
		PathPattern:        "/folders/{folder_uid}/counts",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetFolderDescendantCountsReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetFolderDescendantCountsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getFolderDescendantCounts: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
GetFolders gets all folders

Returns all folders that the authenticated user has permission to view.
If nested folders are enabled, it expects an additional query parameter with the parent folder UID
and returns the immediate subfolders that the authenticated user has permission to view.
If the parameter is not supplied then it returns immediate subfolders under the root
that the authenticated user has permission to view.
*/

func (a *Client) GetFolders(params *GetFoldersParams, opts ...ClientOption) (*GetFoldersOK, error) {
	if params == nil {
		params = NewGetFoldersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "getFolders",
		Method:             "GET",
		PathPattern:        "/folders",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &GetFoldersReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetFoldersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for getFolders: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
MoveFolder moves folder
*/
func (a *Client) MoveFolder(folderUID string, body *models.MoveFolderCommand, opts ...ClientOption) (*MoveFolderOK, error) {
	params := NewMoveFolderParams().WithBody(body).WithFolderUID(folderUID)
	return a.MoveFolderWithParams(params, opts...)
}

func (a *Client) MoveFolderWithParams(params *MoveFolderParams, opts ...ClientOption) (*MoveFolderOK, error) {
	if params == nil {
		params = NewMoveFolderParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "moveFolder",
		Method:             "POST",
		PathPattern:        "/folders/{folder_uid}/move",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &MoveFolderReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*MoveFolderOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for moveFolder: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

/*
UpdateFolder updates folder
*/
func (a *Client) UpdateFolder(folderUID string, body *models.UpdateFolderCommand, opts ...ClientOption) (*UpdateFolderOK, error) {
	params := NewUpdateFolderParams().WithBody(body).WithFolderUID(folderUID)
	return a.UpdateFolderWithParams(params, opts...)
}

func (a *Client) UpdateFolderWithParams(params *UpdateFolderParams, opts ...ClientOption) (*UpdateFolderOK, error) {
	if params == nil {
		params = NewUpdateFolderParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "updateFolder",
		Method:             "PUT",
		PathPattern:        "/folders/{folder_uid}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http", "https"},
		Params:             params,
		Reader:             &UpdateFolderReader{formats: a.formats},
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		if opt != nil {
			opt(op)
		}
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateFolderOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for updateFolder: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}

// WithAuthInfo changes the transport on the client
func WithAuthInfo(authInfo runtime.ClientAuthInfoWriter) ClientOption {
	return func(op *runtime.ClientOperation) {
		op.AuthInfo = authInfo
	}
}
