// Code generated by go-swagger; DO NOT EDIT.

package store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewOrderDeleteParams creates a new OrderDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewOrderDeleteParams() *OrderDeleteParams {
	return &OrderDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewOrderDeleteParamsWithTimeout creates a new OrderDeleteParams object
// with the ability to set a timeout on a request.
func NewOrderDeleteParamsWithTimeout(timeout time.Duration) *OrderDeleteParams {
	return &OrderDeleteParams{
		timeout: timeout,
	}
}

// NewOrderDeleteParamsWithContext creates a new OrderDeleteParams object
// with the ability to set a context for a request.
func NewOrderDeleteParamsWithContext(ctx context.Context) *OrderDeleteParams {
	return &OrderDeleteParams{
		Context: ctx,
	}
}

// NewOrderDeleteParamsWithHTTPClient creates a new OrderDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewOrderDeleteParamsWithHTTPClient(client *http.Client) *OrderDeleteParams {
	return &OrderDeleteParams{
		HTTPClient: client,
	}
}

/*
OrderDeleteParams contains all the parameters to send to the API endpoint

	for the order delete operation.

	Typically these are written to a http.Request.
*/
type OrderDeleteParams struct {

	/* OrderID.

	   ID of the order that needs to be deleted

	   Format: int64
	*/
	OrderID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the order delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *OrderDeleteParams) WithDefaults() *OrderDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the order delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *OrderDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the order delete params
func (o *OrderDeleteParams) WithTimeout(timeout time.Duration) *OrderDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the order delete params
func (o *OrderDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the order delete params
func (o *OrderDeleteParams) WithContext(ctx context.Context) *OrderDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the order delete params
func (o *OrderDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the order delete params
func (o *OrderDeleteParams) WithHTTPClient(client *http.Client) *OrderDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the order delete params
func (o *OrderDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithOrderID adds the orderID to the order delete params
func (o *OrderDeleteParams) WithOrderID(orderID int64) *OrderDeleteParams {
	o.SetOrderID(orderID)
	return o
}

// SetOrderID adds the orderId to the order delete params
func (o *OrderDeleteParams) SetOrderID(orderID int64) {
	o.OrderID = orderID
}

// WriteToRequest writes these params to a swagger request
func (o *OrderDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param orderId
	if err := r.SetPathParam("orderId", swag.FormatInt64(o.OrderID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
