// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: contrib/envoy/extensions/filters/network/generic_proxy/v3/generic_proxy.proto

package generic_proxyv3

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on GenericProxy with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GenericProxy) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GenericProxy with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in GenericProxyMultiError, or
// nil if none found.
func (m *GenericProxy) ValidateAll() error {
	return m.validate(true)
}

func (m *GenericProxy) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if utf8.RuneCountInString(m.GetStatPrefix()) < 1 {
		err := GenericProxyValidationError{
			field:  "StatPrefix",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetCodecConfig() == nil {
		err := GenericProxyValidationError{
			field:  "CodecConfig",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetCodecConfig()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GenericProxyValidationError{
					field:  "CodecConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GenericProxyValidationError{
					field:  "CodecConfig",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCodecConfig()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GenericProxyValidationError{
				field:  "CodecConfig",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	for idx, item := range m.GetFilters() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GenericProxyValidationError{
						field:  fmt.Sprintf("Filters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GenericProxyValidationError{
						field:  fmt.Sprintf("Filters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GenericProxyValidationError{
					field:  fmt.Sprintf("Filters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetTracing()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GenericProxyValidationError{
					field:  "Tracing",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GenericProxyValidationError{
					field:  "Tracing",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTracing()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GenericProxyValidationError{
				field:  "Tracing",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	oneofRouteSpecifierPresent := false
	switch v := m.RouteSpecifier.(type) {
	case *GenericProxy_GenericRds:
		if v == nil {
			err := GenericProxyValidationError{
				field:  "RouteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRouteSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetGenericRds()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GenericProxyValidationError{
						field:  "GenericRds",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GenericProxyValidationError{
						field:  "GenericRds",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetGenericRds()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GenericProxyValidationError{
					field:  "GenericRds",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *GenericProxy_RouteConfig:
		if v == nil {
			err := GenericProxyValidationError{
				field:  "RouteSpecifier",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		oneofRouteSpecifierPresent = true

		if all {
			switch v := interface{}(m.GetRouteConfig()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, GenericProxyValidationError{
						field:  "RouteConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, GenericProxyValidationError{
						field:  "RouteConfig",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetRouteConfig()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return GenericProxyValidationError{
					field:  "RouteConfig",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}
	if !oneofRouteSpecifierPresent {
		err := GenericProxyValidationError{
			field:  "RouteSpecifier",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return GenericProxyMultiError(errors)
	}

	return nil
}

// GenericProxyMultiError is an error wrapping multiple validation errors
// returned by GenericProxy.ValidateAll() if the designated constraints aren't met.
type GenericProxyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GenericProxyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GenericProxyMultiError) AllErrors() []error { return m }

// GenericProxyValidationError is the validation error returned by
// GenericProxy.Validate if the designated constraints aren't met.
type GenericProxyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GenericProxyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GenericProxyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GenericProxyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GenericProxyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GenericProxyValidationError) ErrorName() string { return "GenericProxyValidationError" }

// Error satisfies the builtin error interface
func (e GenericProxyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGenericProxy.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GenericProxyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GenericProxyValidationError{}

// Validate checks the field values on GenericRds with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *GenericRds) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GenericRds with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in GenericRdsMultiError, or
// nil if none found.
func (m *GenericRds) ValidateAll() error {
	return m.validate(true)
}

func (m *GenericRds) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetConfigSource() == nil {
		err := GenericRdsValidationError{
			field:  "ConfigSource",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetConfigSource()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GenericRdsValidationError{
					field:  "ConfigSource",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GenericRdsValidationError{
					field:  "ConfigSource",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetConfigSource()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GenericRdsValidationError{
				field:  "ConfigSource",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if utf8.RuneCountInString(m.GetRouteConfigName()) < 1 {
		err := GenericRdsValidationError{
			field:  "RouteConfigName",
			reason: "value length must be at least 1 runes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return GenericRdsMultiError(errors)
	}

	return nil
}

// GenericRdsMultiError is an error wrapping multiple validation errors
// returned by GenericRds.ValidateAll() if the designated constraints aren't met.
type GenericRdsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GenericRdsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GenericRdsMultiError) AllErrors() []error { return m }

// GenericRdsValidationError is the validation error returned by
// GenericRds.Validate if the designated constraints aren't met.
type GenericRdsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GenericRdsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GenericRdsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GenericRdsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GenericRdsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GenericRdsValidationError) ErrorName() string { return "GenericRdsValidationError" }

// Error satisfies the builtin error interface
func (e GenericRdsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGenericRds.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GenericRdsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GenericRdsValidationError{}
