//go:build !windows && !freebsd && !darwin && !dragonfly
// +build !windows,!freebsd,!darwin,!dragonfly

/*
   Copyright The containerd Authors.

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

package fs

import (
	"fmt"
	"os/exec"
)

func duCmd(root string) *exec.Cmd {
	return exec.Command("du", "-s", fmt.Sprintf("--block-size=%d", blocksUnitSize), root)
}
