// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        (unknown)
// source: coinbase/cloud/mpc_transactions/v1/mpc_transactions.proto

package v1

import (
	v1 "github.com/coinbase/waas-client-library-go/gen/go/coinbase/cloud/types/v1"
	_ "github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2/options"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The state of the MPCTransaction.
type MPCTransaction_State int32

const (
	// The default unspecified state.
	MPCTransaction_STATE_UNSPECIFIED MPCTransaction_State = 0
	// The request to create the MPCTransaction has been received by the service.
	MPCTransaction_CREATED MPCTransaction_State = 1
	// The MPCTransaction is waiting to be signed by the WaaS SDK.
	// Only one MPCTransaction per Address can be in the SIGNING state.
	MPCTransaction_SIGNING MPCTransaction_State = 2
	// The MPCTransaction has been signed and is waiting to be broadcast on-chain.
	MPCTransaction_SIGNED MPCTransaction_State = 3
	// The MPCTransaction has been successfully broadcast on-chain and is awaiting confirmation.
	MPCTransaction_CONFIRMING MPCTransaction_State = 4
	// The MPCTransaction has been confirmed on-chain. It is possible for the MPCTransaction
	// to revert to CONFIRMING if there is an on-chain reorganization.
	MPCTransaction_CONFIRMED MPCTransaction_State = 5
	// The MPCTransaction was broadcast, but failed on-chain.
	MPCTransaction_FAILED MPCTransaction_State = 6
	// The MPCTransaction was cancelled by the service.
	MPCTransaction_CANCELLED MPCTransaction_State = 7
)

// Enum value maps for MPCTransaction_State.
var (
	MPCTransaction_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATED",
		2: "SIGNING",
		3: "SIGNED",
		4: "CONFIRMING",
		5: "CONFIRMED",
		6: "FAILED",
		7: "CANCELLED",
	}
	MPCTransaction_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATED":           1,
		"SIGNING":           2,
		"SIGNED":            3,
		"CONFIRMING":        4,
		"CONFIRMED":         5,
		"FAILED":            6,
		"CANCELLED":         7,
	}
)

func (x MPCTransaction_State) Enum() *MPCTransaction_State {
	p := new(MPCTransaction_State)
	*p = x
	return p
}

func (x MPCTransaction_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MPCTransaction_State) Descriptor() protoreflect.EnumDescriptor {
	return file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_enumTypes[0].Descriptor()
}

func (MPCTransaction_State) Type() protoreflect.EnumType {
	return &file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_enumTypes[0]
}

func (x MPCTransaction_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use MPCTransaction_State.Descriptor instead.
func (MPCTransaction_State) EnumDescriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDescGZIP(), []int{0, 0}
}

// The MPCTransaction resource, which represents a transaction that is in the process of being
// fulfilled. The lifecycle of a successful MPC transaction has five parts:
//
// 1. CREATED - The request has been received by the service.
// 2. SIGNING - The MPCTransaction is waiting to be signed. At this point,
// the WaaS SDK must poll for and process the CREATE_SIGNATURE MPCOperation
// of the DeviceGroup associated with the underlying Address.
// For any given Address, only one MPCTransaction can be in the SIGNING state
// at a given time - i.e., an MPCTransaction must be successfully signed before the
// the next one can be signed.
// 3. SIGNED - The MPCTransaction has been signed and is waiting to be broadcast
// on-chain. MPCTransactions are broadcast on a regular periodic schedule proportional
// to the block production speed of the Network.
// 4. CONFIRMING - The MPCTransaction has been successfully broadcast on-chain
// and is awaiting confirmation.
// 5. CONFIRMED - The MPCTransaction has been confirmed on-chain. It is possible for
// the MPCTransaction to revert to CONFIRMING if there is an on-chain reorganization.
type MPCTransaction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the MPCTransaction.
	// Format: pools/{pool_id}/mpcWallets/{mpc_wallet_id}/mpcTransactions/{mpc_transaction_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The resource name of the Network on which to broadcast the MPCTransaction.
	// Format: networks/{network_id}
	Network string `protobuf:"bytes,2,opt,name=network,proto3" json:"network,omitempty"`
	// The resource name of the Addresses from which to send the MPCTransaction.
	// For account-based Networks, only the first address is used.
	// Format: networks/{network_id}/addresses/{address_id}.
	FromAddresses []string `protobuf:"bytes,3,rep,name=from_addresses,json=fromAddresses,proto3" json:"from_addresses,omitempty"`
	// The current state of the MPCTransaction.
	State MPCTransaction_State `protobuf:"varint,4,opt,name=state,proto3,enum=coinbase.cloud.mpc_transactions.v1.MPCTransaction_State" json:"state,omitempty"`
	// The underlying transaction to be signed and broadcast. Fields in the transaction, such as the hash,
	// will become populated as the MPCTransaction goes through its lifecycle.
	Transaction *v1.Transaction `protobuf:"bytes,5,opt,name=transaction,proto3" json:"transaction,omitempty"`
}

func (x *MPCTransaction) Reset() {
	*x = MPCTransaction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MPCTransaction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MPCTransaction) ProtoMessage() {}

func (x *MPCTransaction) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MPCTransaction.ProtoReflect.Descriptor instead.
func (*MPCTransaction) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDescGZIP(), []int{0}
}

func (x *MPCTransaction) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *MPCTransaction) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *MPCTransaction) GetFromAddresses() []string {
	if x != nil {
		return x.FromAddresses
	}
	return nil
}

func (x *MPCTransaction) GetState() MPCTransaction_State {
	if x != nil {
		return x.State
	}
	return MPCTransaction_STATE_UNSPECIFIED
}

func (x *MPCTransaction) GetTransaction() *v1.Transaction {
	if x != nil {
		return x.Transaction
	}
	return nil
}

// The request message for CreateMPCTransaction.
type CreateMPCTransactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent MPCWallet.
	// Format: pools/{pool_id}/mpcWallets/{mpc_wallet_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The MPCTransaction to be created.
	MpcTransaction *MPCTransaction `protobuf:"bytes,2,opt,name=mpc_transaction,json=mpcTransaction,proto3" json:"mpc_transaction,omitempty"`
	// The transaction input.
	Input *v1.TransactionInput `protobuf:"bytes,3,opt,name=input,proto3" json:"input,omitempty"`
	// Whether the nonce specified in the transaction input should be respected,
	// as opposed to assigned by the service. This is intended for the use case of
	// replacing transactions that fail to confirm on-chain due to too low of a transaction fee.
	// Setting this to true has the side effect of canceling any pending transactions from the
	// same address with nonce greater than or equal to the one provided. Use this
	// with caution.
	OverrideNonce bool `protobuf:"varint,4,opt,name=override_nonce,json=overrideNonce,proto3" json:"override_nonce,omitempty"`
	// A user-provided request ID to allow for idempotency. This should be a UUID.
	RequestId string `protobuf:"bytes,5,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateMPCTransactionRequest) Reset() {
	*x = CreateMPCTransactionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMPCTransactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMPCTransactionRequest) ProtoMessage() {}

func (x *CreateMPCTransactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMPCTransactionRequest.ProtoReflect.Descriptor instead.
func (*CreateMPCTransactionRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDescGZIP(), []int{1}
}

func (x *CreateMPCTransactionRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateMPCTransactionRequest) GetMpcTransaction() *MPCTransaction {
	if x != nil {
		return x.MpcTransaction
	}
	return nil
}

func (x *CreateMPCTransactionRequest) GetInput() *v1.TransactionInput {
	if x != nil {
		return x.Input
	}
	return nil
}

func (x *CreateMPCTransactionRequest) GetOverrideNonce() bool {
	if x != nil {
		return x.OverrideNonce
	}
	return false
}

func (x *CreateMPCTransactionRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Metadata associated with the CreateMPCTransaction long-running operation.
type CreateMPCTransactionMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the DeviceGroup to poll for using ListMPCOperations.
	// Format: pools/{pool_id}/deviceGroups/{device_group_id}
	DeviceGroup string `protobuf:"bytes,1,opt,name=device_group,json=deviceGroup,proto3" json:"device_group,omitempty"`
	// The current state of the MPCTransaction. Once this field is populated,
	// GetMPCTransaction can also be called using the name.
	State MPCTransaction_State `protobuf:"varint,2,opt,name=state,proto3,enum=coinbase.cloud.mpc_transactions.v1.MPCTransaction_State" json:"state,omitempty"`
	// The resource name of the MPCTransaction, if it has been created.
	// Format: pools/{pool_id}/mpcWallets/{mpc_wallet_id}/mpcTransactions/{mpc_transaction_id}
	MpcTransaction string `protobuf:"bytes,3,opt,name=mpc_transaction,json=mpcTransaction,proto3" json:"mpc_transaction,omitempty"`
	// A message describing the current state of the Broadcast and whether any
	// action needs to be taken.
	Message string `protobuf:"bytes,4,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *CreateMPCTransactionMetadata) Reset() {
	*x = CreateMPCTransactionMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateMPCTransactionMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateMPCTransactionMetadata) ProtoMessage() {}

func (x *CreateMPCTransactionMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateMPCTransactionMetadata.ProtoReflect.Descriptor instead.
func (*CreateMPCTransactionMetadata) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDescGZIP(), []int{2}
}

func (x *CreateMPCTransactionMetadata) GetDeviceGroup() string {
	if x != nil {
		return x.DeviceGroup
	}
	return ""
}

func (x *CreateMPCTransactionMetadata) GetState() MPCTransaction_State {
	if x != nil {
		return x.State
	}
	return MPCTransaction_STATE_UNSPECIFIED
}

func (x *CreateMPCTransactionMetadata) GetMpcTransaction() string {
	if x != nil {
		return x.MpcTransaction
	}
	return ""
}

func (x *CreateMPCTransactionMetadata) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// The request message for GetMPCTransaction.
type GetMPCTransactionRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the MPCTransaction.
	// Format: pools/{pool_id}/mpcWallets/{mpc_wallet_id}/mpcTransactions/{mpc_transaction_id}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetMPCTransactionRequest) Reset() {
	*x = GetMPCTransactionRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetMPCTransactionRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetMPCTransactionRequest) ProtoMessage() {}

func (x *GetMPCTransactionRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetMPCTransactionRequest.ProtoReflect.Descriptor instead.
func (*GetMPCTransactionRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDescGZIP(), []int{3}
}

func (x *GetMPCTransactionRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// The request message for ListMPCTransactions.
type ListMPCTransactionsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resource name of the parent MPCWallet.
	// Format: pools/{pool_id}/mpcWallets/{mpc_wallet_id}
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of MPCTransactions to return. The default is 50.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous ListMPCTransactions call.
	// Provide this to retrieve the subsequent page.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListMPCTransactionsRequest) Reset() {
	*x = ListMPCTransactionsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMPCTransactionsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMPCTransactionsRequest) ProtoMessage() {}

func (x *ListMPCTransactionsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMPCTransactionsRequest.ProtoReflect.Descriptor instead.
func (*ListMPCTransactionsRequest) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDescGZIP(), []int{4}
}

func (x *ListMPCTransactionsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListMPCTransactionsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListMPCTransactionsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// The response message for ListMPCTransactions.
type ListMPCTransactionsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of MPCTransactions.
	MpcTransactions []*MPCTransaction `protobuf:"bytes,1,rep,name=mpc_transactions,json=mpcTransactions,proto3" json:"mpc_transactions,omitempty"`
	// A token, which can be sent as page_token to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListMPCTransactionsResponse) Reset() {
	*x = ListMPCTransactionsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListMPCTransactionsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListMPCTransactionsResponse) ProtoMessage() {}

func (x *ListMPCTransactionsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListMPCTransactionsResponse.ProtoReflect.Descriptor instead.
func (*ListMPCTransactionsResponse) Descriptor() ([]byte, []int) {
	return file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDescGZIP(), []int{5}
}

func (x *ListMPCTransactionsResponse) GetMpcTransactions() []*MPCTransaction {
	if x != nil {
		return x.MpcTransactions
	}
	return nil
}

func (x *ListMPCTransactionsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto protoreflect.FileDescriptor

var file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDesc = []byte{
	0x0a, 0x39, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x6d, 0x70, 0x63, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x76, 0x31, 0x2f, 0x6d, 0x70, 0x63, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x22, 0x63, 0x6f, 0x69,
	0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x1a,
	0x29, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x74, 0x79, 0x70, 0x65, 0x73, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69,
	0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x2d, 0x67, 0x65, 0x6e, 0x2d, 0x6f,
	0x70, 0x65, 0x6e, 0x61, 0x70, 0x69, 0x76, 0x32, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x22, 0xb4, 0x15, 0x0a, 0x0e, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0xba, 0x02, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0xa5, 0x02, 0x92, 0x41, 0x9d, 0x02, 0x2a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x32, 0x80, 0x01, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x0a, 0x46, 0x6f, 0x72,
	0x6d, 0x61, 0x74, 0x3a, 0x20, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6f, 0x6c,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2f,
	0x7b, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f,
	0x6d, 0x70, 0x63, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x7b, 0x6d, 0x70, 0x63, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x69, 0x64, 0x7d, 0x4a, 0x91, 0x01, 0x22, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x39, 0x35,
	0x32, 0x35, 0x37, 0x63, 0x35, 0x61, 0x2d, 0x35, 0x32, 0x32, 0x66, 0x2d, 0x34, 0x32, 0x34, 0x31,
	0x2d, 0x62, 0x66, 0x39, 0x37, 0x2d, 0x32, 0x36, 0x35, 0x36, 0x61, 0x38, 0x65, 0x39, 0x63, 0x63,
	0x39, 0x31, 0x2f, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2f, 0x64, 0x32,
	0x38, 0x31, 0x39, 0x37, 0x65, 0x38, 0x2d, 0x33, 0x37, 0x32, 0x63, 0x2d, 0x34, 0x36, 0x31, 0x63,
	0x2d, 0x39, 0x61, 0x30, 0x30, 0x2d, 0x32, 0x64, 0x61, 0x33, 0x63, 0x35, 0x32, 0x38, 0x63, 0x32,
	0x64, 0x31, 0x2f, 0x6d, 0x70, 0x63, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x66, 0x32, 0x61, 0x39, 0x61, 0x37, 0x31, 0x32, 0x2d, 0x66, 0x34, 0x38, 0x33,
	0x2d, 0x34, 0x37, 0x39, 0x30, 0x2d, 0x38, 0x61, 0x31, 0x38, 0x2d, 0x30, 0x65, 0x37, 0x63, 0x31,
	0x38, 0x61, 0x65, 0x61, 0x66, 0x65, 0x63, 0x22, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0xda, 0x01, 0x0a, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0xbf, 0x01, 0x92, 0x41, 0x90, 0x01, 0x2a, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x32, 0x69, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x6f, 0x6e, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20,
	0x74, 0x6f, 0x20, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x0a, 0x20, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x5f, 0x69, 0x64, 0x7d, 0x4a,
	0x1a, 0x22, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x65, 0x74, 0x68, 0x65, 0x72,
	0x65, 0x75, 0x6d, 0x2d, 0x67, 0x6f, 0x65, 0x72, 0x6c, 0x69, 0x22, 0xe2, 0x41, 0x01, 0x02, 0xfa,
	0x41, 0x24, 0x0a, 0x22, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65,
	0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12,
	0xfb, 0x02, 0x0a, 0x0e, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
	0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0xd3, 0x02, 0x92, 0x41, 0xa2, 0x02, 0x2a,
	0x0e, 0x66, 0x72, 0x6f, 0x6d, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x32,
	0xbc, 0x01, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e,
	0x61, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x41, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x65, 0x73, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20,
	0x74, 0x6f, 0x20, 0x73, 0x65, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x20, 0x46, 0x6f, 0x72, 0x20,
	0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x2d, 0x62, 0x61, 0x73, 0x65, 0x64, 0x20, 0x4e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2c, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x20, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x69,
	0x73, 0x20, 0x75, 0x73, 0x65, 0x64, 0x2e, 0x0a, 0x20, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a,
	0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x7b, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73,
	0x2f, 0x7b, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x69, 0x64, 0x7d, 0x2e, 0x4a, 0x51,
	0x5b, 0x22, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x2f, 0x65, 0x74, 0x68, 0x65, 0x72,
	0x65, 0x75, 0x6d, 0x2d, 0x67, 0x6f, 0x65, 0x72, 0x6c, 0x69, 0x2f, 0x61, 0x64, 0x64, 0x72, 0x65,
	0x73, 0x73, 0x65, 0x73, 0x2f, 0x30, 0x78, 0x44, 0x41, 0x46, 0x45, 0x41, 0x34, 0x39, 0x32, 0x44,
	0x39, 0x63, 0x36, 0x37, 0x33, 0x33, 0x61, 0x65, 0x33, 0x64, 0x35, 0x36, 0x62, 0x37, 0x45, 0x64,
	0x31, 0x41, 0x44, 0x42, 0x36, 0x30, 0x36, 0x39, 0x32, 0x63, 0x39, 0x38, 0x42, 0x63, 0x35, 0x22,
	0x5d, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x26, 0x0a, 0x24, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65,
	0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x52, 0x0d,
	0x66, 0x72, 0x6f, 0x6d, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73, 0x12, 0x96, 0x01,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e,
	0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d,
	0x70, 0x63, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x46, 0x92, 0x41, 0x3f, 0x2a, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x32, 0x28, 0x54, 0x68, 0x65, 0x20, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
	0x20, 0x73, 0x74, 0x61, 0x74, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50,
	0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x4a, 0x0c, 0x22,
	0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x49, 0x4e, 0x47, 0x22, 0xe2, 0x41, 0x01, 0x03, 0x52,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x8c, 0x02, 0x0a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x24, 0x2e, 0x63,
	0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0xc3, 0x01, 0x92, 0x41, 0xbb, 0x01, 0x2a, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x32, 0xab, 0x01, 0x54, 0x68, 0x65, 0x20, 0x75, 0x6e, 0x64,
	0x65, 0x72, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x20, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64,
	0x20, 0x61, 0x6e, 0x64, 0x20, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x2e, 0x20,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x73, 0x75, 0x63, 0x68, 0x20,
	0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x68, 0x61, 0x73, 0x68, 0x2c, 0x20, 0x77, 0x69, 0x6c,
	0x6c, 0x20, 0x62, 0x65, 0x63, 0x6f, 0x6d, 0x65, 0x20, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74,
	0x65, 0x64, 0x20, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x67, 0x6f, 0x65, 0x73, 0x20, 0x74, 0x68,
	0x72, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x69, 0x74, 0x73, 0x20, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79,
	0x63, 0x6c, 0x65, 0x2e, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x0b, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x7e, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44,
	0x10, 0x01, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x49, 0x47, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12,
	0x0a, 0x0a, 0x06, 0x53, 0x49, 0x47, 0x4e, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x43,
	0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x49, 0x4e, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x43,
	0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x45, 0x44, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41,
	0x49, 0x4c, 0x45, 0x44, 0x10, 0x06, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c,
	0x4c, 0x45, 0x44, 0x10, 0x07, 0x3a, 0xe1, 0x09, 0x92, 0x41, 0xde, 0x08, 0x0a, 0xdb, 0x08, 0x2a,
	0x0e, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x32,
	0xc8, 0x08, 0x54, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2c, 0x20, 0x77,
	0x68, 0x69, 0x63, 0x68, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x73, 0x20,
	0x61, 0x20, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x68,
	0x61, 0x74, 0x20, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x72, 0x6f,
	0x63, 0x65, 0x73, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x62, 0x65, 0x69, 0x6e, 0x67, 0x20, 0x66, 0x75,
	0x6c, 0x66, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x20, 0x6c, 0x69, 0x66,
	0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x20, 0x73, 0x75, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x20, 0x4d, 0x50, 0x43, 0x20, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x68, 0x61, 0x73, 0x20, 0x66, 0x69, 0x76, 0x65, 0x20,
	0x70, 0x61, 0x72, 0x74, 0x73, 0x3a, 0x0a, 0x0a, 0x20, 0x31, 0x2e, 0x20, 0x43, 0x52, 0x45, 0x41,
	0x54, 0x45, 0x44, 0x20, 0x2d, 0x20, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x20, 0x68, 0x61, 0x73, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x20, 0x72, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x2e, 0x0a, 0x20, 0x32, 0x2e, 0x20, 0x53, 0x49, 0x47, 0x4e, 0x49, 0x4e, 0x47, 0x20,
	0x2d, 0x20, 0x54, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x73, 0x20, 0x77, 0x61, 0x69, 0x74, 0x69, 0x6e, 0x67, 0x20,
	0x74, 0x6f, 0x20, 0x62, 0x65, 0x20, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x2e, 0x20, 0x41, 0x74,
	0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2c, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x57, 0x61, 0x61, 0x53, 0x20, 0x53, 0x44, 0x4b, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x70,
	0x6f, 0x6c, 0x6c, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x70, 0x72, 0x6f, 0x63,
	0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x5f, 0x53,
	0x49, 0x47, 0x4e, 0x41, 0x54, 0x55, 0x52, 0x45, 0x20, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61,
	0x74, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x75, 0x6e, 0x64,
	0x65, 0x72, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2e,
	0x20, 0x46, 0x6f, 0x72, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x20, 0x41,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x2c, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x6f, 0x6e, 0x65,
	0x20, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20,
	0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x53, 0x49,
	0x47, 0x4e, 0x49, 0x4e, 0x47, 0x20, 0x73, 0x74, 0x61, 0x74, 0x65, 0x20, 0x61, 0x74, 0x20, 0x61,
	0x20, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x20, 0x2d, 0x20, 0x69, 0x2e,
	0x65, 0x2e, 0x2c, 0x20, 0x61, 0x6e, 0x20, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6d, 0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x20, 0x73, 0x75,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x20, 0x73, 0x69, 0x67, 0x6e, 0x65,
	0x64, 0x20, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x6e, 0x65, 0x78, 0x74, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65,
	0x20, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x2e, 0x0a, 0x20, 0x33, 0x2e, 0x20, 0x53, 0x49, 0x47,
	0x4e, 0x45, 0x44, 0x20, 0x2d, 0x20, 0x54, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x68, 0x61, 0x73, 0x20, 0x62, 0x65, 0x65,
	0x6e, 0x20, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x69, 0x73, 0x20,
	0x77, 0x61, 0x69, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x20, 0x62, 0x72,
	0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x20, 0x6f, 0x6e, 0x2d, 0x63, 0x68, 0x61, 0x69, 0x6e,
	0x2e, 0x20, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x20, 0x61, 0x72, 0x65, 0x20, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x20,
	0x6f, 0x6e, 0x20, 0x61, 0x20, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x20, 0x70, 0x65, 0x72,
	0x69, 0x6f, 0x64, 0x69, 0x63, 0x20, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x20, 0x70,
	0x72, 0x6f, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x20, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x73, 0x70, 0x65, 0x65, 0x64, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x2e, 0x0a, 0x20, 0x34, 0x2e, 0x20, 0x43, 0x4f,
	0x4e, 0x46, 0x49, 0x52, 0x4d, 0x49, 0x4e, 0x47, 0x20, 0x2d, 0x20, 0x54, 0x68, 0x65, 0x20, 0x4d,
	0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x68, 0x61,
	0x73, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x20, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75,
	0x6c, 0x6c, 0x79, 0x20, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x20, 0x6f, 0x6e,
	0x2d, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x69, 0x73, 0x20, 0x61, 0x77,
	0x61, 0x69, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x2e, 0x0a, 0x20, 0x35, 0x2e, 0x20, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d,
	0x45, 0x44, 0x20, 0x2d, 0x20, 0x54, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x68, 0x61, 0x73, 0x20, 0x62, 0x65, 0x65, 0x6e,
	0x20, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x20, 0x6f, 0x6e, 0x2d, 0x63, 0x68,
	0x61, 0x69, 0x6e, 0x2e, 0x20, 0x49, 0x74, 0x20, 0x69, 0x73, 0x20, 0x70, 0x6f, 0x73, 0x73, 0x69,
	0x62, 0x6c, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x72, 0x65,
	0x76, 0x65, 0x72, 0x74, 0x20, 0x74, 0x6f, 0x20, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x49,
	0x4e, 0x47, 0x20, 0x69, 0x66, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x69, 0x73, 0x20, 0x61,
	0x6e, 0x20, 0x6f, 0x6e, 0x2d, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x20, 0x72, 0x65, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0xea, 0x41, 0x7c, 0x0a, 0x29, 0x61,
	0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69,
	0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f,
	0x7b, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c,
	0x6c, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61, 0x6c, 0x6c, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x70, 0x63, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6d, 0x70, 0x63, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0x22, 0xac, 0x06, 0x0a, 0x1b, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x60, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x48, 0x92, 0x41, 0x13, 0xca, 0x3e,
	0x10, 0xfa, 0x02, 0x0d, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x4e, 0x61, 0x6d,
	0x65, 0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65,
	0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x61, 0x0a, 0x0f, 0x6d,
	0x70, 0x63, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x02, 0x52, 0x0e,
	0x6d, 0x70, 0x63, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x45,
	0x0a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e,
	0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x74,
	0x79, 0x70, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x49, 0x6e, 0x70, 0x75, 0x74, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x02, 0x52, 0x05,
	0x69, 0x6e, 0x70, 0x75, 0x74, 0x12, 0xdb, 0x03, 0x0a, 0x0e, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69,
	0x64, 0x65, 0x5f, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0xb3,
	0x03, 0x92, 0x41, 0xab, 0x03, 0x2a, 0x05, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x32, 0xa1, 0x03, 0x57,
	0x68, 0x65, 0x74, 0x68, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x6f, 0x6e, 0x63, 0x65,
	0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68,
	0x65, 0x20, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x6e,
	0x70, 0x75, 0x74, 0x20, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x62, 0x65, 0x20, 0x72, 0x65,
	0x73, 0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x2c, 0x20, 0x61, 0x73, 0x20, 0x6f, 0x70, 0x70, 0x6f,
	0x73, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x20,
	0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x20,
	0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64,
	0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x75, 0x73, 0x65, 0x20, 0x63, 0x61, 0x73,
	0x65, 0x20, 0x6f, 0x66, 0x20, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x20, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74,
	0x20, 0x66, 0x61, 0x69, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d,
	0x20, 0x6f, 0x6e, 0x2d, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x20, 0x64, 0x75, 0x65, 0x20, 0x74, 0x6f,
	0x20, 0x74, 0x6f, 0x6f, 0x20, 0x6c, 0x6f, 0x77, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x20, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x66, 0x65, 0x65, 0x2e, 0x20, 0x53,
	0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x74,
	0x72, 0x75, 0x65, 0x20, 0x68, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x69, 0x64, 0x65,
	0x20, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x63, 0x61, 0x6e, 0x63, 0x65,
	0x6c, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67,
	0x20, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x66, 0x72,
	0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x61, 0x6d, 0x65, 0x20, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x20, 0x67,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x6f, 0x72, 0x20, 0x65,
	0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x6e, 0x65, 0x20,
	0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x2e, 0x20, 0x55, 0x73, 0x65, 0x20, 0x74, 0x68,
	0x69, 0x73, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x63, 0x61, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0xe2, 0x41, 0x01, 0x01, 0x52, 0x0d, 0x6f, 0x76, 0x65, 0x72, 0x72, 0x69, 0x64, 0x65, 0x4e, 0x6f,
	0x6e, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x01, 0x52, 0x09, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xce, 0x03, 0x0a, 0x1c, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x52, 0x0a, 0x0c, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x2f, 0xe2, 0x41, 0x01, 0x03, 0xfa, 0x41, 0x28, 0x0a, 0x26, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65,
	0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70,
	0x52, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x12, 0x54, 0x0a,
	0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x38, 0x2e, 0x63,
	0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70,
	0x63, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x04, 0xe2, 0x41, 0x01, 0x03, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x12, 0xe9, 0x01, 0x0a, 0x0f, 0x6d, 0x70, 0x63, 0x5f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0xbf, 0x01,
	0x92, 0x41, 0x89, 0x01, 0x2a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x32, 0x80, 0x01, 0x54, 0x68, 0x65,
	0x20, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f,
	0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x0a, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x3a, 0x20, 0x70, 0x6f,
	0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x70, 0x6f, 0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x70,
	0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x6d, 0x70, 0x63, 0x5f, 0x77, 0x61,
	0x6c, 0x6c, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x2f, 0x6d, 0x70, 0x63, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6d, 0x70, 0x63, 0x5f, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x7d, 0xe2, 0x41, 0x01,
	0x03, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f,
	0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x0e, 0x6d, 0x70, 0x63, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x7d, 0x0a, 0x18, 0x47, 0x65, 0x74,
	0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x61, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x4d, 0x92, 0x41, 0x18, 0xca, 0x3e, 0x15, 0xfa, 0x02, 0x12, 0x6d, 0x70,
	0x63, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4e, 0x61, 0x6d, 0x65,
	0xe2, 0x41, 0x01, 0x02, 0xfa, 0x41, 0x2b, 0x0a, 0x29, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76,
	0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xba, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x60, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x48, 0x92, 0x41, 0x13, 0xca, 0x3e, 0x10, 0xfa,
	0x02, 0x0d, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0xe2,
	0x41, 0x01, 0x02, 0xfa, 0x41, 0x2b, 0x12, 0x29, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65,
	0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61,
	0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xf7, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50,
	0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73,
	0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5d, 0x0a, 0x10, 0x6d, 0x70, 0x63, 0x5f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x32, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x6d, 0x70, 0x63, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x3a, 0x51, 0x92, 0x41,
	0x4e, 0x0a, 0x4c, 0x2a, 0x1b, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x32, 0x2d, 0x54, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x20, 0x6d,
	0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d,
	0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x32,
	0xd9, 0x0e, 0x0a, 0x15, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xf4, 0x06, 0x0a, 0x14, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3f, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x50,
	0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e,
	0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x22, 0xfb, 0x05, 0x92, 0x41, 0xeb, 0x04, 0x12, 0x14, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a,
	0xd2, 0x04, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x4d, 0x50, 0x43,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x0a, 0x0a, 0x20, 0x54,
	0x68, 0x65, 0x20, 0x6c, 0x6f, 0x6e, 0x67, 0x2d, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x20,
	0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e,
	0x65, 0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x41, 0x50, 0x49,
	0x20, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x20, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x61, 0x62, 0x6f, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x61, 0x74,
	0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x20, 0x4c, 0x52, 0x4f, 0x20,
	0x69, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x65, 0x64, 0x20, 0x44, 0x6f,
	0x6e, 0x65, 0x20, 0x77, 0x68, 0x65, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x50, 0x43, 0x54,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x72, 0x65, 0x61, 0x63, 0x68,
	0x65, 0x73, 0x20, 0x61, 0x20, 0x73, 0x74, 0x61, 0x74, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x60, 0x43,
	0x4f, 0x4e, 0x46, 0x49, 0x52, 0x4d, 0x49, 0x4e, 0x47, 0x60, 0x20, 0x28, 0x69, 0x2e, 0x65, 0x2e,
	0x2c, 0x20, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x20, 0x6f, 0x6e, 0x2d, 0x63,
	0x68, 0x61, 0x69, 0x6e, 0x29, 0x2e, 0x20, 0x53, 0x65, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4d,
	0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x66, 0x6f, 0x72, 0x20,
	0x69, 0x74, 0x73, 0x20, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x79, 0x63, 0x6c, 0x65, 0x2e, 0x0a, 0x0a,
	0x20, 0x4e, 0x6f, 0x74, 0x65, 0x3a, 0x20, 0x62, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x74,
	0x68, 0x65, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x4d,
	0x50, 0x43, 0x20, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x69, 0x73,
	0x20, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x68, 0x72, 0x6f, 0x6e, 0x6f, 0x75, 0x73, 0x2c, 0x20, 0x4c,
	0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x20, 0x6d, 0x61, 0x79, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20, 0x61, 0x20, 0x4e, 0x4f,
	0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x20, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x20, 0x69, 0x6d,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20,
	0x63, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x20, 0x54, 0x6f,
	0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x70,
	0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75,
	0x65, 0x20, 0x70, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x20, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50,
	0x43, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x65, 0x76, 0x65, 0x6e,
	0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20, 0x69, 0x74, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e,
	0x73, 0x20, 0x61, 0x20, 0x4e, 0x4f, 0x54, 0x5f, 0x46, 0x4f, 0x55, 0x4e, 0x44, 0x20, 0x65, 0x72,
	0x72, 0x6f, 0x72, 0x2e, 0xca, 0x41, 0x2e, 0x0a, 0x0e, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x4d,
	0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x1c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x6d,
	0x70, 0x63, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x69,
	0x6e, 0x70, 0x75, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x36, 0x3a, 0x01, 0x2a, 0x22, 0x31, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x6f, 0x6f, 0x6c, 0x73,
	0x2f, 0x2a, 0x2f, 0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x6d, 0x70, 0x63, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0xfc, 0x02, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x74, 0x72, 0x61, 0x6e,
	0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x4d,
	0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x32, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xf4, 0x01, 0x92, 0x41, 0xb0, 0x01, 0x12,
	0x11, 0x47, 0x65, 0x74, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x1a, 0x9a, 0x01, 0x47, 0x65, 0x74, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x4d, 0x50, 0x43,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x20, 0x54, 0x68, 0x65,
	0x72, 0x65, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x61, 0x20, 0x64, 0x65, 0x6c, 0x61,
	0x79, 0x20, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x20, 0x77, 0x68, 0x65, 0x6e, 0x20, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x69, 0x73, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x20, 0x61, 0x6e,
	0x64, 0x20, 0x77, 0x68, 0x65, 0x6e, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x41, 0x50, 0x49, 0x20,
	0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x4d, 0x50, 0x43, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65,
	0x20, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45, 0x44, 0x20, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0xda,
	0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x2f,
	0x6d, 0x70, 0x63, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x70, 0x63,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xa7, 0x02, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x3e, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61,
	0x73, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6d, 0x70, 0x63, 0x5f, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73,
	0x74, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x8e, 0x01, 0x92, 0x41, 0x49, 0x12, 0x13,
	0x4c, 0x69, 0x73, 0x74, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x1a, 0x32, 0x52, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x20, 0x61, 0x20, 0x6c,
	0x69, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x4d, 0x50, 0x43, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x61, 0x6e, 0x20, 0x4d, 0x50, 0x43,
	0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x2e, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x33, 0x12, 0x31, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x2a, 0x2f, 0x6d, 0x70, 0x63, 0x57,
	0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x6d, 0x70, 0x63, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x9f, 0x02, 0x92, 0x41, 0xe8, 0x01,
	0x12, 0xe5, 0x01, 0x41, 0x20, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x20, 0x74, 0x68, 0x61,
	0x74, 0x20, 0x6f, 0x72, 0x63, 0x68, 0x65, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x73, 0x20, 0x6f,
	0x6e, 0x2d, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x20, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6e, 0x67,
	0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x4d, 0x50, 0x43, 0x57, 0x61, 0x6c, 0x6c, 0x65, 0x74, 0x73,
	0x2e, 0x20, 0x54, 0x68, 0x65, 0x20, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x20, 0x68, 0x61,
	0x6e, 0x64, 0x6c, 0x65, 0x73, 0x20, 0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x20, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x20, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x2c, 0x20, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x2c, 0x20, 0x62, 0x72, 0x6f, 0x61, 0x64,
	0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x6e,
	0x2d, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x20, 0x72, 0x65, 0x2d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
	0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0xca, 0x41, 0x30, 0x61, 0x70, 0x69, 0x2e, 0x64,
	0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73,
	0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x77, 0x61, 0x61, 0x73, 0x2f, 0x6d, 0x70, 0x63, 0x5f, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0xce, 0x01, 0x5a, 0x54,
	0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x63, 0x6f, 0x69, 0x6e, 0x62,
	0x61, 0x73, 0x65, 0x2f, 0x77, 0x61, 0x61, 0x73, 0x2d, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2d,
	0x6c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x2d, 0x67, 0x6f, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67,
	0x6f, 0x2f, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2f, 0x6d, 0x70, 0x63, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x76, 0x31, 0x92, 0x41, 0x75, 0x12, 0x1a, 0x0a, 0x13, 0x4d, 0x50, 0x43, 0x54, 0x72,
	0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x41, 0x50, 0x49, 0x32, 0x03,
	0x31, 0x2e, 0x30, 0x1a, 0x30, 0x61, 0x70, 0x69, 0x2e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70,
	0x65, 0x72, 0x2e, 0x63, 0x6f, 0x69, 0x6e, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x77, 0x61, 0x61, 0x73, 0x2f, 0x6d, 0x70, 0x63, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2a, 0x01, 0x02, 0x32, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x6a, 0x73, 0x6f, 0x6e, 0x3a, 0x10, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x6a, 0x73, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDescOnce sync.Once
	file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDescData = file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDesc
)

func file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDescGZIP() []byte {
	file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDescOnce.Do(func() {
		file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDescData = protoimpl.X.CompressGZIP(file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDescData)
	})
	return file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDescData
}

var file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_goTypes = []interface{}{
	(MPCTransaction_State)(0),            // 0: coinbase.cloud.mpc_transactions.v1.MPCTransaction.State
	(*MPCTransaction)(nil),               // 1: coinbase.cloud.mpc_transactions.v1.MPCTransaction
	(*CreateMPCTransactionRequest)(nil),  // 2: coinbase.cloud.mpc_transactions.v1.CreateMPCTransactionRequest
	(*CreateMPCTransactionMetadata)(nil), // 3: coinbase.cloud.mpc_transactions.v1.CreateMPCTransactionMetadata
	(*GetMPCTransactionRequest)(nil),     // 4: coinbase.cloud.mpc_transactions.v1.GetMPCTransactionRequest
	(*ListMPCTransactionsRequest)(nil),   // 5: coinbase.cloud.mpc_transactions.v1.ListMPCTransactionsRequest
	(*ListMPCTransactionsResponse)(nil),  // 6: coinbase.cloud.mpc_transactions.v1.ListMPCTransactionsResponse
	(*v1.Transaction)(nil),               // 7: coinbase.cloud.types.v1.Transaction
	(*v1.TransactionInput)(nil),          // 8: coinbase.cloud.types.v1.TransactionInput
	(*longrunning.Operation)(nil),        // 9: google.longrunning.Operation
}
var file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_depIdxs = []int32{
	0, // 0: coinbase.cloud.mpc_transactions.v1.MPCTransaction.state:type_name -> coinbase.cloud.mpc_transactions.v1.MPCTransaction.State
	7, // 1: coinbase.cloud.mpc_transactions.v1.MPCTransaction.transaction:type_name -> coinbase.cloud.types.v1.Transaction
	1, // 2: coinbase.cloud.mpc_transactions.v1.CreateMPCTransactionRequest.mpc_transaction:type_name -> coinbase.cloud.mpc_transactions.v1.MPCTransaction
	8, // 3: coinbase.cloud.mpc_transactions.v1.CreateMPCTransactionRequest.input:type_name -> coinbase.cloud.types.v1.TransactionInput
	0, // 4: coinbase.cloud.mpc_transactions.v1.CreateMPCTransactionMetadata.state:type_name -> coinbase.cloud.mpc_transactions.v1.MPCTransaction.State
	1, // 5: coinbase.cloud.mpc_transactions.v1.ListMPCTransactionsResponse.mpc_transactions:type_name -> coinbase.cloud.mpc_transactions.v1.MPCTransaction
	2, // 6: coinbase.cloud.mpc_transactions.v1.MPCTransactionService.CreateMPCTransaction:input_type -> coinbase.cloud.mpc_transactions.v1.CreateMPCTransactionRequest
	4, // 7: coinbase.cloud.mpc_transactions.v1.MPCTransactionService.GetMPCTransaction:input_type -> coinbase.cloud.mpc_transactions.v1.GetMPCTransactionRequest
	5, // 8: coinbase.cloud.mpc_transactions.v1.MPCTransactionService.ListMPCTransactions:input_type -> coinbase.cloud.mpc_transactions.v1.ListMPCTransactionsRequest
	9, // 9: coinbase.cloud.mpc_transactions.v1.MPCTransactionService.CreateMPCTransaction:output_type -> google.longrunning.Operation
	1, // 10: coinbase.cloud.mpc_transactions.v1.MPCTransactionService.GetMPCTransaction:output_type -> coinbase.cloud.mpc_transactions.v1.MPCTransaction
	6, // 11: coinbase.cloud.mpc_transactions.v1.MPCTransactionService.ListMPCTransactions:output_type -> coinbase.cloud.mpc_transactions.v1.ListMPCTransactionsResponse
	9, // [9:12] is the sub-list for method output_type
	6, // [6:9] is the sub-list for method input_type
	6, // [6:6] is the sub-list for extension type_name
	6, // [6:6] is the sub-list for extension extendee
	0, // [0:6] is the sub-list for field type_name
}

func init() { file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_init() }
func file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_init() {
	if File_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MPCTransaction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMPCTransactionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateMPCTransactionMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetMPCTransactionRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMPCTransactionsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListMPCTransactionsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_goTypes,
		DependencyIndexes: file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_depIdxs,
		EnumInfos:         file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_enumTypes,
		MessageInfos:      file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_msgTypes,
	}.Build()
	File_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto = out.File
	file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_rawDesc = nil
	file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_goTypes = nil
	file_coinbase_cloud_mpc_transactions_v1_mpc_transactions_proto_depIdxs = nil
}
