package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DryRunCreateAppEnv invokes the webplus.DryRunCreateAppEnv API synchronously
// api document: https://help.aliyun.com/api/webplus/dryruncreateappenv.html
func (client *Client) DryRunCreateAppEnv(request *DryRunCreateAppEnvRequest) (response *DryRunCreateAppEnvResponse, err error) {
	response = CreateDryRunCreateAppEnvResponse()
	err = client.DoAction(request, response)
	return
}

// DryRunCreateAppEnvWithChan invokes the webplus.DryRunCreateAppEnv API asynchronously
// api document: https://help.aliyun.com/api/webplus/dryruncreateappenv.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DryRunCreateAppEnvWithChan(request *DryRunCreateAppEnvRequest) (<-chan *DryRunCreateAppEnvResponse, <-chan error) {
	responseChan := make(chan *DryRunCreateAppEnvResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DryRunCreateAppEnv(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DryRunCreateAppEnvWithCallback invokes the webplus.DryRunCreateAppEnv API asynchronously
// api document: https://help.aliyun.com/api/webplus/dryruncreateappenv.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DryRunCreateAppEnvWithCallback(request *DryRunCreateAppEnvRequest, callback func(response *DryRunCreateAppEnvResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DryRunCreateAppEnvResponse
		var err error
		defer close(result)
		response, err = client.DryRunCreateAppEnv(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DryRunCreateAppEnvRequest is the request struct for api DryRunCreateAppEnv
type DryRunCreateAppEnvRequest struct {
	*requests.RoaRequest
	OptionSettings  string `position:"Body" name:"OptionSettings"`
	ExtraProperties string `position:"Body" name:"ExtraProperties"`
	StackId         string `position:"Body" name:"StackId"`
	ProfileName     string `position:"Body" name:"ProfileName"`
	SourceEnvId     string `position:"Body" name:"SourceEnvId"`
	TemplateId      string `position:"Body" name:"TemplateId"`
}

// DryRunCreateAppEnvResponse is the response struct for api DryRunCreateAppEnv
type DryRunCreateAppEnvResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	Code       string     `json:"Code" xml:"Code"`
	Message    string     `json:"Message" xml:"Message"`
	DryRunInfo DryRunInfo `json:"DryRunInfo" xml:"DryRunInfo"`
}

// CreateDryRunCreateAppEnvRequest creates a request to invoke DryRunCreateAppEnv API
func CreateDryRunCreateAppEnvRequest() (request *DryRunCreateAppEnvRequest) {
	request = &DryRunCreateAppEnvRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "DryRunCreateAppEnv", "/pop/v1/wam/appEnv/dryRunCreate", "", "")
	request.Method = requests.POST
	return
}

// CreateDryRunCreateAppEnvResponse creates a response to parse from DryRunCreateAppEnv response
func CreateDryRunCreateAppEnvResponse() (response *DryRunCreateAppEnvResponse) {
	response = &DryRunCreateAppEnvResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
