package trademark

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTradeProduceList invokes the trademark.QueryTradeProduceList API synchronously
// api document: https://help.aliyun.com/api/trademark/querytradeproducelist.html
func (client *Client) QueryTradeProduceList(request *QueryTradeProduceListRequest) (response *QueryTradeProduceListResponse, err error) {
	response = CreateQueryTradeProduceListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTradeProduceListWithChan invokes the trademark.QueryTradeProduceList API asynchronously
// api document: https://help.aliyun.com/api/trademark/querytradeproducelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTradeProduceListWithChan(request *QueryTradeProduceListRequest) (<-chan *QueryTradeProduceListResponse, <-chan error) {
	responseChan := make(chan *QueryTradeProduceListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTradeProduceList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTradeProduceListWithCallback invokes the trademark.QueryTradeProduceList API asynchronously
// api document: https://help.aliyun.com/api/trademark/querytradeproducelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryTradeProduceListWithCallback(request *QueryTradeProduceListRequest, callback func(response *QueryTradeProduceListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTradeProduceListResponse
		var err error
		defer close(result)
		response, err = client.QueryTradeProduceList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTradeProduceListRequest is the request struct for api QueryTradeProduceList
type QueryTradeProduceListRequest struct {
	*requests.RpcRequest
	BuyerStatus    requests.Integer `position:"Query" name:"BuyerStatus"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	PreOrderId     string           `position:"Query" name:"PreOrderId"`
	BizId          string           `position:"Query" name:"BizId"`
	SortOrder      string           `position:"Query" name:"SortOrder"`
	PageNum        requests.Integer `position:"Query" name:"PageNum"`
	SortFiled      string           `position:"Query" name:"SortFiled"`
	RegisterNumber string           `position:"Query" name:"RegisterNumber"`
}

// QueryTradeProduceListResponse is the response struct for api QueryTradeProduceList
type QueryTradeProduceListResponse struct {
	*responses.BaseResponse
	RequestId      string                      `json:"RequestId" xml:"RequestId"`
	TotalItemNum   int                         `json:"TotalItemNum" xml:"TotalItemNum"`
	CurrentPageNum int                         `json:"CurrentPageNum" xml:"CurrentPageNum"`
	PageSize       int                         `json:"PageSize" xml:"PageSize"`
	TotalPageNum   int                         `json:"TotalPageNum" xml:"TotalPageNum"`
	Data           DataInQueryTradeProduceList `json:"Data" xml:"Data"`
}

// CreateQueryTradeProduceListRequest creates a request to invoke QueryTradeProduceList API
func CreateQueryTradeProduceListRequest() (request *QueryTradeProduceListRequest) {
	request = &QueryTradeProduceListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Trademark", "2018-07-24", "QueryTradeProduceList", "trademark", "openAPI")
	return
}

// CreateQueryTradeProduceListResponse creates a response to parse from QueryTradeProduceList response
func CreateQueryTradeProduceListResponse() (response *QueryTradeProduceListResponse) {
	response = &QueryTradeProduceListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
