package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserInfoInChannel invokes the rtc.DescribeUserInfoInChannel API synchronously
func (client *Client) DescribeUserInfoInChannel(request *DescribeUserInfoInChannelRequest) (response *DescribeUserInfoInChannelResponse, err error) {
	response = CreateDescribeUserInfoInChannelResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserInfoInChannelWithChan invokes the rtc.DescribeUserInfoInChannel API asynchronously
func (client *Client) DescribeUserInfoInChannelWithChan(request *DescribeUserInfoInChannelRequest) (<-chan *DescribeUserInfoInChannelResponse, <-chan error) {
	responseChan := make(chan *DescribeUserInfoInChannelResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserInfoInChannel(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserInfoInChannelWithCallback invokes the rtc.DescribeUserInfoInChannel API asynchronously
func (client *Client) DescribeUserInfoInChannelWithCallback(request *DescribeUserInfoInChannelRequest, callback func(response *DescribeUserInfoInChannelResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserInfoInChannelResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserInfoInChannel(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserInfoInChannelRequest is the request struct for api DescribeUserInfoInChannel
type DescribeUserInfoInChannelRequest struct {
	*requests.RpcRequest
	UserId    string           `position:"Query" name:"UserId"`
	ShowLog   string           `position:"Query" name:"ShowLog"`
	OwnerId   requests.Integer `position:"Query" name:"OwnerId"`
	AppId     string           `position:"Query" name:"AppId"`
	ChannelId string           `position:"Query" name:"ChannelId"`
}

// DescribeUserInfoInChannelResponse is the response struct for api DescribeUserInfoInChannel
type DescribeUserInfoInChannelResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Timestamp      int            `json:"Timestamp" xml:"Timestamp"`
	IsInChannel    bool           `json:"IsInChannel" xml:"IsInChannel"`
	IsChannelExist bool           `json:"IsChannelExist" xml:"IsChannelExist"`
	Property       []PropertyItem `json:"Property" xml:"Property"`
}

// CreateDescribeUserInfoInChannelRequest creates a request to invoke DescribeUserInfoInChannel API
func CreateDescribeUserInfoInChannelRequest() (request *DescribeUserInfoInChannelRequest) {
	request = &DescribeUserInfoInChannelRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DescribeUserInfoInChannel", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeUserInfoInChannelResponse creates a response to parse from DescribeUserInfoInChannel response
func CreateDescribeUserInfoInChannelResponse() (response *DescribeUserInfoInChannelResponse) {
	response = &DescribeUserInfoInChannelResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
