package rtc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRecordTemplate invokes the rtc.DeleteRecordTemplate API synchronously
func (client *Client) DeleteRecordTemplate(request *DeleteRecordTemplateRequest) (response *DeleteRecordTemplateResponse, err error) {
	response = CreateDeleteRecordTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRecordTemplateWithChan invokes the rtc.DeleteRecordTemplate API asynchronously
func (client *Client) DeleteRecordTemplateWithChan(request *DeleteRecordTemplateRequest) (<-chan *DeleteRecordTemplateResponse, <-chan error) {
	responseChan := make(chan *DeleteRecordTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRecordTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRecordTemplateWithCallback invokes the rtc.DeleteRecordTemplate API asynchronously
func (client *Client) DeleteRecordTemplateWithCallback(request *DeleteRecordTemplateRequest, callback func(response *DeleteRecordTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRecordTemplateResponse
		var err error
		defer close(result)
		response, err = client.DeleteRecordTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRecordTemplateRequest is the request struct for api DeleteRecordTemplate
type DeleteRecordTemplateRequest struct {
	*requests.RpcRequest
	ShowLog    string           `position:"Query" name:"ShowLog"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	TemplateId string           `position:"Query" name:"TemplateId"`
	AppId      string           `position:"Query" name:"AppId"`
}

// DeleteRecordTemplateResponse is the response struct for api DeleteRecordTemplate
type DeleteRecordTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteRecordTemplateRequest creates a request to invoke DeleteRecordTemplate API
func CreateDeleteRecordTemplateRequest() (request *DeleteRecordTemplateRequest) {
	request = &DeleteRecordTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("rtc", "2018-01-11", "DeleteRecordTemplate", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteRecordTemplateResponse creates a response to parse from DeleteRecordTemplate response
func CreateDeleteRecordTemplateResponse() (response *DeleteRecordTemplateResponse) {
	response = &DeleteRecordTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
