package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddDataLevelPermissionRuleUsers invokes the quickbi_public.AddDataLevelPermissionRuleUsers API synchronously
func (client *Client) AddDataLevelPermissionRuleUsers(request *AddDataLevelPermissionRuleUsersRequest) (response *AddDataLevelPermissionRuleUsersResponse, err error) {
	response = CreateAddDataLevelPermissionRuleUsersResponse()
	err = client.DoAction(request, response)
	return
}

// AddDataLevelPermissionRuleUsersWithChan invokes the quickbi_public.AddDataLevelPermissionRuleUsers API asynchronously
func (client *Client) AddDataLevelPermissionRuleUsersWithChan(request *AddDataLevelPermissionRuleUsersRequest) (<-chan *AddDataLevelPermissionRuleUsersResponse, <-chan error) {
	responseChan := make(chan *AddDataLevelPermissionRuleUsersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddDataLevelPermissionRuleUsers(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddDataLevelPermissionRuleUsersWithCallback invokes the quickbi_public.AddDataLevelPermissionRuleUsers API asynchronously
func (client *Client) AddDataLevelPermissionRuleUsersWithCallback(request *AddDataLevelPermissionRuleUsersRequest, callback func(response *AddDataLevelPermissionRuleUsersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddDataLevelPermissionRuleUsersResponse
		var err error
		defer close(result)
		response, err = client.AddDataLevelPermissionRuleUsers(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddDataLevelPermissionRuleUsersRequest is the request struct for api AddDataLevelPermissionRuleUsers
type AddDataLevelPermissionRuleUsersRequest struct {
	*requests.RpcRequest
	ClientToken  string `position:"Query" name:"ClientToken"`
	AccessPoint  string `position:"Query" name:"AccessPoint"`
	AddUserModel string `position:"Query" name:"AddUserModel"`
	SignType     string `position:"Query" name:"SignType"`
}

// AddDataLevelPermissionRuleUsersResponse is the response struct for api AddDataLevelPermissionRuleUsers
type AddDataLevelPermissionRuleUsersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateAddDataLevelPermissionRuleUsersRequest creates a request to invoke AddDataLevelPermissionRuleUsers API
func CreateAddDataLevelPermissionRuleUsersRequest() (request *AddDataLevelPermissionRuleUsersRequest) {
	request = &AddDataLevelPermissionRuleUsersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2020-11-11", "AddDataLevelPermissionRuleUsers", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddDataLevelPermissionRuleUsersResponse creates a response to parse from AddDataLevelPermissionRuleUsers response
func CreateAddDataLevelPermissionRuleUsersResponse() (response *AddDataLevelPermissionRuleUsersResponse) {
	response = &AddDataLevelPermissionRuleUsersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
