package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSlowQueryCategories invokes the opensearch.ListSlowQueryCategories API synchronously
func (client *Client) ListSlowQueryCategories(request *ListSlowQueryCategoriesRequest) (response *ListSlowQueryCategoriesResponse, err error) {
	response = CreateListSlowQueryCategoriesResponse()
	err = client.DoAction(request, response)
	return
}

// ListSlowQueryCategoriesWithChan invokes the opensearch.ListSlowQueryCategories API asynchronously
func (client *Client) ListSlowQueryCategoriesWithChan(request *ListSlowQueryCategoriesRequest) (<-chan *ListSlowQueryCategoriesResponse, <-chan error) {
	responseChan := make(chan *ListSlowQueryCategoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSlowQueryCategories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSlowQueryCategoriesWithCallback invokes the opensearch.ListSlowQueryCategories API asynchronously
func (client *Client) ListSlowQueryCategoriesWithCallback(request *ListSlowQueryCategoriesRequest, callback func(response *ListSlowQueryCategoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSlowQueryCategoriesResponse
		var err error
		defer close(result)
		response, err = client.ListSlowQueryCategories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSlowQueryCategoriesRequest is the request struct for api ListSlowQueryCategories
type ListSlowQueryCategoriesRequest struct {
	*requests.RoaRequest
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// ListSlowQueryCategoriesResponse is the response struct for api ListSlowQueryCategories
type ListSlowQueryCategoriesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    Result `json:"result" xml:"result"`
}

// CreateListSlowQueryCategoriesRequest creates a request to invoke ListSlowQueryCategories API
func CreateListSlowQueryCategoriesRequest() (request *ListSlowQueryCategoriesRequest) {
	request = &ListSlowQueryCategoriesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListSlowQueryCategories", "/v4/openapi/app-groups/[appGroupIdentity]/optimizers/slow-query/categories", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListSlowQueryCategoriesResponse creates a response to parse from ListSlowQueryCategories response
func CreateListSlowQueryCategoriesResponse() (response *ListSlowQueryCategoriesResponse) {
	response = &ListSlowQueryCategoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
