package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetParameters invokes the oos.GetParameters API synchronously
func (client *Client) GetParameters(request *GetParametersRequest) (response *GetParametersResponse, err error) {
	response = CreateGetParametersResponse()
	err = client.DoAction(request, response)
	return
}

// GetParametersWithChan invokes the oos.GetParameters API asynchronously
func (client *Client) GetParametersWithChan(request *GetParametersRequest) (<-chan *GetParametersResponse, <-chan error) {
	responseChan := make(chan *GetParametersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetParameters(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetParametersWithCallback invokes the oos.GetParameters API asynchronously
func (client *Client) GetParametersWithCallback(request *GetParametersRequest, callback func(response *GetParametersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetParametersResponse
		var err error
		defer close(result)
		response, err = client.GetParameters(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetParametersRequest is the request struct for api GetParameters
type GetParametersRequest struct {
	*requests.RpcRequest
	Names string `position:"Query" name:"Names"`
}

// GetParametersResponse is the response struct for api GetParameters
type GetParametersResponse struct {
	*responses.BaseResponse
	RequestId         string      `json:"RequestId" xml:"RequestId"`
	InvalidParameters []string    `json:"InvalidParameters" xml:"InvalidParameters"`
	Parameters        []Parameter `json:"Parameters" xml:"Parameters"`
}

// CreateGetParametersRequest creates a request to invoke GetParameters API
func CreateGetParametersRequest() (request *GetParametersRequest) {
	request = &GetParametersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "GetParameters", "", "")
	request.Method = requests.POST
	return
}

// CreateGetParametersResponse creates a response to parse from GetParameters response
func CreateGetParametersResponse() (response *GetParametersResponse) {
	response = &GetParametersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
