package mts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SubmitOssFileCopyJob invokes the mts.SubmitOssFileCopyJob API synchronously
func (client *Client) SubmitOssFileCopyJob(request *SubmitOssFileCopyJobRequest) (response *SubmitOssFileCopyJobResponse, err error) {
	response = CreateSubmitOssFileCopyJobResponse()
	err = client.DoAction(request, response)
	return
}

// SubmitOssFileCopyJobWithChan invokes the mts.SubmitOssFileCopyJob API asynchronously
func (client *Client) SubmitOssFileCopyJobWithChan(request *SubmitOssFileCopyJobRequest) (<-chan *SubmitOssFileCopyJobResponse, <-chan error) {
	responseChan := make(chan *SubmitOssFileCopyJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SubmitOssFileCopyJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SubmitOssFileCopyJobWithCallback invokes the mts.SubmitOssFileCopyJob API asynchronously
func (client *Client) SubmitOssFileCopyJobWithCallback(request *SubmitOssFileCopyJobRequest, callback func(response *SubmitOssFileCopyJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SubmitOssFileCopyJobResponse
		var err error
		defer close(result)
		response, err = client.SubmitOssFileCopyJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SubmitOssFileCopyJobRequest is the request struct for api SubmitOssFileCopyJob
type SubmitOssFileCopyJobRequest struct {
	*requests.RpcRequest
	TargetStorage SubmitOssFileCopyJobTargetStorage `position:"Query" name:"TargetStorage"  type:"Struct"`
	Notify        string                            `position:"Query" name:"Notify"`
	UserData      string                            `position:"Query" name:"UserData"`
	SourceStorage SubmitOssFileCopyJobSourceStorage `position:"Query" name:"SourceStorage"  type:"Struct"`
	Region        string                            `position:"Query" name:"Region"`
}

// SubmitOssFileCopyJobTargetStorage is a repeated param struct in SubmitOssFileCopyJobRequest
type SubmitOssFileCopyJobTargetStorage struct {
	Bucket         string `name:"Bucket"`
	BucketOwnerId  string `name:"BucketOwnerId"`
	S3Provider     string `name:"S3Provider"`
	S3Endpoint     string `name:"S3Endpoint"`
	ObjectPrefix   string `name:"ObjectPrefix"`
	S3AccessKey    string `name:"S3AccessKey"`
	S3SecretKey    string `name:"S3SecretKey"`
	S3SessionToken string `name:"S3SessionToken"`
	ObjectRoleName string `name:"ObjectRoleName"`
}

// SubmitOssFileCopyJobSourceStorage is a repeated param struct in SubmitOssFileCopyJobRequest
type SubmitOssFileCopyJobSourceStorage struct {
	Bucket         string `name:"Bucket"`
	BucketOwnerId  string `name:"BucketOwnerId"`
	S3Provider     string `name:"S3Provider"`
	S3Endpoint     string `name:"S3Endpoint"`
	ObjectPrefix   string `name:"ObjectPrefix"`
	S3AccessKey    string `name:"S3AccessKey"`
	S3SecretKey    string `name:"S3SecretKey"`
	FileNames      string `name:"FileNames"`
	S3SessionToken string `name:"S3SessionToken"`
	ObjectRoleName string `name:"ObjectRoleName"`
}

// SubmitOssFileCopyJobResponse is the response struct for api SubmitOssFileCopyJob
type SubmitOssFileCopyJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	JobId     string `json:"JobId" xml:"JobId"`
}

// CreateSubmitOssFileCopyJobRequest creates a request to invoke SubmitOssFileCopyJob API
func CreateSubmitOssFileCopyJobRequest() (request *SubmitOssFileCopyJobRequest) {
	request = &SubmitOssFileCopyJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Mts", "2014-06-18", "SubmitOssFileCopyJob", "mts", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSubmitOssFileCopyJobResponse creates a response to parse from SubmitOssFileCopyJob response
func CreateSubmitOssFileCopyJobResponse() (response *SubmitOssFileCopyJobResponse) {
	response = &SubmitOssFileCopyJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
