package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddLiveStreamWatermark invokes the live.AddLiveStreamWatermark API synchronously
func (client *Client) AddLiveStreamWatermark(request *AddLiveStreamWatermarkRequest) (response *AddLiveStreamWatermarkResponse, err error) {
	response = CreateAddLiveStreamWatermarkResponse()
	err = client.DoAction(request, response)
	return
}

// AddLiveStreamWatermarkWithChan invokes the live.AddLiveStreamWatermark API asynchronously
func (client *Client) AddLiveStreamWatermarkWithChan(request *AddLiveStreamWatermarkRequest) (<-chan *AddLiveStreamWatermarkResponse, <-chan error) {
	responseChan := make(chan *AddLiveStreamWatermarkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddLiveStreamWatermark(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddLiveStreamWatermarkWithCallback invokes the live.AddLiveStreamWatermark API asynchronously
func (client *Client) AddLiveStreamWatermarkWithCallback(request *AddLiveStreamWatermarkRequest, callback func(response *AddLiveStreamWatermarkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddLiveStreamWatermarkResponse
		var err error
		defer close(result)
		response, err = client.AddLiveStreamWatermark(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddLiveStreamWatermarkRequest is the request struct for api AddLiveStreamWatermark
type AddLiveStreamWatermarkRequest struct {
	*requests.RpcRequest
	YOffset      requests.Float   `position:"Query" name:"YOffset"`
	PictureUrl   string           `position:"Query" name:"PictureUrl"`
	Description  string           `position:"Query" name:"Description"`
	Type         requests.Integer `position:"Query" name:"Type"`
	Height       requests.Integer `position:"Query" name:"Height"`
	XOffset      requests.Float   `position:"Query" name:"XOffset"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	RefWidth     requests.Integer `position:"Query" name:"RefWidth"`
	Transparency requests.Integer `position:"Query" name:"Transparency"`
	Name         string           `position:"Query" name:"Name"`
	OffsetCorner string           `position:"Query" name:"OffsetCorner"`
	RefHeight    requests.Integer `position:"Query" name:"RefHeight"`
}

// AddLiveStreamWatermarkResponse is the response struct for api AddLiveStreamWatermark
type AddLiveStreamWatermarkResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	TemplateId string `json:"TemplateId" xml:"TemplateId"`
}

// CreateAddLiveStreamWatermarkRequest creates a request to invoke AddLiveStreamWatermark API
func CreateAddLiveStreamWatermarkRequest() (request *AddLiveStreamWatermarkRequest) {
	request = &AddLiveStreamWatermarkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddLiveStreamWatermark", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddLiveStreamWatermarkResponse creates a response to parse from AddLiveStreamWatermark response
func CreateAddLiveStreamWatermarkResponse() (response *AddLiveStreamWatermarkResponse) {
	response = &AddLiveStreamWatermarkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
