package itaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveRegisterBox invokes the itaas.RemoveRegisterBox API synchronously
// api document: https://help.aliyun.com/api/itaas/removeregisterbox.html
func (client *Client) RemoveRegisterBox(request *RemoveRegisterBoxRequest) (response *RemoveRegisterBoxResponse, err error) {
	response = CreateRemoveRegisterBoxResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveRegisterBoxWithChan invokes the itaas.RemoveRegisterBox API asynchronously
// api document: https://help.aliyun.com/api/itaas/removeregisterbox.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveRegisterBoxWithChan(request *RemoveRegisterBoxRequest) (<-chan *RemoveRegisterBoxResponse, <-chan error) {
	responseChan := make(chan *RemoveRegisterBoxResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveRegisterBox(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveRegisterBoxWithCallback invokes the itaas.RemoveRegisterBox API asynchronously
// api document: https://help.aliyun.com/api/itaas/removeregisterbox.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RemoveRegisterBoxWithCallback(request *RemoveRegisterBoxRequest, callback func(response *RemoveRegisterBoxResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveRegisterBoxResponse
		var err error
		defer close(result)
		response, err = client.RemoveRegisterBox(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveRegisterBoxRequest is the request struct for api RemoveRegisterBox
type RemoveRegisterBoxRequest struct {
	*requests.RpcRequest
	Clientappid string `position:"Query" name:"Clientappid"`
	Drsessionid string `position:"Query" name:"Drsessionid"`
	Sysfrom     string `position:"Query" name:"Sysfrom"`
	Operator    string `position:"Query" name:"Operator"`
}

// RemoveRegisterBoxResponse is the response struct for api RemoveRegisterBox
type RemoveRegisterBoxResponse struct {
	*responses.BaseResponse
	RequestId string                       `json:"RequestId" xml:"RequestId"`
	ErrorCode int                          `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string                       `json:"ErrorMsg" xml:"ErrorMsg"`
	Success   bool                         `json:"Success" xml:"Success"`
	ErrorList ErrorListInRemoveRegisterBox `json:"ErrorList" xml:"ErrorList"`
}

// CreateRemoveRegisterBoxRequest creates a request to invoke RemoveRegisterBox API
func CreateRemoveRegisterBoxRequest() (request *RemoveRegisterBoxRequest) {
	request = &RemoveRegisterBoxRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ITaaS", "2017-05-05", "RemoveRegisterBox", "itaas", "openAPI")
	return
}

// CreateRemoveRegisterBoxResponse creates a response to parse from RemoveRegisterBox response
func CreateRemoveRegisterBoxResponse() (response *RemoveRegisterBoxResponse) {
	response = &RemoveRegisterBoxResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
