package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySpeechPushJobSpeech invokes the iot.QuerySpeechPushJobSpeech API synchronously
func (client *Client) QuerySpeechPushJobSpeech(request *QuerySpeechPushJobSpeechRequest) (response *QuerySpeechPushJobSpeechResponse, err error) {
	response = CreateQuerySpeechPushJobSpeechResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySpeechPushJobSpeechWithChan invokes the iot.QuerySpeechPushJobSpeech API asynchronously
func (client *Client) QuerySpeechPushJobSpeechWithChan(request *QuerySpeechPushJobSpeechRequest) (<-chan *QuerySpeechPushJobSpeechResponse, <-chan error) {
	responseChan := make(chan *QuerySpeechPushJobSpeechResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySpeechPushJobSpeech(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySpeechPushJobSpeechWithCallback invokes the iot.QuerySpeechPushJobSpeech API asynchronously
func (client *Client) QuerySpeechPushJobSpeechWithCallback(request *QuerySpeechPushJobSpeechRequest, callback func(response *QuerySpeechPushJobSpeechResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySpeechPushJobSpeechResponse
		var err error
		defer close(result)
		response, err = client.QuerySpeechPushJobSpeech(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySpeechPushJobSpeechRequest is the request struct for api QuerySpeechPushJobSpeech
type QuerySpeechPushJobSpeechRequest struct {
	*requests.RpcRequest
	PageId        requests.Integer `position:"Body" name:"PageId"`
	IotInstanceId string           `position:"Body" name:"IotInstanceId"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	JobCode       string           `position:"Body" name:"JobCode"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// QuerySpeechPushJobSpeechResponse is the response struct for api QuerySpeechPushJobSpeech
type QuerySpeechPushJobSpeechResponse struct {
	*responses.BaseResponse
	RequestId    string                         `json:"RequestId" xml:"RequestId"`
	Success      bool                           `json:"Success" xml:"Success"`
	Code         string                         `json:"Code" xml:"Code"`
	ErrorMessage string                         `json:"ErrorMessage" xml:"ErrorMessage"`
	Data         DataInQuerySpeechPushJobSpeech `json:"Data" xml:"Data"`
}

// CreateQuerySpeechPushJobSpeechRequest creates a request to invoke QuerySpeechPushJobSpeech API
func CreateQuerySpeechPushJobSpeechRequest() (request *QuerySpeechPushJobSpeechRequest) {
	request = &QuerySpeechPushJobSpeechRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "QuerySpeechPushJobSpeech", "", "")
	request.Method = requests.POST
	return
}

// CreateQuerySpeechPushJobSpeechResponse creates a response to parse from QuerySpeechPushJobSpeech response
func CreateQuerySpeechPushJobSpeechResponse() (response *QuerySpeechPushJobSpeechResponse) {
	response = &QuerySpeechPushJobSpeechResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
