package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeAvailableResources invokes the gpdb.DescribeAvailableResources API synchronously
func (client *Client) DescribeAvailableResources(request *DescribeAvailableResourcesRequest) (response *DescribeAvailableResourcesResponse, err error) {
	response = CreateDescribeAvailableResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeAvailableResourcesWithChan invokes the gpdb.DescribeAvailableResources API asynchronously
func (client *Client) DescribeAvailableResourcesWithChan(request *DescribeAvailableResourcesRequest) (<-chan *DescribeAvailableResourcesResponse, <-chan error) {
	responseChan := make(chan *DescribeAvailableResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeAvailableResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeAvailableResourcesWithCallback invokes the gpdb.DescribeAvailableResources API asynchronously
func (client *Client) DescribeAvailableResourcesWithCallback(request *DescribeAvailableResourcesRequest, callback func(response *DescribeAvailableResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeAvailableResourcesResponse
		var err error
		defer close(result)
		response, err = client.DescribeAvailableResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeAvailableResourcesRequest is the request struct for api DescribeAvailableResources
type DescribeAvailableResourcesRequest struct {
	*requests.RpcRequest
	ZoneId     string `position:"Query" name:"ZoneId"`
	ChargeType string `position:"Query" name:"ChargeType"`
	Region     string `position:"Query" name:"Region"`
}

// DescribeAvailableResourcesResponse is the response struct for api DescribeAvailableResources
type DescribeAvailableResourcesResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	RegionId  string     `json:"RegionId" xml:"RegionId"`
	Resources []Resource `json:"Resources" xml:"Resources"`
}

// CreateDescribeAvailableResourcesRequest creates a request to invoke DescribeAvailableResources API
func CreateDescribeAvailableResourcesRequest() (request *DescribeAvailableResourcesRequest) {
	request = &DescribeAvailableResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "DescribeAvailableResources", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeAvailableResourcesResponse creates a response to parse from DescribeAvailableResources response
func CreateDescribeAvailableResourcesResponse() (response *DescribeAvailableResourcesResponse) {
	response = &DescribeAvailableResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
