package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateECSDBInstance invokes the gpdb.CreateECSDBInstance API synchronously
func (client *Client) CreateECSDBInstance(request *CreateECSDBInstanceRequest) (response *CreateECSDBInstanceResponse, err error) {
	response = CreateCreateECSDBInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateECSDBInstanceWithChan invokes the gpdb.CreateECSDBInstance API asynchronously
func (client *Client) CreateECSDBInstanceWithChan(request *CreateECSDBInstanceRequest) (<-chan *CreateECSDBInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateECSDBInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateECSDBInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateECSDBInstanceWithCallback invokes the gpdb.CreateECSDBInstance API asynchronously
func (client *Client) CreateECSDBInstanceWithCallback(request *CreateECSDBInstanceRequest, callback func(response *CreateECSDBInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateECSDBInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateECSDBInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateECSDBInstanceRequest is the request struct for api CreateECSDBInstance
type CreateECSDBInstanceRequest struct {
	*requests.RpcRequest
	EngineVersion         string           `position:"Query" name:"EngineVersion"`
	DBInstanceCategory    string           `position:"Query" name:"DBInstanceCategory"`
	EncryptionType        string           `position:"Query" name:"EncryptionType"`
	DBInstanceDescription string           `position:"Query" name:"DBInstanceDescription"`
	Period                string           `position:"Query" name:"Period"`
	BackupId              string           `position:"Query" name:"BackupId"`
	EncryptionKey         string           `position:"Query" name:"EncryptionKey"`
	OwnerId               requests.Integer `position:"Query" name:"OwnerId"`
	SecurityIPList        string           `position:"Query" name:"SecurityIPList"`
	VSwitchId             string           `position:"Query" name:"VSwitchId"`
	PrivateIpAddress      string           `position:"Query" name:"PrivateIpAddress"`
	ZoneId                string           `position:"Query" name:"ZoneId"`
	InstanceNetworkType   string           `position:"Query" name:"InstanceNetworkType"`
	ClientToken           string           `position:"Query" name:"ClientToken"`
	InstanceSpec          string           `position:"Query" name:"InstanceSpec"`
	StorageSize           requests.Integer `position:"Query" name:"StorageSize"`
	SegStorageType        string           `position:"Query" name:"SegStorageType"`
	MasterNodeNum         requests.Integer `position:"Query" name:"MasterNodeNum"`
	SegNodeNum            requests.Integer `position:"Query" name:"SegNodeNum"`
	Engine                string           `position:"Query" name:"Engine"`
	UsedTime              string           `position:"Query" name:"UsedTime"`
	VPCId                 string           `position:"Query" name:"VPCId"`
	PayType               string           `position:"Query" name:"PayType"`
	SrcDbInstanceName     string           `position:"Query" name:"SrcDbInstanceName"`
}

// CreateECSDBInstanceResponse is the response struct for api CreateECSDBInstance
type CreateECSDBInstanceResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	DBInstanceId     string `json:"DBInstanceId" xml:"DBInstanceId"`
	Port             string `json:"Port" xml:"Port"`
	ConnectionString string `json:"ConnectionString" xml:"ConnectionString"`
	OrderId          string `json:"OrderId" xml:"OrderId"`
}

// CreateCreateECSDBInstanceRequest creates a request to invoke CreateECSDBInstance API
func CreateCreateECSDBInstanceRequest() (request *CreateECSDBInstanceRequest) {
	request = &CreateECSDBInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "CreateECSDBInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateECSDBInstanceResponse creates a response to parse from CreateECSDBInstance response
func CreateCreateECSDBInstanceResponse() (response *CreateECSDBInstanceResponse) {
	response = &CreateECSDBInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
