package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateEndpointGroupAttribute invokes the ga.UpdateEndpointGroupAttribute API synchronously
func (client *Client) UpdateEndpointGroupAttribute(request *UpdateEndpointGroupAttributeRequest) (response *UpdateEndpointGroupAttributeResponse, err error) {
	response = CreateUpdateEndpointGroupAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateEndpointGroupAttributeWithChan invokes the ga.UpdateEndpointGroupAttribute API asynchronously
func (client *Client) UpdateEndpointGroupAttributeWithChan(request *UpdateEndpointGroupAttributeRequest) (<-chan *UpdateEndpointGroupAttributeResponse, <-chan error) {
	responseChan := make(chan *UpdateEndpointGroupAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateEndpointGroupAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateEndpointGroupAttributeWithCallback invokes the ga.UpdateEndpointGroupAttribute API asynchronously
func (client *Client) UpdateEndpointGroupAttributeWithCallback(request *UpdateEndpointGroupAttributeRequest, callback func(response *UpdateEndpointGroupAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateEndpointGroupAttributeResponse
		var err error
		defer close(result)
		response, err = client.UpdateEndpointGroupAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateEndpointGroupAttributeRequest is the request struct for api UpdateEndpointGroupAttribute
type UpdateEndpointGroupAttributeRequest struct {
	*requests.RpcRequest
	ClientToken     string `position:"Query" name:"ClientToken"`
	Description     string `position:"Query" name:"Description"`
	Name            string `position:"Query" name:"Name"`
	EndpointGroupId string `position:"Query" name:"EndpointGroupId"`
}

// UpdateEndpointGroupAttributeResponse is the response struct for api UpdateEndpointGroupAttribute
type UpdateEndpointGroupAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateEndpointGroupAttributeRequest creates a request to invoke UpdateEndpointGroupAttribute API
func CreateUpdateEndpointGroupAttributeRequest() (request *UpdateEndpointGroupAttributeRequest) {
	request = &UpdateEndpointGroupAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "UpdateEndpointGroupAttribute", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateEndpointGroupAttributeResponse creates a response to parse from UpdateEndpointGroupAttribute response
func CreateUpdateEndpointGroupAttributeResponse() (response *UpdateEndpointGroupAttributeResponse) {
	response = &UpdateEndpointGroupAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
