package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExecuteCallTask invokes the dyvmsapi.ExecuteCallTask API synchronously
func (client *Client) ExecuteCallTask(request *ExecuteCallTaskRequest) (response *ExecuteCallTaskResponse, err error) {
	response = CreateExecuteCallTaskResponse()
	err = client.DoAction(request, response)
	return
}

// ExecuteCallTaskWithChan invokes the dyvmsapi.ExecuteCallTask API asynchronously
func (client *Client) ExecuteCallTaskWithChan(request *ExecuteCallTaskRequest) (<-chan *ExecuteCallTaskResponse, <-chan error) {
	responseChan := make(chan *ExecuteCallTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExecuteCallTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExecuteCallTaskWithCallback invokes the dyvmsapi.ExecuteCallTask API asynchronously
func (client *Client) ExecuteCallTaskWithCallback(request *ExecuteCallTaskRequest, callback func(response *ExecuteCallTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExecuteCallTaskResponse
		var err error
		defer close(result)
		response, err = client.ExecuteCallTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExecuteCallTaskRequest is the request struct for api ExecuteCallTask
type ExecuteCallTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TaskId               requests.Integer `position:"Query" name:"TaskId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	FireTime             string           `position:"Query" name:"FireTime"`
	Status               string           `position:"Query" name:"Status"`
}

// ExecuteCallTaskResponse is the response struct for api ExecuteCallTask
type ExecuteCallTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Data      bool   `json:"Data" xml:"Data"`
}

// CreateExecuteCallTaskRequest creates a request to invoke ExecuteCallTask API
func CreateExecuteCallTaskRequest() (request *ExecuteCallTaskRequest) {
	request = &ExecuteCallTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "ExecuteCallTask", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExecuteCallTaskResponse creates a response to parse from ExecuteCallTask response
func CreateExecuteCallTaskResponse() (response *ExecuteCallTaskResponse) {
	response = &ExecuteCallTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
