package dyplsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindAxb invokes the dyplsapi.BindAxb API synchronously
func (client *Client) BindAxb(request *BindAxbRequest) (response *BindAxbResponse, err error) {
	response = CreateBindAxbResponse()
	err = client.DoAction(request, response)
	return
}

// BindAxbWithChan invokes the dyplsapi.BindAxb API asynchronously
func (client *Client) BindAxbWithChan(request *BindAxbRequest) (<-chan *BindAxbResponse, <-chan error) {
	responseChan := make(chan *BindAxbResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindAxb(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindAxbWithCallback invokes the dyplsapi.BindAxb API asynchronously
func (client *Client) BindAxbWithCallback(request *BindAxbRequest, callback func(response *BindAxbResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindAxbResponse
		var err error
		defer close(result)
		response, err = client.BindAxb(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindAxbRequest is the request struct for api BindAxb
type BindAxbRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	CallDisplayType      requests.Integer `position:"Query" name:"CallDisplayType"`
	CallTimeout          requests.Integer `position:"Query" name:"CallTimeout"`
	PhoneNoX             string           `position:"Query" name:"PhoneNoX"`
	RingConfig           string           `position:"Query" name:"RingConfig"`
	ASRStatus            requests.Boolean `position:"Query" name:"ASRStatus"`
	PhoneNoB             string           `position:"Query" name:"PhoneNoB"`
	PhoneNoA             string           `position:"Query" name:"PhoneNoA"`
	ExpectCity           string           `position:"Query" name:"ExpectCity"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	OutOrderId           string           `position:"Query" name:"OutOrderId"`
	PoolKey              string           `position:"Query" name:"PoolKey"`
	Expiration           string           `position:"Query" name:"Expiration"`
	IsRecordingEnabled   requests.Boolean `position:"Query" name:"IsRecordingEnabled"`
	OutId                string           `position:"Query" name:"OutId"`
	ASRModelId           string           `position:"Query" name:"ASRModelId"`
	CallRestrict         string           `position:"Query" name:"CallRestrict"`
}

// BindAxbResponse is the response struct for api BindAxb
type BindAxbResponse struct {
	*responses.BaseResponse
	Code          string        `json:"Code" xml:"Code"`
	Message       string        `json:"Message" xml:"Message"`
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	SecretBindDTO SecretBindDTO `json:"SecretBindDTO" xml:"SecretBindDTO"`
}

// CreateBindAxbRequest creates a request to invoke BindAxb API
func CreateBindAxbRequest() (request *BindAxbRequest) {
	request = &BindAxbRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyplsapi", "2017-05-25", "BindAxb", "", "")
	request.Method = requests.POST
	return
}

// CreateBindAxbResponse creates a response to parse from BindAxb response
func CreateBindAxbResponse() (response *BindAxbResponse) {
	response = &BindAxbResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
