package dm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAccountList invokes the dm.GetAccountList API synchronously
// api document: https://help.aliyun.com/api/dm/getaccountlist.html
func (client *Client) GetAccountList(request *GetAccountListRequest) (response *GetAccountListResponse, err error) {
	response = CreateGetAccountListResponse()
	err = client.DoAction(request, response)
	return
}

// GetAccountListWithChan invokes the dm.GetAccountList API asynchronously
// api document: https://help.aliyun.com/api/dm/getaccountlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAccountListWithChan(request *GetAccountListRequest) (<-chan *GetAccountListResponse, <-chan error) {
	responseChan := make(chan *GetAccountListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAccountList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAccountListWithCallback invokes the dm.GetAccountList API asynchronously
// api document: https://help.aliyun.com/api/dm/getaccountlist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAccountListWithCallback(request *GetAccountListRequest, callback func(response *GetAccountListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAccountListResponse
		var err error
		defer close(result)
		response, err = client.GetAccountList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAccountListRequest is the request struct for api GetAccountList
type GetAccountListRequest struct {
	*requests.RpcRequest
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Total                string           `position:"Query" name:"Total"`
	Offset               string           `position:"Query" name:"Offset"`
	PageSize             string           `position:"Query" name:"PageSize"`
	OffsetCreateTime     string           `position:"Query" name:"OffsetCreateTime"`
	OffsetCreateTimeDesc string           `position:"Query" name:"OffsetCreateTimeDesc"`
	PageNumber           string           `position:"Query" name:"PageNumber"`
}

// GetAccountListResponse is the response struct for api GetAccountList
type GetAccountListResponse struct {
	*responses.BaseResponse
	RequestId string               `json:"RequestId" xml:"RequestId"`
	Total     int                  `json:"Total" xml:"Total"`
	PageNo    int                  `json:"PageNo" xml:"PageNo"`
	PageSize  int                  `json:"PageSize" xml:"PageSize"`
	Data      DataInGetAccountList `json:"data" xml:"data"`
}

// CreateGetAccountListRequest creates a request to invoke GetAccountList API
func CreateGetAccountListRequest() (request *GetAccountListRequest) {
	request = &GetAccountListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dm", "2015-11-23", "GetAccountList", "", "")
	return
}

// CreateGetAccountListResponse creates a response to parse from GetAccountList response
func CreateGetAccountListResponse() (response *GetAccountListResponse) {
	response = &GetAccountListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
