package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRecentCallRecords invokes the cloudcallcenter.ListRecentCallRecords API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listrecentcallrecords.html
func (client *Client) ListRecentCallRecords(request *ListRecentCallRecordsRequest) (response *ListRecentCallRecordsResponse, err error) {
	response = CreateListRecentCallRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// ListRecentCallRecordsWithChan invokes the cloudcallcenter.ListRecentCallRecords API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listrecentcallrecords.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRecentCallRecordsWithChan(request *ListRecentCallRecordsRequest) (<-chan *ListRecentCallRecordsResponse, <-chan error) {
	responseChan := make(chan *ListRecentCallRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRecentCallRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRecentCallRecordsWithCallback invokes the cloudcallcenter.ListRecentCallRecords API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listrecentcallrecords.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListRecentCallRecordsWithCallback(request *ListRecentCallRecordsRequest, callback func(response *ListRecentCallRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRecentCallRecordsResponse
		var err error
		defer close(result)
		response, err = client.ListRecentCallRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRecentCallRecordsRequest is the request struct for api ListRecentCallRecords
type ListRecentCallRecordsRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	Criteria   string           `position:"Query" name:"Criteria"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	StartTime  requests.Integer `position:"Query" name:"StartTime"`
	StopTime   requests.Integer `position:"Query" name:"StopTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListRecentCallRecordsResponse is the response struct for api ListRecentCallRecords
type ListRecentCallRecordsResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	Success           bool              `json:"Success" xml:"Success"`
	Code              string            `json:"Code" xml:"Code"`
	Message           string            `json:"Message" xml:"Message"`
	HttpStatusCode    int               `json:"HttpStatusCode" xml:"HttpStatusCode"`
	CallDetailRecords CallDetailRecords `json:"CallDetailRecords" xml:"CallDetailRecords"`
}

// CreateListRecentCallRecordsRequest creates a request to invoke ListRecentCallRecords API
func CreateListRecentCallRecordsRequest() (request *ListRecentCallRecordsRequest) {
	request = &ListRecentCallRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListRecentCallRecords", "", "")
	request.Method = requests.POST
	return
}

// CreateListRecentCallRecordsResponse creates a response to parse from ListRecentCallRecords response
func CreateListRecentCallRecordsResponse() (response *ListRecentCallRecordsResponse) {
	response = &ListRecentCallRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
