package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJobs invokes the cloudcallcenter.GetJobs API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getjobs.html
func (client *Client) GetJobs(request *GetJobsRequest) (response *GetJobsResponse, err error) {
	response = CreateGetJobsResponse()
	err = client.DoAction(request, response)
	return
}

// GetJobsWithChan invokes the cloudcallcenter.GetJobs API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getjobs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobsWithChan(request *GetJobsRequest) (<-chan *GetJobsResponse, <-chan error) {
	responseChan := make(chan *GetJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJobsWithCallback invokes the cloudcallcenter.GetJobs API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/getjobs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetJobsWithCallback(request *GetJobsRequest, callback func(response *GetJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJobsResponse
		var err error
		defer close(result)
		response, err = client.GetJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJobsRequest is the request struct for api GetJobs
type GetJobsRequest struct {
	*requests.RpcRequest
	JobId      *[]string `position:"Query" name:"JobId"  type:"Repeated"`
	InstanceId string    `position:"Query" name:"InstanceId"`
}

// GetJobsResponse is the response struct for api GetJobs
type GetJobsResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Jobs           []Job  `json:"Jobs" xml:"Jobs"`
}

// CreateGetJobsRequest creates a request to invoke GetJobs API
func CreateGetJobsRequest() (request *GetJobsRequest) {
	request = &GetJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "GetJobs", "", "")
	request.Method = requests.POST
	return
}

// CreateGetJobsResponse creates a response to parse from GetJobs response
func CreateGetJobsResponse() (response *GetJobsResponse) {
	response = &GetJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
